struct cpuinfo_mock_file filesystem[] = {
#if CPUINFO_ARCH_ARM64
	{
		.path = "/proc/cpuinfo",
		.size = 279,
		.content = "Processor\t: AArch64 Processor rev 0 (aarch64)\n"
			   "processor\t: 0\n"
			   "processor\t: 1\n"
			   "processor\t: 2\n"
			   "processor\t: 3\n"
			   "Features\t: fp asimd evtstrm crc32 \n"
			   "CPU implementer\t: 0x41\n"
			   "CPU architecture: 8\n"
			   "CPU variant\t: 0x0\n"
			   "CPU part\t: 0xd03\n"
			   "CPU revision\t: 0\n"
			   "\n"
			   "Hardware\t: Qualcomm Technologies, Inc MSM8916\n",
	},
#elif CPUINFO_ARCH_ARM
	{
		.path = "/proc/cpuinfo",
		.size = 538,
		.content =
			"WARNING: linker: /data/local/tmp/cpuinfo-dump: unused DT entry: type 0x6ffffffe arg 0x52c\r\n"
			"WARNING: linker: /data/local/tmp/cpuinfo-dump: unused DT entry: type 0x6fffffff arg 0x1\r\n"
			"Processor\t: AArch64 Processor rev 0 (aarch64)\r\n"
			"processor\t: 0\r\n"
			"processor\t: 1\r\n"
			"processor\t: 2\r\n"
			"processor\t: 3\r\n"
			"Features\t: fp asimd evtstrm crc32 wp half thumb fastmult vfp edsp neon vfpv3 tlsi vfpv4 idiva idivt \r\n"
			"CPU implementer\t: 0x41\r\n"
			"CPU architecture: 8\r\n"
			"CPU variant\t: 0x0\r\n"
			"CPU part\t: 0xd03\r\n"
			"CPU revision\t: 0\r\n"
			"\r\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8916\r\n",
	},
#endif
	{
		.path = "/system/build.prop",
		.size = 9826,
		.content =
			"\n"
			"source common oppo_buildinfo\n"
			"#\n"
			"#\n"
			"#\n"
			"#\n"
			"# begin build oppo properties\n"
			"# autogenerated by oppo_buildinfo.sh\n"
			"ro.build.date.Ymd=170701\n"
			"ro.build.date.ymd=170701\n"
			"ro.build.date.YmdHM=201707011131\n"
			"ro.common.soft=MSM_15399\n"
			"ro.build.version.incremental=1480422943\n"
			"ro.build.product=A37f\n"
			"ro.product.name=A37f\n"
			"ro.product.model=A37f\n"
			"ro.build.version.opporom=V3.0.0i\n"
			"ro.build.version.ota=A37fEX_11.A.23_INT_023_201707010938\n"
			"ro.build.soft.majorversion=\n"
			"ro.build.display.id=A37fEX_11_170701\n"
			"ro.build.display.full_id=A37fEX_11_A.23_170701\n"
			"ro.build.soft.version=A.23\n"
			"ro.xxversion=v0.5\n"
			"ro.build.kernel.id=3.10.28-G201707010938\n"
			"ro.oppo.version=US\n"
			"ro.oppo.build.exp=US\n"
			"persist.sys.oppo.region=US\n"
			"persist.sys.timezone=America/New_York\n"
			"persist.power.useautobrightadj=true\n"
			"persist.oppo.ctsversion=false\n"
			"persist.radio.multisim.config=dsds\n"
			"# end build oppo properties\n"
			"ro.rf_version=W_G_L_15399\n"
			"ro.telephony.default_network=9,1\n"
			"persist.radio.custom_exp_ecc=1\n"
			"sys.hwc.gpu_perf_mode=1\n"
			"ro.build.ota.versionname=A37fEX_11_170701\n"
			"persist.radio.sap_silent_pin=true\n"
			"ro.dirac.max_active.powersound=3\n"
			"ro.dirac.max_active.headset=5\n"
			"ro.dirac.poolsize=6\n"
			"ro.dirac.config=2\n"
			"persist.sys.startupmanager=false\n"
			"persist.sys.assert.state=false\n"
			"persist.sys.assert.panic=false\n"
			"persist.sys.dump=0\n"
			"persist.sys.modem=no\n"
			"persist.sys.net=no\n"
			"ro.build.release_type=true\n"
			"persist.sys.savetosdcard=true\n"
			"persist.sys.adddevdiag=0\n"
			"persist.radio.lte_vrte_ltd=1\n"
			"persist.sys.oem_smooth=1\n"
			"persist.sys.cfu_auto=1\n"
			"ro.sys.full_disk_ecryption=true\n"
			"persist.version.confidential=false\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=LMY47V\n"
			"ro.build.version.sdk=22\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=5.1.1\n"
			"ro.build.version.security_patch=2017-06-01\n"
			"ro.build.date=Sat Jul  1 11:31:46 CST 2017\n"
			"ro.build.date.utc=1498879906\n"
			"ro.build.type=user\n"
			"ro.build.user=root\n"
			"ro.build.host=ubuntu-122-192\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=msm8916_64-user\n"
			"ro.product.brand=OPPO\n"
			"ro.product.board=msm8916\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=arm64-v8a\n"
			"ro.product.cpu.abilist=arm64-v8a,armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=arm64-v8a\n"
			"ro.product.manufacturer=OPPO\n"
			"ro.product.locale.language=en\n"
			"ro.product.locale.region=US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8916\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=msm8916_64-user 5.1.1 LMY47V eng.root.20170701.113014 release-keys\n"
			"ro.build.characteristics=nosdcard\n"
			"# end build properties\n"
			"#\n"
			"# from device/qcom/msm8916_64/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8916\n"
			"#\n"
			"\n"
			"rild.libpath=/vendor/lib64/libril-qc-qmi-1.so\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.rild.nitz_plmn=\n"
			"persist.rild.nitz_long_ons_0=\n"
			"persist.rild.nitz_long_ons_1=\n"
			"persist.rild.nitz_long_ons_2=\n"
			"persist.rild.nitz_long_ons_3=\n"
			"persist.rild.nitz_short_ons_0=\n"
			"persist.rild.nitz_short_ons_1=\n"
			"persist.rild.nitz_short_ons_2=\n"
			"persist.rild.nitz_short_ons_3=\n"
			"//#ifdef VENDOR_EDIT\n"
			"//xukang.wang@Mobile.Network.phone, 2015-05-11 add for cannot register network manually\n"
			"persist.radio.rat_on=legacy\n"
			"//#endif /*VENDOR_EDIT*/\n"
			"ril.subscription.types=NV,RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"# Start in cdma mode\n"
			"#ifndef VENDOR_EDIT\n"
			"#ShaoQiang@EXP.SysFramework.Framework, 2015/09/24, Remove prop into oppo_buildinfo.sh\n"
			"#ro.telephony.default_network=5\n"
			"#endif /* VENDOR_EDIT */\n"
			"\n"
			"debug.sf.hw=0\n"
			"debug.egl.hw=0\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dalvik.vm.heapsize=36m\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.mdpcomp.idletime=600\n"
			"debug.enable.sglscale=1\n"
			"# disable vsync for cpu render apps\n"
			"#YuCongcong@PSD.Multimedia.display, 2015/06/23, modify debug.cpurend.vsync to true for browser stutter issue.\n"
			"#debug.cpurend.vsync=false\n"
			"debug.cpurend.vsync=true\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#tunnel.decode=true\n"
			"#tunnel.audiovideo.decode=true\n"
			"#lpa.decode=false\n"
			"#lpa.use-stagefright=true\n"
			"#persist.speaker.prot.enable=false\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=1\n"
			"\n"
			"#\n"
			"# system props for the dpm module\n"
			"#\n"
			"#ifdef VENDOR_EDIT\n"
			"#Yuanhua.Du@AirService.Telephony, 2015/06/01  modify to enable NSRM feature\n"
			"persist.dpm.feature=7\n"
			"#else\n"
			"#persist.dpm.feature=3\n"
			"#endif\n"
			"\n"
			"#system props for the MM modules\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"media.msm8939hw=0\n"
			"media.msm8929hw=0\n"
			"mm.enable.smoothstreaming=true\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"\n"
			"# system prop for custom hls enhancements\n"
			"persist.media.hls.enhancements=false\n"
			"\n"
			"#codecs:DivxHD Divx FLAC QCP MP2TS 3G2 DTS AVI ASF AC3 AAC\n"
			"mm.enable.qcom_parser=3314291\n"
			"\n"
			"# Default to AwesomePlayer\n"
			"media.stagefright.use-awesome=false\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=true\n"
			"persist.data.netmgrd.qos.enable=true\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 131072 is decimal for 0x30000 to report version 3\n"
			"ro.opengles.version=196608\n"
			"\n"
			"# System property for cabl\n"
			"#ifdnef VENDOR_EDIT\n"
			"#Xiaori.Yuan@Mobile Phone Software Dept.Driver, 2015/04/07  close cabl\n"
			"#ro.qualcomm.cabl=2\n"
			"#else\n"
			"ro.qualcomm.cabl=0\n"
			"#endif\n"
			"\n"
			"#\n"
			"# System props for telephony\n"
			"# System prop to turn on CdmaLTEPhone always\n"
			"telephony.lteOnCdmaDevice=1\n"
			"\n"
			"#\n"
			"# System props for bluetooh\n"
			"# System prop to turn on hfp client\n"
			"bluetooth.hfp.client=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=none\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.speaker=true\n"
			"#Set for msm8916\n"
			"tunnel.audio.encode = false\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=64\n"
			"#Minimum duration for offload playback in secs\n"
			"audio.offload.min.duration.secs=30\n"
			"#Enable offload audio video playback by default\n"
			"av.offload.enable=true\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=true\n"
			"\n"
			"#System property for FM transmitter\n"
			"ro.fm.transmitter=false\n"
			"#enable dsp gapless mode by default\n"
			"audio.offload.gapless.enabled=true\n"
			"#Audio voice concurrency related flags\n"
			"voice.playback.conc.disabled=true\n"
			"#ifdef VENDOR_EDIT\n"
			"#LiLe@Prd6.BasicDrv.Audio, 2016/08/26, add for voice record and voip record permission\n"
			"voice.record.conc.disabled=false\n"
			"voice.voip.conc.disabled=false\n"
			"#else\n"
			"#voice.record.conc.disabled=true\n"
			"#voice.voip.conc.disabled=true\n"
			"#endif /* VENDOR_EDIT */\n"
			"\n"
			"#Set read only default composition for USB\n"
			"ro.sys.usb.default.config=diag,serial_smd,rmnet_bam,adb\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=1\n"
			"#property to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=1\n"
			"#property to enable narrow search range for video encoding\n"
			"vidc.enc.narrow.searchrange=1\n"
			"\n"
			"#property to enable DS2 dap\n"
			"audio.dolby.ds2.enabled=true\n"
			"\n"
			"#Trim properties\n"
			"ro.sys.fw.use_trim_settings=true\n"
			"ro.sys.fw.empty_app_percent=50\n"
			"ro.sys.fw.trim_empty_percent=100\n"
			"ro.sys.fw.trim_cache_percent=100\n"
			"ro.sys.fw.trim_enable_memory=1073741824\n"
			"\n"
			"#Enable B service adj transition by default\n"
			"ro.sys.fw.bservice_enable=true\n"
			"ro.sys.fw.bservice_limit=5\n"
			"ro.sys.fw.bservice_age=5000\n"
			"\n"
			"ro.sys.fw.dex2oat_thread_count=4\n"
			"#min/max cpu in core control\n"
			"ro.core_ctl_min_cpu=2\n"
			"ro.core_ctl_max_cpu=4\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"keyguard.no_require_sim=true\n"
			"ro.com.android.dataroaming=true\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.alarm_alert=alarm_001.ogg\n"
			"ro.config.ringtone=ringtone_001.ogg\n"
			"ro.config.notification_sound=notification_001.ogg\n"
			"ro.config.ringtone_sim2=ringtone_001.ogg\n"
			"ro.config.notification_sim2=notification_001.ogg\n"
			"ro.config.calendar_sound=notification_003.ogg\n"
			"ro.carrier=unknown\n"
			"ro.oppo.theme.version=800\n"
			"ro.ril.hsxpa=1\n"
			"ro.ril.gprsclass=10\n"
			"ro.adb.qemud=1\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"persist.radio.sib16_support=1\n"
			"ro.frp.pst=/dev/block/bootdevice/by-name/config\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=5.1_r3\n"
			"drm.service.enabled=true\n"
			"ro.dex2oat_white_list=com.google.android.gms:\n"
			"dalvik.vm.heapstartsize=16m\n"
			"dalvik.vm.heapgrowthlimit=256m\n"
			"dalvik.vm.heapsize=512m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=4m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"persist.sys.dalvik.vm.lib.2=libart.so\n"
			"dalvik.vm.isa.arm64.features=div,needfix_835769\n"
			"dalvik.vm.isa.arm.features=div\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.gps.qc_nlp_in_use=1\n"
			"persist.loc.nlp_name=com.qualcomm.location\n"
			"ro.gps.agps_provider=1\n"
			"ro.pip.gated=0\n"
			"# \n"
			"# \n"
			"# \n"
			"# \n"
			"# begin build oppo properties\n"
			"# autogenerated by oppo_buildinfo.sh\n"
			"ro.build.date.Ymd=170701\n"
			"ro.build.date.ymd=170701\n"
			"ro.build.date.YmdHM=201707011131\n"
			"ro.common.soft=MSM_15399\n"
			"ro.build.version.incremental=1480422943\n"
			"ro.build.product=A37f\n"
			"ro.product.name=A37f\n"
			"ro.product.model=A37f\n"
			"ro.build.version.opporom=V3.0.0i\n"
			"ro.build.version.ota=A37fEX_11.A.23_INT_023_201707010938\n"
			"ro.build.soft.majorversion=\n"
			"ro.build.display.id=A37fEX_11_170701\n"
			"ro.build.display.full_id=A37fEX_11_A.23_170701\n"
			"ro.build.soft.version=A.23\n"
			"ro.xxversion=v0.5\n"
			"ro.build.kernel.id=3.10.28-G201707010938\n"
			"ro.oppo.version=US\n"
			"ro.oppo.build.exp=US\n"
			"persist.sys.oppo.region=US\n"
			"persist.sys.timezone=America/New_York\n"
			"persist.power.useautobrightadj=true\n"
			"persist.oppo.ctsversion=false\n"
			"persist.radio.multisim.config=dsds\n"
			"# end build oppo properties\n"
			"ro.rf_version=W_G_L_15399\n"
			"ro.telephony.default_network=9,1\n"
			"persist.radio.custom_exp_ecc=1\n"
			"sys.hwc.gpu_perf_mode=1\n"
			"ro.build.ota.versionname=A37fEX_11_170701\n"
			"persist.radio.sap_silent_pin=true\n"
			"ro.dirac.max_active.powersound=3\n"
			"ro.dirac.max_active.headset=5\n"
			"ro.dirac.poolsize=6\n"
			"ro.dirac.config=2\n"
			"persist.sys.startupmanager=false\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/bus_split",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/default_pwrlevel",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/dev",
		.size = 7,
		.content = "240:0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_frequencies",
		.size = 31,
		.content = "400000000 310000000 200000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/available_governors",
		.size = 89,
		.content =
			"bw_vbif gpubw_mon msm-adreno-tz cpufreq userspace powersave performance simple_ondemand\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/cur_freq",
		.size = 11,
		.content = "310000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/governor",
		.size = 15,
		.content = "msm-adreno-tz\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/max_freq",
		.size = 11,
		.content = "400000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/min_freq",
		.size = 11,
		.content = "200000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/polling_interval",
		.size = 4,
		.content = "10\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/target_freq",
		.size = 11,
		.content = "400000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/devfreq/trans_stat",
		.size = 232,
		.content = "   From  :   To\r\n"
			   "         :400000000310000000200000000   time(ms)\r\n"
			   "*400000000:       0      49       0     43170\r\n"
			   " 310000000:      49       0      11    584160\r\n"
			   " 200000000:       1      10       0      6310\r\n"
			   "Total transition : 120\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_fast_hang_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_hang_intr_status",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_long_ib_detect",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_pagefault_policy",
		.size = 5,
		.content = "0x1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/ft_policy",
		.size = 6,
		.content = "0xC2\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpu_available_frequencies",
		.size = 32,
		.content = "400000000 310000000 200000000 \r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpubusy",
		.size = 17,
		.content = "  53613 1001251\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/gpuclk",
		.size = 11,
		.content = "310000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/idle_timer",
		.size = 4,
		.content = "80\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_gpuclk",
		.size = 11,
		.content = "400000000\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/max_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/min_pwrlevel",
		.size = 3,
		.content = "2\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/num_pwrlevels",
		.size = 3,
		.content = "3\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/pmqos_active_latency",
		.size = 5,
		.content = "701\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/reset_count",
		.size = 5,
		.content = "307\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/sptp_pc",
		.size = 3,
		.content = "1\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/thermal_pwrlevel",
		.size = 3,
		.content = "0\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_nice",
		.size = 4,
		.content = "-7\r\n",
	},
	{
		.path = "/sys/class/kgsl/kgsl-3d0/wake_timeout",
		.size = 5,
		.content = "100\r\n",
	},
	{
		.path = "/sys/devices/soc0/accessory_chip",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/build_id",
		.size = 25,
		.content = "8916A-HAAAANAZA-40000000\n",
	},
	{
		.path = "/sys/devices/soc0/hw_platform",
		.size = 4,
		.content = "MTP\n",
	},
	{
		.path = "/sys/devices/soc0/image_crm_version",
		.size = 5,
		.content = "REL\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/image_variant",
		.size = 12,
		.content = "A37fw-user\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/image_version",
		.size = 22,
		.content = "10:LMY47V:1456818039\n"
			   "\n",
	},
	{
		.path = "/sys/devices/soc0/machine",
		.size = 11,
		.content = "Snapdragon\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype",
		.size = 8,
		.content = "Unknown\n",
	},
	{
		.path = "/sys/devices/soc0/platform_subtype_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/platform_version",
		.size = 6,
		.content = "65536\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_die_revision",
		.size = 7,
		.content = "131072\n",
	},
	{
		.path = "/sys/devices/soc0/pmic_model",
		.size = 6,
		.content = "65547\n",
	},
	{
		.path = "/sys/devices/soc0/raw_id",
		.size = 5,
		.content = "1797\n",
	},
	{
		.path = "/sys/devices/soc0/raw_version",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/soc0/revision",
		.size = 4,
		.content = "1.0\n",
	},
	{
		.path = "/sys/devices/soc0/select_image",
		.size = 3,
		.content = "10\n",
	},
	{
		.path = "/sys/devices/soc0/soc_id",
		.size = 4,
		.content = "206\n",
	},
	{
		.path = "/sys/devices/soc0/vendor",
		.size = 9,
		.content = "Qualcomm\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/modalias",
		.size = 46,
		.content = "cpu:type:aarch64:feature:,0000,0001,0002,0007\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 60,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 89,
		.content = "200000 0\n"
			   "400000 0\n"
			   "533333 0\n"
			   "800000 53148\n"
			   "998400 2868\n"
			   "1094400 127\n"
			   "1152000 240\n"
			   "1209600 7183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 4,
		.content = "922\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 60,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 89,
		.content = "200000 0\n"
			   "400000 0\n"
			   "533333 0\n"
			   "800000 53373\n"
			   "998400 2868\n"
			   "1094400 127\n"
			   "1152000 240\n"
			   "1209600 7183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 4,
		.content = "922\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 60,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 89,
		.content = "200000 0\n"
			   "400000 0\n"
			   "533333 0\n"
			   "800000 53580\n"
			   "998400 2876\n"
			   "1094400 127\n"
			   "1152000 240\n"
			   "1209600 7183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 4,
		.content = "924\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpuidle/driver/name",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1209600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 60,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "800000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 89,
		.content = "200000 0\n"
			   "400000 0\n"
			   "533333 0\n"
			   "800000 53818\n"
			   "998400 2876\n"
			   "1094400 127\n"
			   "1152000 240\n"
			   "1209600 7183\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 4,
		.content = "924\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{NULL},
};
#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "64",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.min.duration.secs",
		.value = "30",
	},
	{
		.key = "av.offload.enable",
		.value = "true",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "camera2.portability.force_api",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "4m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "16m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "div",
	},
	{
		.key = "dalvik.vm.isa.arm64.features",
		.value = "div,needfix_835769",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.cpurend.vsync",
		.value = "true",
	},
	{
		.key = "debug.egl.hw",
		.value = "0",
	},
	{
		.key = "debug.enable.sglscale",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.idletime",
		.value = "600",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.oppo.morning.time",
		.value = "3 : 19",
	},
	{
		.key = "debug.sf.hw",
		.value = "0",
	},
	{
		.key = "dev.bootcomplete",
		.value = "1",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "dhcp.wlan0.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "dhcp.wlan0.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "dhcp.wlan0.dns3",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.dns4",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.domain",
		.value = "tfbnw.net",
	},
	{
		.key = "dhcp.wlan0.gateway",
		.value = "172.22.192.1",
	},
	{
		.key = "dhcp.wlan0.ipaddress",
		.value = "172.22.215.15",
	},
	{
		.key = "dhcp.wlan0.leasetime",
		.value = "1800",
	},
	{
		.key = "dhcp.wlan0.mask",
		.value = "255.255.224.0",
	},
	{
		.key = "dhcp.wlan0.mtu",
		.value = "",
	},
	{
		.key = "dhcp.wlan0.pid",
		.value = "2085",
	},
	{
		.key = "dhcp.wlan0.reason",
		.value = "REBOOT",
	},
	{
		.key = "dhcp.wlan0.result",
		.value = "ok",
	},
	{
		.key = "dhcp.wlan0.server",
		.value = "192.168.137.185",
	},
	{
		.key = "dhcp.wlan0.vendorInfo",
		.value = "",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1,1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown,Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false,false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.serial",
		.value = "001539227802032300006672",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = ",",
	},
	{
		.key = "gsm.sim.operator.spn",
		.value = "No service,No service",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT,ABSENT",
	},
	{
		.key = "gsm.version.baseband",
		.value = "Q_V1_P14,Q_V1_P14",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "hw.cabl.version",
		.value = "1.1.20130401",
	},
	{
		.key = "hw.cabl.yuv",
		.value = "0",
	},
	{
		.key = "hw.pp.cfg",
		.value = "/data/misc/display/pp_data.cfg",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.block-mode",
		.value = "stopped",
	},
	{
		.key = "init.svc.bms-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "stopped",
	},
	{
		.key = "init.svc.charger",
		.value = "stopped",
	},
	{
		.key = "init.svc.cnd",
		.value = "running",
	},
	{
		.key = "init.svc.cnss-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.config-zram",
		.value = "stopped",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.criticallog",
		.value = "running",
	},
	{
		.key = "init.svc.datafree",
		.value = "stopped",
	},
	{
		.key = "init.svc.datasync",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd64",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.dhcpcd_wlan0",
		.value = "running",
	},
	{
		.key = "init.svc.diag_mdlog_stop",
		.value = "stopped",
	},
	{
		.key = "init.svc.dpmd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.engineermode-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.imsdatadaemon",
		.value = "running",
	},
	{
		.key = "init.svc.imsqmidaemon",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.odbd",
		.value = "stopped",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.perfd",
		.value = "running",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.prop-self-adap",
		.value = "stopped",
	},
	{
		.key = "init.svc.psensord",
		.value = "running",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-debug",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-post-boot",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-usb-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.rfs_access",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon2",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.rootdetect-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.rutilsdaemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.sdcard",
		.value = "running",
	},
	{
		.key = "init.svc.sensor_work",
		.value = "stopped",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.usb_uicc_daemon",
		.value = "stopped",
	},
	{
		.key = "init.svc.usb_uicc_enable",
		.value = "stopped",
	},
	{
		.key = "init.svc.vm_bms",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.wifiserver",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "init.svc.zygote_secondary",
		.value = "running",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.msm8929hw",
		.value = "0",
	},
	{
		.key = "media.msm8939hw",
		.value = "0",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "media.stagefright.use-awesome",
		.value = "false",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "3314291",
	},
	{
		.key = "mm.enable.smoothstreaming",
		.value = "true",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.hostname",
		.value = "android-d4ca7f6fcc9702ef",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.buffersize.default",
		.value = "4096,87380,524288,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.edge",
		.value = "4093,26280,35040,4096,16384,35040",
	},
	{
		.key = "net.tcp.buffersize.evdo",
		.value = "4094,87380,524288,4096,16384,262144",
	},
	{
		.key = "net.tcp.buffersize.gprs",
		.value = "4092,8760,11680,4096,8760,11680",
	},
	{
		.key = "net.tcp.buffersize.hsdpa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hspap",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.hsupa",
		.value = "4094,87380,1220608,4096,16384,1220608",
	},
	{
		.key = "net.tcp.buffersize.lte",
		.value = "2097152,4194304,8388608,262144,524288,1048576",
	},
	{
		.key = "net.tcp.buffersize.umts",
		.value = "4094,87380,110208,4096,16384,110208",
	},
	{
		.key = "net.tcp.buffersize.wifi",
		.value = "524288,2097152,4194304,262144,524288,1048576",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "oppo.clear.running",
		.value = "0",
	},
	{
		.key = "oppo.device.firstboot",
		.value = "0",
	},
	{
		.key = "oppo.dex.front.package",
		.value = "com.android.settings",
	},
	{
		.key = "oppo.hostap.state",
		.value = "0",
	},
	{
		.key = "oppo.roam.renew",
		.value = "0",
	},
	{
		.key = "oppo.rutils.used.count",
		.value = "0",
	},
	{
		.key = "oppo.service.datafree.enable",
		.value = "1",
	},
	{
		.key = "oppo.service.datasync.enable",
		.value = "0",
	},
	{
		.key = "oppo.service.rutils.enable",
		.value = "0",
	},
	{
		.key = "persist.allcommode",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.boot_time",
		.value = "6",
	},
	{
		.key = "persist.cne.feature",
		.value = "1",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "true",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "1",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.dpm.feature",
		.value = "3",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "1",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "1",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.loc.nlp_name",
		.value = "com.qualcomm.location",
	},
	{
		.key = "persist.media.hls.enhancements",
		.value = "false",
	},
	{
		.key = "persist.oppo.ctsversion",
		.value = "false",
	},
	{
		.key = "persist.oppo.signal",
		.value = "4000",
	},
	{
		.key = "persist.power.useautobrightadj",
		.value = "true",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.custom_exp_ecc",
		.value = "1",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.force_on_dc",
		.value = "true",
	},
	{
		.key = "persist.radio.lte_vrte_ltd",
		.value = "1",
	},
	{
		.key = "persist.radio.msim.stackid_0",
		.value = "0",
	},
	{
		.key = "persist.radio.msim.stackid_1",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.rat_on",
		.value = "legacy",
	},
	{
		.key = "persist.radio.ril_payload_on",
		.value = "0",
	},
	{
		.key = "persist.radio.sap_silent_pin",
		.value = "true",
	},
	{
		.key = "persist.radio.sib16_support",
		.value = "1",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:31:0f:8d:ff",
	},
	{
		.key = "persist.sys.911.shutdown",
		.value = "1",
	},
	{
		.key = "persist.sys.adb.engineermode",
		.value = "1",
	},
	{
		.key = "persist.sys.adddevdiag",
		.value = "0",
	},
	{
		.key = "persist.sys.allcommode",
		.value = "false",
	},
	{
		.key = "persist.sys.assert.panic",
		.value = "false",
	},
	{
		.key = "persist.sys.assert.state",
		.value = "false",
	},
	{
		.key = "persist.sys.cfu_auto",
		.value = "1",
	},
	{
		.key = "persist.sys.cnd.iwlan",
		.value = "1",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.device_first_boot",
		.value = "0",
	},
	{
		.key = "persist.sys.dpmd.nsrm",
		.value = "3",
	},
	{
		.key = "persist.sys.dump",
		.value = "0",
	},
	{
		.key = "persist.sys.modem",
		.value = "no",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.net",
		.value = "no",
	},
	{
		.key = "persist.sys.oem_smooth",
		.value = "1",
	},
	{
		.key = "persist.sys.oppo.displaymetrics",
		.value = "720,1280",
	},
	{
		.key = "persist.sys.oppo.dragstate",
		.value = "0",
	},
	{
		.key = "persist.sys.oppo.region.netlock",
		.value = "1",
	},
	{
		.key = "persist.sys.oppo.region",
		.value = "US",
	},
	{
		.key = "persist.sys.oppo.screendrag",
		.value = "0,0,0,0.0",
	},
	{
		.key = "persist.sys.oppo.usbactive",
		.value = "false",
	},
	{
		.key = "persist.sys.panic.file",
		.value = "",
	},
	{
		.key = "persist.sys.permission.enable",
		.value = "false",
	},
	{
		.key = "persist.sys.poweralarm.time",
		.value = "-1",
	},
	{
		.key = "persist.sys.poweroffsound",
		.value = "1",
	},
	{
		.key = "persist.sys.poweronsound",
		.value = "1",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.quick.REBOOT",
		.value = "1502426956599;1;25000",
	},
	{
		.key = "persist.sys.savetosdcard",
		.value = "true",
	},
	{
		.key = "persist.sys.screenshot.times",
		.value = "3",
	},
	{
		.key = "persist.sys.silencereboot",
		.value = "0",
	},
	{
		.key = "persist.sys.startupmanager",
		.value = "false",
	},
	{
		.key = "persist.sys.systemserver.pid",
		.value = "959",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/New_York",
	},
	{
		.key = "persist.sys.usb.config.extra",
		.value = "none",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,mass_storage,adb",
	},
	{
		.key = "persist.sys.wipemedia",
		.value = "0",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "persist.version.confidential",
		.value = "false",
	},
	{
		.key = "qcom.audio.init",
		.value = "complete",
	},
	{
		.key = "ril.ecclist1",
		.value = "911,120,122,112,000,08,110,999,118,119",
	},
	{
		.key = "ril.ecclist",
		.value = "911,120,122,112,000,08,110,999,118,119",
	},
	{
		.key = "ril.qcril_pre_init_lock_held",
		.value = "0",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/vendor/lib64/libril-qc-qmi-1.so",
	},
	{
		.key = "ro.adb.qemud",
		.value = "1",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.dun",
		.value = "true",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.bluetooth.sap",
		.value = "true",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8916",
	},
	{
		.key = "ro.boot.authorized_kernel",
		.value = "true",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "7824900.sdhci",
	},
	{
		.key = "ro.boot.console",
		.value = "ttyHSL0",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.serialno",
		.value = "90ba9bca",
	},
	{
		.key = "ro.boot.startupmode",
		.value = "unknow",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.build.characteristics",
		.value = "nosdcard",
	},
	{
		.key = "ro.build.date.YmdHM",
		.value = "201707011131",
	},
	{
		.key = "ro.build.date.Ymd",
		.value = "170701",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1498879906",
	},
	{
		.key = "ro.build.date.ymd",
		.value = "170701",
	},
	{
		.key = "ro.build.date",
		.value = "Sat Jul  1 11:31:46 CST 2017",
	},
	{
		.key = "ro.build.description",
		.value = "msm8916_64-user 5.1.1 LMY47V eng.root.20170701.113014 release-keys",
	},
	{
		.key = "ro.build.display.full_id",
		.value = "A37fwEX_11_A.23_170701",
	},
	{
		.key = "ro.build.display.id",
		.value = "A37fwEX_11_170701",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "OPPO/A37fw/A37f:5.1.1/LMY47V/1496912041:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "msm8916_64-user",
	},
	{
		.key = "ro.build.host",
		.value = "ubuntu-122-192",
	},
	{
		.key = "ro.build.id",
		.value = "LMY47V",
	},
	{
		.key = "ro.build.kernel.id",
		.value = "3.10.28-G201707010938",
	},
	{
		.key = "ro.build.ota.versionname",
		.value = "A37fwEX_11_170701",
	},
	{
		.key = "ro.build.product",
		.value = "A37fw",
	},
	{
		.key = "ro.build.release_type",
		.value = "true",
	},
	{
		.key = "ro.build.soft.majorversion",
		.value = "",
	},
	{
		.key = "ro.build.soft.version",
		.value = "A.23",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "root",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "OPPO/A37fw/A37f:5.1.1/LMY47V/1487588453:user/release-keys",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "1456818039",
	},
	{
		.key = "ro.build.version.opporom",
		.value = "V3.0.0i",
	},
	{
		.key = "ro.build.version.ota",
		.value = "A37fEX_11.A.23_INT_023_201707010938",
	},
	{
		.key = "ro.build.version.release",
		.value = "5.1.1",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "22",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-06-01",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "true",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-oppo",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "5.1_r3",
	},
	{
		.key = "ro.common.soft",
		.value = "MSM_15399",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "alarm_001.ogg",
	},
	{
		.key = "ro.config.calendar_sound",
		.value = "notification_003.ogg",
	},
	{
		.key = "ro.config.notification_sim2",
		.value = "notification_001.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "notification_001.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "ringtone_001.ogg",
	},
	{
		.key = "ro.config.ringtone_sim2",
		.value = "ringtone_001.ogg",
	},
	{
		.key = "ro.core_ctl_max_cpu",
		.value = "4",
	},
	{
		.key = "ro.core_ctl_min_cpu",
		.value = "2",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.dex2oat_white_list",
		.value = "com.google.android.gms:",
	},
	{
		.key = "ro.dirac.config",
		.value = "2",
	},
	{
		.key = "ro.dirac.max_active.headset",
		.value = "5",
	},
	{
		.key = "ro.dirac.max_active.powersound",
		.value = "3",
	},
	{
		.key = "ro.dirac.poolsize",
		.value = "6",
	},
	{
		.key = "ro.factorytest",
		.value = "0",
	},
	{
		.key = "ro.fm.transmitter",
		.value = "false",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/bootdevice/by-name/config",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.min_freq_0",
		.value = "800000",
	},
	{
		.key = "ro.modem_type",
		.value = "1",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.operator_name",
		.value = "108",
	},
	{
		.key = "ro.oppo.build.exp",
		.value = "US",
	},
	{
		.key = "ro.oppo.theme.version",
		.value = "800",
	},
	{
		.key = "ro.oppo.version",
		.value = "US",
	},
	{
		.key = "ro.pcb_version",
		.value = "4",
	},
	{
		.key = "ro.pip.gated",
		.value = "0",
	},
	{
		.key = "ro.prj_version",
		.value = "15399",
	},
	{
		.key = "ro.product.board",
		.value = "msm8916",
	},
	{
		.key = "ro.product.brand",
		.value = "OPPO",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "arm64-v8a",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "arm64-v8a,armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.device",
		.value = "A37f",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "OPPO",
	},
	{
		.key = "ro.product.model",
		.value = "A37fw",
	},
	{
		.key = "ro.product.name",
		.value = "A37fw",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "none",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bluetooth.ftp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hfp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.hsp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.map",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.nap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.opp",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bluetooth.pbap",
		.value = "true",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "0",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.rf_version",
		.value = "W_G_L_15399",
	},
	{
		.key = "ro.ril.gprsclass",
		.value = "10",
	},
	{
		.key = "ro.ril.hsxpa",
		.value = "1",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.runtime.firstboot",
		.value = "1524189236936",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "90ba9bca",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sys.full_disk_ecryption",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_age",
		.value = "5000",
	},
	{
		.key = "ro.sys.fw.bservice_enable",
		.value = "true",
	},
	{
		.key = "ro.sys.fw.bservice_limit",
		.value = "5",
	},
	{
		.key = "ro.sys.fw.dex2oat_thread_count",
		.value = "4",
	},
	{
		.key = "ro.sys.fw.empty_app_percent",
		.value = "50",
	},
	{
		.key = "ro.sys.fw.trim_cache_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_empty_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_enable_memory",
		.value = "1073741824",
	},
	{
		.key = "ro.sys.fw.use_trim_settings",
		.value = "true",
	},
	{
		.key = "ro.sys.oppo.singlecard",
		.value = "false",
	},
	{
		.key = "ro.sys.usb.default.config",
		.value = "diag,serial_smd,rmnet_bam,adb",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9,1",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.wandrfmode",
		.value = "0",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.xxversion",
		.value = "v0.5",
	},
	{
		.key = "ro.zygote",
		.value = "zygote64_32",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "sys.boot_completed",
		.value = "1",
	},
	{
		.key = "sys.hwc.gpu_perf_mode",
		.value = "1",
	},
	{
		.key = "sys.ims.QMI_DAEMON_STATUS",
		.value = "1",
	},
	{
		.key = "sys.oppo.screenshot",
		.value = "0",
	},
	{
		.key = "sys.power.screenoff.reason",
		.value = "2",
	},
	{
		.key = "sys.settings_global_version",
		.value = "8",
	},
	{
		.key = "sys.settings_secure_version",
		.value = "6",
	},
	{
		.key = "sys.settings_system_version",
		.value = "1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.sysctl.tcp_def_init_rwnd",
		.value = "60",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,mass_storage,adb",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "0",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,mass_storage,adb",
	},
	{
		.key = "sys.usb_uicc.enabled",
		.value = "0",
	},
	{
		.key = "sys.usb_uicc.loading",
		.value = "1",
	},
	{
		.key = "telephony.imei_0",
		.value = "865266031167696",
	},
	{
		.key = "telephony.imei_1",
		.value = "865266031167688",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "1",
	},
	{
		.key = "tunnel.audio.encode",
		.value = "false",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "true",
	},
	{
		.key = "vidc.enc.narrow.searchrange",
		.value = "0",
	},
	{
		.key = "voice.playback.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.record.conc.disabled",
		.value = "false",
	},
	{
		.key = "voice.voip.conc.disabled",
		.value = "false",
	},
	{
		.key = "vold.pfe",
		.value = "deactivated",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.config",
		.value = "/data/misc/wifi/WCNSS_qcom_cfg.ini",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{NULL},
};
#endif /* __ANDROID__ */
