<script language="javascript" src="<?php echo $this->config->item('js_path');?>jquery-plugin/jquery.validate.min.js"></script>
<script type="text/javascript">
	$(document).ready(function() {
		// validation
		$("#settingsForm").validate({
			escapeHtml: true,
			rules: {
				phone_number: {
					required: true,
					remote: {
						url: "<?php echo site_url('kalkun/phone_number_validation'); ?>",
						type: "get",
						data: {
							phone: function() {
								return $("#phone_number").val();
							},
						}
					}
				},
			},
			messages: {
				phone_number: {
					required: <?php echo tr_js('Field required.'); ?>,
				},
			},
			submitHandler: function(form) {
				document.getElementById('settingsForm').submit();
			}
		});
	});

</script>
<table class="settings">
	<tr>
		<td><?php echo tr('Name'); ?></td>
		<td>
			<input type="text" name="realname" value="<?php echo htmlentities($settings->row('realname'), ENT_QUOTES);?>" />
		</td>
	</tr>

	<tr>
		<td><?php echo tr('Username'); ?></td>
		<td>
			<input type="text" name="username" value="<?php echo htmlentities($settings->row('username'), ENT_QUOTES);?>" />
		</td>
	</tr>

	<tr>
		<td><?php echo tr('Telephone number'); ?></td>
		<td>
			<input type="text" id="phone_number" name="phone_number" value="<?php echo htmlentities($settings->row('phone_number'), ENT_QUOTES);?>" />
		</td>
	</tr>

	<tr>
		<td><?php echo tr('Signature'); ?><br /><small><?php echo tr('Max. 50 characters'); ?></small></td>
		<td>
			<?php list($sig_option, $sig) = explode(';', $settings->row('signature'));?>
			<input type="radio" id="signature_off" name="signatureoption" value="false" <?php if ($sig_option === 'false')
{
	echo 'checked="checked"';
} ?> />
			<label for="signature_off"><?php echo tr('Disable'); ?></label><br />
			<input type="radio" id="signature_on" name="signatureoption" value="true" <?php if ($sig_option === 'true')
{
	echo 'checked="checked"';
} ?> />
			<label for="signature_on"><?php echo tr('Enable'); ?></label><br />
			<textarea name="signature" rows="5" cols="40"><?php echo htmlentities($sig, ENT_QUOTES); ?></textarea>
			<div class="note"><?php echo tr('Signature is added at the end of the message.'); ?></div>
		</td>
	</tr>
</table>
<input type="hidden" name="option" value="personal" />
