# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicebus.aio import ServiceBusManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceBusManagementMigrationConfigsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceBusManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.migration_configs.list(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2021-11-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_and_start_migration(self, resource_group):
        response = await (
            await self.client.migration_configs.begin_create_and_start_migration(
                resource_group_name=resource_group.name,
                namespace_name="str",
                config_name="str",
                parameters={
                    "id": "str",
                    "location": "str",
                    "migrationState": "str",
                    "name": "str",
                    "pendingReplicationOperationsCount": 0,
                    "postMigrationName": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "targetNamespace": "str",
                    "type": "str",
                },
                api_version="2021-11-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delete(self, resource_group):
        response = await self.client.migration_configs.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            config_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.migration_configs.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            config_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_complete_migration(self, resource_group):
        response = await self.client.migration_configs.complete_migration(
            resource_group_name=resource_group.name,
            namespace_name="str",
            config_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_revert(self, resource_group):
        response = await self.client.migration_configs.revert(
            resource_group_name=resource_group.name,
            namespace_name="str",
            config_name="str",
            api_version="2021-11-01",
        )

        # please add some check logic here by yourself
        # ...
