% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{degMean}
\alias{degMean}
\title{Distribution of pvalues by expression range}
\usage{
degMean(pvalues, counts)
}
\arguments{
\item{pvalues}{pvalues of DEG analysis.}

\item{counts}{Matrix with counts for each samples and each gene.
row number should be the same length than pvalues vector.}
}
\value{
ggplot2 object
}
\description{
This function plot the p-values distribution colored by
the quantiles of the average count data.
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dds <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dds <- DESeq(dds)
res <- results(dds)
degMean(res[, 4], counts(dds))
}
