% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setPriorVcf.R
\name{setPriorVcf}
\alias{setPriorVcf}
\title{Set Somatic Prior VCF}
\usage{
setPriorVcf(
  vcf,
  prior.somatic = c(0.5, 5e-04, 0.999, 1e-04, 0.995, 0.5),
  tumor.id.in.vcf = NULL,
  min.cosmic.cnt = 6,
  DB.info.flag = "DB",
  Cosmic.CNT.info.field = "Cosmic.CNT"
)
}
\arguments{
\item{vcf}{\code{CollapsedVCF} object, read in with the \code{readVcf}
function from the VariantAnnotation package.}

\item{prior.somatic}{Prior probabilities for somatic mutations. First value
is for the case when no matched normals are available and the variant is not
in dbSNP (second value). Third value is for variants with MuTect somatic
call. Different from 1, because somatic mutations in segments of copy number
0 have 0 probability and artifacts can thus have dramatic influence on
likelihood score. Forth value is for variants not labeled as somatic by
MuTect. Last two values are optional, if vcf contains a flag Cosmic.CNT, it
will set the prior probability for variants with CNT > 2 to the first of
those values in case of no matched normal available (0.995 default).  Final
value is for the case that variant is in both dbSNP and COSMIC > 2.}

\item{tumor.id.in.vcf}{Id of tumor in case multiple samples are stored in
VCF.}

\item{min.cosmic.cnt}{Minimum number of hits in the COSMIC database to 
call variant as likely somatic.}

\item{DB.info.flag}{Flag in INFO of VCF that marks presence in common
germline databases. Defaults to \code{DB} that may contain somatic variants
if it is from an unfiltered dbSNP VCF.}

\item{Cosmic.CNT.info.field}{Info field containing hits in the Cosmic database}
}
\value{
The \code{vcf} with \code{numeric(nrow(vcf))} vector with the
prior probability of somatic status for each variant in the 
\code{CollapsedVCF} added to the \code{INFO} field \code{PR}.
}
\description{
Function to set prior for somatic mutation status for each variant in the
provided \code{CollapsedVCF} object.
}
\examples{

# This function is typically only called by runAbsoluteCN via the 
# fun.setPriorVcf and args.setPriorVcf comments.
vcf.file <- system.file("extdata", "example.vcf.gz", package="PureCN")
vcf <- readVcf(vcf.file, "hg19")
vcf <- setPriorVcf(vcf)        

}
\author{
Markus Riester
}
