% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hepatitis}
\alias{hepatitis}
\title{Post-transfusion hepatitis: impact of non-A, non-B hepatitis
surrogate tests}
\format{
A data frame with 28 rows and the following 6 columns:
\itemize{
\item \code{city}: Subjects were recruited from 3 Canadian Red Cross Society
Blood Centres and 13 university-affiliated hospitals in 3 cities:
Toronto, Hamilton and Winnipeg.
\item \code{group}: Eligible subjects were assigned to one of two allogenic
blood recipient groups.  One group received products that had only
routine Canadian transfusion-transmissible disease marker screening
(no-withhold).  The other group received only products that were
not positive for NANB surrogate markers (withhold).
\item \code{time}: Hepatitis C (HCV) screening was introduced in Canada in
May, 1990.  Subjects were recruited into the study before (pre) and
after (post) the introduction of anti-HCV testing.
\item \code{HCV}: Post-transfusion HCV hepatitis present (1) or absent (0).
\item \code{nonABC}: Post-transfusion non-A, non-B, non-C hepatitis present (1) or absent (0)
\item \code{counts}: Number of subjects
}
}
\source{
Data is from Blajchman et al. (1995), also analyzed in Bull et
al. (2002), and is also provided by the
\href{https://cran.r-project.org/package=pmlr}{\pkg{pmlr}} R package.
}
\usage{
hepatitis
}
\description{
Data from a randomized double-blind trial to assess whether
withholding donor blood positive for the non-A, non-B (\code{"NANB"})
surrogate markers would reduce the frequency of post-transfusion
hepatitis.  The dataset contains \code{4588} subjects enrolled from 1988
to 1992 into two study groups that received allogenic blood from
which units positive for NANB surrogate markers were withheld (n =
\code{2311}) or not withheld (n = \code{2277}).  Subjects were followed up
for 6 months and assessed for the presence of post-transfusion
hepatitis.
}
\references{
Bull S B, Mak C, Greenwood C M T (2002). A modified score function
estimator for multinomial logistic regression in small
samples. \emph{Computational Statistics & Data Analysis}, \strong{39},
57-74. \doi{10.1016/S0167-9473(01)00048-2}

Blajchman M A, Bull S B and Feinman S V (1995). Post-transfusion
hepatitis: impact of non-A, non-B hepatitis surrogate tests. \emph{The
Lancet}, \strong{345}, 21--25. \doi{10.1016/S0140-6736(95)91153-7}
}
\keyword{datasets}
