% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_dag.R
\name{is_graph_dag}
\alias{is_graph_dag}
\title{Is the graph a directed acyclic graph?}
\usage{
is_graph_dag(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A logical value.
}
\description{
Provides a logical value on whether the graph is a directed acyclic graph
(DAG). The conditions for a graph that is a DAG are that it should be a
directed graph and it should not contain any cycles.
}
\examples{
# Create a directed graph containing
# only a balanced tree
graph_tree <-
  create_graph() \%>\%
  add_balanced_tree(
    k = 2, h = 3)

# Determine whether this graph
# is a DAG
graph_tree \%>\%
  is_graph_dag()

# Create a directed graph containing
# a single cycle
graph_cycle <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine whether this graph
# is a DAG
graph_cycle \%>\%
  is_graph_dag()

# Create an undirected graph
# containing a balanced tree
graph_tree_undirected <-
  create_graph(
    directed = FALSE) \%>\%
  add_balanced_tree(
    k = 2, h = 2)

# Determine whether this graph
# is a DAG
graph_tree_undirected \%>\%
  is_graph_dag()

}
