% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-elements.R, R/margins.R
\name{element}
\alias{element_blank}
\alias{element_rect}
\alias{element_line}
\alias{element_text}
\alias{rel}
\alias{margin}
\title{Theme elements}
\usage{
element_blank()

element_rect(
  fill = NULL,
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  color = NULL,
  inherit.blank = FALSE,
  size = deprecated()
)

element_line(
  colour = NULL,
  linewidth = NULL,
  linetype = NULL,
  lineend = NULL,
  color = NULL,
  arrow = NULL,
  inherit.blank = FALSE,
  size = deprecated()
)

element_text(
  family = NULL,
  face = NULL,
  colour = NULL,
  size = NULL,
  hjust = NULL,
  vjust = NULL,
  angle = NULL,
  lineheight = NULL,
  color = NULL,
  margin = NULL,
  debug = NULL,
  inherit.blank = FALSE
)

rel(x)

margin(t = 0, r = 0, b = 0, l = 0, unit = "pt")
}
\arguments{
\item{fill}{Fill colour.}

\item{colour, color}{Line/border colour. Color is an alias for colour.}

\item{linewidth}{Line/border size in mm.}

\item{linetype}{Line type. An integer (0:8), a name (blank, solid,
dashed, dotted, dotdash, longdash, twodash), or a string with
an even number (up to eight) of hexadecimal digits which give the
lengths in consecutive positions in the string.}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}

\item{size}{text size in pts.}

\item{lineend}{Line end Line end style (round, butt, square)}

\item{arrow}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}}

\item{family}{Font family}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{hjust}{Horizontal justification (in \eqn{[0, 1]})}

\item{vjust}{Vertical justification (in \eqn{[0, 1]})}

\item{angle}{Angle (in \eqn{[0, 360]})}

\item{lineheight}{Line height}

\item{margin}{Margins around the text. See \code{\link[=margin]{margin()}} for more
details. When creating a theme, the margins should be placed on the
side of the text facing towards the center of the plot.}

\item{debug}{If \code{TRUE}, aids visual debugging by drawing a solid
rectangle behind the complete text area, and a point where each label
is anchored.}

\item{x}{A single number specifying size relative to parent element.}

\item{t, r, b, l}{Dimensions of each margin. (To remember order, think trouble).}

\item{unit}{Default units of dimensions. Defaults to "pt" so it
can be most easily scaled with the text.}
}
\value{
An S3 object of class \code{element}, \code{rel}, or \code{margin}.
}
\description{
In conjunction with the \link{theme} system, the \code{element_} functions
specify the display of how non-data components of the plot are drawn.
\itemize{
\item \code{element_blank()}: draws nothing, and assigns no space.
\item \code{element_rect()}: borders and backgrounds.
\item \code{element_line()}: lines.
\item \code{element_text()}: text.
}

\code{rel()} is used to specify sizes relative to the parent,
\code{margin()} is used to specify the margins of elements.
}
\examples{
plot <- ggplot(mpg, aes(displ, hwy)) + geom_point()

plot + theme(
  panel.background = element_blank(),
  axis.text = element_blank()
)

plot + theme(
  axis.text = element_text(colour = "red", size = rel(1.5))
)

plot + theme(
  axis.line = element_line(arrow = arrow())
)

plot + theme(
  panel.background = element_rect(fill = "white"),
  plot.margin = margin(2, 2, 2, 2, "cm"),
  plot.background = element_rect(
    fill = "grey90",
    colour = "black",
    linewidth = 1
  )
)
}
