% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tsn.R
\name{get_tsn}
\alias{get_tsn}
\alias{as.tsn}
\alias{as.tsn.tsn}
\alias{as.tsn.character}
\alias{as.tsn.list}
\alias{as.tsn.numeric}
\alias{as.tsn.data.frame}
\alias{as.data.frame.tsn}
\alias{get_tsn_}
\title{Get the TSN code for a search term.}
\usage{
get_tsn(
  searchterm,
  searchtype = "scientific",
  accepted = FALSE,
  ask = TRUE,
  messages = TRUE,
  rows = NA,
  ...
)

as.tsn(x, check = TRUE)

\method{as.tsn}{tsn}(x, check = TRUE)

\method{as.tsn}{character}(x, check = TRUE)

\method{as.tsn}{list}(x, check = TRUE)

\method{as.tsn}{numeric}(x, check = TRUE)

\method{as.tsn}{data.frame}(x, check = TRUE)

\method{as.data.frame}{tsn}(x, ...)

get_tsn_(
  searchterm,
  messages = TRUE,
  searchtype = "scientific",
  accepted = TRUE,
  rows = NA,
  ...
)
}
\arguments{
\item{searchterm}{character; A vector of common or scientific names.
Or, a \code{taxon_state} object (see \link{taxon-state})}

\item{searchtype}{character; One of 'scientific' or 'common', or any
unique abbreviation}

\item{accepted}{logical; If TRUE, removes names that are not accepted valid
names by ITIS. Set to \code{FALSE} (default) to give back both accepted
and unaccepted names.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If \code{TRUE} and more than one TSN is found for the species, the user is
asked for input. If \code{FALSE} NA is returned for multiple matches.}

\item{messages}{logical; should progress be printed?}

\item{rows}{numeric; Any number from 1 to infinity. If the default NA, all
rows are considered. Note that this function still only gives back a tsn
class object with one to many identifiers. See
\code{\link[=get_tsn_]{get_tsn_()}} to get back all, or a subset, of the raw
data that you are presented during the ask process.}

\item{...}{Ignored}

\item{x}{Input to as.tsn}

\item{check}{logical; Check if ID matches any existing on the DB, only
used in \code{\link[=as.tsn]{as.tsn()}}}
}
\value{
A vector of taxonomic identifiers as an S3 class.
If a taxon is not found an \code{NA} is given. If more than one identifier
is found the function asks for user input if \code{ask = TRUE}, otherwise
returns \code{NA}. If \code{ask=FALSE} and \code{rows} does not equal
\code{NA}, then a data.frame is given back, but not of the uid class, which
you can't pass on to other functions as you normally can.

See \code{\link{get_id_details}} for further details including
attributes and exceptions
}
\description{
Retrieve the taxonomic serial numbers (TSN) of a taxon from ITIS.
}
\examples{
\dontrun{
get_tsn("Quercus douglasii")
get_tsn("Chironomus riparius")
get_tsn(c("Chironomus riparius","Quercus douglasii"))
splist <- c("annona cherimola", 'annona muricata', "quercus robur",
		"shorea robusta", "pandanus patina", "oryza sativa", "durio zibethinus")
get_tsn(splist, messages=FALSE)

# specify rows to limit choices available
get_tsn('Arni')
get_tsn('Arni', rows=1)
get_tsn('Arni', rows=1:2)

# When not found
get_tsn("howdy")
get_tsn(c("Chironomus riparius", "howdy"))

# Using common names
get_tsn(searchterm="black bear", searchtype="common")

# Convert a tsn without class information to a tsn class
as.tsn(get_tsn("Quercus douglasii")) # already a tsn, returns the same
as.tsn(get_tsn(c("Chironomus riparius","Pinus contorta"))) # same
as.tsn(19322) # numeric
as.tsn(c(19322,129313,506198)) # numeric vector, length > 1
as.tsn("19322") # character
as.tsn(c("19322","129313","506198")) # character vector, length > 1
as.tsn(list("19322","129313","506198")) # list, either numeric or character
## dont check, much faster
as.tsn("19322", check=FALSE)
as.tsn(19322, check=FALSE)
as.tsn(c("19322","129313","506198"), check=FALSE)
as.tsn(list("19322","129313","506198"), check=FALSE)

(out <- as.tsn(c(19322,129313,506198)))
data.frame(out)
as.tsn( data.frame(out) )

# Get all data back
get_tsn_("Arni")
get_tsn_("Arni", rows=1)
get_tsn_("Arni", rows=1:2)
get_tsn_(c("asdfadfasd","Pinus contorta"), rows=1:5)
}
}
\seealso{
\code{\link[=classification]{classification()}}

Other taxonomic-ids: 
\code{\link{get_boldid}()},
\code{\link{get_eolid}()},
\code{\link{get_gbifid}()},
\code{\link{get_ids}()},
\code{\link{get_iucn}()},
\code{\link{get_natservid}()},
\code{\link{get_nbnid}()},
\code{\link{get_pow}()},
\code{\link{get_tolid}()},
\code{\link{get_tpsid}()},
\code{\link{get_uid}()},
\code{\link{get_wiki}()},
\code{\link{get_wormsid}()}
}
\concept{taxonomic-ids}
