// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ZigbeeManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.zigbee {
  public class ZigbeeManager : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager:1.0.0", null);

    public ZigbeeManager(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ZigbeeManager(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ZigbeeManager StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ZigbeeManager(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int ERR_DEVICE_EXISTS = 1;

    public const int ERR_MAX_DEVICE_REACHED = 2;

    public const int ERR_DEVICE_NOT_FOUND = 3;

    public const int ERR_INVALID_PARAMS = 4;

    public const int ERR_INVALID_KEY = 5;

    public const int ERR_INVALID_CHANNEL = 6;

    public enum DongleState {
      NOT_INIT,
      READY,
      ERROR,
      INIT_IN_PROGRESS,
      FW_UPGRADE,
      IN_MODEM_STATE,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.firmwareVersion = this.firmwareVersion;
        copy.stackVersion = this.stackVersion;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["firmwareVersion"] = this.firmwareVersion;
        json["stackVersion"] = this.stackVersion;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.firmwareVersion = (string)json["firmwareVersion"];
        inst.stackVersion = (string)json["stackVersion"];
        return inst;
      }

      public string firmwareVersion = "";
      public string stackVersion = "";
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.channel = this.channel;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["channel"] = this.channel;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.channel = (int)json["channel"];
        return inst;
      }

      public int channel = 0;
    }

    public class DeviceRegistration : ICloneable {
      public object Clone() {
        DeviceRegistration copy = new DeviceRegistration();
        copy.sourceId = this.sourceId;
        copy.key = this.key;
        copy.slot = this.slot;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["sourceId"] = this.sourceId;
        json["key"] = this.key;
        json["slot"] = this.slot;
        return json;
      }

      public static DeviceRegistration Decode(LightJson.JsonObject json, Agent agent) {
        DeviceRegistration inst = new DeviceRegistration();
        inst.sourceId = (int)json["sourceId"];
        inst.key = (string)json["key"];
        inst.slot = (int)json["slot"];
        return inst;
      }

      public int sourceId = 0;
      public string key = "";
      public int slot = 0;
    }

    public class DeviceEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public int sourceId = 0;
    }

    public class DeviceAddedEvent : Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceAddedEvent:1.0.0", Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceEvent.typeInfo);

    }

    public class DeviceRemovedEvent : Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.DeviceRemovedEvent:1.0.0", Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceEvent.typeInfo);

    }

    public class SettingsChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.SettingsChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.zigbee.ZigbeeManager.Settings oldSettings = new Com.Raritan.Idl.zigbee.ZigbeeManager.Settings();
      public Com.Raritan.Idl.zigbee.ZigbeeManager.Settings newSettings = new Com.Raritan.Idl.zigbee.ZigbeeManager.Settings();
    }

    public class StateChangedEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("zigbee.ZigbeeManager.StateChangedEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState oldState = Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState.NOT_INIT;
      public Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState newState = Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState.NOT_INIT;
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.zigbee.ZigbeeManager.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.zigbee.ZigbeeManager.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.zigbee.ZigbeeManager.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDongleStateResult {
      public Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState _ret_;
    }

    public GetDongleStateResult getDongleState() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDongleState", _parameters);
      var _ret = new GetDongleStateResult();
      _ret._ret_ = (Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState)(int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getDongleState(AsyncRpcResponse<GetDongleStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDongleState(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDongleState(AsyncRpcResponse<GetDongleStateResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDongleState", _parameters,
        _result => {
          try {
            var _ret = new GetDongleStateResult();
            _ret._ret_ = (Com.Raritan.Idl.zigbee.ZigbeeManager.DongleState)(int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.zigbee.ZigbeeManager.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.zigbee.ZigbeeManager.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.zigbee.ZigbeeManager.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.zigbee.ZigbeeManager.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.zigbee.ZigbeeManager.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.zigbee.ZigbeeManager.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class AddDevicesResult {
      public System.Collections.Generic.IEnumerable<int> _ret_;
    }

    public AddDevicesResult addDevices(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceRegistration> sensors) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sensors"] = new JsonArray(sensors.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("addDevices", _parameters);
      var _ret = new AddDevicesResult();
      _ret._ret_ = new System.Collections.Generic.List<int>(_result["_ret_"].AsJsonArray.Select(
        _value => (int)_value));
      return _ret;
    }

    public AsyncRequest addDevices(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, AsyncRpcResponse<AddDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return addDevices(sensors, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest addDevices(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.zigbee.ZigbeeManager.DeviceRegistration> sensors, AsyncRpcResponse<AddDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sensors"] = new JsonArray(sensors.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("addDevices", _parameters,
        _result => {
          try {
            var _ret = new AddDevicesResult();
            _ret._ret_ = new System.Collections.Generic.List<int>(_result["_ret_"].AsJsonArray.Select(
              _value => (int)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RemoveDeviceResult {
      public int _ret_;
    }

    public RemoveDeviceResult removeDevice(int sourceId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["sourceId"] = sourceId;

      var _result = RpcCall("removeDevice", _parameters);
      var _ret = new RemoveDeviceResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest removeDevice(int sourceId, AsyncRpcResponse<RemoveDeviceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return removeDevice(sourceId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest removeDevice(int sourceId, AsyncRpcResponse<RemoveDeviceResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["sourceId"] = sourceId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("removeDevice", _parameters,
        _result => {
          try {
            var _ret = new RemoveDeviceResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetRegisteredDevicesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.zigbee.ZigbeeDevice> _ret_;
    }

    public GetRegisteredDevicesResult getRegisteredDevices() {
      JsonObject _parameters = null;
      var _result = RpcCall("getRegisteredDevices", _parameters);
      var _ret = new GetRegisteredDevicesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.zigbee.ZigbeeDevice>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.zigbee.ZigbeeDevice.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getRegisteredDevices(AsyncRpcResponse<GetRegisteredDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getRegisteredDevices(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getRegisteredDevices(AsyncRpcResponse<GetRegisteredDevicesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getRegisteredDevices", _parameters,
        _result => {
          try {
            var _ret = new GetRegisteredDevicesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.zigbee.ZigbeeDevice>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.zigbee.ZigbeeDevice.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
