//////////////////////////////////////////////////////////////////////
//
//  FILE:       mtbdata.h
//              Memory tablebases
//
//  Part of:    Scid (Shane's Chess Information Database)
//  Version:    3.5
//
//  Notice:     Copyright (c) 2003 Shane Hudson.  All rights reserved.
//
//  Author:     Shane Hudson (sgh@users.sourceforge.net)
//
//////////////////////////////////////////////////////////////////////


// This file was automatically generated by the program mtbgen.cpp.
// It contains selected compressed tablebase data used by the endgame
// recognition code in the Scidlet chess engine.

#ifndef SCID_MTBDATA_H
#define SCID_MTBDATA_H


//////////////////////////////////////////////////////////////////////
//
// KQK

static const byte mtbdata_KQK[5954] = {
    1,72,0,159,0,46,16,17,15,13,34,34,0,34,36,34,50,51,35,34,51,76,35,51,
    192,1,50,35,208,0,151,1,51,44,51,67,68,5,52,207,0,1,0,85,11,85,69,68,
    84,85,0,69,111,1,5,0,101,102,86,101,102,1,86,133,31,1,2,103,102,118,
    119,0,103,133,31,1,15,51,23,17,33,18,191,32,10,68,216,226,29,143,32,
    5,0,52,227,32,63,5,68,68,98,69,68,146,32,63,5,85,85,86,209,32,62,102,
    118,87,15,8,114,15,7,191,56,14,159,0,5,143,33,218,1,34,34,18,144,26,
    205,0,98,60,160,29,50,51,79,79,143,64,10,79,12,160,17,66,145,52,148,
    21,34,50,147,1,35,34,50,221,162,20,244,2,143,4,2,35,72,128,28,79,13,
    51,254,128,32,207,0,0,15,115,132,16,159,0,7,136,20,141,117,125,255,
    52,144,1,127,11,143,8,14,143,32,98,143,12,5,150,0,28,191,201,145,31,
    2,69,208,1,15,11,143,8,14,15,30,143,32,46,255,60,158,0,143,12,1,242,
    2,128,11,79,6,177,178,198,9,251,143,20,14,63,78,143,32,14,63,5,150,
    0,31,37,103,226,206,192,31,9,143,8,14,31,81,1,80,0,159,0,79,51,15,13,
    67,68,68,216,52,209,0,5,51,183,1,3,85,85,48,69,85,85,224,0,15,2,101,
    102,102,22,102,118,119,87,130,1,119,192,0,52,67,118,103,241,2,102,103,
    102,119,34,233,0,161,1,228,1,35,120,18,135,136,63,15,83,34,34,161,29,
    209,0,29,5,143,32,9,71,229,32,102,199,32,101,86,102,177,30,192,2,114,
    98,86,149,1,79,9,127,10,24,17,64,1,18,34,17,18,33,33,34,18,37,80,18,
    18,128,1,34,17,192,0,18,215,161,3,5,221,1,33,154,2,34,15,11,143,32,
    49,79,200,64,101,160,30,101,85,16,6,31,31,128,195,32,19,40,34,34,68,
    51,50,1,50,51,50,35,35,34,50,34,58,128,1,50,35,241,1,194,0,81,35,131,
    4,191,34,84,34,80,48,160,2,95,12,1,248,39,143,32,22,184,97,95,13,153,
    0,95,43,56,51,14,51,85,68,68,84,174,14,226,14,0,222,53,137,20,15,1,
    52,143,4,33,225,13,144,12,127,4,255,69,176,0,196,0,247,31,137,32,68,
    111,11,129,128,142,128,129,15,17,72,68,68,193,73,137,74,136,140,63,
    102,102,70,131,4,159,0,7,240,20,127,2,198,2,247,47,2,241,23,213,2,143,
    8,3,176,60,86,192,0,47,7,126,144,8,86,199,32,143,32,1,225,31,86,241,
    29,95,7,63,88,85,85,209,167,152,168,165,8,134,140,206,3,254,241,3,143,
    4,13,143,8,14,150,14,31,7,148,8,4,143,20,0,240,118,15,13,139,32,158,
    0,5,104,102,102,255,136,240,1,193,0,92,133,200,95,36,21,95,6,192,149,
    2,143,12,38,31,49,1,64,0,144,0,68,68,52,68,84,64,69,68,2,85,69,84,85,
    69,131,68,209,1,85,84,84,69,85,211,2,4,15,104,84,85,85,85,102,179,1,
    100,128,102,225,1,68,68,86,101,68,84,0,100,85,68,100,69,86,68,100,48,
    86,100,102,0,244,3,102,84,101,24,102,102,100,70,192,0,162,0,70,118,
    12,100,118,102,116,119,64,192,25,85,17,85,117,119,119,0,102,101,86,
    4,129,1,117,136,101,134,86,16,103,64,133,136,50,50,51,67,68,52,32,67,
    68,36,144,33,36,52,67,52,3,35,52,68,67,36,52,68,192,1,55,223,28,83,
    34,34,129,16,240,13,66,127,0,131,4,211,231,33,193,25,135,32,85,34,51,
    51,240,55,169,193,3,193,32,69,129,33,100,192,0,70,119,234,128,34,39,
    208,31,40,119,32,135,37,137,34,144,0,66,36,34,32,34,50,110,176,0,35,
    160,0,0,50,144,16,192,0,112,128,17,98,33,33,18,33,17,18,1,33,34,17,
    33,34,34,33,17,111,80,18,0,177,7,34,131,4,160,4,153,1,205,224,2,192,
    5,152,0,33,50,163,6,161,0,18,95,161,7,33,192,0,18,161,3,210,8,192,29,
    66,22,112,34,66,66,0,36,129,2,162,32,20,34,34,51,51,144,36,85,193,36,
    67,65,52,85,128,1,99,85,67,100,52,45,0,69,83,160,27,85,128,32,193,35,
    101,229,44,129,66,132,68,47,12,51,51,128,48,52,4,160,12,36,51,51,53,
    35,192,13,35,221,51,64,208,42,37,145,11,129,16,240,19,52,7,130,3,51,
    35,34,35,50,129,1,198,0,179,144,0,129,4,50,241,1,128,21,35,35,240,39,
    254,129,5,36,78,242,43,129,1,19,35,130,28,117,68,35,224,29,176,47,64,
    67,80,52,220,129,2,177,30,132,64,84,209,113,99,144,63,68,186,100,192,
    1,100,225,62,134,32,13,103,79,22,123,68,68,145,72,193,127,133,77,194,
    0,84,160,14,31,132,12,51,51,83,136,4,242,0,92,146,21,254,170,119,227,
    21,145,0,95,2,226,25,193,4,79,2,130,16,248,69,96,147,14,134,28,192,
    0,192,146,85,84,7,85,100,85,84,101,69,64,176,1,235,144,0,133,128,65,
    20,103,16,103,16,231,135,32,27,106,161,11,101,86,144,141,192,0,253,
    176,0,158,0,242,11,140,4,137,5,149,149,89,101,255,216,4,127,2,194,4,
    79,10,209,3,148,4,79,4,193,0,236,226,12,194,66,129,60,194,60,86,129,
    61,160,0,118,28,86,103,101,118,178,62,128,32,208,0,118,76,119,119,193,
    0,118,103,64,1,135,6,103,135,118,135,119,134,33,160,7,7,85,117,103,
    102,102,119,64,176,0,126,147,0,118,20,48,242,13,241,1,214,3,143,4,20,
    127,118,119,31,9,197,8,143,8,7,208,1,148,2,143,16,8,254,147,8,143,20,
    16,131,32,176,0,41,192,0,37,242,3,59,119,135,120,225,165,159,0,0,143,
    4,99,135,151,2,192,47,8,143,8,14,47,16,1,64,0,144,0,68,68,68,67,85,
    40,85,68,84,192,0,68,177,0,69,85,39,68,85,84,16,85,102,16,0,224,132,
    4,2,128,1,177,5,68,69,68,84,178,69,224,4,69,227,2,95,75,85,67,178,19,
    101,85,85,209,13,208,14,85,84,130,2,69,190,193,2,144,1,85,128,4,163,
    19,193,3,128,19,192,0,168,69,112,86,208,19,86,136,20,102,102,3,70,85,
    102,102,69,102,100,0,5,161,0,86,100,69,102,103,132,4,36,148,178,8,192,
    30,68,86,128,1,70,242,9,68,32,84,84,102,145,13,85,85,51,51,66,35,51,
    160,2,51,67,68,66,240,0,0,66,51,68,51,66,67,52,68,112,66,67,128,2,179,
    15,159,0,77,35,34,34,154,51,145,16,68,34,144,49,194,0,67,32,205,52,
    193,1,130,16,35,34,129,19,228,51,68,209,224,22,208,29,224,24,100,227,
    25,68,68,52,212,160,23,131,36,128,32,85,96,85,96,85,15,86,116,69,85,
    102,2,129,28,208,26,0,208,4,52,51,86,51,52,68,54,149,68,192,11,85,52,
    160,9,52,2,34,168,144,0,208,15,50,192,0,34,176,0,51,36,7,51,34,67,50,
    68,34,112,144,17,65,0,17,0,34,34,17,18,33,0,48,18,34,18,17,33,34,18,
    61,18,34,34,0,34,160,3,101,18,126,132,1,33,144,1,128,5,34,68,208,4,
    224,5,127,33,34,225,0,224,6,128,9,210,8,24,224,52,136,192,0,193,29,
    35,34,35,32,52,66,64,35,34,177,35,34,34,35,34,50,144,51,144,24,84,53,
    49,68,83,102,0,52,68,52,86,52,68,70,83,21,52,68,86,52,144,3,51,143,
    32,5,100,238,21,129,64,133,92,52,84,145,97,59,177,12,0,50,51,85,51,
    50,51,53,51,67,50,67,192,1,67,67,85,50,34,193,193,16,128,40,144,0,50,
    51,50,34,50,153,208,53,128,1,51,50,208,18,129,19,51,51,254,130,4,146,
    1,225,2,32,176,3,112,179,4,38,63,68,67,52,17,129,8,161,8,224,4,113,
    128,145,0,132,28,68,52,34,68,84,51,48,34,83,85,128,3,192,0,53,83,51,
    247,34,176,19,130,4,129,64,130,100,84,176,0,177,24,124,32,70,192,1,
    95,20,160,4,134,128,160,123,85,255,70,160,128,224,104,80,192,0,18,130,
    4,130,100,223,241,36,128,108,226,0,68,244,7,193,16,195,7,164,80,255,
    197,4,162,118,131,4,222,90,177,135,127,10,193,3,38,222,133,24,177,126,
    165,0,69,192,52,131,28,41,163,23,67,69,87,16,84,69,85,87,139,128,172,
    129,32,83,118,80,116,5,163,35,85,68,85,101,192,0,102,85,86,160,30,86,
    0,101,85,102,86,101,101,119,86,121,101,102,144,0,139,4,195,4,161,0,
    85,119,247,193,5,163,71,146,1,90,192,3,102,111,9,81,250,111,10,143,
    8,14,2,225,17,163,51,209,1,86,145,2,149,102,224,20,102,85,128,24,87,
    192,0,103,193,34,193,162,35,119,119,85,102,117,65,16,85,16,87,133,85,
    102,120,140,179,17,162,3,102,102,118,16,176,0,102,207,103,160,0,225,
    0,102,136,129,1,211,12,146,1,189,154,0,143,4,49,119,31,10,0,31,11,209,
    21,135,123,31,9,104,16,192,0,18,241,56,119,224,9,118,224,28,119,64,
    162,0,17,120,55,158,0,29,120,119,119,153,192,0,16,127,7,136,234,79,
    13,34,143,8,41,79,15,136,127,41,121,0,0,121,119,1,73,0,159,0,79,51,
    68,2,52,51,0,5,68,51,52,68,67,68,52,10,67,52,68,52,52,161,3,85,2,26,
    53,68,68,51,176,1,194,5,84,144,1,0,69,69,84,85,85,84,68,68,34,100,85,
    102,2,86,102,102,130,5,216,101,192,1,177,2,101,113,208,2,118,118,141,
    119,2,103,102,119,162,5,241,1,102,164,145,2,65,103,192,0,135,136,98,
    120,100,136,136,130,5,0,119,119,49,135,109,136,119,160,0,79,79,56,151,
    31,31,3,67,118,243,35,68,176,33,164,37,27,84,129,29,139,32,219,85,144,
    29,145,1,85,145,33,31,143,67,166,29,87,31,12,67,31,46,118,15,35,56,
    133,84,144,17,191,147,18,129,21,52,208,84,65,254,21,239,57,13,148,92,
    253,217,5,183,25,143,28,3,168,29,128,4,131,96,143,32,8,102,104,31,13,
    118,31,32,132,112,69,192,15,51,84,12,84,85,84,69,69,64,128,1,84,255,
    69,192,0,130,115,159,24,11,178,120,143,4,21,138,27,161,127,63,247,127,
    85,69,193,127,128,14,128,17,128,127,145,1,27,160,2,85,84,85,130,125,
    143,128,3,118,124,109,143,64,36,88,133,12,145,42,86,176,0,144,14,86,
    231,162,0,242,11,128,3,149,0,101,85,208,3,65,254,143,4,47,163,3,132,
    15,143,16,2,144,1,131,8,130,123,146,0,136,87,132,31,102,102,119,226,
    28,102,103,255,103,128,29,212,31,131,32,176,3,243,30,231,2,240,28,239,
    15,0,242,126,130,3,208,2,88,135,136,192,10,192,11,119,144,42,102,224,
    1,177,39,193,0,87,143,4,4,194,3,255,15,42,244,26,15,8,128,3,197,8,6,
    136,28,198,28,185,192,24,145,0,104,131,63,209,59,226,28,119,120,254,
    241,59,212,31,133,32,129,31,200,0,130,3,167,37,192,9,255,135,177,0,
    192,5,161,0,194,6,143,4,75,143,16,15,208,20,255,193,0,131,5,193,26,
    176,0,144,55,138,12,134,9,145,90,42,159,0,1,137,153,98,121,131,63,153,
    18,8,136,152,153,136,137,144,1,153,136,1,9,0,0,101,85,150,0,53,83,79,
    242,0,86,244,1,101,86,200,3,15,81,244,15,62,10,102,102,176,0,0,135,
    4,193,1,144,19,0,101,101,102,86,101,86,102,119,40,119,118,119,1,102,
    160,1,87,101,2,102,102,86,117,119,119,103,32,43,103,118,118,192,0,103,
    177,3,136,65,112,145,1,87,192,3,19,129,2,135,136,119,4,135,119,136,
    51,51,85,228,14,83,40,85,53,51,224,1,53,177,0,53,83,63,83,53,85,32,
    178,2,79,75,129,15,49,255,161,1,210,13,240,1,176,16,192,29,128,18,208,
    16,146,30,236,138,32,162,52,144,51,97,85,160,29,211,26,85,233,85,128,
    28,177,3,240,1,87,193,1,117,117,81,192,0,87,31,17,84,228,10,67,68,52,
    0,19,84,53,51,52,67,83,53,231,84,112,176,1,159,0,77,68,68,21,131,48,
    66,31,26,85,31,49,68,68,85,84,195,10,1,84,85,69,52,67,68,85,69,6,177,
    0,69,84,84,69,85,144,1,176,1,224,68,176,20,146,0,128,1,52,67,67,52,
    157,67,208,35,68,67,128,2,195,0,201,25,67,124,144,40,67,214,1,209,27,
    163,28,226,7,241,7,51,27,67,69,67,52,225,6,161,0,52,161,8,193,176,0,
    243,15,128,17,85,53,67,84,85,180,241,1,176,16,85,160,16,192,0,69,137,
    32,101,166,54,143,64,16,117,111,30,102,102,144,105,130,12,1,84,85,101,
    70,84,102,102,70,94,240,126,69,160,127,70,240,2,192,0,160,19,132,36,
    107,68,84,208,33,176,0,85,128,1,69,208,1,239,192,19,96,176,27,143,4,
    0,69,161,1,208,39,15,6,118,241,0,68,209,43,1,199,125,69,193,31,197,
    0,243,100,131,1,128,29,146,124,145,1,70,84,193,62,95,225,21,86,209,
    0,118,1,143,128,46,210,43,163,44,249,208,7,145,8,245,11,157,0,143,4,
    57,4,118,103,254,31,1,12,135,28,162,6,192,26,197,24,43,161,5,169,103,
    59,135,163,29,135,133,32,135,104,162,193,3,240,1,120,224,2,120,135,
    135,192,0,253,120,128,3,149,6,212,7,177,38,25,143,4,9,120,61,127,13,
    135,104,15,9,145,0,143,8,6,149,24,120,191,15,1,40,135,65,36,164,2,128,
    1,21,62,6,152,153,0,243,9,193,30,195,2,238,4,254,136,210,34,192,0,176,
    1,230,10,143,4,133,159,0,3,99,31,152,137,136,136,176,0,118,193,31,33,
    128,184,33,42,1,4,80,85,101,87,85,144,0,102,0,102,86,101,85,85,51,85,
    101,0,102,85,101,119,85,101,85,87,2,102,101,86,101,119,101,103,128,
    3,234,86,129,4,3,34,85,176,0,85,208,2,190,86,144,1,102,15,78,128,13,
    130,1,244,15,161,21,68,118,85,224,16,86,85,86,192,0,102,150,101,160,
    4,117,119,0,86,161,19,130,4,0,119,119,101,85,117,119,103,85,155,86,
    96,103,117,144,24,241,3,119,211,8,130,49,193,1,134,136,103,102,103,
    48,99,119,134,192,9,130,28,102,102,70,130,32,160,162,8,16,87,192,32,
    85,119,101,86,17,54,51,83,53,131,16,53,85,51,0,144,0,83,85,51,83,86,
    51,83,1,51,53,85,83,53,83,85,83,204,183,35,31,71,242,15,102,53,161,
    15,18,85,18,85,83,51,83,192,29,53,101,240,21,141,83,133,32,69,68,100,
    20,49,117,5,192,32,85,119,102,85,87,16,86,233,18,130,36,227,27,116,
    87,192,0,119,117,184,179,57,145,0,69,149,44,100,146,1,86,53,37,51,67,
    53,227,14,53,68,100,67,168,176,0,16,67,16,67,239,31,79,69,68,141,52,
    192,60,102,102,52,176,16,21,67,93,224,16,69,160,16,69,0,208,23,4,84,
    223,129,34,6,225,23,86,63,19,135,64,149,40,41,49,128,11,69,68,144,0,
    129,36,102,68,51,0,128,1,68,84,102,68,84,68,70,0,85,84,69,84,102,84,
    85,68,49,68,52,67,129,4,3,51,52,67,7,176,0,52,68,52,68,67,192,0,192,
    2,234,194,38,154,0,144,25,114,67,144,1,68,209,1,81,67,84,178,91,51,
    241,7,51,84,53,167,162,7,161,0,68,128,9,68,52,128,15,130,32,74,128,
    17,85,240,15,102,70,160,16,84,193,61,3,68,69,102,86,68,86,100,140,64,
    239,211,25,127,25,128,3,136,128,68,62,130,125,134,68,136,208,15,192,
    30,119,85,84,128,4,84,86,62,101,102,84,129,116,165,53,240,3,16,192,
    3,207,84,128,36,130,1,85,84,194,27,131,57,177,39,252,242,39,224,2,128,
    4,176,3,0,104,176,1,68,115,68,86,18,129,8,130,29,85,84,210,31,234,130,
    32,193,30,224,20,192,0,102,35,118,130,1,62,102,102,118,133,28,130,2,
    128,132,177,2,160,1,173,119,192,124,118,143,128,4,118,193,3,192,0,119,
    119,192,7,103,176,4,162,141,144,5,85,128,2,224,131,22,64,104,119,103,
    208,3,103,160,7,134,4,231,101,112,162,11,177,0,103,119,209,7,193,11,
    255,244,3,5,160,1,193,14,195,3,193,16,166,153,144,20,253,195,153,97,
    164,0,241,5,104,147,0,20,118,255,192,0,208,15,242,27,131,24,176,10,
    192,22,194,15,224,23,142,225,19,128,28,118,135,136,144,0,139,4,161,
    23,71,103,135,113,120,119,119,18,130,9,144,179,18,96,135,136,208,0,
    136,120,119,227,120,192,3,160,4,82,103,119,136,224,2,239,161,3,209,
    3,209,4,144,1,135,229,3,129,4,165,7,191,210,7,192,0,120,8,133,45,147,
    7,192,3,195,5,255,177,1,79,7,20,47,33,160,23,227,16,194,27,134,28,238,
    194,26,208,1,201,0,70,134,81,67,152,0,16,153,153,137,137,163,1,120,
    135,153,12,153,119,136,152,153,192,2,176,0,137,255,153,176,3,192,0,
    212,3,98,146,10,80,16,190,98,160,0,152,167,9,36,144,0,33,50,191,136,
    47,11,152,162,4,31,11,231,15,19,99,107,19,137,143,8,1,29,137,192,1,
    152,128,25,204,160,25,229,29,193,0,153,152,96,161,0,153,0,136,1,32,
    96,102,153,0,84,102,102,70,16,100,102,102,86,184,2,70,84,70,10,68,68,
    84,84,85,0,68,4,33,85,69,68,209,2,68,84,69,84,138,225,0,143,4,11,84,
    85,101,176,1,101,100,192,84,176,3,2,85,70,68,69,84,0,84,69,85,68,100,
    102,118,103,60,102,102,118,178,13,160,3,224,5,140,16,102,152,102,1,
    118,119,144,0,34,102,102,195,119,160,6,144,6,118,103,118,119,240,2,
    249,224,0,176,2,2,226,5,96,209,5,118,103,12,129,1,118,119,135,136,119,
    129,5,103,135,134,152,2,136,136,153,73,143,24,13,79,78,207,192,12,130,
    35,135,16,84,85,225,1,192,35,128,1,239,224,39,130,32,147,0,1,69,240,
    35,28,128,31,249,50,3,196,32,193,29,241,38,127,13,136,72,255,63,109,
    241,13,59,178,32,192,1,192,0,240,18,48,249,230,26,63,70,160,45,147,
    16,161,17,192,83,102,86,239,208,2,224,83,163,49,159,0,79,101,192,0,
    132,60,128,100,63,182,14,101,102,133,3,163,26,131,96,143,32,13,209,
    105,216,89,202,29,95,2,104,129,110,137,128,86,101,63,102,119,87,208,
    78,193,112,192,0,129,65,161,81,159,228,35,145,20,69,85,192,83,101,129,
    122,232,89,248,240,39,128,39,192,40,146,25,69,143,41,0,86,101,179,86,
    144,28,86,128,28,128,14,102,102,227,60,255,241,29,242,1,155,0,209,131,
    98,140,4,210,134,163,31,230,243,60,225,1,240,129,148,0,135,120,208,
    0,141,32,120,136,104,111,3,131,140,130,40,144,12,118,87,1,102,119,103,
    86,103,118,118,87,255,176,2,130,4,200,36,145,16,128,35,133,36,79,6,
    194,0,254,128,41,31,3,130,1,208,13,17,136,32,218,30,144,57,111,119,
    103,145,54,193,31,118,135,28,192,0,181,28,1,161,28,135,120,135,135,
    119,119,120,156,135,60,210,3,136,136,128,3,96,134,32,152,254,153,144,
    0,241,36,240,2,91,210,43,133,72,144,1,255,103,160,167,192,167,197,0,
    214,143,227,18,177,175,160,4,255,148,13,112,143,4,39,192,26,130,15,
    146,22,214,54,149,24,102,193,55,135,162,56,128,2,136,136,131,89,195,
    30,190,135,209,3,120,192,3,211,25,152,26,252,61,147,31,56,137,136,152,
    129,189,131,32,246,190,153,152,71,137,152,192,0,136,153,137,146,66,
    216,66,255,194,10,129,1,176,7,97,143,4,8,35,31,42,146,48,188,31,5,137,
    2,136,216,54,136,30,128,24,98,153,235,153,131,28,228,2,209,0,137,49,
    153,197,0,224,148,0,242,64,40,1,1,1,0,102,102,119,103,102,102,128,176,
    0,145,0,70,101,102,102,85,102,101,118,119,208,2,224,1,103,119,128,3,
    85,21,65,86,86,85,18,69,48,85,0,192,4,86,85,119,85,86,102,87,46,102,
    86,102,32,101,212,3,130,4,97,173,101,224,2,119,128,1,87,209,1,144,8,
    86,161,180,4,128,7,101,52,101,103,85,101,49,160,8,101,86,131,15,147,
    0,69,68,100,250,224,0,146,14,111,3,51,27,128,21,118,208,23,219,119,
    17,39,119,241,2,128,27,103,224,2,48,129,28,118,136,97,197,3,103,119,
    136,22,136,103,119,134,192,0,103,193,2,140,32,200,68,133,11,210,2,119,
    68,129,30,70,69,130,68,68,85,85,68,84,101,160,17,15,119,68,69,85,71,
    52,79,75,128,18,241,208,15,194,18,163,16,224,17,176,36,69,102,100,92,
    192,0,69,133,32,118,118,178,5,8,102,125,102,134,128,4,8,145,0,193,1,
    0,102,224,3,180,29,15,3,144,14,101,71,68,68,184,69,135,16,68,224,12,
    224,16,128,1,70,85,222,68,134,35,159,0,70,85,240,13,139,32,195,32,97,
    236,69,240,18,142,64,63,57,104,225,81,136,92,119,99,119,71,224,0,145,
    66,85,85,103,160,1,231,135,95,159,0,75,193,102,132,60,68,102,240,15,
    162,105,253,240,2,177,108,177,117,143,32,6,130,28,127,18,135,96,86,
    49,143,128,0,102,85,129,12,148,0,86,101,119,254,128,4,225,11,213,38,
    133,123,226,3,131,22,209,124,144,123,125,85,102,128,37,130,4,128,3,
    114,132,26,86,127,224,2,101,193,40,160,2,128,128,130,126,130,28,242,
    4,191,241,2,155,0,118,146,26,134,4,129,22,131,60,149,29,122,128,17,
    135,129,28,84,128,2,134,32,135,95,9,173,153,48,152,129,11,120,226,11,
    145,0,103,3,128,17,102,119,135,136,119,119,176,0,255,132,3,240,62,119,
    161,11,192,4,241,21,196,0,130,34,252,129,7,116,213,22,128,9,193,9,105,
    236,26,119,241,118,192,0,146,26,160,146,43,118,103,118,248,241,12,66,
    231,15,195,30,243,10,22,119,119,239,135,16,132,28,133,6,136,240,23,
    225,24,147,1,56,128,25,152,153,144,0,128,161,136,4,151,153,22,120,119,
    120,153,227,1,120,130,8,130,30,253,136,193,9,241,41,195,0,116,130,44,
    100,120,255,144,14,128,2,129,5,242,36,6,226,17,4,192,5,223,225,7,195,
    2,159,0,0,135,129,13,208,4,114,0,159,135,8,147,26,135,120,192,18,4,
    194,9,106,239,226,1,159,0,0,246,18,123,152,192,0,241,31,192,29,56,85,
    153,153,240,2,32,129,3,119,137,58,153,153,137,130,36,128,1,161,3,137,
    144,6,55,152,137,153,193,3,241,1,119,208,0,131,4,227,226,9,8,162,0,
    0,137,136,120,7,127,148,14,137,160,5,160,12,34,133,44,30,225,9,142,
    31,19,159,26,0,137,136,137,20,195,5,139,16,250,153,246,23,194,0,148,
    0,193,30,136,3,170,129,1,1,0,112,136,119,135,119,119,119,24,136,120,
    119,119,176,0,145,0,103,118,0,119,119,102,119,135,136,118,119,245,136,
    147,2,18,212,3,16,87,128,4,85,198,110,23,99,119,119,118,200,6,31,9,
    92,136,120,129,16,104,208,2,176,0,160,15,102,8,102,118,102,102,85,208,
    0,118,119,55,104,119,103,16,128,20,136,177,5,241,4,169,17,65,102,177,
    1,135,133,8,136,136,248,129,24,240,0,144,0,83,128,2,192,1,120,136,149,
    135,192,0,120,119,64,152,0,153,192,49,195,16,193,3,153,153,120,136,
    151,126,153,121,128,12,128,25,177,25,244,21,135,20,33,235,104,130,18,
    194,0,36,86,64,85,162,1,0,211,21,85,117,85,85,85,118,86,96,85,85,176,
    0,39,101,102,85,85,132,119,129,1,119,101,118,85,128,6,86,112,85,101,
    130,4,129,8,84,101,103,85,47,101,85,117,227,25,103,181,12,128,5,130,
    32,246,145,0,208,2,209,12,163,0,131,27,119,128,4,226,2,189,103,208,
    6,102,194,20,128,32,195,33,82,86,255,161,10,242,35,224,30,176,27,80,
    133,36,79,4,149,43,246,143,52,1,226,1,128,28,128,25,192,18,86,47,3,
    159,0,79,63,102,86,117,128,34,128,31,65,160,19,211,2,191,224,40,192,
    33,102,225,39,146,0,193,24,146,64,135,32,235,129,75,176,0,35,143,64,
    1,152,32,135,47,17,188,128,16,128,14,103,0,21,128,18,208,48,86,49,85,
    103,85,193,65,159,0,76,86,102,86,175,192,13,129,76,101,60,118,48,195,
    2,52,227,132,68,53,85,128,96,119,119,151,117,34,135,29,136,152,50,102,
    102,134,144,6,99,103,120,130,127,5,102,103,134,144,78,191,129,112,145,
    83,119,144,32,178,84,145,79,160,34,226,112,250,130,84,195,2,159,0,75,
    128,49,225,14,135,96,85,130,2,254,103,129,3,160,0,129,1,193,29,135,
    4,131,32,0,255,135,224,23,142,132,135,64,4,128,5,145,6,224,1,255,132,
    35,194,142,210,39,193,38,128,128,130,126,131,163,130,148,222,176,111,
    145,44,241,1,118,224,34,208,120,164,50,132,120,213,87,0,192,3,101,144,
    4,101,143,4,2,86,143,128,130,192,8,101,118,118,2,131,12,128,1,255,226,
    15,210,175,213,13,159,0,20,130,184,248,1,241,153,130,30,191,197,62,
    16,152,149,1,130,33,243,2,196,2,134,32,255,132,4,146,70,160,1,129,38,
    193,0,161,17,129,26,128,35,255,195,34,145,37,161,41,132,43,139,4,132,
    169,194,179,160,17,255,31,2,153,23,128,80,129,60,130,44,133,32,145,
    6,34,255,82,142,116,243,213,208,194,131,25,196,0,230,90,210,60,189,
    40,128,125,136,192,157,129,1,145,0,133,2,137,114,2,136,0,131,12,135,
    32,135,121,96,21,153,137,153,135,144,6,135,143,4,11,136,167,31,4,129,
    40,137,192,3,152,152,19,154,0,95,53,120,128,7,151,129,9,143,8,4,196,
    47,101,254,129,2,131,4,73,144,56,32,204,2,176,28,240,28,240,137,227,
    29,116,132,30,111,2
};

static MTB * mtb_KQK = NULL;

void initMTB_KQK()
{
    mtb_KQK = new MTB ("KQK", 4, 10);
    mtb_KQK->SetPackedData (mtbdata_KQK);
    mtb_KQK->Add (A1, WHITE, 277);
    mtb_KQK->Add (B1, WHITE, 381);
    mtb_KQK->Add (C1, WHITE, 682);
    mtb_KQK->Add (D1, WHITE, 787);
    mtb_KQK->Add (B2, WHITE, 474);
    mtb_KQK->Add (C2, WHITE, 561);
    mtb_KQK->Add (D2, WHITE, 816);
    mtb_KQK->Add (C3, WHITE, 591);
    mtb_KQK->Add (D3, WHITE, 686);
    mtb_KQK->Add (D4, WHITE, 699);
}

//////////////////////////////////////////////////////////////////////
//
// KRK

static const byte mtbdata_KRK[7112] = {
    1,75,0,159,0,46,32,34,2,2,159,4,7,73,208,3,36,195,4,18,17,15,2,65,68,
    89,1,36,192,0,52,127,1,16,102,102,33,208,0,100,85,16,102,102,102,86,
    130,12,19,101,102,134,103,102,2,224,118,12,17,129,1,134,136,119,136,
    215,152,79,1,15,50,24,224,24,1,191,36,16,143,32,5,18,161,32,52,51,35,
    111,8,68,84,6,224,101,192,30,203,0,147,0,85,85,133,103,3,102,119,135,
    103,102,136,120,60,211,65,128,1,1,135,128,30,151,153,61,123,64,41,193,
    20,161,53,47,1,49,16,136,1,218,45,130,28,144,27,33,223,27,6,112,33,
    143,32,15,142,51,111,13,85,85,101,99,31,0,80,163,101,2,118,0,118,120,
    119,29,134,33,193,35,136,119,119,151,15,6,144,19,255,65,196,24,209,
    20,89,130,24,133,28,132,1,73,201,137,4,15,2,145,0,49,50,96,52,51,13,
    48,34,34,50,35,11,49,66,131,129,32,208,60,52,84,85,85,53,44,238,50,
    128,1,3,32,103,160,1,41,86,207,119,16,193,29,119,121,10,18,192,35,154,
    19,1,167,154,7,34,73,128,20,251,67,196,45,159,0,3,140,4,141,52,105,
    52,144,1,184,15,7,192,21,53,208,0,142,28,128,32,67,86,59,85,85,69,1,
    204,0,101,117,194,31,106,5,117,7,144,0,117,192,2,133,240,28,248,135,
    210,29,82,129,31,53,193,34,119,151,166,137,48,153,54,167,154,51,130,
    32,219,105,193,15,176,105,70,63,1,145,0,86,137,4,252,147,46,95,7,176,
    1,82,130,1,69,18,119,107,119,87,134,3,28,87,16,118,16,181,193,9,163,
    26,119,176,2,150,0,117,208,1,117,60,208,27,87,152,192,0,240,25,121,
    131,28,85,86,85,149,32,135,128,4,119,32,20,255,121,18,148,0,140,32,
    197,32,19,128,67,178,71,225,202,170,8,140,4,194,4,135,136,136,88,183,
    192,0,113,104,13,193,19,133,0,245,19,143,9,198,23,153,153,89,213,19,
    0,244,52,101,200,27,151,7,16,119,137,128,21,152,247,195,6,196,4,54,
    131,26,147,0,121,204,0,83,174,55,95,2,121,128,11,121,130,25,96,132,
    17,255,103,132,2,130,168,15,2,145,15,128,3,143,8,6,148,19,159,15,3,
    151,0,170,154,201,22,129,28,150,54,98,222,176,52,137,26,94,119,82,202,
    25,143,32,3,32,46,187,171,154,198,0,170,128,15,33,16,1,82,0,159,0,79,
    51,10,85,53,203,0,10,51,51,67,68,85,224,0,68,0,93,85,69,35,102,40,241,
    2,1,119,6,33,86,85,85,136,87,27,0,66,117,102,129,3,119,118,119,153,
    17,192,121,27,3,102,119,153,137,119,48,119,170,138,31,0,63,82,51,51,
    34,62,34,17,35,15,4,17,141,32,9,147,32,0,68,68,119,85,101,102,119,86,
    30,101,102,136,87,11,18,66,192,28,14,119,102,136,153,121,91,1,16,170,
    102,16,135,128,30,151,61,153,64,4,102,33,100,102,102,17,31,9,1,103,
    0,0,15,6,17,17,33,192,25,1,230,31,5,130,32,207,32,5,33,68,67,132,29,
    15,11,190,102,0,102,192,30,203,0,3,192,33,193,28,61,119,102,104,96,
    122,241,3,4,136,107,128,30,152,77,101,85,128,24,34,15,2,223,129,20,
    133,28,0,33,12,141,4,61,2,119,193,31,37,207,32,4,133,32,193,28,85,144,
    30,29,56,145,0,102,86,80,176,61,240,24,102,136,117,103,134,10,35,128,
    3,120,192,28,135,54,129,29,102,105,89,103,135,48,34,160,184,41,187,
    144,0,119,69,100,119,127,85,84,160,105,47,2,112,129,113,143,4,23,33,
    127,77,70,192,24,177,85,192,56,133,22,198,0,81,54,96,119,118,193,27,
    53,104,54,131,6,59,68,68,136,81,129,28,2,150,6,150,149,0,133,32,170,
    137,2,105,5,194,3,191,136,113,136,192,31,6,64,3,49,47,193,103,136,101,
    128,101,101,208,117,93,144,0,179,193,75,201,2,136,143,4,1,137,8,136,
    104,208,110,231,128,2,66,146,112,7,136,103,49,64,229,129,1,1,145,0,
    192,23,136,118,116,135,119,17,134,139,4,129,24,128,3,153,160,1,129,
    25,109,195,0,152,66,117,170,129,28,32,187,187,128,1,68,139,33,102,128,
    31,187,33,187,160,2,36,184,2,129,32,193,11,151,224,10,254,128,1,130,
    26,193,16,5,145,0,143,4,1,129,18,47,11,179,137,160,0,135,161,21,19,
    153,152,35,227,194,3,225,3,196,0,5,170,152,154,2,142,193,2,193,1,170,
    136,152,48,96,148,0,16,187,169,154,137,193,8,170,153,154,138,137,113,
    187,169,170,0,186,135,4,189,171,132,3,170,101,82,132,32,3,204,105,16,
    221,20,192,1,153,16,201,204,64,144,0,170,192,5,170,169,170,170,170,
    47,152,170,170,128,25,153,128,13,71,0,69,143,4,6,187,111,14,155,187,
    171,224,2,170,46,111,2,170,153,128,2,153,31,1,197,3,33,96,153,185,19,
    193,26,186,187,171,187,248,168,128,6,64,194,1,196,0,101,204,187,31,
    187,171,204,169,195,2,33,240,58,50,15,70,188,187,171,221,1,80,1,128,
    130,6,144,4,1,81,0,144,0,119,1,167,137,136,144,207,0,2,15,80,72,68,
    1,85,69,68,54,68,102,70,47,0,0,102,194,1,0,6,118,103,102,102,134,104,
    43,3,1,101,102,135,120,102,102,151,137,96,16,153,27,1,119,119,102,102,
    5,152,153,120,136,184,155,16,187,128,27,1,104,118,119,119,122,23,12,
    136,136,122,23,135,30,15,82,68,0,68,52,51,21,65,68,68,21,60,65,85,85,
    29,2,193,35,192,28,118,114,103,101,192,30,27,35,85,85,128,32,189,119,
    32,136,112,10,17,36,135,104,32,167,64,90,170,96,102,86,1,136,120,135,
    24,136,136,85,21,192,192,13,45,48,102,22,83,102,102,64,22,17,63,7,32,
    34,0,0,16,176,17,32,18,15,0,49,19,49,51,48,51,17,17,1,47,4,84,69,51,
    3,51,21,81,69,68,21,81,176,14,247,12,131,32,192,16,192,28,112,85,192,
    30,106,161,130,20,34,118,32,118,120,151,153,138,75,194,91,119,102,119,
    32,119,47,10,160,136,32,88,47,6,54,83,102,85,3,21,51,51,34,18,34,34,
    14,51,144,0,84,53,128,24,128,28,18,17,176,2,247,192,2,105,134,4,192,
    32,82,33,75,82,114,129,32,97,128,64,47,6,144,0,119,103,0,181,119,129,
    29,133,10,81,118,130,3,119,141,64,0,153,119,122,9,51,118,2,52,121,119,
    184,187,121,183,9,144,187,16,134,104,48,88,136,136,124,102,86,176,73,
    13,130,111,176,44,132,2,119,167,87,143,4,3,85,15,14,119,103,224,48,
    1,114,145,0,87,200,0,226,19,131,24,135,104,80,123,136,120,10,58,160,
    89,3,151,6,10,147,0,85,85,151,121,176,152,154,6,202,122,5,148,4,119,
    153,128,32,185,48,92,185,187,2,183,5,49,224,124,120,94,153,105,192,
    157,104,209,129,92,130,104,128,8,51,105,137,120,128,2,50,153,105,131,
    1,231,49,134,12,143,4,17,133,3,153,153,195,4,17,39,53,169,122,51,153,
    137,1,192,1,193,81,96,6,138,137,120,169,154,153,129,3,64,169,153,70,
    29,185,171,100,6,123,1,22,170,153,192,2,153,34,120,201,188,0,204,153,
    136,0,224,184,1,129,32,193,10,185,155,170,154,60,153,137,153,176,1,
    12,146,0,143,4,32,185,131,139,111,13,187,170,154,185,139,192,2,49,104,
    169,154,195,4,193,1,185,155,169,178,64,24,171,19,1,201,172,69,229,202,
    23,129,10,192,4,201,188,10,156,37,21,201,204,195,6,217,205,6,170,32,
    0,202,204,144,0,169,170,170,154,0,203,188,187,170,203,156,187,170,95,
    187,155,7,186,0,17,95,6,1,47,95,10,219,157,95,13,221,15,8,130,2,48,
    106,10,172,203,3,10,204,128,10,173,195,2,87,219,205,54,171,74,189,132,
    3,128,15,0,21,1,64,0,144,0,102,102,120,119,136,5,153,137,136,136,170,
    139,206,0,102,6,6,136,119,102,102,137,30,15,81,204,85,1,241,0,119,136,
    31,0,0,117,193,102,193,3,1,153,120,119,119,170,136,60,2,103,119,136,
    192,1,136,187,194,122,62,226,3,102,119,119,121,128,32,50,122,170,135,
    62,33,85,85,224,31,24,102,113,119,153,31,1,159,32,84,68,68,1,102,17,
    101,102,102,17,117,119,144,29,33,102,102,1,103,119,119,61,136,104,136,
    29,33,161,28,0,151,84,128,30,167,29,170,32,119,0,119,7,153,153,137,
    122,170,151,30,3,234,209,11,193,29,31,2,129,20,65,240,48,17,159,0,7,
    0,0,34,2,0,0,17,1,0,96,0,33,31,1,0,68,17,68,68,51,17,17,65,16,15,4,
    101,102,129,32,44,176,80,17,118,16,134,27,34,101,67,102,135,192,28,
    135,136,104,104,13,161,225,3,84,136,128,30,168,136,187,123,197,10,82,
    194,71,153,137,120,15,10,136,64,15,10,68,0,65,68,34,34,33,148,34,127,
    0,34,34,129,56,85,128,28,34,181,17,128,2,33,92,134,4,68,35,17,237,144,
    2,25,144,0,131,32,103,128,30,176,61,17,205,176,114,89,100,135,136,114,
    49,106,178,57,195,3,104,80,144,25,187,138,48,88,139,184,57,187,144,
    0,193,24,151,170,2,154,137,151,187,151,137,152,192,30,208,154,56,17,
    101,144,40,135,153,119,95,119,135,160,73,119,0,129,1,5,145,0,95,160,
    83,102,128,4,103,128,2,78,227,51,193,16,117,31,14,120,32,63,0,27,121,
    0,153,129,10,230,147,153,136,103,136,136,137,154,1,208,94,137,106,5,
    142,32,204,128,155,240,204,192,31,52,1,192,11,119,152,170,0,154,153,
    152,187,152,153,152,170,46,152,153,153,48,154,52,145,0,193,15,75,136,
    170,144,132,170,152,54,168,52,183,129,36,134,4,153,128,2,49,136,132,
    1,194,1,251,111,1,9,63,3,201,9,57,1,155,20,173,4,53,187,129,2,154,52,
    2,139,212,2,147,0,51,187,16,204,192,3,204,92,155,153,96,185,65,129,
    32,129,9,170,0,204,171,153,170,204,170,153,170,174,187,67,169,0,171,
    0,145,0,130,4,235,187,64,196,3,5,186,79,10,170,131,1,190,15,7,193,13,
    171,143,12,10,131,2,11,116,194,21,165,187,112,203,47,0,204,172,21,154,
    118,16,156,38,194,6,16,221,192,3,23,96,201,204,144,0,193,21,186,204,
    188,187,46,186,221,187,26,187,17,32,143,4,6,185,170,127,13,186,243,
    3,15,8,143,8,14,221,189,95,15,9,189,80,204,12,85,193,3,83,192,47,0,
    7,17,1,68,0,159,0,77,153,136,68,3,52,0,51,51,85,69,68,68,136,72,34,
    68,68,153,201,0,104,86,85,1,193,102,129,4,0,136,88,85,85,153,32,41,
    121,119,3,103,102,102,136,14,118,119,119,153,120,32,192,2,5,32,187,
    155,136,51,120,118,119,153,14,137,136,136,187,154,4,128,3,1,49,204,
    188,153,52,128,2,187,153,153,241,1,34,193,1,32,127,78,85,84,51,230,
    86,193,32,130,33,40,136,102,242,31,134,32,209,102,240,33,17,119,20,
    153,121,134,79,34,102,144,0,136,118,192,28,129,29,88,115,16,138,143,
    32,3,52,192,29,185,187,0,39,95,102,102,100,131,28,68,68,192,31,15,1,
    102,31,16,135,242,27,135,64,135,136,201,0,16,219,170,65,24,170,9,28,
    169,129,2,69,2,187,3,153,84,152,227,67,84,99,208,12,67,144,18,12,85,
    67,84,131,24,211,193,1,183,57,150,0,102,200,25,102,70,129,6,111,75,
    136,145,55,1,100,209,0,193,27,240,0,71,56,153,162,59,102,102,119,129,
    4,193,31,200,84,241,2,17,153,121,243,91,119,103,89,119,119,131,32,136,
    128,31,119,187,155,207,132,24,129,34,18,152,154,57,192,29,241,31,170,
    97,144,1,153,81,187,114,187,83,76,153,86,39,102,83,144,29,92,136,94,
    86,102,131,80,84,208,17,143,4,18,145,0,72,110,153,103,67,129,28,119,
    193,30,81,136,32,150,170,244,119,136,102,192,0,134,213,1,39,56,170,
    138,169,132,60,128,30,176,65,170,136,228,153,96,192,2,84,187,171,131,
    4,153,134,121,129,25,168,136,187,170,64,88,105,204,188,242,63,128,32,
    152,48,169,171,136,129,2,16,219,204,187,18,203,153,134,135,148,85,103,
    152,153,119,128,44,109,127,153,134,149,89,192,48,80,131,113,136,4,134,
    8,204,115,33,193,21,136,118,35,29,136,201,119,209,57,39,170,152,242,
    23,170,170,195,193,6,128,28,240,52,153,170,136,168,192,27,17,209,30,
    170,170,204,244,3,170,138,137,227,195,5,241,29,96,197,0,204,187,186,
    132,4,4,144,3,154,186,170,204,186,34,171,140,187,36,204,204,186,130,
    32,145,7,187,112,187,186,192,31,32,192,2,204,203,186,136,219,32,203,
    187,152,242,3,187,187,62,152,170,187,193,21,194,48,177,110,36,136,4,
    168,170,41,170,47,14,138,192,18,135,170,223,170,46,196,28,153,192,27,
    129,1,176,80,147,0,53,240,58,170,151,195,2,114,137,208,27,137,127,129,
    32,204,131,4,176,2,193,9,193,3,240,24,242,1,48,241,30,221,203,20,224,
    1,204,171,203,3,187,204,186,204,187,204,202,192,2,140,113,192,0,221,
    220,204,148,0,128,35,204,54,203,204,221,160,1,66,203,208,0,1,223,185,
    244,3,224,129,187,176,69,240,68,81,6,68,143,4,10,187,31,14,171,187,
    187,31,6,187,241,169,193,30,31,4,194,3,241,86,169,218,205,198,128,26,
    244,23,128,27,186,203,204,133,32,196,0,11,205,221,204,221,205,164,4,
    187,33,164,130,6,33,202,67,238,220,136,4,220,166,220,114,221,192,2,
    221,219,128,3,128,5,1,8,224,206,187,170,145,0,154,153,2,153,153,201,
    204,187,170,233,128,2,112,217,205,195,0,17,15,78,183,171,90,128,85,
    5,119,119,85,85,167,170,16,85,85,183,171,39,184,171,119,128,136,1,119,
    87,85,85,120,119,1,119,119,168,170,135,136,184,171,48,39,185,187,242,
    3,161,4,119,169,138,28,136,136,185,171,0,192,2,5,218,130,221,131,13,
    169,170,136,136,186,240,25,114,218,189,0,64,5,157,201,195,28,166,169,
    144,32,155,192,1,155,185,11,159,0,78,39,119,87,88,134,32,102,86,192,
    32,128,29,57,105,168,138,144,27,113,5,138,120,230,58,192,28,224,30,
    111,11,202,204,80,42,176,205,119,173,209,2,129,64,169,170,170,3,172,
    74,187,170,171,74,185,90,37,63,78,135,104,225,26,119,119,193,31,102,
    49,16,119,103,208,1,8,168,138,135,250,123,128,2,105,192,28,130,9,132,
    32,153,64,196,170,193,2,21,218,221,171,76,171,36,202,218,205,23,187,
    123,196,60,122,1,170,170,186,75,187,170,119,71,136,208,12,24,170,74,
    151,242,3,153,73,9,151,153,170,74,68,158,0,118,87,75,242,22,102,129,
    56,118,71,208,0,69,75,231,211,55,1,136,1,40,153,121,228,55,192,29,100,
    129,28,120,240,93,105,169,154,131,4,135,226,104,129,33,195,60,57,185,
    187,168,132,32,174,135,128,2,152,0,168,128,31,119,0,214,187,145,0,0,
    170,4,203,48,70,83,219,125,242,3,187,1,170,74,240,32,35,12,186,123,
    4,89,151,153,205,35,38,33,153,121,131,52,151,89,192,23,143,4,1,226,
    169,132,56,66,207,32,1,185,155,137,67,12,121,120,119,120,135,192,4,
    240,5,120,140,151,199,0,185,155,169,160,147,144,0,121,4,152,153,153,
    137,153,153,129,117,169,88,154,169,54,186,160,27,130,20,153,152,145,
    153,209,88,186,171,48,187,169,172,18,53,219,221,172,132,32,168,170,
    224,28,0,171,219,189,172,187,219,205,172,146,219,54,141,203,130,4,186,
    139,195,64,98,136,120,208,17,56,186,139,186,131,68,112,138,153,198,
    3,194,54,12,169,138,153,249,153,15,14,129,24,2,130,26,195,0,202,156,
    146,135,144,1,170,138,128,81,155,185,64,152,186,2,203,172,36,160,28,
    170,154,14,170,170,187,171,187,194,2,129,1,194,1,128,204,131,56,185,
    187,169,153,187,155,10,186,187,203,188,187,5,188,1,120,235,222,208,
    1,129,28,160,32,225,0,219,189,10,188,187,235,206,188,192,32,188,128,
    32,8,188,219,220,173,203,241,99,204,202,15,172,203,170,187,139,160,
    36,128,16,201,0,172,128,4,146,8,186,129,14,139,160,72,132,3,204,128,
    140,79,45,204,202,188,204,140,202,224,188,26,128,24,193,3,187,171,186,
    187,17,187,171,202,188,129,1,220,189,204,153,147,24,176,19,203,156,
    224,0,240,89,204,188,66,161,0,187,192,0,203,188,236,206,135,4,37,204,
    172,203,162,3,220,205,0,204,16,51,237,222,221,69,187,204,204,0,203,
    188,221,205,220,188,237,206,144,221,128,1,221,204,48,220,237,190,97,
    221,205,146,32,128,7,221,189,221,205,194,129,12,41,9,220,189,221,204,
    201,3,68,221,173,127,45,221,220,205,31,6,221,7,189,220,205,221,189,
    219,31,3,3,31,224,23,189,204,205,192,25,19,160,4,193,26,200,225,30,
    128,1,166,0,253,239,119,237,238,224,221,130,6,192,34,195,0,206,221,
    221,1,8,160,221,190,170,145,0,136,136,3,170,153,171,187,187,170,171,
    128,2,10,201,0,136,221,173,153,1,136,1,56,187,171,153,17,41,15,78,136,
    204,64,187,119,3,118,119,136,153,121,17,119,136,204,123,42,153,204,
    156,28,131,5,153,118,119,146,1,81,24,186,70,221,172,198,9,186,204,170,
    66,25,43,188,204,189,134,32,187,16,187,64,21,9,201,136,171,22,153,192,
    4,153,200,49,9,31,78,153,166,226,31,102,102,24,103,102,136,136,193,
    32,11,153,204,84,154,154,26,187,240,1,204,7,186,27,221,173,201,204,
    144,0,20,169,192,30,68,64,173,54,172,204,189,240,30,187,66,187,155,
    131,64,187,172,204,185,58,193,203,197,28,16,170,136,166,153,187,176,
    60,31,80,167,130,1,160,32,119,136,119,7,135,136,136,119,151,153,41,
    0,186,131,56,23,170,193,2,101,128,30,202,18,140,170,192,33,204,170,
    186,129,2,57,187,85,204,188,18,170,128,29,185,128,1,188,140,192,30,
    9,170,170,169,130,12,144,17,153,45,170,170,166,144,64,150,208,12,89,
    134,83,244,35,134,160,4,102,159,0,0,136,104,135,1,38,224,56,102,135,
    43,136,119,162,107,128,27,49,135,136,119,2,91,153,170,152,17,132,12,
    135,136,153,192,5,153,119,168,162,208,33,7,170,134,32,151,153,169,128,
    5,253,170,16,194,2,4,192,60,130,28,16,170,88,0,187,192,30,203,64,86,
    187,204,130,204,3,170,171,170,187,187,192,1,99,204,201,128,31,71,170,
    204,185,19,167,193,11,16,170,29,187,137,166,53,192,33,143,144,25,11,
    153,187,138,228,3,193,23,192,2,125,1,135,7,139,4,131,33,194,34,68,170,
    144,160,19,130,28,170,152,96,137,136,170,222,119,208,1,25,221,67,129,
    37,194,53,129,6,36,204,170,172,101,187,221,131,92,170,66,187,155,128,
    122,186,187,187,221,128,62,38,221,189,219,53,203,221,132,32,176,0,130,
    203,192,33,203,221,201,187,203,128,31,136,204,116,187,204,202,130,4,
    169,187,216,186,128,132,131,66,187,194,66,67,186,204,122,186,171,129,
    16,224,1,35,193,2,187,143,4,26,225,187,104,147,0,224,20,171,186,187,
    186,241,195,0,108,194,3,80,37,202,221,203,131,50,67,186,171,202,204,
    203,33,136,208,94,19,203,238,205,132,28,171,170,56,203,221,202,64,192,
    28,192,2,203,221,131,205,192,31,205,219,219,238,220,147,36,0,144,0,
    203,204,220,188,219,221,218,10,189,203,204,202,188,49,204,129,1,253,
    238,147,100,129,15,133,3,49,128,35,195,1,221,235,135,4,193,37,201,4,
    63,15,188,63,10,204,195,16,42,56,203,204,241,85,203,128,19,204,199,
    0,76,238,205,22,204,221,204,3,64,220,88,238,221,241,127,204,208,128,
    81,204,220,36,221,220,204,193,2,220,221,66,220,49,221,255,221,146,0,
    192,33,188,221,238,126,144,1,238,224,2,240,2,70,49,132,4,224,1,223,
    205,202,3,67,205,129,12,129,22,193,10,48,250,193,4,199,0,127,43,128,
    14,111,7,193,17,204,0,249,237,2,194,29,6,193,3,196,0,255,238,208,6,
    193,5,115,238,37,221,1,1,208,205,221,221,253,223,221,14,146,0,220,221,
    205,188,146,1,192,2,194,0,129,189,49,204,204,237,190,205,204,1,2,188,
    204,188,221,189,205,204,128,49,192,1,204,187,203,187,187,236,48,190,
    204,188,129,1,83,170,170,220,48,189,204,188,49,165,0,219,221,170,16,
    170,203,188,170,18,168,170,102,9,102,219,205,170,170,33,203,204,0,35,
    218,205,156,153,218,205,155,134,153,17,152,153,102,102,193,1,33,64,
    202,204,19,218,205,187,153,234,224,206,139,4,129,2,133,5,219,205,172,
    170,34,235,222,172,130,12,169,170,153,67,96,206,172,192,12,19,236,206,
    204,204,100,252,239,243,23,129,14,220,221,67,236,224,222,16,192,3,128,
    29,188,235,206,221,159,188,148,24,203,220,64,162,29,226,29,192,27,0,
    159,0,77,200,188,108,102,200,188,107,200,102,85,193,28,200,188,199,
    0,201,188,16,153,153,217,189,242,31,153,152,121,123,102,102,129,1,193,
    2,5,192,26,172,129,42,96,133,32,203,176,33,201,44,220,205,205,220,112,
    236,222,131,56,117,129,2,236,206,205,195,204,192,3,144,28,204,204,190,
    187,208,2,153,129,4,224,29,188,171,144,31,196,0,187,171,3,239,31,78,
    187,187,152,121,121,119,49,224,147,0,128,32,176,1,57,169,170,154,153,
    33,201,172,154,122,185,171,153,153,187,193,29,130,30,188,34,146,64,
    38,189,195,78,109,17,220,240,28,192,61,220,241,90,87,204,129,192,31,
    19,187,139,187,187,205,172,156,83,193,30,170,106,144,9,121,159,0,77,
    153,161,137,128,25,138,131,28,136,120,119,119,196,129,2,57,160,4,153,
    202,172,133,64,119,189,119,161,5,186,128,32,129,3,1,192,28,204,223,
    64,130,24,4,187,0,192,57,99,132,64,48,12,205,220,129,3,81,170,138,170,
    36,170,221,157,35,204,156,192,32,107,24,187,187,153,105,208,12,20,136,
    104,8,136,136,204,108,201,242,3,187,107,24,185,187,204,108,182,85,146,
    0,136,120,25,136,136,153,121,131,20,161,56,153,105,127,208,0,103,87,
    131,28,131,4,193,5,193,20,130,6,1,68,170,154,170,170,186,155,186,128,
    198,33,240,61,153,186,155,185,170,170,98,154,169,35,144,0,203,188,186,
    194,69,8,169,138,169,170,171,128,8,187,171,197,186,160,141,99,203,188,
    202,128,32,202,139,130,20,161,64,203,172,186,48,202,192,31,190,195,
    0,192,28,221,128,30,242,154,96,144,65,66,227,221,129,3,1,65,237,158,
    237,130,4,89,17,187,16,155,24,193,18,220,157,51,20,123,185,202,35,37,
    202,156,128,22,95,145,0,122,32,106,27,129,12,25,197,37,2,133,32,186,
    155,187,170,202,172,19,98,186,139,208,0,192,30,186,171,186,192,0,203,
    185,82,129,31,219,189,212,101,155,128,33,20,204,114,204,188,203,192,
    28,203,131,20,187,188,186,131,2,189,80,128,1,193,0,129,185,237,133,
    222,131,188,219,221,202,204,224,28,205,129,82,196,188,187,155,187,187,
    237,174,60,131,32,220,173,195,64,193,50,197,0,129,4,220,201,173,161,
    101,144,0,172,202,198,3,204,156,241,42,131,136,192,47,47,23,224,145,
    204,156,203,158,194,140,29,204,172,80,192,13,130,1,160,177,127,220,
    189,20,225,177,128,6,228,179,194,0,193,212,15,135,28,187,187,221,189,
    176,93,130,215,84,248,144,0,135,220,128,34,224,0,137,32,193,8,254,207,
    64,253,238,49,236,206,237,205,204,230,172,129,29,200,0,128,4,237,206,
    163,12,192,195,55,204,221,173,160,72,196,3,221,129,38,67,253,131,12,
    32,201,7,47,2,138,8,192,17,47,6,221,255,177,118,193,0,130,28,20,240,
    21,17,195,3,129,24,252,176,8,130,248,83,177,88,130,32,53,192,0,254,
    4,223,238,222,255,223,254,164,36,221,5,221,238,222,237,222,254,128,
    2,238,128,160,0,33,1,0,224,238,221,205,237,255,223,64,205,204,144,0,
    170,204,204,171,237,98,238,222,128,2,197,0,221,205,221,128,4,199,221,
    192,1,51,188,171,221,48,17,128,130,1,192,3,204,204,189,187,204,238,
    64,189,187,145,0,169,187,187,171,204,225,221,115,194,0,192,1,185,221,
    189,171,67,65,170,32,154,153,153,153,53,24,134,3,221,173,186,65,130,
    8,170,138,192,136,5,37,203,238,238,171,203,99,238,206,50,129,4,203,
    221,205,2,4,39,222,189,203,255,222,132,16,139,14,136,203,238,221,187,
    1,128,3,18,142,220,17,255,223,203,129,24,193,4,48,32,203,220,255,87,
    205,238,220,220,8,205,238,222,220,221,144,0,170,170,140,204,112,221,
    220,204,16,35,221,1,220,218,221,204,171,170,238,205,252,130,16,50,112,
    82,97,193,1,15,77,169,3,221,221,136,169,238,221,136,5,16,193,28,169,
    221,141,54,187,221,189,79,188,187,134,48,136,136,146,1,129,2,192,47,
    1,1,220,238,205,220,220,255,206,9,241,31,204,187,204,188,48,204,204,
    254,192,2,86,241,29,128,57,130,4,129,32,114,24,14,203,170,205,171,219,
    128,3,241,10,129,18,227,187,193,1,120,95,79,187,200,153,65,1,145,0,
    136,136,137,136,169,170,152,198,128,2,71,192,26,188,187,221,16,89,224,
    221,240,1,192,29,130,30,221,205,219,220,51,238,206,219,129,60,131,64,
    204,203,128,31,5,51,221,205,203,205,221,224,0,238,25,225,3,221,221,
    189,128,26,130,2,221,219,12,54,204,187,202,187,144,39,242,10,187,156,
    170,128,92,187,200,224,1,7,159,0,78,170,91,187,185,0,201,194,1,160,
    32,153,225,96,128,195,2,83,203,204,188,204,203,221,223,188,130,56,129,
    34,203,128,5,129,2,130,3,64,127,224,25,220,128,32,130,92,132,64,0,192,
    2,17,176,32,192,60,221,96,146,0,204,187,205,113,187,219,113,128,31,
    37,204,204,202,98,160,11,219,131,72,80,204,204,200,128,1,195,184,160,
    1,3,170,170,168,170,195,1,234,129,68,113,182,85,132,86,169,128,53,169,
    130,56,33,153,153,154,16,168,153,169,170,252,199,0,144,74,209,74,229,
    61,243,0,197,2,112,187,183,187,176,131,204,242,131,224,1,169,128,2,
    176,0,255,65,84,146,19,243,87,128,148,128,34,193,20,132,2,243,145,0,
    225,57,128,32,130,28,2,238,204,32,217,227,60,193,0,83,237,51,144,7,
    221,221,173,193,1,60,221,59,204,8,130,17,221,181,225,14,145,0,185,136,
    3,136,4,204,99,170,253,160,156,111,0,209,10,25,129,27,129,2,131,28,
    203,127,192,3,203,160,51,18,160,116,129,1,229,13,131,18,191,135,32,
    129,37,204,224,62,105,193,59,192,186,131,28,28,240,181,237,238,220,
    128,2,131,62,145,0,237,13,238,236,221,237,255,20,176,0,237,30,192,33,
    237,238,235,194,0,134,33,192,4,130,72,46,221,220,187,195,34,203,176,
    12,177,170,193,13,191,219,192,44,220,130,196,208,15,131,16,201,0,131,
    4,183,132,20,28,188,31,10,145,0,203,194,3,21,211,224,2,20,136,28,221,
    128,216,238,237,130,16,118,131,2,220,209,58,198,0,130,26,255,147,30,
    130,32,224,255,128,30,194,28,195,30,238,238,237,238,14,238,255,254,
    239,238,144,0,208,1,176,0,170,254,128,2,252,16,236,160,2,236,224,3,
    127,237,222,128,8,146,40,160,69,192,10,81,193,70,255,129,101,193,41,
    193,9,134,4,129,16,163,1,196,0,111,44,239,129,52,47,6,163,26,131,28,
    239,39,130,19,129,6,1,99,254,255,254,238,254,255,255,135,241,27,161,
    29,205,238,255,237,128,2,192,28,0,148,0,1,1,224,238,237,238,254,255,
    254,46,193,0,239,238,144,0,237,0,194,1,132,2,3,221,238,236,238,237,
    255,252,225,4,138,241,1,64,222,221,237,128,6,237,162,0,4,236,238,221,
    221,236,221,39,221,11,221,219,221,221,205,192,8,221,224,3,69,133,3,
    205,35,220,205,204,144,0,203,211,32,128,4,192,4,237,194,2,221,221,129,
    1,248,195,1,31,3,194,9,208,14,160,13,145,0,204,221,174,205,97,222,48,
    222,146,2,193,1,128,18,99,238,255,242,19,129,24,205,238,255,211,1,162,
    193,21,129,1,255,192,25,255,255,255,133,28,207,221,193,1,195,2,254,
    239,177,8,161,25,160,32,69,194,6,204,128,8,254,255,253,164,33,237,126,
    224,14,220,192,12,192,32,130,2,128,4,130,28,165,0,125,236,238,193,22,
    224,18,192,0,128,5,144,0,203,163,194,26,193,1,220,224,2,204,204,219,
    128,2,194,1,129,27,33,188,187,187,187,202,2,40,221,205,220,115,204,
    146,8,203,204,118,172,170,44,128,10,48,238,144,31,130,36,124,172,170,
    193,1,134,3,148,0,131,46,129,16,173,239,170,37,53,128,25,221,128,36,
    198,2,192,59,221,51,130,5,160,54,221,193,41,131,42,224,47,205,165,131,
    31,145,0,220,160,0,219,205,224,0,205,253,49,180,24,209,29,131,2,196,
    54,79,74,192,36,170,17,194,0,221,204,170,69,203,221,172,212,192,2,99,
    193,4,220,161,0,238,132,72,221,125,170,170,161,47,227,47,177,21,193,
    32,241,64,222,238,200,66,193,55,165,74,129,32,236,192,31,193,0,81,48,
    236,205,238,194,1,163,8,187,187,188,13,187,221,204,219,205,114,130,
    4,203,226,240,50,131,2,227,85,159,0,76,187,187,186,160,70,8,186,187,
    203,204,202,128,1,187,187,62,170,170,171,128,31,195,2,193,0,131,32,
    134,30,252,188,101,183,53,2,179,102,1,50,221,223,237,193,2,15,2,221,
    12,197,28,133,92,176,82,87,128,31,202,160,2,202,96,218,198,74,159,0,
    70,117,193,30,203,224,32,193,0,3,170,192,1,203,205,213,1,141,32,128,
    64,186,187,127,1,12,221,95,8,220,144,33,236,208,3,131,96,241,34,129,
    2,253,193,0,195,30,129,36,194,128,164,18,193,2,129,31,218,103,224,12,
    202,130,52,130,34,221,218,164,14,193,35,118,182,85,170,130,53,193,55,
    136,56,187,8,131,28,254,203,200,26,193,2,43,147,25,168,98,156,0,130,
    94,159,238,180,113,238,219,128,2,135,115,135,32,133,164,253,129,33,
    88,128,31,209,67,193,192,147,0,161,161,254,248,130,172,128,156,192,
    32,128,32,193,31,200,138,221,238,185,234,8,203,131,14,132,148,17,220,
    221,251,131,68,195,0,130,4,211,164,134,36,20,188,47,6,199,197,28,131,
    1,33,220,238,222,148,26,193,2,255,151,60,224,49,128,194,192,54,179,
    91,192,19,128,58,128,2,190,128,3,128,151,221,240,185,131,185,192,158,
    243,27,177,195,239,255,195,2,193,28,192,189,255,192,31,162,0,145,0,
    191,129,5,227,1,253,144,198,227,188,131,8,193,194,162,39,127,208,41,
    253,216,169,193,15,195,40,131,2,241,0,197,2,255,192,74,134,4,133,214,
    247,40,11,137,8,195,3,131,223,255,194,27,11,192,8,197,2,150,91,201,
    222,196,225,193,3,184,133,221,133,224,238,240,0,37,241,1
};

static MTB * mtb_KRK = NULL;

void initMTB_KRK()
{
    mtb_KRK = new MTB ("KRK", 4, 10);
    mtb_KRK->SetPackedData (mtbdata_KRK);
    mtb_KRK->Add (A1, WHITE, 554);
    mtb_KRK->Add (B1, WHITE, 621);
    mtb_KRK->Add (C1, WHITE, 635);
    mtb_KRK->Add (D1, WHITE, 606);
    mtb_KRK->Add (B2, WHITE, 711);
    mtb_KRK->Add (C2, WHITE, 782);
    mtb_KRK->Add (D2, WHITE, 718);
    mtb_KRK->Add (C3, WHITE, 879);
    mtb_KRK->Add (D3, WHITE, 839);
    mtb_KRK->Add (D4, WHITE, 767);
}

//////////////////////////////////////////////////////////////////////
//
// KPK

static const byte mtbdata_KPK[6552] = {
    1,65,255,159,0,109,0,3,3,3,0,130,0,134,2,15,14,15,15,15,144,2,134,31,
    1,7,0,0,63,1,160,2,148,127,1,31,31,142,8,1,148,8,1,97,7,7,224,5,128,
    1,14,14,14,2,209,49,241,7,96,1,82,15,0,1,201,82,143,8,1,164,16,1,0,
    147,8,1,0,223,48,130,1,131,16,1,33,17,33,15,3,255,51,80,50,64,50,64,
    48,2,255,17,129,10,17,143,8,2,18,1,17,1,239,17,1,17,0,15,16,130,18,
    16,255,143,8,3,16,67,36,16,131,10,36,16,128,131,26,15,0,1,65,255,159,
    0,117,0,7,7,7,0,144,0,133,2,3,31,1,0,0,15,132,63,1,15,0,31,127,1,31,
    88,31,63,226,3,63,243,0,129,7,14,15,84,15,15,145,7,2,148,8,3,131,2,
    3,219,7,240,7,144,2,15,33,160,2,31,33,233,176,2,162,7,16,134,8,15,4,
    7,5,34,3,15,11,130,2,3,31,23,132,16,173,47,4,95,4,191,15,0,145,6,2,
    252,224,0,97,1,128,2,18,96,18,63,254,63,19,32,164,7,135,8,242,4,146,
    20,145,22,242,7,133,2,131,32,160,1,242,7,63,63,99,123,127,127,150,7,
    148,0,244,3,245,4,7,140,2,208,128,14,19,116,127,141,47,1,73,255,159,
    0,109,60,63,1,0,0,6,133,2,0,14,14,14,0,0,37,145,7,132,4,31,127,1,31,
    0,63,16,226,2,63,63,127,130,1,127,127,60,161,62,240,3,62,144,6,28,31,
    31,31,82,145,7,4,148,8,7,131,2,7,15,128,4,237,15,128,8,65,160,2,63,
    1,176,2,127,153,1,48,60,63,1,144,5,31,29,36,147,6,14,10,35,31,23,130,
    2,7,87,63,47,132,16,95,52,191,52,19,239,50,145,4,49,145,6,4,224,0,97,
    17,231,128,2,18,128,4,18,127,127,19,64,255,18,48,131,32,144,4,226,0,
    146,20,144,0,48,231,132,2,99,160,1,242,7,127,127,115,144,7,239,133,
    1,244,2,36,245,4,14,140,2,133,4,245,6,0,150,0,1,81,255,159,0,109,254,
    227,0,0,120,127,32,1,0,0,133,3,0,28,28,28,212,0,0,133,2,15,132,4,63,
    226,1,63,69,0,127,130,1,127,127,254,145,8,254,80,128,8,124,240,3,124,
    144,6,56,62,62,169,62,145,7,8,20,14,131,2,15,31,110,128,4,31,32,97,
    63,16,33,176,2,209,254,162,16,129,16,125,130,12,0,62,58,36,147,6,28,
    20,35,62,46,130,2,15,95,127,95,116,191,68,35,66,240,21,239,66,145,4,
    17,145,6,8,224,0,97,17,254,128,2,18,128,4,18,128,6,18,96,243,7,127,
    255,255,131,32,144,4,226,0,144,6,130,1,96,158,132,2,3,127,127,243,7,
    144,7,255,41,4,245,2,176,62,68,28,108,254,6,1,64,255,159,0,117,0,7,
    7,7,3,130,0,0,14,15,15,7,7,128,1,32,31,31,31,160,1,0,0,63,63,134,63,
    49,0,127,127,127,49,142,7,48,0,3,3,97,135,2,15,14,14,247,2,145,9,144,
    8,18,32,15,128,8,33,166,176,2,95,0,1,35,0,1,160,16,130,1,63,14,14,14,
    50,17,49,18,48,221,18,143,8,1,164,16,1,177,24,2,19,1,255,49,2,17,129,
    10,17,143,8,2,19,0,241,18,0,18,0,18,1,0,15,255,16,130,18,16,143,8,3,
    16,35,116,0,240,131,10,36,0,131,26,47,0,1,72,255,159,0,109,0,15,0,0,
    0,161,0,137,2,7,32,7,31,31,31,8,145,3,7,63,63,63,160,1,0,31,46,127,
    127,127,81,63,192,4,81,142,9,54,0,7,7,129,7,54,3,144,8,144,2,111,7,
    15,64,144,9,31,65,176,2,162,7,164,16,135,7,14,147,16,0,2,3,0,175,3,
    131,2,3,161,16,7,128,8,98,16,210,35,179,7,25,15,36,7,5,35,70,15,11,
    130,2,3,31,23,192,6,129,16,219,47,1,240,7,95,1,160,7,191,1,191,59,145,
    6,2,161,31,0,17,128,2,18,251,160,16,18,49,17,33,187,31,0,161,19,255,
    145,36,131,1,128,8,132,2,129,32,18,242,7,16,128,82,174,39,1,72,255,
    159,0,109,62,63,1,0,0,14,0,31,31,31,30,240,0,133,3,129,2,164,15,64,
    15,224,3,31,31,128,1,127,77,127,127,160,1,0,63,192,3,1,127,10,226,4,
    127,127,0,60,144,4,62,136,7,22,0,14,14,14,137,9,7,128,4,144,9,109,15,
    31,144,8,0,63,17,176,2,127,153,17,64,0,60,161,16,16,0,28,146,160,14,
    240,0,0,4,3,0,7,131,2,191,7,113,15,128,8,2,96,51,208,1,210,133,16,17,
    145,24,29,147,6,14,10,19,70,31,23,130,2,7,63,47,129,4,48,223,95,65,
    240,7,191,49,64,50,35,223,49,1,145,6,4,224,0,17,1,128,2,255,2,160,16,
    2,161,31,1,178,23,131,28,129,32,255,130,8,242,0,0,130,1,0,132,2,113,
    2,224,242,7,32,131,35,4,255,1,80,255,159,0,109,252,226,0,254,0,124,
    0,127,127,127,126,126,0,0,0,29,62,62,62,60,240,0,133,4,129,2,30,78,
    64,31,48,63,63,128,1,192,2,160,1,66,0,127,226,3,127,127,252,254,241,
    7,20,254,0,0,120,144,4,124,136,7,0,42,28,28,28,137,9,15,128,4,31,128,
    8,217,63,208,1,144,9,127,145,8,176,2,252,254,230,50,0,161,16,48,0,56,
    160,14,240,0,74,0,8,3,0,14,131,2,15,113,252,31,96,2,96,51,128,16,19,
    120,105,127,125,192,2,145,24,58,147,6,28,20,35,19,62,46,130,2,15,127,
    95,129,4,127,32,191,49,240,7,50,35,128,20,34,223,49,1,145,6,8,224,0,
    17,1,128,2,255,2,160,16,2,178,23,131,40,243,7,128,8,242,3,255,96,242,
    0,0,130,1,0,132,2,129,32,2,128,131,6,244,7,255,1,64,255,159,0,181,0,
    0,7,7,7,65,3,0,0,14,15,15,7,7,16,128,1,31,31,31,160,1,0,0,63,99,63,
    63,48,143,7,8,0,3,3,80,15,136,2,15,14,14,2,145,9,144,8,2,94,16,15,143,
    8,10,1,18,128,1,160,16,98,63,14,14,14,2,49,1,33,143,8,10,203,115,0,
    35,1,0,3,1,97,127,49,15,0,95,11,0,51,84,16,224,131,10,4,16,15,6,1,68,
    255,159,0,173,0,0,15,0,0,128,0,138,2,7,0,0,0,7,31,66,31,31,145,3,7,
    63,63,63,161,1,24,31,127,127,127,64,143,9,8,0,7,217,7,128,7,39,3,144,
    8,144,2,7,15,173,16,192,10,31,17,31,142,8,112,14,29,146,16,0,0,2,18,
    144,7,131,2,3,125,161,16,7,96,19,208,1,17,95,1,15,36,4,7,5,3,15,11,
    130,2,3,109,31,23,192,6,129,16,47,1,240,7,95,223,32,111,5,129,8,2,164,
    31,33,49,33,240,49,33,1,17,14,1,68,255,159,0,173,0,62,63,1,0,1,0,0,
    31,31,31,30,0,0,169,134,3,129,2,15,240,2,15,224,3,31,31,23,128,1,127,
    127,127,161,1,63,208,3,112,80,135,5,60,144,4,62,136,7,0,14,14,179,14,
    137,9,7,128,4,144,9,15,31,144,8,122,192,10,63,177,7,210,0,133,8,161,
    16,62,128,7,206,28,224,3,240,0,0,4,146,8,144,7,131,2,191,7,81,15,128,
    8,19,208,1,17,137,16,164,1,145,24,29,147,6,14,10,3,31,141,23,130,2,
    7,63,47,129,4,16,95,190,33,240,7,191,137,32,3,129,8,1,81,255,4,240,
    0,81,65,17,33,17,33,192,17,198,15,145,0,1,72,255,159,0,173,0,252,242,
    0,254,0,0,124,127,127,127,126,126,0,0,3,0,62,62,62,60,0,0,134,4,83,
    129,2,30,240,2,31,32,63,63,128,1,161,208,2,161,1,127,242,3,127,0,252,
    254,10,241,7,254,0,0,120,144,4,124,136,7,21,0,28,28,28,137,9,15,128,
    4,31,91,128,8,63,224,1,63,112,145,8,127,17,214,34,16,161,16,124,128,
    7,56,160,14,240,0,69,0,8,34,0,0,14,131,2,15,126,97,31,80,35,208,1,133,
    16,33,1,210,125,192,2,145,24,58,147,6,28,20,19,70,62,46,130,2,15,127,
    95,129,4,32,255,191,97,240,7,33,20,129,8,17,97,191,17,1,8,240,0,1,17,
    1,17,224,1,17,1,162,32,1,64,255,159,0,245,0,0,0,7,7,64,7,3,240,0,0,
    14,15,15,7,130,7,128,1,31,31,31,15,15,143,7,17,8,0,3,3,3,0,137,2,15,
    14,107,14,2,33,144,8,7,143,8,18,1,97,199,33,160,16,18,14,14,14,18,0,
    234,127,19,32,19,100,0,20,7,31,16,1,66,255,159,0,237,0,0,0,15,0,161,
    0,139,2,7,240,0,7,31,31,31,1,144,3,0,7,63,63,63,31,31,11,143,9,17,0,
    7,7,7,89,3,144,8,43,144,9,7,15,112,15,143,7,10,14,145,16,115,144,0,
    2,17,145,7,131,2,3,15,16,255,130,17,0,143,8,10,146,24,151,23,117,129,
    16,50,128,240,7,15,7,1,66,255,159,0,237,0,0,62,63,1,1,0,0,0,31,31,31,
    30,0,169,135,3,129,2,15,240,0,15,224,3,31,31,4,128,1,127,127,127,63,
    63,143,8,0,0,161,60,144,4,62,56,0,14,14,14,101,137,9,7,128,4,144,9,
    15,31,144,8,31,155,127,5,129,16,0,28,160,14,129,1,4,81,159,145,7,131,
    2,7,31,130,4,128,17,32,143,8,10,255,240,5,2,240,0,2,132,2,129,16,2,
    240,7,0,46,1,68,255,159,0,237,0,0,252,132,1,124,0,127,127,127,126,126,
    0,0,0,13,62,62,62,60,0,135,4,129,2,30,76,240,0,31,32,63,63,16,224,2,
    127,170,127,136,8,254,64,254,144,4,120,32,133,124,136,7,0,28,28,28,
    137,9,15,92,128,4,31,0,63,240,1,193,0,140,16,0,109,120,126,48,65,56,
    160,14,129,1,8,167,145,8,144,0,14,131,2,15,63,130,4,128,17,255,143,
    24,3,130,16,130,8,240,5,98,240,0,2,132,2,192,81,2,137,32,1,104,255,
    159,0,255,15,36,0,0,7,7,66,7,2,129,1,14,15,15,7,143,7,26,17,0,3,3,3,
    138,2,15,14,14,18,143,8,27,1,3,3,51,7,7,50,128,7,111,24,1,107,255,159,
    0,255,15,28,0,0,15,0,67,140,2,7,240,0,7,31,31,31,134,3,12,143,9,18,
    0,7,7,7,72,240,7,31,184,31,143,16,19,10,130,14,130,8,2,11,15,128,15,
    79,22,1,96,255,159,0,255,15,28,0,0,0,62,193,63,0,128,1,0,31,31,31,30,
    171,136,3,129,2,15,240,0,15,240,3,31,143,8,9,67,241,7,63,137,7,0,14,
    14,14,143,4,6,141,15,6,130,14,29,31,31,5,130,2,23,128,114,79,11,1,96,
    255,159,0,255,15,36,0,0,0,124,16,127,127,127,126,128,1,0,62,62,106,
    62,60,136,3,129,2,30,240,0,31,128,4,200,63,143,8,9,240,3,127,127,137,
    7,0,28,113,28,28,111,6,127,6,130,14,58,62,62,176,53,130,2,46,98,63,
    3,1,104,255,159,0,255,15,100,0,1,7,7,163,7,244,1,254,143,7,27,0,3,3,
    252,2,0,143,8,23,1,104,255,159,0,255,15,92,0,1,15,15,194,15,143,2,6,
    143,9,26,15,10,15,7,143,7,30,1,104,255,159,0,255,15,100,0,1,31,31,194,
    31,143,2,6,143,9,26,31,21,31,14,143,6,22,1,104,255,159,0,255,15,108,
    0,1,62,62,194,62,143,2,6,143,9,26,62,42,62,28,143,5,14,1,9,3,3,3,0,
    145,0,7,7,68,131,1,255,15,37,7,7,7,130,8,14,0,15,14,15,15,15,0,0,28,
    64,31,30,18,56,63,63,31,31,0,31,7,0,112,127,127,63,63,0,63,15,15,224,
    255,255,127,127,44,127,31,31,133,7,0,151,16,147,8,15,32,14,14,6,17,
    29,30,30,14,182,2,0,57,112,177,3,113,32,161,10,234,225,32,80,134,8,
    1,36,1,20,17,1,14,14,14,130,1,28,30,30,109,1,1,160,16,161,3,1,80,1,
    1,210,80,10,20,1,20,1,0,147,8,127,1,0,80,130,1,81,113,2,16,254,224,
    6,138,8,3,16,2,16,2,16,63,28,30,28,18,0,18,144,31,129,8,255,193,7,10,
    82,65,49,65,49,65,139,49,1,63,63,56,1,15,16,255,129,8,214,7,85,16,35,
    84,0,19,252,160,24,130,11,144,16,33,48,2,24,1,12,7,7,7,0,145,0,133,
    1,15,172,15,19,255,15,21,3,132,7,133,2,14,80,15,15,82,31,2,0,0,59,64,
    63,63,18,127,127,127,63,63,100,63,15,129,5,176,1,31,31,227,5,63,8,63,
    0,3,7,3,154,16,14,15,213,14,149,8,161,9,3,224,6,31,160,3,15,228,81,
    192,11,145,7,240,7,31,63,67,63,57,0,2,7,19,128,1,18,2,15,127,3,3,242,
    14,240,11,208,4,129,8,1,81,234,1,81,1,18,5,3,2,4,65,2,5,3,3,11,31,31,
    28,109,17,23,225,4,16,47,33,16,95,19,34,63,63,191,131,24,2,4,128,7,
    98,32,2,161,24,32,2,1,7,18,58,3,3,15,17,128,36,192,5,56,128,8,109,15,
    63,16,241,26,127,17,99,255,237,32,160,3,17,131,1,7,98,17,3,149,224,
    0,0,3,7,210,21,56,240,7,63,95,0,112,64,127,1,130,24,144,0,147,45,255,
    128,7,138,1,146,29,18,241,32,145,8,241,7,1,192,17,1,20,255,1,66,255,
    148,0,15,15,14,0,1,78,14,14,131,1,30,30,35,133,4,15,6,130,63,2,0,0,
    7,15,15,138,6,49,28,30,30,130,2,69,119,127,127,134,34,176,3,127,127,
    127,31,132,5,160,2,196,31,96,145,5,7,15,7,154,16,28,106,30,28,149,8,
    129,4,7,224,6,63,176,12,210,31,17,160,6,63,212,15,0,28,132,8,82,4,15,
    19,4,20,4,30,19,255,7,242,14,240,11,16,1,17,113,1,10,18,29,31,31,3,
    129,6,10,3,144,4,4,4,10,3,7,23,63,91,63,56,17,47,32,1,95,17,88,0,191,
    131,24,28,145,16,16,4,8,177,14,18,4,161,24,0,4,2,14,24,2,7,7,31,1,128,
    36,63,127,95,127,112,241,29,127,144,7,241,26,18,130,24,126,49,4,224,
    0,49,129,1,49,97,49,206,7,0,16,7,15,160,6,16,240,7,191,127,16,224,99,
    147,9,160,36,145,18,144,0,251,208,48,130,1,128,8,98,80,147,48,63,241,
    32,224,145,8,241,7,65,84,255,1,66,255,156,0,30,30,28,0,1,78,28,28,131,
    1,60,60,35,141,5,5,76,123,127,1,0,0,242,0,32,14,70,30,30,138,6,56,60,
    60,130,2,133,4,49,239,255,255,2,227,3,63,0,120,66,241,2,124,144,4,63,
    63,63,62,145,5,34,14,30,14,154,16,56,60,56,66,41,126,126,126,49,15,
    224,6,127,31,214,240,5,242,7,128,8,124,116,56,144,8,129,5,82,8,30,19,
    8,20,8,60,19,222,14,16,1,31,128,7,113,49,18,129,125,130,18,0,56,58,
    63,63,7,82,129,6,20,35,8,36,8,20,35,11,14,46,126,126,112,17,95,144,
    7,84,17,191,131,24,124,145,16,3,16,56,139,62,2,8,16,28,2,8,161,24,17,
    0,8,4,28,2,14,14,62,1,1,15,31,31,127,255,255,224,226,241,29,17,131,
    24,1,56,62,62,2,253,8,128,1,1,33,1,33,1,14,156,32,16,15,31,224,5,16,
    243,7,255,255,192,130,40,161,24,226,0,144,26,130,1,208,48,18,227,128,
    8,18,32,18,126,126,15,18,128,160,23,132,52,1,84,255,159,0,45,3,0,0,
    0,7,68,7,7,130,1,14,14,15,146,1,28,0,30,31,15,7,7,0,0,56,0,63,63,31,
    15,15,7,0,112,16,127,127,63,31,160,1,224,255,255,184,127,176,2,31,141,
    9,145,8,129,8,0,14,33,15,14,2,49,28,31,30,6,243,65,0,146,9,0,240,7,
    15,0,0,152,112,134,8,0,0,148,16,6,15,14,136,14,130,1,29,30,30,146,9,
    57,63,136,63,162,3,113,127,127,33,0,225,84,255,255,10,1,68,1,36,1,135,
    14,35,1,28,30,30,82,160,16,110,145,3,1,96,17,1,224,6,26,4,181,1,4,1,
    192,32,145,8,1,96,28,223,130,1,112,18,127,32,16,193,7,138,8,254,35,
    16,2,16,2,16,2,16,47,63,63,56,17,15,32,129,8,217,39,255,130,4,16,3,
    36,16,99,161,24,129,11,240,145,16,112,0,82,8,1,65,255,159,0,45,3,7,
    7,7,0,196,0,240,0,130,1,14,15,15,50,28,64,31,31,146,1,63,63,63,31,15,
    2,15,0,0,119,127,127,63,176,2,172,0,176,6,127,96,31,193,7,0,63,248,
    0,144,8,129,6,133,10,49,129,2,0,31,68,31,31,146,3,59,63,63,145,9,7,
    57,127,127,127,17,145,7,240,7,31,63,46,19,63,0,96,3,146,6,148,16,96,
    219,14,21,241,0,3,208,4,129,8,15,16,243,81,17,81,1,18,2,7,3,148,128,
    1,2,2,15,3,3,3,3,159,7,226,4,7,15,2,225,10,2,208,2,169,2,128,6,5,3,
    2,4,2,5,5,3,3,11,31,31,28,129,8,23,182,1,48,47,0,49,95,1,192,2,218,
    191,1,128,6,4,128,7,0,2,196,40,99,2,1,192,5,0,3,3,15,1,166,128,36,208,
    5,56,192,2,15,63,193,32,144,0,215,127,179,23,129,8,255,130,22,15,130,
    7,136,1,103,193,40,3,224,0,160,24,3,7,226,29,0,240,176,6,2,224,8,2,
    130,46,1,64,255,159,0,45,3,31,31,31,30,2,0,0,0,7,15,15,14,240,0,98,
    0,14,0,129,1,28,30,30,50,8,56,63,63,31,15,48,127,127,0,127,63,31,31,
    0,0,239,255,89,255,127,176,2,0,193,7,96,63,0,248,132,8,145,8,241,0,
    133,11,33,129,2,0,63,69,63,63,146,3,119,127,127,145,9,15,182,192,3,
    1,63,129,8,16,0,81,146,5,59,7,15,7,130,1,148,16,80,28,21,222,242,3,
    160,16,129,8,31,144,7,81,17,178,3,148,28,4,4,15,3,4,4,4,167,30,3,7,
    3,7,15,0,129,8,225,34,225,10,18,0,29,31,31,3,82,129,6,10,19,4,20,4,
    10,19,11,7,23,63,63,56,65,47,1,111,16,95,241,27,16,191,1,16,145,16,
    20,32,4,8,14,18,4,196,40,4,70,2,14,18,7,7,31,17,128,36,19,63,127,127,
    112,112,31,127,179,23,111,145,16,255,131,24,161,24,4,224,0,193,40,129,
    1,217,114,161,43,80,7,96,128,21,7,15,216,160,6,176,32,240,7,127,144,
    8,100,255,1,80,255,159,0,45,127,0,126,126,0,0,0,7,63,63,62,60,0,0,9,
    0,14,30,30,28,240,0,0,28,136,0,129,1,56,60,60,66,112,126,48,126,62,
    30,64,177,6,63,63,0,106,0,223,194,7,144,1,123,128,8,124,144,3,63,63,
    63,63,33,145,8,241,0,133,12,81,8,129,2,0,126,126,126,50,239,255,5,255,
    63,31,0,0,31,149,9,120,227,144,16,129,8,1,146,5,14,30,14,130,1,182,
    68,96,56,37,241,0,15,144,7,129,8,220,63,0,98,124,32,130,5,20,8,165,
    30,19,8,20,8,60,19,14,122,19,15,161,15,129,8,50,17,125,35,10,56,58,
    63,63,7,129,6,20,35,144,8,36,8,20,35,14,46,126,90,126,112,17,95,1,16,
    191,146,9,82,120,124,145,16,3,16,56,62,2,40,8,16,28,2,8,196,40,8,4,
    136,28,2,14,14,62,1,15,31,13,31,127,255,255,224,96,81,255,143,131,24,
    81,56,62,62,0,128,6,128,1,246,193,40,33,130,8,32,49,14,32,160,24,112,
    15,31,224,5,176,32,243,7,255,1,74,255,159,0,109,0,3,0,0,0,34,7,7,7,
    130,1,14,14,15,146,1,0,28,30,31,15,7,7,0,0,0,56,63,63,31,15,15,7,0,
    3,112,127,127,63,31,31,15,143,9,7,130,145,8,129,8,0,14,15,14,2,49,31,
    28,31,30,6,65,96,146,9,32,241,48,143,7,0,161,16,146,7,37,15,14,14,17,
    130,1,29,30,30,50,57,63,63,21,162,3,113,127,127,143,8,3,1,20,1,33,20,
    1,14,19,1,28,30,30,206,34,160,16,145,3,1,127,0,95,2,36,181,1,36,1,192,
    32,65,1,0,28,23,130,1,63,63,63,49,15,16,143,8,3,255,16,51,100,80,3,
    146,16,128,11,20,128,32,29,1,64,255,159,0,109,0,3,7,7,7,226,0,0,240,
    0,130,1,14,15,15,50,32,28,31,31,146,1,63,63,63,31,1,15,15,0,0,119,127,
    127,63,95,176,2,15,192,6,127,96,134,8,145,8,240,4,194,135,2,32,17,0,
    31,31,31,146,9,33,59,63,63,113,7,127,127,127,123,240,7,15,161,7,0,135,
    6,80,3,146,6,182,148,16,80,14,5,241,0,3,160,16,129,8,243,15,0,65,177,
    7,74,2,7,19,148,128,1,18,2,15,19,3,19,3,253,7,16,1,19,208,2,1,121,5,
    72,3,2,4,2,5,3,3,11,45,31,31,28,49,23,1,48,47,182,1,16,95,137,40,128,
    6,4,132,7,164,24,109,2,1,192,5,17,3,208,5,130,36,31,40,19,15,63,20,
    127,23,1,64,255,159,0,109,0,3,31,31,31,1,30,0,0,0,7,15,15,14,49,240,
    0,0,14,0,129,1,28,30,30,4,50,56,63,63,31,15,48,127,0,127,127,63,31,
    31,0,0,239,44,255,255,127,176,2,31,209,7,96,0,252,0,132,8,145,8,224,
    0,134,11,33,241,2,0,33,63,63,63,145,3,0,119,127,127,101,145,9,15,208,
    3,240,7,31,63,129,8,63,199,48,81,146,5,7,15,7,130,1,148,16,127,80,28,
    21,242,3,160,16,129,8,161,15,81,165,17,162,3,28,4,4,15,3,4,41,4,4,30,
    3,7,3,7,15,248,0,129,8,35,208,2,17,1,29,31,84,31,3,129,6,10,19,4,20,
    4,130,10,19,7,23,63,63,56,65,218,47,1,16,95,1,16,191,130,29,69,0,28,
    148,16,4,8,14,178,32,4,19,164,24,4,2,14,2,7,7,208,5,72,130,36,63,83,
    31,127,87,1,72,255,159,0,109,0,127,0,126,126,0,0,0,7,63,63,62,60,0,
    4,0,0,14,30,30,28,240,0,0,196,28,0,129,1,56,60,60,66,112,24,126,126,
    62,30,64,192,6,127,63,21,63,0,0,223,145,1,127,0,123,71,128,8,124,144,
    3,63,63,63,33,145,8,225,243,4,131,12,81,241,2,0,126,126,126,0,49,0,
    239,255,255,63,31,0,94,0,31,149,9,120,144,16,129,8,1,146,5,59,14,30,
    14,130,1,68,96,56,37,109,241,0,15,144,7,129,8,63,0,98,124,202,32,130,
    5,20,8,30,19,8,20,87,8,60,19,14,19,15,161,15,129,8,160,50,17,125,35,
    56,58,63,63,169,7,129,6,20,35,8,36,8,20,5,35,14,46,126,126,112,17,95,
    164,1,16,191,146,9,120,124,148,16,56,69,56,62,82,8,16,28,178,32,8,17,
    164,24,8,4,28,114,14,14,62,12,81,15,31,31,127,51,33,1,69,255,159,0,
    173,0,0,3,0,0,17,0,7,7,7,130,1,14,14,15,0,146,1,28,30,31,15,7,7,0,3,
    0,56,63,63,31,15,15,143,9,16,130,145,8,129,8,0,14,15,14,2,49,25,28,
    31,30,6,65,96,15,7,226,143,7,9,161,16,146,7,37,15,14,14,2,34,29,30,
    30,146,9,57,63,63,143,8,11,164,1,36,1,36,1,14,35,1,35,28,30,30,114,
    63,63,63,31,11,250,160,16,83,20,192,32,3,20,7,31,8,1,64,255,159,0,173,
    0,0,3,7,7,113,7,0,0,240,0,130,1,14,15,15,16,50,28,31,31,146,1,63,63,
    63,0,31,15,15,0,0,119,127,127,51,63,31,31,143,8,0,145,8,0,0,136,2,132,
    112,97,0,31,31,31,146,9,59,64,63,63,49,7,127,127,127,31,221,15,47,1,
    16,3,146,6,148,16,16,14,236,21,242,3,160,16,81,15,16,95,3,2,229,7,19,
    128,1,2,2,15,3,3,55,3,3,15,0,113,31,0,111,5,202,131,7,134,1,163,24,
    3,15,4,31,2,32,31,31,63,15,0,1,64,255,159,0,173,0,0,3,31,31,0,31,30,
    0,0,0,7,15,15,152,14,240,0,0,14,0,129,1,28,30,130,30,50,56,63,63,31,
    15,48,0,127,127,127,63,31,31,0,0,5,239,255,255,127,63,63,135,8,0,156,
    100,145,8,0,0,136,3,0,241,2,0,33,63,63,63,97,0,119,127,127,78,145,9,
    15,224,3,63,31,136,5,1,146,5,59,7,15,7,130,1,148,16,0,28,5,244,242,
    3,160,16,129,8,193,7,10,28,68,4,165,15,51,4,52,4,30,51,7,61,51,7,31,
    48,33,214,23,29,14,165,161,24,24,14,67,7,31,20,63,16,18,63,63,127,7,
    1,68,255,159,0,173,0,0,127,0,126,0,126,0,0,7,63,63,62,60,2,0,0,0,14,
    30,30,28,240,0,98,0,28,0,129,1,56,60,60,66,12,112,126,126,62,30,64,
    208,6,127,10,63,63,0,0,223,145,1,127,144,2,163,123,128,8,124,64,63,
    63,63,33,240,145,8,226,4,132,12,81,241,2,0,126,126,128,126,33,0,239,
    255,255,63,31,55,0,0,31,146,9,128,2,120,144,16,33,142,1,146,5,14,30,
    14,130,1,84,112,219,56,53,241,0,15,144,7,129,8,63,16,114,114,126,48,
    130,5,36,8,30,35,149,8,36,8,60,35,14,35,15,181,145,7,129,8,127,131,
    20,39,62,36,28,167,161,24,40,28,99,14,62,36,144,7,64,16,127,17,1,67,
    255,159,0,237,0,0,0,3,0,8,240,0,0,7,7,7,130,1,14,14,32,15,7,2,48,28,
    30,31,15,225,7,143,9,25,145,8,33,0,14,15,14,7,129,8,0,28,31,30,6,143,
    7,18,161,16,136,50,101,15,14,14,50,31,30,170,30,15,19,1,4,1,4,1,4,128,
    7,15,16,1,64,255,159,0,237,0,0,0,3,7,88,7,7,240,0,0,16,130,1,14,15,
    136,15,50,28,31,31,146,1,63,63,55,63,31,15,143,8,9,145,8,0,137,2,112,
    11,33,0,31,31,31,97,7,16,176,63,11,16,3,130,1,148,16,0,15,15,236,14,
    34,64,225,2,31,32,95,11,7,169,3,83,2,84,7,3,15,11,192,82,224,8,31,8,
    1,64,255,159,0,237,0,0,0,3,31,33,31,31,30,128,1,7,15,15,14,49,240,0,
    0,14,0,17,28,30,30,4,18,56,63,63,31,15,16,127,22,127,127,63,31,143,
    8,1,0,116,145,8,225,0,137,3,16,241,0,0,63,63,63,104,1,15,16,15,6,31,
    146,5,15,15,195,7,130,1,148,16,0,30,30,28,130,4,181,96,225,3,63,64,
    127,3,29,116,14,169,32,145,0,4,4,14,19,31,23,192,2,224,8,15,0,1,66,
    255,159,0,237,0,0,0,127,0,130,126,128,1,7,63,63,62,60,32,19,14,30,30,
    28,240,0,0,28,0,16,33,56,60,60,34,112,126,126,101,62,30,32,224,6,127,
    63,136,8,124,15,36,0,63,63,63,33,145,8,209,4,194,133,4,81,241,0,0,126,
    126,126,33,214,31,240,2,45,127,113,62,0,146,5,48,30,30,14,130,1,148,
    16,0,60,60,237,56,82,96,65,127,143,24,0,67,58,106,68,28,16,145,0,8,
    68,28,3,112,62,46,34,224,5,39,1,107,255,159,0,255,15,28,0,0,3,0,8,129,
    1,7,7,7,2,65,14,15,92,15,6,244,3,254,143,9,26,145,8,66,15,125,15,14,
    143,8,22,130,6,160,16,19,36,7,0,47,24,1,104,255,159,0,255,15,28,0,0,
    3,7,113,7,7,129,1,240,0,50,14,15,15,15,50,28,31,31,15,143,8,18,145,
    8,138,2,138,0,50,31,31,31,127,19,2,131,15,84,0,5,52,2,68,15,79,16,1,
    104,255,159,0,255,15,28,0,0,3,31,66,31,31,129,1,7,15,15,14,49,196,14,
    0,49,28,30,30,50,56,47,63,63,31,143,8,10,0,4,145,8,138,3,138,32,98,
    63,63,63,15,11,28,4,41,4,15,15,82,10,131,16,0,4,64,100,31,47,8,1,104,
    255,159,0,255,15,36,0,0,7,63,66,63,62,129,1,14,30,30,28,49,196,28,0,
    49,56,60,60,50,112,33,126,126,62,143,8,10,0,63,63,63,241,50,144,8,138,
    3,32,18,126,126,126,69,15,11,62,4,8,30,30,18,20,40,131,16,0,8,100,62,
    47,0
};

static MTB * mtb_KPK = NULL;

void initMTB_KPK()
{
    mtb_KPK = new MTB ("KPK", 1, 48);
    mtb_KPK->SetPackedData (mtbdata_KPK);
    mtb_KPK->Add (A2, WHITE, 137);
    mtb_KPK->Add (B2, WHITE, 160);
    mtb_KPK->Add (C2, WHITE, 177);
    mtb_KPK->Add (D2, WHITE, 173);
    mtb_KPK->Add (A3, WHITE, 140);
    mtb_KPK->Add (B3, WHITE, 166);
    mtb_KPK->Add (C3, WHITE, 193);
    mtb_KPK->Add (D3, WHITE, 204);
    mtb_KPK->Add (A4, WHITE, 104);
    mtb_KPK->Add (B4, WHITE, 130);
    mtb_KPK->Add (C4, WHITE, 161);
    mtb_KPK->Add (D4, WHITE, 174);
    mtb_KPK->Add (A5, WHITE, 76);
    mtb_KPK->Add (B5, WHITE, 89);
    mtb_KPK->Add (C5, WHITE, 112);
    mtb_KPK->Add (D5, WHITE, 124);
    mtb_KPK->Add (A6, WHITE, 49);
    mtb_KPK->Add (B6, WHITE, 53);
    mtb_KPK->Add (C6, WHITE, 66);
    mtb_KPK->Add (D6, WHITE, 68);
    mtb_KPK->Add (A7, WHITE, 29);
    mtb_KPK->Add (B7, WHITE, 27);
    mtb_KPK->Add (C7, WHITE, 27);
    mtb_KPK->Add (D7, WHITE, 27);
    mtb_KPK->Add (A2, BLACK, 204);
    mtb_KPK->Add (B2, BLACK, 237);
    mtb_KPK->Add (C2, BLACK, 239);
    mtb_KPK->Add (D2, BLACK, 249);
    mtb_KPK->Add (A3, BLACK, 207);
    mtb_KPK->Add (B3, BLACK, 244);
    mtb_KPK->Add (C3, BLACK, 249);
    mtb_KPK->Add (D3, BLACK, 251);
    mtb_KPK->Add (A4, BLACK, 164);
    mtb_KPK->Add (B4, BLACK, 181);
    mtb_KPK->Add (C4, BLACK, 211);
    mtb_KPK->Add (D4, BLACK, 216);
    mtb_KPK->Add (A5, BLACK, 118);
    mtb_KPK->Add (B5, BLACK, 135);
    mtb_KPK->Add (C5, BLACK, 152);
    mtb_KPK->Add (D5, BLACK, 174);
    mtb_KPK->Add (A6, BLACK, 79);
    mtb_KPK->Add (B6, BLACK, 92);
    mtb_KPK->Add (C6, BLACK, 113);
    mtb_KPK->Add (D6, BLACK, 123);
    mtb_KPK->Add (A7, BLACK, 51);
    mtb_KPK->Add (B7, BLACK, 56);
    mtb_KPK->Add (C7, BLACK, 69);
    mtb_KPK->Add (D7, BLACK, 72);
}

//////////////////////////////////////////////////////////////////////
//
// KQKQ

static const byte mtbdata_KQKQ[7580] = {
    1,68,85,159,0,157,81,85,80,224,0,68,0,84,69,81,65,69,69,21,69,85,85,
    65,131,2,85,32,68,35,90,31,130,4,85,85,69,84,34,80,160,2,15,8,69,81,
    69,69,16,192,1,176,5,15,152,0,5,85,20,0,128,3,2,129,6,58,143,16,1,1,
    81,129,10,164,0,128,2,5,129,12,223,85,20,80,21,130,14,145,16,3,144,
    12,63,18,85,85,3,144,22,0,129,20,162,10,244,139,16,0,49,134,10,128,
    28,1,148,15,69,195,85,160,11,157,0,89,85,80,17,177,3,251,208,16,133,
    18,208,17,194,19,128,6,130,2,17,20,253,128,32,130,24,131,4,129,12,63,
    1,16,128,14,69,187,209,2,69,4,131,42,131,16,128,18,16,130,30,191,132,
    4,111,1,4,129,36,160,5,192,28,130,14,129,6,111,128,8,65,130,48,128,
    2,65,132,52,162,0,143,16,1,253,83,128,54,132,24,128,8,129,34,129,2,
    130,10,64,187,137,4,131,36,68,128,1,129,60,95,3,16,131,54,255,160,16,
    192,48,133,8,129,66,160,18,143,16,2,130,28,128,4,255,210,27,136,14,
    133,2,131,68,211,71,130,66,133,64,177,2,247,128,18,130,24,161,1,180,
    4,45,64,133,72,177,40,255,143,16,1,132,20,129,56,133,14,135,48,133,
    2,136,4,129,54,254,132,92,98,4,129,72,6,130,80,161,18,157,0,1,88,85,
    159,0,13,81,143,2,77,143,16,15,84,84,0,85,80,0,1,85,64,84,65,0,81,65,
    69,65,21,81,85,84,20,85,84,1,85,22,65,17,5,16,85,85,68,85,24,21,85,
    85,30,80,84,69,85,18,128,8,176,0,128,6,108,81,81,160,2,51,80,48,16,
    81,112,69,69,160,12,208,3,152,0,65,84,4,1,0,21,0,21,85,68,84,69,97,
    240,3,69,160,9,11,65,84,80,1,200,240,7,128,4,133,18,80,5,161,8,80,85,
    17,69,81,65,5,129,12,80,21,86,144,128,2,128,14,85,69,80,1,17,80,136,
    84,16,84,64,81,32,21,69,8,21,1,68,80,80,18,84,65,48,65,65,69,225,33,
    141,16,84,0,85,195,0,241,2,3,65,84,64,1,160,2,88,192,24,81,128,22,81,
    129,14,139,6,85,80,72,17,80,128,32,64,85,241,25,65,21,27,17,84,80,68,
    1,128,28,85,144,2,96,129,18,17,3,128,22,85,81,21,1,207,85,128,4,33,
    84,65,129,36,143,16,2,130,14,142,177,47,51,80,4,85,128,46,129,2,48,
    141,5,128,18,16,84,4,244,1,130,32,88,206,180,58,243,0,129,6,80,68,161,
    1,160,16,129,22,14,84,80,16,84,17,163,21,160,0,129,10,119,65,84,130,
    4,130,40,143,16,2,4,129,60,242,2,124,0,97,129,8,128,14,193,24,176,44,
    65,64,99,85,16,192,66,147,20,21,65,81,128,36,110,240,8,64,193,7,50,
    88,226,11,225,17,193,0,6,65,80,80,16,80,16,129,30,162,18,31,21,81,80,
    80,177,31,130,2,49,143,16,1,52,130,14,68,84,242,7,113,64,160,2,85,162,
    17,226,70,84,128,32,80,0,84,208,13,229,68,128,50,160,12,128,78,80,1,
    129,36,80,139,194,9,128,28,68,64,4,129,8,64,209,4,48,129,14,85,88,226,
    31,165,18,65,68,80,159,64,160,24,85,0,128,50,227,22,142,16,112,244,
    129,90,208,67,240,83,80,96,84,176,30,81,203,81,129,23,34,0,84,128,1,
    69,128,32,87,130,64,1,129,38,68,128,50,65,129,2,129,54,106,96,80,96,
    162,18,20,80,16,130,78,240,81,225,13,128,18,209,94,6,1,93,85,159,0,
    29,69,143,2,61,143,16,32,160,0,1,2,129,1,84,85,84,84,84,81,162,2,5,
    5,21,85,68,85,21,81,81,128,129,4,240,1,85,80,84,20,85,81,32,68,80,21,
    18,84,21,85,64,42,84,16,81,240,5,17,18,80,16,12,85,80,81,80,68,129,
    8,159,0,12,68,34,85,68,0,129,1,81,85,16,192,10,194,80,130,14,105,4,
    81,64,5,0,0,69,16,17,4,65,1,1,0,16,1,68,84,0,161,12,85,68,69,9,20,21,
    4,84,5,128,4,0,84,0,161,16,0,17,64,16,16,16,4,8,16,4,84,0,80,97,0,68,
    0,0,65,64,64,16,64,68,80,32,8,84,5,64,5,5,21,21,32,69,84,5,142,18,68,
    84,1,1,213,69,80,144,8,1,240,7,16,16,84,241,129,32,192,29,208,0,99,
    90,4,64,68,0,17,0,21,64,68,16,4,4,24,4,68,16,0,224,15,128,3,85,4,0,
    21,68,84,20,81,4,65,0,48,68,5,80,128,4,164,16,4,1,64,97,0,5,160,0,112,
    0,17,0,65,129,194,29,138,10,16,0,4,5,1,85,0,22,68,84,65,84,69,4,85,
    192,65,128,2,48,69,81,68,85,4,44,65,5,17,161,5,80,0,143,18,1,16,20,
    64,16,5,17,65,0,194,32,68,176,64,16,68,129,29,160,18,84,4,81,44,6,84,
    2,128,28,21,38,142,16,64,6,0,16,5,4,21,1,240,42,2,3,68,80,64,84,69,
    16,69,176,37,128,193,32,224,33,85,1,1,5,65,21,66,17,66,128,2,64,5,16,
    17,128,18,56,4,5,4,192,1,164,18,14,64,64,4,64,5,65,5,68,0,84,6,22,16,
    10,4,37,160,16,17,84,142,16,70,0,0,240,10,21,4,17,84,114,234,64,128,
    31,209,74,128,30,4,192,62,5,16,56,16,17,64,18,128,54,32,21,4,49,66,
    68,0,226,48,128,18,16,5,16,193,65,208,0,79,1,6,64,10,16,37,97,160,44,
    65,164,16,47,1,0,5,64,21,192,176,71,19,34,0,69,65,69,21,82,68,21,208,
    42,85,36,1,4,20,111,4,4,128,54,160,0,16,128,65,1,128,18,14,112,21,16,
    66,16,144,12,144,6,80,104,64,5,208,35,17,80,128,2,1,64,85,159,0,162,
    1,85,85,81,85,4,81,84,81,81,81,69,130,2,5,53,85,85,21,161,2,16,21,240,
    1,21,13,208,0,17,85,85,84,32,19,84,236,131,6,144,4,128,5,48,80,129,
    4,129,8,85,3,69,20,85,5,0,5,0,53,134,132,10,152,0,21,85,84,80,240,7,
    79,9,239,64,130,1,128,14,130,16,85,100,66,82,226,37,66,136,6,133,22,
    1,64,21,0,5,21,81,81,68,81,17,130,8,80,99,129,2,85,209,14,130,12,80,
    65,85,113,142,208,7,161,0,85,85,68,132,32,128,28,143,18,4,207,68,83,
    128,14,85,85,114,1,20,221,130,16,7,81,65,17,225,13,132,10,64,142,3,
    38,80,5,21,0,145,15,131,4,24,66,85,85,4,163,28,193,0,21,85,61,4,81,
    21,209,31,130,12,81,142,18,17,253,116,49,128,1,128,16,176,24,130,2,
    130,36,65,111,130,14,21,242,9,113,72,83,161,9,192,0,56,128,16,85,21,
    2,209,38,130,20,84,85,192,16,228,15,0,21,85,2,81,21,207,65,229,17,129,
    18,68,68,129,6,130,50,128,12,95,47,1,69,48,84,133,54,128,16,130,14,
    128,2,225,225,18,17,39,114,16,64,21,16,120,112,81,133,4,80,178,56,162,
    14,69,21,51,21,0,81,131,8,132,2,85,66,34,189,195,53,130,18,17,80,130,
    46,195,6,29,65,198,130,14,130,70,208,16,69,84,8,96,224,6,33,69,69,17,
    131,32,16,0,21,64,255,129,22,192,25,210,22,128,16,128,38,131,64,129,
    4,115,245,130,96,21,130,32,18,128,2,66,50,65,48,38,68,69,128,10,134,
    82,1,88,85,159,0,29,69,143,2,61,143,16,34,84,1,0,85,85,64,84,65,81,
    65,69,64,65,21,193,2,84,5,85,85,68,225,85,19,130,4,224,2,80,84,69,85,
    97,18,84,16,192,0,64,84,81,81,176,160,2,3,80,0,128,6,81,69,69,0,85,
    68,84,4,0,21,0,85,116,85,81,136,10,159,0,26,128,15,5,176,10,85,32,80,
    85,69,130,8,68,84,65,21,200,86,48,128,14,85,69,49,85,65,203,84,50,65,
    85,69,129,4,80,3,69,65,81,128,16,81,0,84,48,69,212,128,20,63,2,128,
    6,1,1,84,0,81,89,69,81,129,8,4,129,32,128,14,85,65,182,160,0,127,1,
    68,49,64,85,128,28,97,214,17,51,0,85,128,8,85,128,4,49,129,84,224,7,
    69,65,85,68,86,64,252,130,16,160,16,128,12,31,3,130,14,144,0,21,16,
    96,84,4,244,1,128,6,70,85,73,65,115,84,17,129,2,224,11,239,59,1,68,
    80,16,199,132,4,160,0,129,8,65,84,68,34,129,30,177,134,28,129,51,69,
    128,12,13,100,84,97,227,130,14,193,24,176,20,97,64,84,16,129,32,182,
    160,16,129,28,85,32,240,32,64,161,10,128,4,29,70,84,73,4,129,6,130,
    2,143,36,2,68,241,96,33,128,10,17,133,28,81,84,69,81,224,20,69,143,
    16,1,96,130,14,81,85,85,158,225,24,49,0,84,208,11,128,55,176,2,130,
    42,254,1,131,50,193,13,130,28,99,209,12,128,2,128,18,251,16,129,8,49,
    161,14,143,44,1,130,28,65,129,84,222,223,99,1,128,16,130,14,80,33,128,
    4,18,128,38,245,65,128,92,144,90,129,80,82,68,128,50,65,158,67,34,80,
    68,227,31,130,12,33,130,64,92,85,85,128,18,64,129,10,33,129,2,1,64,
    85,159,0,173,69,5,64,85,80,1,5,16,17,4,65,1,1,0,32,160,0,69,21,128,
    2,21,64,68,16,0,4,4,4,1,4,0,4,69,0,85,106,85,80,85,0,17,64,0,16,16,
    16,4,16,1,16,69,128,81,32,81,0,68,0,65,64,0,64,16,64,4,64,21,1,64,0,
    1,85,85,5,0,17,0,65,1,0,1,1,1,4,85,85,81,0,155,12,1,80,1,84,85,84,0,
    68,17,1,240,7,16,16,64,142,16,17,8,64,5,84,85,64,166,16,69,69,13,64,
    21,84,85,0,118,128,4,85,234,32,144,8,3,16,81,32,80,5,238,69,129,12,
    72,142,16,5,83,21,129,14,128,80,96,80,1,68,4,65,16,128,64,142,18,101,
    5,64,69,80,21,204,85,22,128,6,17,80,128,3,5,69,232,65,128,4,176,12,
    5,69,128,32,80,1,103,5,0,5,142,16,17,80,1,128,3,153,3,128,8,17,84,8,
    80,65,80,113,192,18,85,196,32,142,18,129,16,17,0,84,135,69,80,65,80,
    69,0,176,18,67,156,128,56,48,17,0,69,30,224,11,80,102,5,17,38,131,14,
    68,4,37,129,24,48,84,65,16,38,128,10,5,80,5,59,64,68,0,196,32,142,18,
    129,16,65,160,15,188,20,131,42,65,96,115,143,64,1,128,14,16,199,4,37,
    130,38,65,65,16,37,131,40,195,144,33,36,129,16,84,5,16,4,37,248,130,
    48,128,31,144,12,194,32,142,72,128,42,80,5,206,1,70,143,80,2,80,65,
    177,71,51,131,14,124,64,64,53,131,2,144,87,4,131,32,4,207,4,5,129,16,
    84,17,32,4,130,48,192,128,63,176,61,194,32,1,88,85,159,0,29,69,143,
    2,61,143,16,31,1,80,0,85,80,1,84,5,1,16,0,72,64,0,0,69,5,16,5,80,9,
    17,0,65,0,1,161,0,5,21,0,16,21,80,69,16,4,4,4,4,1,4,0,4,5,84,16,85,
    0,80,17,64,16,16,16,4,16,16,1,16,5,80,224,1,81,80,69,0,0,65,64,64,16,
    64,4,64,1,4,0,0,1,85,169,85,1,2,146,8,1,1,4,85,85,81,138,14,100,5,1,
    224,13,80,17,1,240,7,16,68,16,64,141,18,4,17,64,162,16,16,17,17,4,65,
    1,128,16,69,68,64,50,114,64,68,19,128,4,85,90,16,132,0,20,4,68,64,81,
    128,2,81,77,0,68,19,69,0,129,12,128,13,0,201,35,142,16,132,4,84,0,35,
    4,16,128,128,14,128,2,80,1,68,4,65,16,0,64,64,69,85,64,17,80,5,0,85,
    85,64,85,81,81,69,69,0,65,21,4,4,64,69,80,21,38,85,85,0,36,69,16,64,
    128,9,217,0,144,8,2,65,16,176,12,0,80,22,3,4,1,64,160,28,85,70,142,
    16,193,16,224,43,24,4,64,64,17,84,152,24,128,8,65,80,19,194,32,69,84,
    16,96,5,80,69,193,8,64,85,65,44,69,81,21,128,22,17,128,4,70,69,200,
    64,128,6,72,4,8,129,16,81,1,232,5,160,15,65,126,64,225,11,81,1,206,
    84,160,3,17,132,0,129,14,23,129,24,173,84,160,2,64,85,4,128,36,32,0,
    16,196,32,69,80,96,128,16,81,85,64,165,84,162,18,21,0,65,80,32,0,222,
    176,18,17,131,42,81,128,64,19,143,48,1,130,28,192,17,20,128,16,1,80,
    65,81,17,99,68,4,19,131,40,84,65,16,20,141,33,224,19,5,64,68,19,132,
    32,17,130,176,27,0,0,84,69,68,96,96,251,81,160,1,208,0,160,18,129,42,
    129,28,65,144,4,206,225,15,143,64,2,161,16,16,4,83,130,16,160,2,103,
    65,16,83,115,81,1,176,49,18,13,131,32,84,5,16,4,19,33,84,53,32,64,16,
    19,84,65,176,61,68,0,193,32,1,40,81,85,159,0,109,84,192,0,0,85,0,85,
    69,84,69,81,69,69,69,129,21,255,7,34,84,5,85,85,68,85,195,131,8,130,
    2,224,8,84,84,69,85,66,134,144,2,17,68,84,85,81,160,2,67,224,80,131,
    6,144,4,142,10,80,84,21,0,161,21,128,18,68,111,5,84,84,81,65,143,240,
    7,143,4,9,1,85,86,18,192,26,98,221,132,2,129,14,129,16,68,21,129,8,
    145,6,17,100,131,32,80,128,20,130,22,5,0,129,2,85,33,68,69,17,130,12,
    84,1,65,84,192,96,192,22,80,85,17,84,84,65,152,5,176,12,85,84,208,7,
    161,0,84,85,225,17,132,32,131,8,142,18,80,1,17,86,92,98,65,16,85,3,
    17,131,36,85,59,85,86,129,130,16,160,16,144,4,65,97,199,129,14,241,
    66,131,10,84,1,5,176,6,145,0,216,17,128,4,192,4,4,130,2,130,20,86,85,
    112,9,81,177,24,128,8,194,0,84,84,17,120,68,84,208,17,193,1,240,11,
    143,18,0,68,1,159,69,132,4,81,65,129,16,209,25,130,64,129,38,112,129,
    12,5,130,28,145,26,144,2,21,85,68,138,33,129,14,21,84,20,128,2,5,130,
    16,56,64,85,16,128,53,176,7,144,20,21,84,8,69,1,81,84,65,245,5,85,21,
    22,86,84,9,68,129,20,64,163,16,129,18,127,17,84,128,6,130,50,128,48,
    159,72,0,208,13,129,14,156,112,130,52,84,5,130,28,128,6,225,26,21,0,
    85,80,33,64,84,16,84,4,64,81,65,130,2,17,20,84,64,0,2,84,64,85,81,68,
    68,81,16,173,81,129,42,81,129,8,84,131,32,64,1,246,131,16,128,44,17,
    128,18,115,85,208,20,35,252,69,96,130,64,194,38,49,128,6,128,32,81,
    242,69,128,57,16,128,14,241,63,69,17,241,3,32,17,0,32,96,84,16,16,4,
    68,17,1,130,65,84,65,0,129,52,65,62,84,69,21,145,58,130,32,176,8,131,
    64,130,80,188,68,129,10,80,129,60,116,83,50,85,44,86,68,9,130,16,4,
    224,3,161,18,1,40,81,85,159,0,44,21,143,2,45,17,81,0,81,85,81,1,85,
    85,81,81,26,21,69,21,21,237,3,15,16,17,192,0,0,80,5,84,85,1,81,4,69,
    17,5,21,5,85,129,26,80,21,84,192,128,3,19,130,4,85,84,85,65,81,100,
    20,85,18,144,4,80,81,129,6,68,24,69,21,85,5,224,3,171,32,17,81,3,17,
    0,85,0,85,85,69,132,10,8,143,18,31,68,4,21,80,160,16,64,68,0,16,4,4,
    4,1,4,17,17,32,4,85,90,0,0,17,64,16,20,16,16,4,16,128,4,81,128,2,81,
    1,0,68,0,65,64,64,16,64,168,128,14,130,32,21,80,85,80,17,1,116,68,1,
    50,144,4,240,7,4,142,12,81,50,4,85,80,128,4,192,24,69,81,160,13,8,17,
    65,4,17,80,240,20,64,5,13,16,17,4,65,1,160,3,140,6,16,153,64,128,1,
    0,84,163,16,16,69,80,35,176,30,0,80,67,17,81,69,130,16,0,160,14,65,
    17,5,81,21,17,8,115,0,1,128,12,70,142,10,64,5,128,14,6,50,1,68,4,65,
    16,130,18,162,12,0,80,69,16,21,20,85,25,4,11,36,5,80,69,80,144,57,0,
    194,32,49,143,8,0,4,65,128,4,102,17,89,1,32,128,16,81,85,176,25,85,
    21,5,17,199,21,128,22,224,11,84,1,21,192,48,81,1,141,8,145,0,128,65,
    81,17,84,1,54,17,1,5,1,80,65,80,226,240,18,195,32,128,63,128,66,80,
    85,16,192,5,132,16,208,10,25,16,36,17,128,20,17,120,0,84,115,143,42,
    0,192,70,128,16,17,80,88,21,65,160,14,21,64,128,28,84,1,118,68,0,163,
    16,15,1,128,14,81,240,56,67,44,17,1,4,128,54,84,144,33,3,17,39,4,5,
    5,80,5,64,144,8,193,32,32,133,36,16,81,162,18,85,25,64,36,178,65,128,
    22,65,176,27,160,30,0,80,66,136,5,192,96,80,17,65,241,77,17,0,142,0,
    224,25,84,5,4,164,16,79,3,0,110,65,16,3,17,80,0,177,49,1,0,17,4,4,5,
    81,5,84,5,76,16,4,3,17,16,128,54,160,0,64,106,16,0,194,32,130,18,65,
    66,69,161,18,1,32,81,85,159,0,108,21,84,65,165,0,65,5,17,0,65,0,1,1,
    16,1,4,1,16,143,10,46,16,21,0,0,85,64,21,64,68,16,4,4,2,4,1,4,0,4,16,
    85,128,2,0,85,0,17,64,16,16,16,4,4,16,1,16,16,85,170,33,68,0,0,65,64,
    64,16,64,4,64,67,85,85,171,32,80,4,0,5,224,18,164,144,4,240,7,4,112,
    85,69,138,4,84,0,5,64,5,81,85,80,1,68,2,4,65,16,64,64,64,0,142,16,7,
    69,0,21,81,85,0,166,16,129,18,118,128,2,84,53,16,81,80,53,192,1,75,
    5,65,160,14,5,0,195,32,20,129,12,131,24,141,16,85,85,64,5,80,128,4,
    160,21,129,14,64,128,2,64,5,16,17,19,4,65,1,1,141,18,144,21,0,218,128,
    1,21,128,6,69,50,116,21,160,7,49,81,5,5,128,25,35,16,5,0,233,32,208,
    22,36,142,32,69,224,43,5,80,131,128,3,3,17,85,0,69,80,8,248,130,8,192,
    18,160,12,194,32,142,18,129,16,69,0,231,80,69,96,128,32,17,0,69,128,
    38,48,48,68,0,69,143,48,1,69,65,21,102,68,4,37,131,14,16,17,37,129,
    10,58,80,5,64,144,8,36,129,32,21,144,11,238,84,195,32,141,18,131,16,
    65,144,4,19,131,42,118,4,1,5,143,64,2,0,16,5,97,115,65,5,145,33,4,130,
    40,16,4,5,90,128,12,21,128,36,16,5,130,48,69,144,45,195,68,195,32,129,
    4,65,5,1,1,37,241,128,8,160,44,177,71,35,143,16,3,5,64,64,246,37,131,
    14,176,103,4,132,18,4,5,131,32,108,16,16,5,130,54,69,144,87,52,1,64,
    85,159,0,29,81,85,84,1,64,4,5,1,16,0,64,0,2,81,0,85,68,5,64,17,0,65,
    0,192,1,163,0,128,2,21,64,69,16,4,12,4,4,1,4,0,32,48,85,1,64,17,64,
    16,16,16,4,16,64,224,6,16,48,81,64,69,0,65,1,64,64,16,64,4,64,1,64,
    144,143,16,30,29,65,5,128,12,5,16,17,36,4,65,1,2,65,21,80,21,64,64,
    68,165,16,65,85,100,85,64,72,85,0,86,65,81,64,81,0,192,68,85,143,14,
    32,84,1,80,85,80,0,1,68,4,65,16,64,64,64,4,0,65,17,68,5,80,8,65,6,69,
    68,21,80,85,0,6,128,4,181,85,112,84,5,64,81,80,80,32,37,65,1,128,42,
    1,85,85,5,254,0,210,40,160,1,193,44,136,46,129,14,224,2,144,8,160,1,
    240,7,16,142,18,65,84,17,64,64,5,85,166,16,97,5,68,69,64,108,21,85,
    70,128,16,17,209,28,69,65,226,65,128,4,144,12,5,65,1,68,128,12,96,5,
    0,5,110,17,84,5,80,127,1,84,128,3,3,128,8,128,14,161,18,195,32,104,
    143,36,1,5,128,60,6,97,129,16,17,0,215,84,117,128,8,65,128,4,80,21,
    128,56,56,128,32,17,0,21,14,128,28,80,5,193,17,70,128,22,65,64,17,68,
    4,141,38,128,24,64,65,16,198,32,142,18,17,107,128,36,17,144,11,36,97,
    129,16,65,160,15,142,36,129,56,64,1,65,144,4,35,62,3,1,84,65,80,17,
    16,4,5,62,131,14,65,16,5,130,2,240,60,5,128,26,143,5,128,17,4,64,68,
    195,32,143,54,1,129,16,177,118,131,42,1,86,79,1,1,80,65,251,177,71,
    83,131,14,128,55,36,131,2,1,38,48,3,4,4,37,130,64,17,16,16,96,64,16,
    195,32,157,0,1,64,85,159,0,29,65,85,84,1,64,4,5,81,17,0,64,0,2,65,0,
    85,68,5,80,17,84,65,1,96,1,0,162,0,128,2,21,64,69,80,6,5,8,4,2,4,0,
    32,48,0,85,64,17,80,17,16,16,4,10,16,1,16,0,16,48,81,128,4,0,65,64,
    64,16,64,4,64,1,192,64,143,16,30,31,126,1,17,68,5,64,4,85,80,5,16,17,
    4,194,32,65,128,68,128,32,85,80,21,64,68,16,8,4,4,4,1,4,112,85,106,
    2,85,80,85,0,17,64,16,34,33,68,68,81,96,81,0,68,0,32,34,65,0,128,42,
    1,85,85,5,4,0,17,0,65,0,1,160,1,85,104,85,81,137,12,64,80,224,2,84,
    0,80,17,1,240,7,16,142,16,65,68,17,8,64,5,85,85,64,164,16,1,4,2,68,
    69,64,21,85,85,0,116,110,65,16,48,128,5,0,144,8,1,128,6,72,69,64,144,
    12,0,80,3,1,1,224,68,129,12,70,142,16,16,84,5,80,76,1,84,22,1,64,129,
    14,161,18,80,97,1,68,224,11,141,18,9,4,100,5,164,128,60,22,1,33,17,
    80,22,65,49,64,68,65,128,4,22,1,8,68,28,128,32,81,1,5,160,15,17,46,
    64,3,84,17,80,5,81,1,84,160,3,46,1,129,0,128,8,17,193,18,3,129,24,50,
    64,65,80,198,32,142,18,16,100,129,16,52,17,0,84,51,112,65,128,6,69,
    233,0,176,18,49,128,20,5,33,17,0,199,51,143,48,1,224,11,80,5,17,36,
    16,12,128,14,81,17,68,4,35,18,1,52,84,65,16,4,48,5,128,36,5,50,64,68,
    0,194,32,142,18,64,100,17,227,65,192,31,34,131,42,81,1,65,0,207,227,
    15,143,64,1,16,16,4,19,130,16,160,2,206,128,59,98,3,81,1,176,49,50,
    3,31,84,5,16,4,51,132,48,160,47,144,12,128,192,32,157,0,1,64,85,159,
    0,29,64,85,68,1,64,3,5,81,17,80,65,128,0,161,0,0,128,2,5,80,17,84,65,
    81,1,128,0,18,64,85,4,21,64,69,3,80,5,84,5,1,4,0,16,8,32,84,64,17,80,
    16,8,16,20,2,16,0,16,32,80,128,4,65,6,80,65,16,64,4,64,240,5,159,0,
    31,192,69,95,61,143,32,29,4,68,1,80,85,64,80,1,128,28,16,0,64,0,0,73,
    0,17,64,85,80,192,32,0,65,16,66,68,4,21,48,21,80,69,17,16,4,4,4,112,
    17,4,84,0,16,85,80,17,64,16,16,16,4,4,16,0,68,4,80,224,1,81,0,80,69,
    0,65,64,64,16,64,129,64,208,36,64,1,85,169,85,1,84,146,8,1,193,12,81,
    136,14,0,208,8,80,2,1,85,1,84,1,17,1,240,7,130,16,141,18,0,65,4,17,
    64,162,16,0,16,17,4,65,1,1,0,4,36,68,68,64,66,64,68,65,64,150,16,128,
    4,85,90,64,0,2,128,6,34,68,64,81,128,2,81,0,68,1,16,0,1,68,0,129,12,
    85,85,5,249,0,1,142,16,128,20,224,29,128,4,84,0,12,65,0,64,4,16,128,
    14,128,2,80,0,1,68,4,65,16,0,1,4,186,65,128,60,5,160,35,50,128,22,4,
    96,195,21,160,7,2,0,16,68,16,128,4,228,161,9,144,8,145,30,128,6,69,
    80,176,12,0,199,80,65,129,28,64,1,81,54,142,16,24,128,14,80,5,81,54,
    128,18,64,64,99,17,84,6,96,1,64,65,128,76,139,4,49,96,5,80,6,0,208,
    38,134,130,80,36,0,64,68,64,128,6,39,35,32,4,8,97,81,1,5,192,15,186,
    193,0,142,32,64,225,11,32,192,3,84,160,94,12,132,0,64,65,81,38,130,
    16,1,180,84,32,64,34,130,32,5,128,66,69,211,0,2,97,96,130,96,0,84,2,
    222,224,94,64,48,0,176,18,16,130,42,1,118,17,0,227,15,143,48,1,130,
    28,17,18,82,124,1,80,16,144,73,16,35,224,19,65,238,16,18,35,112,5,192,
    31,1,133,32,235,17,48,1,16,96,1,65,48,0,64,1,0,1,85,17,84,17,0,85,0,
    0,85,1,1,4,1,16,1,64,64,85,159,0,29,1,85,16,5,16,6,17,84,65,85,1,0,
    162,0,128,2,0,21,64,68,84,4,84,4,2,96,4,0,16,32,84,0,17,84,0,16,84,
    16,4,16,1,16,0,128,16,32,80,0,68,84,65,84,11,64,16,64,4,64,129,14,81,
    191,14,30,67,12,21,47,43,1,80,17,84,240,0,72,160,32,65,208,23,1,4,143,
    32,31,17,16,0,5,85,85,84,5,84,17,4,72,65,1,81,68,16,144,12,84,21,4,
    84,68,16,4,4,4,192,42,17,128,16,128,12,84,84,84,17,64,16,136,16,193,
    32,68,16,80,128,2,80,84,26,68,0,65,64,32,141,10,0,208,36,149,21,129,
    50,0,68,208,39,4,142,18,1,0,208,8,80,1,84,85,84,1,68,16,4,65,16,64,
    142,8,1,4,16,20,68,0,21,86,160,16,64,67,16,28,16,17,0,84,128,2,224,
    48,65,1,185,65,128,4,80,96,112,1,1,81,9,132,64,85,5,0,17,193,32,0,16,
    177,240,54,33,21,66,129,14,1,1,84,176,0,144,8,1,192,1,208,8,64,4,84,
    27,1,85,85,80,18,144,4,65,128,64,72,192,32,64,128,65,4,65,143,22,1,
    16,0,88,17,86,32,0,114,128,8,65,0,80,68,86,32,0,98,1,88,17,119,86,129,
    130,30,19,129,14,4,65,20,24,65,0,4,85,22,128,20,64,65,192,16,128,76,
    4,1,1,18,1,8,113,65,84,6,128,32,160,0,84,68,84,115,224,48,0,192,32,
    142,18,192,46,0,65,128,4,237,68,129,64,208,86,128,14,5,66,113,4,119,
    224,11,84,225,48,0,17,32,16,5,222,129,36,224,46,160,2,80,66,128,32,
    192,0,128,90,65,17,64,50,1,4,18,4,8,239,224,95,128,60,50,65,16,0,208,
    44,194,32,221,142,18,129,16,224,11,85,192,31,161,16,129,14,4,196,130,
    28,144,8,131,2,0,32,64,128,8,4,203,17,50,130,16,0,84,16,68,18,61,33,
    0,1,224,19,224,48,17,129,32,1,32,33,4,64,2,1,16,18,16,240,8,33,112,
    225,15,17,16,64,84,80,64,84,80,0,192,32,1,1,1,85,17,80,17,1,81,1,160,
    0,1,8,1,32,1,128,85,0,159,0,29,1,85,16,5,16,17,84,24,65,81,1,0,2,128,
    2,21,64,1,69,80,5,84,5,1,4,0,144,0,48,84,0,176,12,80,17,8,8,16,2,16,
    0,16,48,80,0,0,69,80,65,80,65,16,64,4,6,64,1,64,85,85,81,191,14,30,
    28,134,21,63,43,1,64,17,80,160,16,128,32,144,65,208,23,1,4,239,15,30,
    0,17,16,1,5,81,85,80,5,80,17,0,136,144,8,160,0,68,16,21,32,21,80,8,
    69,16,4,4,4,192,32,17,16,128,84,16,85,80,17,64,16,16,48,16,4,16,128,
    4,128,14,80,81,80,6,69,0,65,64,64,16,128,32,171,32,4,0,1,16,0,17,1,
    240,42,1,160,68,208,39,4,143,18,32,4,16,68,0,136,21,80,21,64,68,161,
    16,0,16,10,16,17,0,85,90,64,0,66,81,0,65,128,4,81,128,2,81,0,68,49,
    65,1,65,129,64,48,85,5,0,151,177,24,128,8,1,64,2,21,144,4,240,55,136,
    141,12,128,38,0,5,80,128,3,80,1,20,68,4,65,16,128,22,65,128,60,5,38,
    85,85,64,128,65,4,65,142,6,193,14,97,17,80,161,1,96,64,16,0,64,72,112,
    69,177,46,0,80,161,16,1,68,48,17,81,65,224,47,85,0,32,16,24,8,0,1,84,
    86,142,10,0,16,16,64,1,17,84,6,0,65,17,48,81,0,65,128,76,4,2,4,24,5,
    4,32,5,80,69,80,240,60,0,152,192,32,143,24,0,16,64,128,6,38,1,96,41,
    17,88,1,130,96,5,192,13,5,0,11,128,4,16,0,5,84,16,21,128,2,128,193,
    0,155,0,128,0,144,0,128,65,234,81,22,128,32,240,70,84,16,64,18,26,0,
    68,17,84,128,36,16,0,18,9,2,16,24,16,32,130,96,0,84,201,193,32,142,
    104,128,42,1,5,129,16,17,0,174,1,129,28,0,224,11,84,128,64,239,15,0,
    84,77,1,80,96,68,4,65,49,0,25,224,7,84,65,16,66,128,56,4,1,31,224,111,
    80,5,64,144,8,193,28,128,54,99,4,2,2,64,24,64,32,32,80,192,65,208,43,
    240,50,1,0,65,85,17,5,1,5,65,0,0,1,1,1,4,1,16,1,64,64,85,159,0,29,65,
    85,80,5,0,8,21,5,64,1,0,3,65,85,3,16,21,0,69,1,4,0,164,0,0,128,2,85,
    0,21,65,16,16,16,4,4,16,1,16,0,16,50,69,1,1,65,64,64,16,64,4,64,100,
    129,14,81,191,14,30,15,11,0,21,81,64,12,68,16,4,4,4,226,16,1,85,36,
    0,17,64,165,16,85,144,65,68,128,0,53,5,17,5,65,85,5,52,0,17,0,195,32,
    15,32,80,128,8,64,0,5,16,17,4,65,1,1,0,7,1,0,69,16,21,65,57,128,18,
    119,64,84,21,128,4,49,80,21,193,8,17,169,32,0,5,80,128,50,85,85,21,
    218,144,4,240,7,130,18,69,137,46,128,14,64,128,4,3,80,1,68,4,65,16,
    64,142,54,25,128,8,69,0,21,129,19,163,16,128,21,236,128,50,129,3,68,
    128,16,69,130,2,68,1,88,5,81,128,14,5,176,2,195,32,0,5,240,16,128,12,
    177,6,35,141,16,64,69,81,25,21,64,5,81,128,3,3,1,5,240,128,10,160,2,
    160,3,194,32,143,36,1,21,0,21,81,0,84,53,128,129,16,69,0,80,140,21,
    130,48,5,17,0,21,128,38,5,60,0,5,68,176,6,19,46,128,28,65,22,21,69,
    4,80,4,0,128,8,192,26,238,17,5,128,18,64,64,144,8,195,32,126,179,69,
    128,36,69,144,11,100,1,21,131,96,134,101,129,56,0,5,4,1,5,143,16,1,
    6,5,64,69,65,16,68,4,129,38,113,1,5,144,33,4,130,18,5,16,4,71,37,1,
    129,48,21,64,16,144,12,194,32,0,13,1,69,17,21,1,5,1,252,1,21,192,7,
    128,42,177,71,99,143,16,3,5,110,65,64,37,49,0,128,8,37,132,18,165,4,
    39,17,48,16,16,21,1,48,130,48,64,64,176,61,194,32,1,0,1,85,17,85,1,
    5,65,0,5,1,1,1,4,1,16,1,64,64,85,159,0,29,1,85,80,5,0,8,21,68,69,1,
    0,3,1,85,0,16,21,64,69,80,5,4,4,48,1,4,0,160,0,128,2,85,0,21,0,64,21,
    32,16,8,16,2,16,64,0,16,50,69,64,69,64,64,22,16,64,4,64,129,14,81,191,
    14,30,15,59,0,1,0,17,85,65,165,69,5,24,17,0,65,0,193,32,143,10,46,0,
    68,0,16,21,0,85,64,21,64,68,80,16,4,2,17,128,30,85,64,85,1,0,17,64,
    16,16,16,4,16,35,128,4,85,170,129,2,68,0,65,1,128,193,6,169,32,0,1,
    80,5,1,5,58,85,85,21,144,4,240,7,130,18,69,138,22,32,80,5,64,128,4,
    80,1,68,4,32,65,16,64,142,54,0,4,16,69,102,0,21,128,1,164,16,0,16,49,
    128,2,154,84,3,0,65,80,33,80,3,41,1,1,81,128,64,69,160,10,5,0,240,193,
    32,128,8,129,12,102,141,16,0,64,81,19,85,64,5,80,70,1,0,129,14,2,161,
    18,64,5,16,17,4,65,141,18,25,32,16,144,21,128,4,70,0,64,100,128,6,69,
    130,2,50,1,4,128,48,5,48,81,5,5,208,18,49,0,32,16,14,5,0,5,68,5,209,
    22,17,142,16,1,0,80,69,65,21,68,5,80,138,160,19,17,0,2,17,128,74,80,
    22,140,1,128,24,0,5,64,198,32,142,18,64,137,144,65,69,0,80,3,1,32,52,
    131,96,17,0,3,128,20,21,65,68,244,0,83,31,1,224,11,32,4,35,0,66,2,16,
    128,54,68,69,16,17,35,173,0,128,26,0,128,36,64,144,8,1,1,218,129,48,
    128,96,176,27,84,193,32,142,80,64,131,16,208,65,144,4,65,0,130,42,68,
    5,4,237,1,67,47,3,65,16,3,33,0,241,128,8,176,49,2,129,56,128,18,5,16,
    4,85,4,16,112,21,128,36,16,3,1,80,131,48,69,176,61,68,193,32
};

static MTB * mtb_KQKQ = NULL;

void initMTB_KQKQ()
{
    mtb_KQKQ = new MTB ("KQKQ", 2, 17);
    mtb_KQKQ->SetPackedData (mtbdata_KQKQ);
    mtb_KQKQ->Add (C2, A1, WHITE, 317);
    mtb_KQKQ->Add (C3, A1, WHITE, 502);
    mtb_KQKQ->Add (A3, B1, WHITE, 515);
    mtb_KQKQ->Add (B3, B1, WHITE, 376);
    mtb_KQKQ->Add (C3, B1, WHITE, 409);
    mtb_KQKQ->Add (D2, B1, WHITE, 381);
    mtb_KQKQ->Add (D3, B1, WHITE, 480);
    mtb_KQKQ->Add (C3, C1, WHITE, 474);
    mtb_KQKQ->Add (D3, C1, WHITE, 503);
    mtb_KQKQ->Add (E2, C1, WHITE, 386);
    mtb_KQKQ->Add (D2, B2, WHITE, 417);
    mtb_KQKQ->Add (D3, B2, WHITE, 434);
    mtb_KQKQ->Add (D4, B2, WHITE, 487);
    mtb_KQKQ->Add (C4, C2, WHITE, 505);
    mtb_KQKQ->Add (D4, C2, WHITE, 505);
    mtb_KQKQ->Add (E2, C2, WHITE, 434);
    mtb_KQKQ->Add (E3, C2, WHITE, 455);
}

//////////////////////////////////////////////////////////////////////
//
// KQKP

static const byte mtbdata_KQKP[1662] = {
    1,72,255,159,0,23,249,253,1,127,12,3,17,44,68,132,4,4,0,133,1,75,13,
    248,143,8,12,255,15,76,252,143,16,28,98,79,49,108,79,28,132,7,255,249,
    237,101,223,4,48,1,196,2,128,4,133,5,141,1,56,19,253,229,143,23,2,1,
    132,9,68,132,101,7,6,132,3,4,6,2,3,12,168,139,6,63,24,0,20,12,15,14,
    1,74,255,159,0,22,7,0,15,28,240,143,8,21,230,248,143,16,45,47,78,143,
    31,27,2,2,239,36,29,15,111,1,64,255,159,0,23,7,9,25,49,97,57,193,127,
    240,131,1,133,2,255,7,23,63,6,124,131,6,127,20,143,8,30,70,143,16,37,
    64,89,218,177,111,34,23,121,15,3,80,48,84,145,55,133,3,101,197,138,
    4,33,65,129,20,131,2,33,65,0,129,40,241,141,9,96,186,192,83,103,143,
    12,4,70,53,97,51,103,49,225,133,4,132,8,97,199,47,12,70,0,5,193,1,74,
    255,159,0,21,7,0,15,28,248,141,8,252,192,175,8,28,46,143,5,21,143,24,
    30,47,14,130,7,32,76,64,128,239,23,20,2,2,255,36,29,159,0,111,1,64,
    255,159,0,23,15,24,57,113,225,57,193,127,0,131,1,133,2,143,8,30,255,
    127,217,63,45,30,63,23,56,63,36,136,6,49,97,84,18,121,141,9,112,20,
    119,133,3,229,137,197,138,4,97,193,129,131,2,33,65,146,19,35,57,241,
    133,6,224,192,51,237,231,143,20,1,41,5,225,4,142,5,199,192,143,8,12,
    38,85,193,1,64,255,159,0,7,249,255,231,207,159,64,63,224,245,1,15,16,
    44,68,132,0,5,4,0,8,16,32,64,128,109,1,0,134,1,15,6,240,252,9,143,8,
    6,248,176,175,16,8,91,48,95,28,128,14,84,164,69,166,132,32,60,132,7,
    12,4,144,0,32,163,96,10,8,128,19,133,5,5,34,60,131,5,44,64,143,13,2,
    8,130,28,0,192,253,129,133,3,131,2,143,6,6,63,7,132,9,103,3,128,47,
    36,31,41,1,64,255,159,0,7,15,23,36,68,132,64,4,224,228,1,63,0,8,16,
    32,42,64,128,0,15,23,240,252,9,7,143,8,5,169,248,143,16,6,127,79,44,
    23,133,6,8,0,88,132,1,48,79,3,16,132,5,1,66,130,224,2,138,2,143,30,
    26,159,0,165,1,73,255,159,0,38,15,2,2,0,240,156,143,8,45,143,7,30,127,
    126,47,44,160,8,47,27,31,0,2,7,27,19,35,67,0,15,58,2,7,11,131,1,51,
    117,31,24,183,0,20,6,140,3,130,6,0,147,0,21,0,111,117,1,64,255,150,
    0,62,125,236,204,140,88,12,0,15,5,192,151,5,3,0,2,190,1,146,3,254,77,
    15,21,133,8,255,7,37,127,20,135,251,31,45,235,255,255,1,132,5,133,1,
    152,133,7,79,19,8,8,135,2,159,0,132,1,88,255,150,0,159,183,1,15,19,
    31,39,7,100,196,132,4,0,254,255,6,29,141,8,194,255,7,38,79,87,128,5,
    212,148,20,0,128,1,49,68,132,4,128,6,133,7,31,39,228,214,4,133,2,6,
    192,4,220,143,4,5,140,9,37,100,196,133,76,128,0,51,156,217,143,8,4,
    38,6,5,124,52,132,28,0,63,12,132,4,1,64,255,159,0,23,31,48,108,196,
    133,42,5,124,248,131,1,252,132,2,0,15,5,142,252,143,8,5,252,127,28,
    79,11,143,7,0,5,240,63,106,23,143,22,12,128,5,32,76,132,69,5,4,129,
    6,44,68,132,129,2,112,66,142,9,197,91,96,192,129,1,89,210,124,20,101,
    108,35,48,236,134,7,239,132,131,3,133,10,133,8,220,143,22,2,16,37,183,
    87,132,2,135,68,133,16,141,127,4,22,104,46,7,4,133,24,13,127,12,133,
    5,1,64,255,159,0,7,15,31,36,68,132,67,4,248,228,1,7,248,7,0,15,26,240,
    133,7,5,143,8,70,141,5,137,6,16,32,64,227,128,54,143,16,6,137,4,2,2,
    2,138,2,0,79,209,1,64,255,150,0,30,63,108,204,140,115,12,0,15,5,135,
    5,3,0,255,143,3,4,182,15,22,143,8,149,235,37,138,1,128,140,2,15,7,96,
    8,8,22,95,133,1,64,255,159,0,39,63,97,228,197,132,160,4,143,8,169,225,
    31,20,63,97,255,213,70,181,85,130,1,133,37,69,135,15,63,1,169,199,52,
    193,52,221,143,5,5,133,4,75,140,3,133,140,2,128,0,51,156,143,8,4,178,
    54,134,9,5,140,4,68,132,28,15,12,0,132,4,1,64,255,159,0,24,63,120,236,
    221,141,1,127,248,255,63,112,236,197,133,200,129,2,132,1,239,7,21,0,
    60,129,8,255,127,98,0,60,79,35,132,16,255,255,127,79,22,4,63,96,204,
    133,5,254,32,88,34,172,93,140,17,56,108,220,64,67,255,127,44,47,88,
    172,92,129,4,131,0,130,5,47,88,168,89,168,72,9,134,9,112,172,69,132,
    130,3,108,196,44,18,240,237,5,196,19,133,11,224,91,193,129,138,2,252,
    132,1,5,236,4,183,135,17,100,199,52,133,8,221,137,21,120,159,5,141,
    3,197,135,116,133,16,129,30,143,5,2,0,37,5,1,64,255,159,0,24,47,95,
    191,79,143,0,127,8,0,40,83,163,67,131,99,255,15,132,1,15,22,63,0,40,
    129,8,224,134,7,63,30,132,16,63,25,47,79,135,7,193,7,161,15,66,255,
    255,15,31,63,65,50,104,44,47,80,184,72,136,8,129,1,83,185,73,137,130,
    13,187,75,194,139,130,2,132,5,67,131,3,3,65,148,115,100,19,35,3,211,
    133,9,160,75,64,128,131,10,65,129,2,167,136,12,158,9,52,83,227,20,4,
    128,4,132,8,156,67,67,163,71,79,4,118,4,163,216,195,77,133,2,135,31,
    12,118,3,1,64,255,159,0,38,0,0,32,64,128,42,0,0,254,143,8,86,223,132,
    1,191,31,29,160,239,31,40,225,209,0,32,0,255,89,54,174,73,136,134,6,
    32,0,0,33,241,192,132,2,133,3,31,31,132,9,64,128,1,128,95,44,31,41,
    1,73,255,159,0,43,254,254,143,8,212,254,239,0,131,1,222,254,255,191,
    255,255,127,52,254,254,190,27,37,252,140,2,254,145,250,36,226,255,161,
    2,241,220,242,41,35,252,178,4,114,2,255,253,37,131,3,255,252,4,240,
    240,84,250,233,4,131,8,134,4,116,255,21,252,243,184,68,133,7,254,140,
    6,29,54,1,75,255,159,0,43,199,254,143,8,44,231,255,7,44,45,31,87,247,
    239,139,6,231,132,31,133,2,199,210,141,1,132,4,101,215,51,252,199,147,
    6,34,252,199,191,114,228,199,221,143,7,4,92,193,248,67,223,133,3,148,
    13,133,5,135,220,159,143,15,5,68,197,132,8,143,4,6,55,1,64,255,159,
    0,15,31,47,73,136,8,104,8,192,159,5,16,15,121,247,191,2,0,127,254,189,
    127,143,8,24,245,239,3,11,159,9,16,79,12,15,17,253,0,175,37,86,1,64,
    255,158,0,124,250,217,152,24,90,24,0,15,5,128,159,6,0,15,145,247,143,
    8,45,144,215,79,109,255,223,175,35,70,1,64,255,159,0,15,16,62,73,136,
    8,212,8,143,5,16,15,187,247,143,8,109,245,159,29,86,1,64,255,158,0,
    60,126,219,153,24,118,24,0,15,5,143,6,0,15,211,215,143,8,173,15,7
};

static MTB * mtb_KQKP = NULL;

void initMTB_KQKP()
{
    mtb_KQKP = new MTB ("KQKP", 1, 23);
    mtb_KQKP->SetPackedData (mtbdata_KQKP);
    mtb_KQKP->Add (A2, A1, WHITE, 90);
    mtb_KQKP->Add (A2, B1, WHITE, 31);
    mtb_KQKP->Add (A2, C1, WHITE, 98);
    mtb_KQKP->Add (A2, B2, WHITE, 44);
    mtb_KQKP->Add (A2, C2, WHITE, 88);
    mtb_KQKP->Add (C2, A1, WHITE, 111);
    mtb_KQKP->Add (C2, B1, WHITE, 69);
    mtb_KQKP->Add (C2, C1, WHITE, 61);
    mtb_KQKP->Add (C2, D1, WHITE, 60);
    mtb_KQKP->Add (C2, E1, WHITE, 87);
    mtb_KQKP->Add (C2, A2, WHITE, 117);
    mtb_KQKP->Add (C2, B2, WHITE, 52);
    mtb_KQKP->Add (C2, D2, WHITE, 44);
    mtb_KQKP->Add (C2, E2, WHITE, 74);
    mtb_KQKP->Add (C2, A3, WHITE, 145);
    mtb_KQKP->Add (C2, B3, WHITE, 138);
    mtb_KQKP->Add (C2, C3, WHITE, 63);
    mtb_KQKP->Add (C2, D3, WHITE, 82);
    mtb_KQKP->Add (C2, E3, WHITE, 76);
    mtb_KQKP->Add (D2, C1, WHITE, 46);
    mtb_KQKP->Add (D2, E1, WHITE, 34);
    mtb_KQKP->Add (D2, C2, WHITE, 26);
    mtb_KQKP->Add (D2, E2, WHITE, 26);
}

//////////////////////////////////////////////////////////////////////
//
// KRKP

static const byte mtbdata_KRKP[10529] = {
    1,71,0,159,0,13,64,85,1,155,2,141,2,8,15,79,64,85,81,85,9,81,85,173,
    64,168,0,85,143,18,47,84,234,11,15,2,65,125,140,16,0,31,93,143,32,0,
    167,16,31,48,131,9,65,248,134,10,165,1,143,2,8,159,64,93,159,0,255,
    63,58,1,74,0,159,0,239,80,85,15,14,64,168,0,54,85,85,5,143,16,61,225,
    10,69,136,12,195,1,248,68,36,133,2,63,72,159,0,255,47,219,1,8,0,0,84,
    85,159,0,43,1,84,60,85,1,0,167,0,129,10,143,2,28,15,46,84,172,1,140,
    12,5,60,21,143,18,14,191,28,15,85,253,17,22,50,143,30,43,47,1,24,131,
    14,21,123,43,84,167,16,143,16,67,138,49,67,21,143,12,61,255,63,16,27,
    5,31,88,117,55,17,15,90,160,19,41,21,15,79,1,90,0,159,0,49,32,143,2,
    45,143,16,47,2,28,204,8,28,156,14,32,128,47,61,31,41,64,7,85,85,85,
    64,85,69,192,0,165,0,255,49,23,143,46,66,47,18,201,2,143,14,82,47,0,
    231,2,240,143,16,100,143,1,0,143,18,96,173,33,127,64,1,32,84,85,159,
    0,44,1,0,0,0,251,1,170,0,143,2,28,15,46,143,16,46,193,24,21,143,32,
    105,183,194,8,16,0,4,35,21,194,2,3,253,131,4,6,143,14,45,46,194,24,
    135,49,5,149,127,92,129,127,54,15,7,141,58,165,16,53,5,255,143,16,70,
    3,25,3,23,3,63,72,195,1,240,89,1,57,1,31,60,1,43,84,85,159,0,2,81,166,
    1,65,160,0,128,225,0,167,3,1,0,0,0,8,0,255,68,132,2,208,1,82,11,95,
    30,15,8,175,19,0,127,129,16,0,76,15,72,195,33,140,32,192,0,79,86,248,
    133,30,139,2,143,40,24,111,84,143,18,255,127,151,1,43,80,85,159,0,2,
    69,166,1,64,194,1,47,135,2,5,0,3,5,164,0,15,94,165,14,170,133,18,244,
    1,2,252,4,8,60,32,60,248,128,143,17,46,143,16,110,159,0,255,127,255,
    15,20,1,45,84,85,159,0,2,1,175,1,1,132,2,0,63,161,6,1,0,167,0,47,44,
    15,46,128,10,208,8,95,138,12,5,44,21,44,138,16,255,31,3,111,25,84,114,
    1,28,5,44,21,79,14,65,119,85,64,164,0,47,35,143,48,41,65,228,8,149,
    0,127,21,21,143,60,53,15,24,134,58,4,165,16,143,16,86,254,83,9,83,111,
    88,17,11,17,47,76,1,64,0,159,0,13,64,85,5,0,132,20,168,6,0,4,164,0,
    0,128,2,84,183,85,8,1,175,8,14,15,46,64,233,13,0,220,140,16,32,63,48,
    1,166,0,35,169,12,5,127,0,20,28,197,33,130,34,47,53,139,16,169,16,248,
    129,28,57,143,30,50,63,8,31,255,15,205,1,68,0,159,0,30,85,80,85,11,
    0,73,0,4,160,0,84,85,35,85,5,243,175,10,31,15,29,143,16,13,128,2,159,
    26,29,85,5,76,7,95,12,64,85,4,85,20,228,13,131,14,227,111,44,145,38,
    129,7,37,21,0,20,192,18,111,7,5,224,11,141,30,84,160,16,163,0,143,14,
    32,124,15,4,16,100,143,2,6,165,2,15,255,15,173,1,3,0,0,85,85,150,170,
    167,0,43,159,0,31,2,0,18,85,21,5,131,2,124,31,24,64,182,7,31,36,140,
    16,68,47,24,85,87,85,21,172,10,106,28,20,168,0,128,12,215,90,143,14,
    32,47,18,42,174,2,16,84,31,86,224,175,16,0,31,94,95,255,31,67,1,16,
    0,0,85,159,0,60,5,85,85,116,4,0,167,0,129,12,143,2,12,80,159,16,61,
    85,179,5,140,14,21,143,18,14,15,30,4,84,23,214,50,143,30,27,31,18,10,
    28,84,143,12,61,31,16,255,10,160,1,147,0,19,165,16,143,16,86,39,21,
    254,35,63,88,37,23,1,63,90,3,25,128,84,143,14,63,1,64,0,159,0,13,84,
    85,85,85,165,4,170,166,170,6,0,4,163,0,85,239,5,130,1,129,3,1,1,159,
    8,14,15,45,133,13,87,5,69,143,16,93,68,192,12,21,232,16,21,187,165,
    0,15,54,1,84,141,31,163,2,20,143,30,81,192,75,111,255,79,197,1,3,20,
    85,85,85,150,170,167,0,94,159,0,30,0,31,1,128,143,2,25,240,15,31,43,
    143,16,3,183,8,60,32,60,152,16,21,192,8,193,0,255,111,59,15,27,45,207,
    10,4,159,0,10,143,14,28,95,36,201,2,254,31,82,47,0,231,2,143,16,100,
    143,1,0,143,18,96,173,33,143,12,48,1,6,84,84,85,85,85,193,0,159,0,53,
    125,4,0,1,169,0,143,2,12,175,15,56,134,16,5,118,140,14,21,111,31,143,
    34,41,143,32,30,4,192,13,79,0,188,0,76,84,143,10,24,79,53,149,0,69,
    84,255,2,140,6,29,143,18,63,139,16,167,16,38,29,255,79,63,91,101,120,
    13,31,63,43,51,192,74,93,143,14,31,1,40,68,85,159,0,30,69,236,1,5,0,
    13,0,0,32,0,4,164,0,3,32,234,132,1,5,143,2,14,15,8,84,142,16,5,15,1,
    250,0,12,63,56,15,0,143,32,2,15,72,68,130,12,223,20,134,17,131,14,4,
    128,3,143,48,10,159,0,46,129,9,127,137,10,4,160,16,139,2,31,12,143,
    60,24,79,84,143,18,255,0,54,1,45,68,85,145,0,64,226,0,15,2,84,26,140,
    4,4,85,0,2,133,2,68,82,243,42,211,2,6,95,30,15,24,85,85,177,15,255,
    246,15,132,16,15,88,195,33,95,104,141,14,143,48,4,111,110,128,143,18,
    255,79,135,1,46,84,85,145,0,21,226,0,15,2,141,4,41,1,85,0,16,20,134,
    2,20,0,27,1,2,0,20,164,0,3,2,132,1,245,5,95,8,159,15,7,15,21,143,16,
    5,8,140,14,32,119,60,128,111,54,156,27,31,31,20,162,8,229,23,255,133,
    24,159,0,30,143,46,24,143,2,4,127,62,63,94,143,32,94,143,14,46,0,63,
    120,1,47,84,85,145,0,5,243,0,15,7,135,4,63,173,5,4,0,227,0,167,0,143,
    2,28,143,15,12,47,32,55,160,10,5,0,232,13,112,21,76,143,16,78,191,208,
    36,140,14,21,143,34,9,227,42,76,167,22,159,0,30,223,143,50,46,53,141,
    10,84,15,45,63,32,141,26,165,16,255,143,16,86,67,41,67,95,88,1,123,
    1,0,143,14,60,1,72,0,159,0,13,64,85,15,32,17,0,141,16,166,0,0,0,84,
    143,2,13,15,30,84,108,255,15,14,5,231,11,130,14,21,60,143,18,0,85,245,
    16,38,79,50,143,32,28,15,18,0,12,80,255,143,12,61,15,16,137,48,1,165,
    16,143,16,86,55,5,248,51,79,88,53,39,17,15,90,16,0,160,128,44,80,143,
    12,47,1,65,0,159,0,30,85,85,85,26,162,55,167,0,170,86,178,2,7,5,175,
    10,31,159,16,32,209,10,173,2,143,10,30,21,142,12,16,0,20,177,166,0,
    129,2,149,205,14,58,0,0,16,186,40,159,0,54,4,36,127,255,31,235,128,
    175,10,63,1,20,0,0,85,159,0,45,65,140,2,0,72,0,16,160,0,81,85,35,85,
    21,184,0,15,13,84,143,16,76,16,15,12,21,85,6,17,84,20,84,21,85,35,95,
    34,24,16,84,80,84,137,14,31,30,16,0,220,20,6,129,50,16,204,50,143,2,
    12,16,0,62,80,85,80,192,16,65,143,14,16,159,0,255,79,235,1,4,0,0,0,
    84,85,156,0,82,247,2,167,0,128,4,15,35,214,9,21,191,5,15,142,16,227,
    15,44,108,132,2,15,10,81,84,80,166,0,92,161,6,80,172,10,168,28,231,
    5,129,6,0,58,85,0,84,55,143,14,17,159,0,33,168,174,2,252,64,20,63,86,
    175,16,0,63,94,127,255,15,51,1,16,0,0,85,159,0,76,21,85,85,116,16,0,
    167,0,129,14,139,2,84,159,16,77,85,207,21,143,16,12,159,12,48,17,80,
    23,49,47,14,77,15,32,40,12,80,1,143,12,60,15,16,40,255,160,1,147,0,
    3,165,16,143,16,86,23,5,19,252,47,88,21,7,17,47,90,19,9,80,128,1,143,
    12,46,1,74,0,159,0,13,84,85,15,28,17,193,0,94,0,16,168,0,64,143,2,11,
    15,30,143,18,14,128,16,223,5,233,13,128,14,21,76,127,27,143,32,78,46,
    175,141,8,34,0,44,80,143,6,13,63,41,15,5,255,149,0,5,167,16,143,12,
    52,15,16,43,103,31,86,254,35,9,35,31,88,33,91,1,143,12,44,1,64,0,159,
    0,29,80,85,85,85,154,128,170,167,0,16,84,21,0,26,0,119,16,0,240,2,2,
    193,4,10,204,6,143,2,14,210,15,26,133,13,53,16,192,0,26,2,140,16,175,
    8,140,14,32,108,128,63,40,129,32,33,239,58,112,165,0,47,64,64,194,26,
    143,2,10,143,14,30,224,143,18,30,143,12,62,143,16,255,47,105,1,0,80,
    84,0,0,80,86,80,102,84,85,149,0,160,1,90,170,167,0,15,30,171,0,15,2,
    2,143,2,8,81,128,14,82,137,16,171,15,45,127,3,34,92,130,27,81,16,243,
    165,0,129,32,194,0,31,58,111,9,0,0,192,6,255,141,2,154,0,207,10,5,79,
    10,143,14,11,63,53,201,2,127,82,252,15,0,231,2,143,16,100,143,1,0,143,
    18,96,173,33,143,10,31,1,44,84,85,156,0,81,196,0,15,53,16,251,0,17,
    169,0,139,2,175,13,56,143,16,7,21,127,47,148,143,34,41,143,32,14,17,
    80,95,18,0,60,80,242,1,143,10,6,63,70,149,0,53,80,9,140,6,255,8,143,
    18,78,139,16,167,16,22,68,143,34,72,59,255,69,88,18,143,50,74,11,19,
    42,16,0,143,12,28,1,45,84,85,159,0,2,81,239,2,3,143,4,18,17,63,227,
    0,0,16,166,0,161,12,143,2,8,15,30,143,22,4,55,138,16,5,0,232,13,128,
    14,21,108,31,27,170,63,14,143,32,3,5,60,21,31,40,16,226,10,255,1,135,
    8,131,48,140,2,136,44,79,29,95,22,134,18,119,4,80,143,12,61,15,16,139,
    16,16,166,16,95,86,254,99,41,3,95,88,1,27,1,143,12,44,1,1,80,85,0,85,
    85,85,16,175,192,0,147,0,21,226,0,80,134,2,31,4,137,4,136,129,8,55,
    16,85,0,16,128,0,223,16,164,0,3,128,132,1,5,125,15,24,43,207,17,0,0,
    84,143,16,1,8,12,32,12,246,159,16,39,15,1,143,32,2,15,71,131,12,80,
    134,44,131,2,126,144,2,27,143,48,72,159,0,4,127,14,111,142,143,34,232,
    1,6,84,85,0,84,85,194,0,147,0,180,21,226,0,1,245,1,30,81,140,4,16,107,
    84,0,18,134,2,85,225,1,168,211,2,255,70,127,8,192,9,138,16,47,32,139,
    24,83,47,24,223,15,49,196,16,15,36,17,132,40,31,38,141,14,143,48,4,
    192,31,110,143,18,255,31,119,1,1,84,85,1,84,85,85,85,233,193,0,153,
    0,141,2,22,81,140,4,5,84,72,129,8,81,38,80,0,17,8,0,221,80,164,0,19,
    8,132,1,21,103,85,213,143,16,4,31,39,84,8,92,32,12,128,203,15,70,156,
    29,15,15,81,84,225,0,88,134,38,255,131,2,229,1,133,24,159,0,30,143,
    46,8,127,20,47,62,143,14,126,192,143,16,62,63,110,127,40,1,38,84,85,
    159,0,2,21,80,255,2,3,143,4,2,147,81,171,3,17,0,225,0,16,0,167,0,231,
    143,2,12,143,13,12,15,48,160,12,21,0,232,15,143,16,97,175,240,37,63,
    8,17,146,48,17,140,2,141,4,167,24,231,159,0,30,143,48,14,127,22,141,
    10,80,1,95,44,79,32,255,141,26,165,16,143,16,86,19,73,19,47,88,17,192,
    75,17,143,12,44,1,83,0,159,0,30,85,15,32,64,0,167,0,232,145,8,139,2,
    15,46,255,15,15,21,143,16,12,85,85,189,69,141,4,84,39,255,29,33,143,
    32,29,79,2,74,75,76,106,76,0,2,140,8,1,143,12,28,243,79,16,165,16,21,
    37,21,0,2,135,48,255,162,3,36,143,16,54,5,55,3,55,5,255,134,8,2,31,
    56,3,57,1,57,3,247,120,0,31,58,1,59,106,60,1,64,122,1,143,14,30,1,82,
    0,148,0,85,15,41,104,136,167,0,47,170,90,1,203,9,21,165,12,15,12,143,
    16,42,176,11,108,85,15,20,168,17,0,21,0,198,1,166,0,161,19,65,0,81,
    54,162,21,216,2,189,14,11,65,56,159,0,52,40,0,223,16,20,36,2,159,11,
    53,175,16,25,44,111,255,0,15,164,1,4,0,0,0,80,64,160,0,85,196,84,4,
    159,0,63,1,0,65,0,69,157,85,3,85,85,160,14,43,143,16,111,65,8,123,84,
    69,80,81,143,18,41,5,85,28,65,80,65,81,135,14,15,15,108,85,6,84,64,
    0,85,0,81,164,0,128,2,232,85,96,74,111,12,5,16,64,85,120,64,81,83,143,
    14,16,15,255,15,219,1,65,0,156,0,85,85,0,80,85,63,12,72,9,167,0,141,
    6,15,22,231,9,191,5,15,205,142,16,15,44,127,32,64,81,39,161,6,64,48,
    172,10,160,86,139,2,139,6,0,84,0,229,80,39,143,14,17,159,0,33,160,2,
    190,2,1,248,116,31,85,175,16,1,31,93,95,255,31,35,1,2,0,0,85,85,64,
    0,167,0,198,85,159,0,81,137,14,0,0,84,140,2,143,16,94,39,85,85,65,79,
    61,69,64,7,47,2,86,63,48,160,141,4,5,12,32,127,60,15,0,239,160,160,
    1,147,0,20,37,140,6,164,16,143,16,70,255,23,118,18,136,2,18,47,72,21,
    72,250,16,106,16,15,74,19,42,37,76,128,32,143,10,14,1,86,0,159,0,29,
    85,12,80,196,0,15,6,87,64,84,32,0,169,0,0,138,2,15,46,190,191,15,9,
    133,16,21,31,58,197,30,127,22,143,32,14,111,4,212,74,103,130,8,106,
    108,0,28,64,255,1,28,141,4,143,16,29,169,16,19,103,19,255,149,0,134,
    8,6,143,12,20,31,16,5,21,69,255,5,140,16,22,63,54,21,7,19,39,255,60,
    4,47,56,3,25,1,25,44,128,50,143,14,28,1,64,0,159,0,45,65,85,85,85,106,
    128,170,167,0,65,80,85,0,105,0,119,65,0,240,2,2,193,4,40,204,6,141,
    2,192,15,42,133,13,53,65,84,85,85,105,175,8,140,16,32,44,128,47,56,
    129,32,193,0,255,42,80,165,0,15,18,143,34,16,170,4,194,26,143,2,10,
    255,143,14,30,111,18,201,2,143,12,66,15,16,231,2,143,16,100,143,1,0,
    192,143,18,96,173,33,47,48,1,88,0,145,0,8,226,0,2,69,81,3,0,0,64,89,
    64,81,85,5,47,160,1,106,169,167,0,170,15,29,167,11,8,163,136,14,1,2,
    138,16,85,85,72,57,191,15,45,63,3,136,143,18,8,49,129,32,165,0,17,255,
    194,0,15,58,28,139,2,192,6,125,154,0,207,10,5,255,47,10,143,14,11,31,
    53,201,2,95,82,31,0,231,2,143,16,100,224,143,1,0,143,18,96,173,33,143,
    8,15,1,2,68,64,85,85,64,0,167,0,189,85,157,0,69,196,0,31,53,161,12,
    137,14,69,222,143,16,14,31,61,111,2,65,15,30,143,34,41,143,32,14,143,
    2,20,183,0,141,4,5,169,24,224,0,32,76,170,28,223,15,50,149,0,86,37,
    140,6,166,16,143,16,68,101,255,72,4,134,2,4,127,70,3,26,2,255,56,2,
    95,72,131,65,122,0,26,0,0,143,10,12,1,18,64,84,85,144,0,64,0,165,0,
    218,80,241,1,14,64,239,2,3,143,4,18,69,140,12,121,64,0,139,2,15,46,
    159,19,13,129,16,21,0,239,232,15,47,46,143,14,14,143,32,3,21,47,56,
    131,42,167,26,127,132,44,1,140,2,141,4,127,7,63,38,149,0,70,255,166,
    16,143,14,68,63,0,92,22,79,86,19,10,248,18,79,88,17,12,16,143,10,28,
    1,17,64,84,0,145,0,2,64,0,1,163,0,85,85,1,84,85,85,65,223,192,0,4,162,
    1,65,246,1,15,4,137,4,130,8,209,167,3,140,12,52,2,149,1,64,84,1,229,
    81,125,63,23,207,17,0,1,80,143,16,1,34,127,44,130,159,13,31,31,24,143,
    32,2,31,14,134,34,159,0,30,55,35,64,1,21,132,2,10,59,143,48,8,248,15,
    69,29,63,30,143,16,110,143,18,126,31,71,1,19,68,80,0,144,0,160,2,225,
    0,13,1,85,85,0,80,195,0,4,84,109,209,0,5,18,15,2,69,18,137,4,1,103,
    224,8,1,128,9,67,65,84,139,12,67,61,135,2,69,80,129,6,71,192,9,192,
    15,1,251,135,16,31,31,193,7,135,8,67,31,8,69,130,32,255,15,59,192,33,
    15,30,137,34,143,6,12,31,14,141,14,143,48,4,192,15,110,143,18,126,15,
    232,1,16,68,81,0,144,0,32,0,64,128,1,163,0,85,85,5,80,85,85,123,85,
    81,192,0,9,141,2,6,69,142,4,79,129,8,69,70,69,1,139,12,225,1,1,46,85,
    69,81,177,2,34,143,16,14,79,39,100,191,32,12,128,7,225,0,15,72,150,
    29,122,223,13,135,36,131,2,96,228,1,21,37,133,24,252,111,30,135,46,
    31,36,111,62,143,16,94,143,14,142,47,104,1,19,68,80,85,144,0,64,0,165,
    0,181,225,1,15,1,64,143,3,5,143,4,0,69,155,3,69,238,162,10,135,12,163,
    12,39,69,143,16,20,159,0,55,63,132,223,65,143,18,7,143,2,4,0,118,79,
    30,61,15,38,127,142,10,5,79,44,15,32,142,26,164,16,47,86,3,252,138,
    4,2,31,88,1,60,0,143,10,28,1,74,0,159,0,13,84,85,15,12,17,192,4,95,
    16,0,135,2,1,159,10,14,15,29,143,16,206,143,12,14,110,13,69,60,131,
    14,4,166,0,143,28,62,111,78,138,64,192,8,65,85,68,48,69,226,0,171,65,
    22,64,28,84,28,4,2,128,95,46,159,0,238,1,93,0,159,0,37,85,4,143,8,38,
    15,38,16,251,194,0,229,15,143,16,96,15,62,167,25,31,4,64,232,0,188,
    143,30,66,161,11,69,128,12,193,0,163,0,131,2,64,124,85,68,114,7,19,
    143,46,174,159,0,254,1,34,80,85,159,0,28,0,85,64,224,0,243,69,135,2,
    4,45,15,70,85,85,171,22,245,143,16,96,143,14,4,127,86,143,26,64,129,
    58,64,160,58,64,252,162,0,133,2,89,105,143,28,158,159,0,255,44,1,53,
    84,85,159,0,46,171,8,0,6,20,220,140,2,15,4,239,10,6,81,143,16,85,143,
    20,38,111,120,4,117,0,20,128,5,229,16,15,80,81,194,51,1,112,142,14,
    4,162,0,143,2,8,159,0,20,64,85,64,112,85,1,127,25,15,255,15,29,1,32,
    80,85,159,0,46,80,85,5,0,29,0,0,5,0,227,1,176,1,4,5,221,162,0,15,14,
    239,10,6,69,143,16,85,15,30,127,0,16,252,228,13,31,86,173,17,139,2,
    31,78,15,255,15,173,1,65,0,159,0,13,84,85,85,85,69,173,192,0,15,6,65,
    16,5,226,4,3,1,191,159,10,14,15,29,68,207,15,9,132,16,176,14,31,72,
    167,11,87,87,5,143,32,57,4,192,0,80,160,8,143,28,6,222,205,47,141,14,
    131,2,4,166,0,239,28,46,131,24,79,14,220,4,166,2,143,46,58,1,80,159,
    0,255,79,77,1,82,0,159,0,29,85,15,13,0,80,192,0,113,0,20,135,2,15,61,
    143,16,15,84,85,5,254,95,90,240,29,34,139,14,95,24,143,26,14,79,2,25,
    219,64,193,12,46,16,166,0,79,14,16,204,11,48,143,2,18,80,85,136,28,
    194,14,16,85,16,254,84,192,0,0,239,42,36,141,22,63,2,229,0,37,224,80,
    138,28,143,30,22,159,0,254,1,6,84,85,85,85,0,192,0,159,0,38,171,0,144,
    8,0,168,8,0,31,29,21,207,15,41,55,132,14,84,0,152,24,128,2,80,143,16,
    26,255,15,45,221,143,30,31,143,32,14,13,20,228,0,165,0,145,22,64,220,
    162,46,116,159,0,87,16,34,63,255,63,173,1,41,84,85,159,0,46,65,236,
    1,1,0,62,1,4,0,163,11,19,15,40,143,20,16,143,16,240,226,69,127,3,163,
    0,239,12,22,1,0,5,18,171,68,160,1,80,136,10,69,143,2,3,5,134,19,111,
    133,14,68,143,16,43,129,5,4,18,101,163,2,188,133,8,161,1,20,76,139,
    12,143,14,28,159,0,248,1,34,84,85,159,0,44,1,84,0,224,0,172,20,134,
    2,0,4,20,164,0,15,14,85,119,85,21,224,6,193,0,15,38,0,176,24,143,16,
    42,247,15,46,133,14,143,32,42,239,15,46,15,40,20,160,8,128,40,240,134,
    22,133,2,165,24,127,255,95,189,1,35,84,85,159,0,62,65,85,69,224,0,151,
    193,0,227,1,1,0,3,4,162,0,13,246,167,5,143,16,100,79,14,143,36,32,15,
    222,69,138,14,6,175,80,15,28,4,164,13,69,132,6,133,15,143,2,6,253,13,
    37,143,14,8,111,14,139,4,195,1,43,20,224,28,143,12,12,143,46,36,159,
    0,94,1,35,84,85,159,0,62,0,85,0,2,139,228,1,15,13,85,85,69,130,5,64,
    143,10,7,247,163,20,143,4,8,143,16,44,31,30,143,14,0,68,194,19,135,
    20,191,171,5,15,94,68,175,14,63,13,35,151,17,132,2,224,148,73,239,15,
    76,159,0,255,111,47,1,34,84,85,159,0,62,0,85,0,0,110,20,0,228,1,6,20,
    162,0,13,229,6,255,21,143,10,7,163,20,143,4,8,143,16,52,63,40,173,40,
    229,13,187,47,86,171,9,84,134,2,141,14,47,6,20,207,43,25,191,239,15,
    8,159,0,38,20,134,38,164,0,6,195,2,95,255,0,47,61,1,95,0,159,0,29,85,
    0,210,0,15,5,193,3,221,227,4,132,2,15,61,80,207,15,9,143,16,82,207,
    14,3,84,81,31,44,21,200,1,16,194,12,16,0,20,219,164,0,141,30,141,2,
    64,140,50,51,16,102,112,159,0,40,4,50,79,255,79,189,1,36,84,85,159,
    0,76,0,64,192,0,0,177,80,246,12,0,12,255,15,77,85,0,80,119,143,16,92,
    65,20,139,14,95,8,21,192,2,97,237,53,201,1,207,14,26,53,1,193,12,14,
    64,133,166,0,63,2,21,85,20,0,21,0,131,156,66,143,2,18,65,85,80,84,80,
    193,0,129,16,81,0,85,64,84,64,80,240,96,48,159,14,3,159,0,255,79,104,
    1,44,84,85,159,0,0,1,223,2,2,15,21,0,151,80,192,0,84,0,166,8,0,15,13,
    158,8,181,207,15,41,132,14,80,233,10,128,2,64,143,16,14,1,222,191,14,
    44,61,159,0,27,5,128,30,138,46,141,32,44,155,80,34,80,84,165,0,161,
    45,0,162,46,184,68,159,0,87,64,66,15,255,15,157,1,44,80,85,159,0,62,
    0,192,0,231,10,0,95,85,0,2,16,164,0,15,46,195,11,239,22,10,209,143,
    16,78,143,32,114,57,16,140,34,0,85,21,78,15,57,16,128,8,64,85,129,7,
    164,8,132,2,255,80,12,134,12,129,14,192,0,10,143,32,57,159,0,255,0,
    127,45,1,42,84,85,159,0,62,1,176,10,81,246,10,190,0,4,80,164,0,13,159,
    8,1,193,7,255,18,41,127,1,80,143,16,45,63,45,133,14,31,22,194,21,137,
    30,205,191,50,43,158,12,47,13,81,84,193,16,229,19,80,224,143,2,7,165,
    24,31,255,31,173,1,40,80,85,159,0,78,0,160,0,85,85,219,16,231,1,4,16,
    18,143,6,0,21,226,0,248,143,19,14,143,23,24,143,16,12,63,30,143,32,
    62,31,160,16,85,237,64,138,12,131,2,135,50,16,138,14,22,65,247,31,36,
    224,9,228,5,164,6,102,80,108,164,0,224,141,12,143,14,7,143,32,36,159,
    0,190,1,35,84,85,159,0,78,0,84,0,2,213,228,1,12,143,6,0,21,226,0,1,
    143,10,7,81,222,143,4,13,143,16,46,31,46,17,194,19,135,20,171,13,15,
    94,199,17,174,14,13,17,84,1,208,64,193,0,45,159,0,36,16,85,209,24,0,
    134,8,132,2,80,192,143,30,4,47,255,47,109,1,34,84,85,159,0,78,1,84,
    0,0,119,80,0,227,1,193,1,3,80,162,0,255,6,7,127,159,19,7,81,143,4,13,
    143,16,53,79,39,132,20,23,228,13,243,31,86,133,12,229,17,139,14,79,
    0,81,84,194,41,237,134,42,132,2,239,15,45,159,0,22,81,226,51,229,17,
    80,224,95,9,195,2,127,255,79,45,1,84,0,144,0,1,160,0,85,15,41,1,251,
    84,207,3,12,233,11,129,14,15,0,207,15,40,65,207,19,17,212,143,16,16,
    47,40,223,14,3,80,31,40,1,193,10,0,209,21,194,50,161,0,65,194,12,65,
    0,81,219,116,141,30,141,2,1,140,50,131,16,65,22,112,159,0,40,16,18,
    127,255,31,173,1,41,84,85,159,0,92,0,2,65,81,189,255,14,93,135,16,64,
    193,16,56,145,32,223,32,73,5,191,196,0,143,32,6,5,192,15,1,154,0,143,
    18,45,137,14,148,141,12,131,16,0,1,165,0,1,208,1,5,28,0,17,0,16,48,
    17,129,2,85,4,84,81,0,85,0,81,18,1,208,80,203,11,95,14,0,0,5,85,64,
    114,81,64,49,64,1,0,84,144,9,224,65,148,10,159,0,255,127,108,1,6,4,
    80,85,85,0,192,0,159,0,10,205,5,143,4,13,31,10,0,64,129,12,167,12,0,
    216,28,193,11,143,16,11,81,207,15,40,132,14,64,0,211,0,138,2,14,1,12,
    5,84,207,14,44,197,12,159,0,11,131,32,65,81,64,164,0,21,236,48,138,
    46,29,60,64,50,229,7,64,157,81,193,41,0,84,161,46,164,0,159,0,88,1,
    192,50,79,255,79,140,1,1,84,85,1,84,85,85,65,235,192,0,159,0,70,130,
    12,232,1,0,18,64,164,0,255,132,4,143,16,41,193,11,39,127,32,133,2,143,
    32,100,159,0,46,234,207,31,0,193,41,201,2,32,84,31,56,65,129,8,231,
    85,129,7,51,133,2,64,1,108,164,0,248,130,14,192,0,106,143,32,57,159,
    0,255,95,29,1,0,84,85,5,80,85,85,85,234,81,192,0,159,0,69,129,12,69,
    38,0,20,124,64,1,163,0,131,4,143,16,11,193,3,143,20,41,5,241,64,127,
    45,79,45,133,14,47,8,5,0,84,249,40,194,21,137,18,207,19,43,69,63,6,
    5,80,129,192,0,8,69,81,0,0,85,85,248,229,1,143,2,8,165,6,143,12,14,
    63,255,47,125,1,34,84,85,159,0,94,1,84,1,208,14,223,65,159,15,24,162,
    5,65,223,4,13,143,4,14,143,16,9,191,32,93,125,109,0,148,0,15,100,229,
    15,31,38,161,9,1,250,171,49,130,2,135,50,112,138,30,132,16,4,63,36,
    84,65,84,131,1,64,194,0,64,24,64,236,1,28,138,4,165,2,1,12,159,0,238,
    1,32,84,85,159,0,94,1,80,1,0,26,0,0,1,0,159,6,23,178,20,5,159,21,7,
    231,69,226,0,143,4,8,143,16,14,69,84,193,7,143,8,24,179,159,0,30,141,
    12,1,192,15,111,104,69,84,208,15,143,24,160,2,80,5,80,225,34,134,6,
    130,2,142,193,0,111,36,65,84,1,192,13,135,10,36,240,64,227,1,235,15,
    79,255,47,95,1,32,84,85,159,0,94,5,80,1,0,21,0,0,65,1,255,6,29,81,159,
    3,6,69,247,143,4,13,143,16,53,15,39,132,20,71,0,79,92,208,13,204,82,
    229,17,133,2,64,1,161,0,160,2,81,111,5,80,225,0,134,22,81,194,41,77,
    239,15,45,63,159,0,6,69,81,139,18,37,227,1,47,10,195,2,192,143,12,14,
    79,255,60,1,36,84,85,159,0,76,1,0,3,5,252,0,139,2,15,22,143,20,46,143,
    16,255,143,12,61,13,5,91,0,4,224,10,4,228,13,95,82,69,196,0,90,46,5,
    137,14,4,164,0,125,68,140,8,157,69,136,2,64,85,225,3,143,4,8,87,68,
    254,212,27,140,32,160,16,143,16,14,149,0,61,237,5,131,2,224,20,143,
    6,13,79,24,21,1,55,80,85,159,0,46,171,8,0,4,141,2,251,15,54,143,16,
    240,173,54,143,14,4,95,22,239,60,22,64,134,1,22,161,1,69,85,0,50,64,
    143,28,47,163,11,241,69,224,0,193,0,193,1,133,2,64,85,68,252,160,0,
    41,53,35,163,16,143,44,62,159,0,222,1,34,80,85,159,0,62,80,85,0,0,119,
    5,0,227,1,193,1,3,5,162,0,13,234,255,15,63,143,16,29,31,30,15,17,84,
    15,108,16,241,4,191,80,15,74,64,129,11,134,14,173,19,139,2,143,64,18,
    31,129,10,64,85,69,192,0,161,1,21,169,0,192,23,159,24,47,159,0,253,
    1,32,84,85,159,0,78,84,85,4,0,63,4,0,0,192,0,193,13,144,1,6,129,3,175,
    255,15,79,143,16,39,81,127,54,81,15,10,79,14,15,49,175,132,13,15,102,
    20,15,79,68,234,1,225,10,135,14,140,141,2,63,14,68,85,64,160,0,193,
    63,65,107,85,69,64,41,85,44,5,0,240,169,8,165,13,143,12,6,15,14,159,
    0,98,1,34,80,85,159,0,78,80,85,0,2,125,5,0,225,1,195,1,165,2,195,2,
    143,16,132,69,125,111,54,81,111,10,31,30,15,33,230,13,15,72,21,81,141,
    2,84,199,2,16,15,61,5,0,64,215,192,0,199,17,91,21,200,5,21,162,0,43,
    128,127,46,159,0,190,1,40,84,85,159,0,62,81,234,1,65,85,126,1,0,1,133,
    13,19,15,24,143,20,32,143,16,238,246,65,127,27,143,64,48,139,30,15,
    6,4,164,0,93,174,68,130,4,80,134,6,69,143,2,35,135,25,133,14,187,68,
    148,2,1,143,16,13,85,227,3,5,10,188,225,0,121,20,28,137,10,31,14,95,
    134,1,41,80,85,159,0,92,0,4,4,0,250,159,15,93,143,16,255,239,8,42,233,
    70,193,1,135,2,16,115,215,84,141,14,63,40,16,234,1,21,2,25,185,11,133,
    12,16,164,0,79,6,157,0,85,85,141,179,22,31,8,16,0,20,0,137,10,84,192,
    28,143,14,26,47,118,1,47,84,85,159,0,62,0,196,0,228,1,4,221,141,2,141,
    3,143,16,104,21,111,62,176,42,108,64,123,143,32,74,64,196,0,171,12,
    47,40,141,2,20,228,0,95,163,0,0,194,27,64,130,1,2,159,0,45,141,22,29,
    103,0,0,20,0,167,22,225,1,20,128,255,13,46,79,255,1,42,84,85,159,0,
    80,65,192,0,69,198,1,78,1,0,3,4,0,207,15,82,143,16,255,95,95,170,65,
    95,15,81,143,14,65,65,212,11,21,131,2,61,84,65,80,35,229,15,81,161,
    0,68,235,162,2,212,3,130,21,47,28,5,36,1,228,25,191,35,145,0,84,146,
    2,135,14,111,14,131,18,59,112,141,4,20,174,2,63,10,31,18,1,34,84,85,
    159,0,78,0,85,0,0,110,20,0,228,1,6,20,162,0,255,15,79,143,16,17,215,
    21,196,0,111,69,81,143,32,92,84,64,10,119,145,0,64,15,72,133,10,143,
    2,4,84,118,131,14,120,63,0,20,160,0,73,13,229,5,0,0,223,4,48,79,62,
    20,134,12,52,88,226,0,96,136,16,20,95,65,15,110,1,32,84,85,159,0,94,
    5,85,65,85,6,5,0,0,0,4,0,207,15,96,143,16,4,165,69,47,92,69,143,32,
    109,1,64,47,108,0,22,47,106,69,85,1,42,81,191,13,72,244,27,167,1,192,
    13,64,128,1,65,80,227,31,151,0,255,145,4,135,2,243,5,127,24,131,24,
    225,11,24,247,1,112,144,0,20,160,0,31,10,97,1,35,84,85,159,0,94,0,85,
    0,4,175,191,15,95,143,16,5,69,226,0,64,175,6,7,195,36,143,4,8,87,63,
    29,69,143,32,109,1,15,92,68,160,0,193,39,199,133,40,229,15,15,40,84,
    85,80,224,0,193,0,13,143,2,2,16,0,16,0,41,139,14,68,163,40,145,0,4,
    236,17,81,85,4,196,2,24,161,7,4,0,20,194,1,193,23,0,0,175,21,0,16,88,
    80,160,13,89,225,1,252,83,147,0,31,2,45,135,16,31,20,47,62,1,34,84,
    85,159,0,94,0,85,0,2,111,20,0,191,15,95,143,16,11,21,175,6,7,195,36,
    143,4,8,93,63,29,69,143,32,109,1,63,78,128,38,248,74,84,62,160,0,64,
    80,128,1,196,2,227,15,31,56,133,10,211,0,20,139,2,84,247,1,0,84,162,
    0,92,151,0,20,194,16,20,80,201,59,59,65,223,85,225,4,227,5,21,65,138,
    10,233,1,159,0,36,254,167,8,129,13,197,13,133,2,143,4,10,161,2,233,
    25,15,36,1,42,80,85,159,0,78,0,192,0,64,232,1,253,0,2,255,14,79,143,
    16,71,175,38,30,143,32,140,35,21,175,243,0,130,3,16,228,0,20,162,0,
    143,30,0,143,2,2,219,135,12,141,14,143,16,6,16,68,157,0,16,132,4,255,
    161,4,17,133,2,161,21,162,6,135,24,194,24,117,216,133,10,77,142,14,
    84,143,16,12,159,0,222,1,54,84,85,159,0,255,15,221,21,196,0,15,42,197,
    65,204,1,135,2,64,84,64,225,0,81,100,85,0,4,85,84,84,225,1,21,34,85,
    20,0,163,0,85,85,20,191,82,13,224,64,138,4,128,8,16,65,85,80,84,149,
    80,193,0,84,64,18,64,129,15,80,46,0,84,64,132,14,64,164,0,149,0,29,
    190,4,0,16,80,135,20,127,0,161,2,57,240,80,56,161,9,137,6,159,0,150,
    1,46,84,85,159,0,78,1,176,12,193,0,3,243,0,4,255,14,79,143,16,40,191,
    34,61,1,80,143,32,92,254,177,11,249,11,139,14,111,1,193,19,201,30,13,
    140,2,151,80,2,80,84,163,0,0,32,129,14,215,129,1,34,159,0,29,81,164,
    6,80,36,133,2,254,160,12,226,13,39,195,4,37,5,159,0,255,31,29,1,40,
    80,85,159,0,94,0,160,0,85,85,253,16,143,15,95,143,16,56,193,38,143,
    39,40,143,32,176,63,58,0,171,12,165,2,16,194,0,16,128,2,16,204,21,210,
    63,4,135,50,51,64,140,14,0,81,196,55,139,84,50,81,0,65,143,16,4,16,
    60,219,39,164,2,40,80,44,162,0,84,166,9,128,12,159,0,132,1,32,84,85,
    159,0,94,1,84,0,0,30,1,0,80,0,159,15,95,143,16,24,209,34,159,35,71,
    91,1,68,143,32,92,81,160,0,42,0,47,76,214,240,11,146,0,143,2,4,81,54,
    80,98,160,2,124,84,81,138,46,52,135,24,12,229,7,0,109,0,16,80,159,0,
    46,81,224,65,231,17,80,248,15,11,225,0,7,193,0,143,16,48,95,110,1,39,
    80,85,159,0,255,85,21,226,0,175,35,14,149,175,39,255,15,163,16,0,7,
    16,160,0,69,149,160,2,195,2,16,0,163,60,16,96,64,233,169,6,143,2,5,
    133,66,79,2,0,128,1,0,81,223,67,210,11,113,65,143,16,2,7,227,1,11,188,
    225,0,9,80,142,6,153,0,15,14,33,1,37,84,85,159,0,255,85,21,226,0,1,
    119,143,4,7,81,47,13,15,255,10,17,160,0,193,39,113,135,40,21,162,46,
    227,46,79,34,81,85,65,205,224,0,193,0,143,2,2,64,0,160,0,104,0,171,
    54,225,1,4,162,1,1,66,20,114,130,7,225,6,69,85,16,0,16,228,5,186,0,
    48,80,182,7,208,0,240,0,64,104,127,64,1,193,13,88,162,0,151,0,95,2,
    29,192,99,47,24,31,46,1,59,84,85,159,0,255,5,191,35,7,81,143,4,13,225,
    15,254,128,38,180,38,227,1,81,85,1,65,217,128,1,200,2,79,58,0,38,143,
    2,2,80,1,8,71,80,1,80,1,128,17,84,81,248,84,194,57,132,58,70,133,22,
    26,5,85,39,80,0,80,227,7,0,85,160,10,195,1,255,134,10,232,1,159,0,20,
    167,6,129,11,197,11,143,2,6,143,6,10,192,162,2,232,27,31,20,1,43,84,
    85,159,0,94,1,176,14,1,239,14,95,64,143,16,72,65,63,45,21,0,0,0,84,
    232,0,143,32,102,208,15,10,1,160,0,0,0,43,85,0,21,162,1,1,128,19,65,
    129,2,127,224,0,81,2,143,30,0,63,2,137,28,109,143,16,12,35,157,0,65,
    84,165,1,64,0,80,80,191,117,161,7,64,80,103,211,10,21,193,3,176,137,
    4,21,1,28,159,0,238,1,62,84,85,159,0,255,15,222,177,64,253,64,255,66,
    45,197,5,204,1,135,2,0,81,0,225,0,69,0,101,81,0,1,0,0,0,85,16,0,17,
    0,16,192,0,17,0,81,185,81,2,84,240,4,176,5,209,5,81,80,34,207,13,12,
    1,81,233,1,81,81,0,128,6,15,5,85,64,81,64,17,177,8,128,2,118,210,9,
    65,146,10,241,11,145,0,1,164,0,127,5,191,16,192,0,64,0,21,192,8,142,
    2,161,2,120,138,4,1,103,161,11,137,6,79,134,1,39,84,85,159,0,94,5,80,
    195,0,15,102,87,143,16,31,81,63,61,64,143,32,92,0,176,60,17,253,134,
    2,34,139,34,202,28,193,1,13,47,9,64,34,2,64,81,163,0,0,80,0,128,10,
    114,0,84,129,1,2,159,0,13,69,81,35,127,64,1,3,127,6,160,12,226,13,119,
    195,4,224,37,165,6,143,14,14,159,0,254,1,54,84,85,159,0,255,15,31,65,
    196,0,15,164,245,0,4,239,15,108,15,6,165,4,64,34,64,30,128,2,65,84,
    65,218,86,31,4,135,50,19,138,1,22,1,84,1,17,68,143,16,20,121,65,84,
    11,55,163,2,41,64,1,188,44,129,4,80,165,9,52,38,159,0,116,1,54,84,85,
    159,0,255,15,0,81,196,0,15,179,216,69,160,0,15,90,0,4,143,2,6,69,81,
    159,69,192,43,21,80,123,135,46,20,135,24,156,28,227,9,64,1,192,0,160,
    0,159,0,30,65,151,81,165,1,64,1,1,69,84,227,1,248,79,12,225,0,71,194,
    2,143,16,31,159,0,110,1,59,84,85,159,0,255,15,0,210,36,65,223,4,13,
    221,143,4,14,15,255,4,0,6,239,15,108,19,64,14,202,1,64,0,21,85,225,
    0,228,1,131,61,31,84,65,84,1,137,63,143,2,5,133,66,127,3,63,160,74,
    1,68,143,16,18,23,227,1,27,137,6,112,226,3,1,125,203,11,79,0,1,58,84,
    85,159,0,255,15,0,210,36,5,191,37,7,255,69,226,0,143,4,8,15,255,143,
    44,0,193,39,135,40,141,2,25,111,29,69,85,5,129,50,47,5,0,1,149,160,
    0,38,16,0,49,5,226,0,80,176,96,93,80,56,225,6,21,85,64,83,0,64,212,
    1,0,160,1,64,1,98,191,192,21,160,2,1,226,11,70,240,6,193,13,71,254,
    225,1,67,147,0,11,47,3,99,31,24,47,30,1,53,84,85,159,0,255,15,6,81,
    159,3,6,69,246,143,4,13,15,254,128,38,180,38,15,82,0,6,143,2,4,31,69,
    81,69,81,194,55,132,56,31,7,229,23,2,26,21,84,64,1,64,1,225,9,6,64,
    1,85,1,85,85,195,1,147,0,127,64,5,233,1,31,16,161,9,167,6,35,143,2,
    12,208,225,0,143,4,6,162,2,5,207,14,14,1,41,84,85,159,0,221,21,175,
    30,109,21,84,141,175,16,108,129,16,21,0,0,207,16,103,63,118,21,96,191,
    10,56,69,196,0,143,2,6,5,0,0,0,93,4,0,197,1,4,160,0,7,143,8,12,64,182,
    143,12,19,143,14,9,5,129,45,8,21,225,15,137,16,1,35,80,85,159,0,78,
    80,85,0,2,244,227,1,195,1,135,2,15,80,143,16,239,84,208,13,64,181,5,
    111,103,16,138,14,15,50,64,192,0,69,246,79,7,141,12,75,15,2,131,8,64,
    50,73,59,64,85,68,44,165,0,35,0,17,0,159,0,173,1,34,80,85,159,0,94,
    80,85,0,2,110,5,0,191,15,95,143,16,244,81,63,109,243,15,63,75,171,21,
    141,2,84,199,2,16,63,1,64,140,6,29,115,64,85,68,132,1,49,197,4,69,26,
    60,5,0,64,164,58,53,0,24,220,21,228,13,145,0,21,162,0,27,79,110,1,54,
    84,85,159,0,255,15,119,81,159,32,238,15,209,55,84,85,80,162,0,169,62,
    84,64,203,4,192,143,2,58,225,1,7,1,54,80,85,159,0,255,15,119,69,159,
    32,238,15,211,253,64,162,0,169,62,135,2,131,1,101,195,117,69,240,15,
    23,227,0,13,135,14,49,1,46,84,85,159,0,96,81,207,14,97,143,16,255,47,
    231,139,65,160,0,85,85,69,143,14,87,1,83,82,148,109,21,133,2,80,181,
    16,1,0,145,0,212,80,135,6,15,27,69,12,5,4,0,220,0,147,14,8,84,145,47,
    229,1,149,0,1,58,80,85,159,0,255,15,255,15,189,21,255,9,60,158,16,160,
    0,85,85,135,105,131,2,193,0,100,31,0,16,0,0,112,229,1,149,0,143,17,
    38,216,177,7,224,0,36,69,1,50,16,0,248,21,208,2,246,11,0,163,15,15,
    12,1,35,84,85,159,0,94,0,85,0,2,175,159,15,95,143,16,135,21,63,92,81,
    143,32,94,203,76,227,15,222,63,40,128,40,224,0,64,140,2,247,9,141,12,
    63,14,63,85,85,20,204,48,63,12,133,8,160,8,192,8,238,231,1,159,0,36,
    143,20,12,141,4,20,170,14,218,17,95,37,1,61,84,85,159,0,255,15,255,
    15,255,15,127,81,126,200,1,21,160,0,129,2,197,2,99,192,0,180,125,0,
    1,0,0,0,64,85,5,0,64,64,80,225,1,1,55,84,85,159,0,255,15,97,21,196,
    0,15,255,24,15,51,84,85,84,248,92,224,1,85,84,206,80,128,1,191,95,37,
    20,0,161,0,113,131,2,211,0,70,63,18,84,247,1,0,84,16,247,128,9,18,135,
    64,63,15,138,16,20,136,10,129,3,0,159,0,30,1,55,84,85,159,0,255,15,
    97,69,159,32,238,15,255,0,15,86,1,53,84,85,159,0,255,15,97,69,226,0,
    64,245,143,4,7,227,52,63,8,15,255,15,139,84,160,0,80,219,239,9,59,131,
    10,195,10,80,4,133,2,16,2,112,88,0,1,82,240,78,1,55,84,85,159,0,255,
    15,103,21,175,3,7,227,52,247,143,4,8,15,255,15,93,237,104,137,2,84,
    162,0,15,8,106,95,46,20,18,231,11,0,18,64,192,1,208,64,162,13,39,0,
    31,1,1,58,80,85,159,0,255,15,143,207,54,188,0,2,245,21,192,0,143,16,
    106,1,133,43,16,64,64,164,168,4,143,2,12,16,47,29,0,84,145,29,0,191,
    81,95,0,16,160,0,39,225,1,45,193,36,86,25,80,142,6,16,29,84,31,6,147,
    0,1,62,84,85,159,0,255,15,255,15,204,175,96,47,156,8,46,64,84,0,160,
    2,64,140,2,193,0,3,156,0,4,85,21,102,141,4,47,41,0,134,84,133,12,64,
    0,85,0,231,13,15,6,1,58,84,85,159,0,255,15,112,223,50,205,81,239,9,
    59,45,0,84,0,128,38,0,141,2,198,40,0,143,4,95,6,81,84,81,193,5,200,
    46,15,28,187,133,10,160,10,1,233,1,127,20,167,6,80,162,0,208,63,12,
    143,6,10,162,2,1,143,16,30,1,62,80,85,159,0,255,15,145,225,54,175,55,
    255,15,37,95,16,0,161,0,64,128,1,175,42,100,135,16,132,2,198,82,135,
    60,31,31,84,16,85,177,9,24,161,84,17,64,26,21,84,0,81,0,225,1,1,62,
    84,85,159,0,255,15,114,241,50,191,51,255,15,54,19,81,85,81,81,239,9,
    56,80,0,161,0,179,129,1,131,2,0,22,15,20,81,84,97,220,135,62,15,30,
    139,16,80,247,11,130,3,31,14,1,55,80,85,159,0,255,15,113,21,226,0,207,
    51,14,160,207,55,255,15,169,64,143,14,101,1,53,84,85,159,0,255,15,113,
    21,226,0,1,117,143,4,7,81,63,13,15,255,15,217,80,162,0,65,141,160,1,
    193,0,85,85,64,116,134,2,84,128,34,52,1,59,84,85,159,0,255,15,120,223,
    51,7,81,143,4,13,236,15,255,15,93,132,52,143,2,3,81,162,0,31,72,80,
    204,84,1,231,13,0,84,2,192,1,0,96,85,80,0,120,84,80,85,1,52,84,85,159,
    0,255,15,159,65,239,23,171,1,28,0,1,0,0,192,0,165,81,131,2,85,246,0,
    239,15,84,176,13,10,169,2,64,133,44,176,19,207,1,137,46,95,11,65,84,
    95,26,143,16,11,160,0,252,87,225,1,29,137,6,130,4,240,10,75,65,160,
    84,28,80,11,1,56,84,85,159,0,255,15,255,15,204,81,0,7,1,0,0,0,85,0,
    134,2,159,10,47,15,251,1,0,81,0,80,224,0,61,192,0,52,17,1,80,208,15,
    18,16,180,2,0,124,0,1,144,1,1,132,6,143,2,43,135,12,0,48,1,85,1,225,
    3,59,1,54,84,85,159,0,255,15,128,81,159,32,238,15,26,31,0,80,0,80,224,
    0,150,91,132,2,192,0,199,100,20,5,69,81,69,129,44,198,44,246,13,161,
    2,15,26,133,12,160,12,5,233,1,159,0,4,79,69,81,165,1,64,1,161,0,167,
    6,127,18,208,225,24,143,4,6,162,2,5,143,16,14,1,55,84,85,159,0,255,
    15,161,65,196,0,15,255,101,15,17,0,6,195,97,64,0,161,0,0,249,128,1,
    239,15,82,160,13,54,129,15,143,16,0,65,84,194,113,135,60,143,2,31,80,
    65,84,1,8,20,64,80,64,80,1,1,226,1,1,55,84,85,159,0,255,15,130,81,196,
    0,15,255,59,15,128,64,1,161,0,129,1,131,2,0,6,2,127,4,65,81,69,81,5,
    80,135,60,185,69,16,69,136,62,31,30,139,16,64,1,224,135,14,129,3,231,
    1,147,0,1,59,84,85,159,0,255,15,130,242,52,65,223,4,13,230,143,4,14,
    15,255,140,44,15,100,65,0,161,0,239,15,102,1,58,84,85,159,0,255,15,
    130,242,52,5,223,53,7,247,69,226,0,143,4,8,15,255,15,122,0,162,0,193,
    55,90,143,56,67,64,2,5,129,68,248,13,0,132,2,1,53,84,85,159,0,255,15,
    136,81,159,3,6,69,249,143,4,13,15,255,15,93,132,52,143,2,7,15,74,64,
    81,152,161,0,167,15,0,80,18,144,127,0,84,0,64,85
};

static MTB * mtb_KRKP = NULL;

void initMTB_KRKP()
{
    mtb_KRKP = new MTB ("KRKP", 2, 134);
    mtb_KRKP->SetPackedData (mtbdata_KRKP);
    mtb_KRKP->Add (A2, A1, WHITE, 69);
    mtb_KRKP->Add (A2, B1, WHITE, 39);
    mtb_KRKP->Add (A2, C1, WHITE, 85);
    mtb_KRKP->Add (A2, B2, WHITE, 69);
    mtb_KRKP->Add (A2, C2, WHITE, 87);
    mtb_KRKP->Add (A2, A3, WHITE, 69);
    mtb_KRKP->Add (A2, B3, WHITE, 53);
    mtb_KRKP->Add (A2, C3, WHITE, 95);
    mtb_KRKP->Add (B2, A1, WHITE, 75);
    mtb_KRKP->Add (B2, B1, WHITE, 92);
    mtb_KRKP->Add (B2, C1, WHITE, 72);
    mtb_KRKP->Add (B2, D1, WHITE, 84);
    mtb_KRKP->Add (B2, A2, WHITE, 70);
    mtb_KRKP->Add (B2, C2, WHITE, 80);
    mtb_KRKP->Add (B2, D2, WHITE, 88);
    mtb_KRKP->Add (B2, A3, WHITE, 89);
    mtb_KRKP->Add (B2, B3, WHITE, 60);
    mtb_KRKP->Add (B2, C3, WHITE, 89);
    mtb_KRKP->Add (B2, D3, WHITE, 92);
    mtb_KRKP->Add (C2, A1, WHITE, 87);
    mtb_KRKP->Add (C2, B1, WHITE, 66);
    mtb_KRKP->Add (C2, C1, WHITE, 84);
    mtb_KRKP->Add (C2, D1, WHITE, 80);
    mtb_KRKP->Add (C2, E1, WHITE, 82);
    mtb_KRKP->Add (C2, A2, WHITE, 84);
    mtb_KRKP->Add (C2, B2, WHITE, 88);
    mtb_KRKP->Add (C2, D2, WHITE, 100);
    mtb_KRKP->Add (C2, E2, WHITE, 86);
    mtb_KRKP->Add (C2, A3, WHITE, 102);
    mtb_KRKP->Add (C2, B3, WHITE, 94);
    mtb_KRKP->Add (C2, C3, WHITE, 75);
    mtb_KRKP->Add (C2, D3, WHITE, 97);
    mtb_KRKP->Add (C2, E3, WHITE, 97);
    mtb_KRKP->Add (D2, B1, WHITE, 107);
    mtb_KRKP->Add (D2, C1, WHITE, 78);
    mtb_KRKP->Add (D2, D1, WHITE, 87);
    mtb_KRKP->Add (D2, E1, WHITE, 77);
    mtb_KRKP->Add (D2, F1, WHITE, 90);
    mtb_KRKP->Add (D2, B2, WHITE, 106);
    mtb_KRKP->Add (D2, C2, WHITE, 104);
    mtb_KRKP->Add (D2, E2, WHITE, 106);
    mtb_KRKP->Add (D2, F2, WHITE, 98);
    mtb_KRKP->Add (D2, B3, WHITE, 97);
    mtb_KRKP->Add (D2, C3, WHITE, 105);
    mtb_KRKP->Add (D2, D3, WHITE, 100);
    mtb_KRKP->Add (D2, E3, WHITE, 99);
    mtb_KRKP->Add (D2, F3, WHITE, 86);
    mtb_KRKP->Add (A3, A2, WHITE, 70);
    mtb_KRKP->Add (A3, B2, WHITE, 59);
    mtb_KRKP->Add (A3, B3, WHITE, 56);
    mtb_KRKP->Add (A3, A4, WHITE, 67);
    mtb_KRKP->Add (A3, B4, WHITE, 54);
    mtb_KRKP->Add (B3, A2, WHITE, 87);
    mtb_KRKP->Add (B3, B2, WHITE, 93);
    mtb_KRKP->Add (B3, C2, WHITE, 71);
    mtb_KRKP->Add (B3, A3, WHITE, 83);
    mtb_KRKP->Add (B3, C3, WHITE, 68);
    mtb_KRKP->Add (B3, A4, WHITE, 81);
    mtb_KRKP->Add (B3, B4, WHITE, 70);
    mtb_KRKP->Add (B3, C4, WHITE, 78);
    mtb_KRKP->Add (C3, B2, WHITE, 67);
    mtb_KRKP->Add (C3, C2, WHITE, 95);
    mtb_KRKP->Add (C3, D2, WHITE, 82);
    mtb_KRKP->Add (C3, B3, WHITE, 74);
    mtb_KRKP->Add (C3, D3, WHITE, 69);
    mtb_KRKP->Add (C3, B4, WHITE, 83);
    mtb_KRKP->Add (C3, C4, WHITE, 78);
    mtb_KRKP->Add (C3, D4, WHITE, 84);
    mtb_KRKP->Add (D3, C2, WHITE, 81);
    mtb_KRKP->Add (D3, D2, WHITE, 106);
    mtb_KRKP->Add (D3, E2, WHITE, 97);
    mtb_KRKP->Add (D3, C3, WHITE, 84);
    mtb_KRKP->Add (D3, E3, WHITE, 90);
    mtb_KRKP->Add (D3, C4, WHITE, 84);
    mtb_KRKP->Add (D3, D4, WHITE, 93);
    mtb_KRKP->Add (D3, E4, WHITE, 90);
    mtb_KRKP->Add (A4, A3, WHITE, 91);
    mtb_KRKP->Add (A4, B3, WHITE, 72);
    mtb_KRKP->Add (A4, B4, WHITE, 77);
    mtb_KRKP->Add (A4, A5, WHITE, 91);
    mtb_KRKP->Add (A4, B5, WHITE, 72);
    mtb_KRKP->Add (B4, A3, WHITE, 82);
    mtb_KRKP->Add (B4, B3, WHITE, 73);
    mtb_KRKP->Add (B4, C3, WHITE, 76);
    mtb_KRKP->Add (B4, A4, WHITE, 90);
    mtb_KRKP->Add (B4, C4, WHITE, 86);
    mtb_KRKP->Add (B4, A5, WHITE, 88);
    mtb_KRKP->Add (B4, B5, WHITE, 119);
    mtb_KRKP->Add (B4, C5, WHITE, 116);
    mtb_KRKP->Add (C4, B3, WHITE, 90);
    mtb_KRKP->Add (C4, C3, WHITE, 104);
    mtb_KRKP->Add (C4, D3, WHITE, 86);
    mtb_KRKP->Add (C4, B4, WHITE, 85);
    mtb_KRKP->Add (C4, D4, WHITE, 92);
    mtb_KRKP->Add (C4, B5, WHITE, 79);
    mtb_KRKP->Add (C4, C5, WHITE, 107);
    mtb_KRKP->Add (C4, D5, WHITE, 103);
    mtb_KRKP->Add (D4, C3, WHITE, 99);
    mtb_KRKP->Add (D4, D3, WHITE, 122);
    mtb_KRKP->Add (D4, E3, WHITE, 88);
    mtb_KRKP->Add (D4, C4, WHITE, 73);
    mtb_KRKP->Add (D4, E4, WHITE, 78);
    mtb_KRKP->Add (D4, C5, WHITE, 79);
    mtb_KRKP->Add (D4, D5, WHITE, 105);
    mtb_KRKP->Add (D4, E5, WHITE, 92);
    mtb_KRKP->Add (A5, A4, WHITE, 71);
    mtb_KRKP->Add (A5, B4, WHITE, 67);
    mtb_KRKP->Add (A5, B5, WHITE, 73);
    mtb_KRKP->Add (A5, A6, WHITE, 34);
    mtb_KRKP->Add (A5, B6, WHITE, 38);
    mtb_KRKP->Add (B5, A4, WHITE, 64);
    mtb_KRKP->Add (B5, B4, WHITE, 63);
    mtb_KRKP->Add (B5, C4, WHITE, 77);
    mtb_KRKP->Add (B5, A5, WHITE, 43);
    mtb_KRKP->Add (B5, C5, WHITE, 70);
    mtb_KRKP->Add (B5, A6, WHITE, 18);
    mtb_KRKP->Add (B5, B6, WHITE, 50);
    mtb_KRKP->Add (B5, C6, WHITE, 52);
    mtb_KRKP->Add (C5, B4, WHITE, 66);
    mtb_KRKP->Add (C5, C4, WHITE, 51);
    mtb_KRKP->Add (C5, D4, WHITE, 68);
    mtb_KRKP->Add (C5, B5, WHITE, 55);
    mtb_KRKP->Add (C5, D5, WHITE, 54);
    mtb_KRKP->Add (C5, B6, WHITE, 25);
    mtb_KRKP->Add (C5, C6, WHITE, 43);
    mtb_KRKP->Add (C5, D6, WHITE, 51);
    mtb_KRKP->Add (D5, C4, WHITE, 74);
    mtb_KRKP->Add (D5, D4, WHITE, 69);
    mtb_KRKP->Add (D5, E4, WHITE, 80);
    mtb_KRKP->Add (D5, C5, WHITE, 63);
    mtb_KRKP->Add (D5, E5, WHITE, 59);
    mtb_KRKP->Add (D5, C6, WHITE, 32);
    mtb_KRKP->Add (D5, D6, WHITE, 45);
    mtb_KRKP->Add (D5, E6, WHITE, 46);
}

//////////////////////////////////////////////////////////////////////
//
// KPKP

static const byte mtbdata_KPKP[12152] = {
    1,74,0,157,0,80,21,140,2,85,28,196,1,190,6,9,10,0,8,26,42,16,0,40,0,
    32,24,170,0,168,98,0,160,192,0,15,6,64,85,21,160,0,77,0,64,21,85,84,
    16,143,16,89,85,80,66,21,70,5,79,77,85,85,9,7,85,5,85,5,64,5,133,30,
    128,2,136,65,165,16,5,84,1,47,75,42,84,36,41,84,37,137,8,84,9,31,12,
    80,203,9,143,14,11,47,31,80,169,16,170,28,87,137,4,41,80,160,28,128,
    143,12,7,31,14,1,13,170,2,168,2,160,2,170,214,160,0,56,192,2,168,92,
    160,73,192,0,184,128,76,0,77,143,14,6,143,16,0,10,160,110,10,170,162,
    0,11,168,5,129,20,0,191,160,12,128,9,129,24,13,146,49,142,28,0,12,1,
    1,0,64,5,64,21,64,0,40,166,0,21,80,1,0,6,170,84,8,170,84,21,84,0,6,
    170,86,68,170,86,138,2,90,170,90,74,106,49,170,106,149,137,8,145,0,
    66,160,66,148,133,12,66,10,168,32,0,114,80,142,85,49,64,85,68,192,0,
    63,8,135,4,95,170,86,225,0,0,36,128,2,128,16,32,84,59,106,60,170,60,
    170,55,85,87,85,101,224,8,69,15,9,170,130,14,133,4,173,208,13,129,2,
    84,5,106,160,16,96,80,85,38,85,34,64,38,86,34,170,123,38,90,34,0,37,
    161,10,69,160,0,247,29,133,2,129,20,193,13,21,165,3,162,16,225,2,160,
    34,114,5,90,149,106,128,151,38,0,106,149,1,0,12,161,2,110,144,0,106,
    160,8,1,5,160,0,131,10,129,2,61,85,85,21,112,23,136,46,32,149,134,69,
    130,50,170,86,149,86,228,29,132,66,55,149,90,128,166,16,115,160,38,
    132,48,191,134,16,133,10,5,162,0,130,24,129,2,97,130,79,118,35,32,225,
    15,133,28,32,160,166,62,51,223,160,166,16,35,160,54,36,54,39,141,51,
    133,8,10,80,5,162,0,133,2,8,92,130,97,21,70,40,225,13,131,42,64,168,
    119,86,168,29,164,16,131,16,168,160,0,51,124,67,168,80,51,73,17,131,
    6,170,23,74,170,74,42,160,113,5,129,52,129,2,93,0,42,128,115,21,122,
    132,56,36,170,189,136,14,34,82,44,162,16,131,16,225,0,170,192,2,153,
    0,1,1,0,160,90,149,90,0,90,0,160,80,165,0,149,140,2,170,106,170,106,
    165,0,1,64,3,170,90,0,88,187,136,4,17,82,139,6,90,145,0,98,229,7,132,
    128,8,17,138,138,10,0,20,160,5,86,85,86,85,84,0,164,0,85,28,20,1,85,
    17,192,0,31,8,135,4,170,58,90,86,85,128,13,134,8,130,22,64,140,16,169,
    170,108,170,103,165,209,8,84,5,82,8,149,192,0,21,15,9,169,86,0,191,
    84,133,4,105,48,162,13,37,160,16,2,94,21,86,18,0,136,40,17,161,2,20,
    239,106,18,163,16,165,10,21,160,0,29,133,2,51,129,20,1,84,80,36,149,
    86,196,13,111,37,90,52,37,106,32,166,16,45,62,128,6,85,170,18,1,224,
    27,160,0,18,122,84,21,136,2,192,28,132,20,3,1,134,38,15,169,86,169,
    86,0,166,16,129,50,112,185,88,130,66,106,112,4,132,48,170,128,199,4,
    128,20,160,0,10,80,5,114,130,22,27,0,8,80,21,2,133,2,32,225,13,185,
    133,26,0,128,77,165,16,131,82,90,128,188,22,131,16,128,22,71,19,130,
    6,74,12,170,74,42,64,5,162,0,131,8,138,27,90,40,64,21,18,133,2,32,137,
    96,99,64,160,225,13,70,170,90,160,193,96,198,9,164,16,131,16,170,106,
    160,52,67,55,170,170,160,52,132,4,42,160,0,131,34,118,134,2,168,57,
    16,63,15,66,137,14,48,232,74,12,162,16,151,0,168,34,1,0,160,106,165,
    106,2,104,0,129,64,165,0,149,106,85,106,168,106,20,135,2,170,106,170,
    138,4,170,146,0,10,100,168,0,52,33,170,98,139,6,170,232,74,108,41,49,
    138,229,7,0,0,4,160,90,165,74,85,65,136,16,90,5,85,89,85,81,1,80,163,
    0,85,3,20,5,84,69,84,5,84,229,1,129,31,0,7,169,106,89,85,1,64,14,135,
    8,169,170,168,170,240,12,140,24,135,16,169,165,66,5,71,86,208,8,81,
    21,202,73,161,2,15,9,165,90,0,80,133,4,246,165,192,0,0,164,16,0,86,
    2,118,88,170,90,13,170,2,37,149,86,227,169,2,35,165,10,85,84,85,30,
    155,134,2,128,20,5,80,160,0,21,90,18,188,114,18,106,180,13,9,135,56,
    0,170,203,66,1,115,169,86,160,0,82,1,145,97,128,10,86,165,130,32,85,
    80,85,108,137,2,85,133,28,67,5,134,38,128,42,90,118,1,88,21,129,50,
    128,16,104,23,132,48,204,168,21,50,74,42,50,17,169,140,90,161,0,41,
    64,21,34,133,2,33,108,64,85,132,36,67,129,192,13,73,0,95,82,0,11,90,
    133,46,129,16,160,16,198,32,223,52,70,130,86,42,160,0,137,90,128,2,
    149,36,10,50,106,42,106,160,60,128,61,199,66,224,13,54,170,106,128,
    193,96,25,142,164,16,131,16,170,170,128,68,21,144,0,138,2,137,4,170,
    170,168,60,160,47,30,176,10,44,42,44,98,1,9,0,64,5,0,154,0,64,21,194,
    140,2,251,1,31,15,0,10,0,8,232,1,138,42,160,0,40,0,32,22,170,80,56,
    168,0,160,192,0,133,8,140,16,80,21,130,80,169,16,85,80,0,80,85,105,
    26,81,0,80,1,47,58,156,0,85,96,186,21,160,0,0,128,15,1,240,1,84,0,222,
    64,128,13,2,21,192,2,143,16,82,81,3,192,5,15,75,129,14,9,85,5,85,5,
    125,80,5,133,30,128,2,1,163,16,33,1,64,24,1,31,63,42,84,41,84,37,64,
    64,5,162,0,0,64,85,85,10,92,84,9,96,21,66,87,23,10,112,80,9,10,139,
    14,15,30,42,80,42,90,80,169,80,170,76,137,4,41,128,8,174,160,76,128,
    5,64,139,12,141,14,143,16,14,0,170,64,170,2,168,2,160,2,245,170,160,
    0,4,129,4,192,2,168,28,160,174,25,192,0,128,28,0,19,141,12,31,13,1,
    0,160,106,165,106,170,106,149,64,106,160,160,0,0,64,0,64,149,16,90,
    149,90,170,192,0,128,90,0,145,80,1,170,86,0,82,21,82,255,227,1,134,
    2,68,80,224,5,90,224,9,128,8,130,23,145,0,106,149,66,160,66,225,11,
    66,0,64,18,170,170,10,168,160,0,221,0,80,129,16,165,44,1,38,85,12,161,
    14,21,86,0,84,3,34,86,236,149,228,1,128,2,1,90,136,4,1,106,69,149,88,
    10,170,170,98,12,138,71,5,85,148,0,64,85,68,192,0,31,8,41,71,170,86,
    225,0,0,164,0,106,85,215,1,128,2,117,85,18,106,136,38,146,0,106,22,
    90,3,25,101,192,0,69,31,9,247,170,130,14,133,4,208,13,97,84,21,161,
    16,118,80,80,22,112,16,64,136,54,17,221,170,22,34,168,32,21,161,10,
    69,251,160,0,29,133,2,129,20,193,13,21,165,3,240,162,16,2,160,34,226,
    13,5,90,149,106,203,128,36,2,106,149,1,0,12,238,161,2,0,161,8,1,5,160,
    0,241,17,131,2,60,85,85,21,112,23,133,46,225,33,170,119,85,149,69,226,
    15,128,66,86,68,129,16,255,131,88,164,16,113,130,92,68,134,48,36,130,
    22,114,130,10,5,162,0,134,2,17,84,21,86,236,32,225,15,133,28,80,160,
    164,16,132,82,86,199,160,52,67,149,90,160,52,68,248,129,92,50,132,80,
    130,16,33,135,8,10,80,198,5,160,0,135,2,8,80,21,112,7,142,40,138,14,
    168,86,168,13,82,133,16,238,168,16,81,101,168,112,1,27,0,168,170,1,
    0,160,106,165,106,170,106,0,8,106,128,106,0,64,161,0,149,106,189,149,
    138,2,170,224,1,17,0,19,90,25,0,74,170,72,35,22,64,10,226,5,129,6,9,
    145,0,106,170,66,10,4,170,170,10,138,10,0,66,160,0,90,165,90,149,90,
    0,90,0,186,80,163,0,149,224,1,25,142,16,86,162,14,199,88,134,4,1,90,
    170,82,139,6,72,104,147,0,98,134,22,3,138,133,16,85,85,2,165,86,85,
    86,85,84,0,164,0,142,85,4,1,85,17,192,0,15,8,135,4,25,170,90,86,85,
    160,13,132,8,170,85,95,130,22,64,134,16,86,147,14,136,38,147,16,71,
    42,209,8,84,5,8,149,192,0,21,15,9,87,169,86,0,84,133,4,105,48,194,13,
    255,37,160,16,2,21,34,176,13,135,54,17,187,161,2,4,106,2,83,165,10,
    21,160,0,204,13,133,2,129,20,1,84,96,52,149,219,86,228,29,53,90,68,
    53,106,48,254,164,16,15,0,162,6,2,17,224,27,160,0,2,122,84,21,136,2,
    192,28,132,20,19,1,134,38,15,169,86,169,86,0,166,16,225,15,0,243,102,
    114,161,50,20,134,48,170,128,18,140,130,20,160,0,10,80,5,2,133,2,8,
    110,80,21,2,37,32,225,13,133,26,0,231,128,45,164,16,132,82,90,128,20,
    36,248,129,106,18,132,80,130,16,17,132,6,74,170,24,74,42,64,5,160,0,
    133,8,138,90,54,40,64,21,48,135,2,32,135,56,98,143,160,138,14,170,90,
    160,194,96,8,162,16,26,133,16,170,106,160,66,151,0,160,66,1,32,160,
    170,145,0,0,168,0,170,178,0,2,128,140,2,242,1,170,2,44,20,170,170,10,
    168,36,106,160,0,42,55,170,34,42,51,37,2,6,145,0,196,13,240,7,5,160,
    106,165,96,2,32,104,0,64,99,149,106,149,106,23,85,106,168,106,5,85,
    129,10,136,4,89,142,16,90,162,14,98,38,130,6,170,74,209,108,39,147,
    0,138,244,15,0,165,90,16,160,0,74,85,65,134,14,85,149,90,5,85,89,85,
    81,1,80,51,85,3,20,5,84,69,84,5,84,229,1,129,31,0,135,4,169,106,89,
    85,1,64,6,133,8,169,86,169,170,168,193,39,133,16,212,90,147,16,77,5,
    71,86,208,8,81,229,21,73,161,2,31,9,165,90,16,80,123,133,4,165,192,
    0,16,164,16,16,86,18,238,4,16,2,25,170,18,3,17,227,169,18,3,165,10,
    85,84,85,30,155,134,2,128,20,5,80,160,0,21,90,18,190,50,18,106,212,
    13,25,132,56,224,15,16,121,170,66,17,49,128,40,160,6,169,82,200,17,
    49,128,10,86,165,130,32,85,80,182,85,137,2,85,133,36,35,5,134,38,161,
    26,118,1,88,117,192,9,225,73,104,117,134,48,194,168,35,130,18,74,170,
    74,42,130,16,17,5,64,169,90,163,0,41,64,21,141,114,133,2,33,64,85,130,
    36,21,129,138,192,13,25,0,82,0,27,90,131,46,127,169,106,129,16,160,
    16,196,32,133,88,128,106,18,124,132,86,42,160,0,135,104,130,2,147,36,
    20,106,43,42,106,160,28,128,29,66,136,96,120,112,128,194,96,24,162,
    16,133,16,170,170,128,128,34,1,69,0,159,0,81,10,0,8,232,1,42,16,160,
    0,40,0,32,245,1,64,5,64,132,5,217,5,64,21,64,21,56,85,37,64,0,64,249,
    3,85,65,140,2,69,225,123,143,16,30,224,15,26,85,85,21,80,224,160,0,
    224,2,128,11,64,85,85,85,80,33,0,80,85,9,81,0,80,1,250,7,140,20,143,
    32,31,156,0,128,12,64,21,112,111,0,84,113,242,1,84,0,224,16,1,235,129,
    20,129,16,130,33,111,75,21,6,5,15,9,226,114,143,14,11,15,12,67,9,85,
    5,224,12,250,5,133,30,128,2,33,161,16,35,1,40,224,1,47,29,13,47,0,42,
    84,41,84,49,37,80,5,162,0,129,2,10,84,9,227,32,130,65,40,7,10,80,9,
    134,64,163,17,143,30,26,170,2,168,0,160,192,0,0,99,42,80,42,80,169,
    64,165,118,64,170,161,81,128,76,133,2,168,161,97,116,13,41,64,37,64,
    160,132,80,21,128,48,228,15,42,64,143,28,10,143,16,14,1,5,0,64,5,64,
    0,160,0,21,137,226,0,128,1,80,21,80,137,2,0,84,128,0,63,9,160,90,160,
    90,42,64,128,42,54,168,106,170,106,170,64,40,170,64,149,52,170,145,
    0,66,170,8,66,149,66,160,66,54,10,170,19,10,128,10,168,64,0,0,129,16,
    157,161,16,133,8,85,85,66,194,0,34,85,224,162,14,135,2,225,1,41,80,
    160,90,170,97,90,42,38,130,16,106,170,80,149,250,36,130,14,160,16,106,
    16,43,5,38,229,80,34,195,16,161,0,85,85,19,21,70,131,15,84,128,2,84,
    168,86,57,81,74,170,90,53,168,85,82,106,86,218,86,21,4,90,21,3,85,150,
    0,57,64,85,68,192,0,95,8,135,4,168,86,195,225,0,128,19,160,0,85,85,
    106,85,65,207,33,68,162,16,149,106,70,116,6,171,20,9,101,192,0,69,15,
    9,170,130,14,223,133,4,208,13,129,2,84,69,161,16,32,194,51,217,224,
    15,66,48,64,22,2,160,170,187,22,2,168,0,21,161,10,69,160,0,247,45,133,
    2,129,20,225,13,37,165,35,160,16,225,36,160,34,227,67,20,90,149,106,
    128,159,2,20,106,149,17,224,61,26,160,2,223,129,10,161,8,17,5,160,0,
    135,2,160,81,96,199,119,133,46,225,33,170,85,149,52,130,48,57,160,12,
    149,86,52,226,15,128,16,90,128,223,162,16,19,129,34,160,50,136,48,36,
    163,22,123,129,10,5,160,0,136,2,4,69,32,4,113,69,160,162,16,0,162,28,
    149,86,160,223,18,227,15,113,160,18,83,98,66,128,134,80,18,168,170,
    1,91,0,159,0,14,64,160,0,9,80,16,1,143,2,9,128,106,128,106,168,0,168,
    46,70,160,170,0,2,17,67,241,1,75,170,10,49,138,10,131,12,5,32,179,226,
    12,34,21,34,7,85,85,199,1,122,34,84,162,14,7,225,1,9,64,128,16,96,106,
    168,86,114,170,170,66,170,224,66,67,243,1,23,85,85,5,80,49,37,80,21,
    227,8,160,0,85,85,21,188,0,39,69,28,128,18,163,16,134,6,0,52,80,160,
    90,9,18,106,5,160,216,86,164,14,21,90,53,21,85,85,62,37,84,85,160,0,
    128,11,64,113,147,0,56,1,85,17,192,0,15,8,135,4,160,90,207,84,224,16,
    133,8,168,85,130,16,164,35,96,233,164,16,6,20,7,165,209,0,84,5,82,8,
    149,192,0,21,15,9,169,86,0,191,84,133,4,105,112,226,13,5,160,16,197,
    51,246,224,15,100,195,73,82,18,138,161,2,52,247,106,50,17,131,12,161,
    10,21,160,0,109,153,133,2,129,20,1,84,48,228,5,149,86,173,132,46,128,
    8,170,49,90,229,67,132,16,106,245,80,162,16,95,2,162,6,2,5,2,169,157,
    160,0,2,84,21,136,2,162,63,104,1,7,134,38,169,86,169,86,0,164,16,226,
    9,126,160,12,0,36,228,15,160,0,128,16,160,14,136,48,112,170,128,128,
    2,128,6,163,20,86,10,80,219,5,112,55,8,130,81,55,32,132,14,121,21,128,
    29,162,16,16,163,28,90,128,188,82,229,15,170,128,115,1,134,80,130,16,
    128,0,170,1,0,32,0,32,0,160,2,160,88,2,0,159,0,38,64,160,0,143,2,10,
    170,0,129,170,137,12,128,170,168,170,168,10,219,17,165,2,143,16,12,
    85,45,157,2,80,172,14,188,225,1,172,16,160,48,106,50,133,10,37,8,64,
    165,66,165,66,132,7,64,85,7,85,21,64,149,64,85,36,129,2,188,199,1,161,
    0,21,92,128,18,163,16,134,6,0,52,64,128,106,42,81,170,21,128,228,90,
    34,112,133,8,165,82,160,0,66,64,85,65,134,14,85,149,80,85,81,28,85,
    81,1,80,113,49,147,0,5,14,84,69,84,5,84,39,61,135,4,4,129,106,81,85,
    1,64,133,8,161,125,86,161,129,16,164,35,0,164,16,13,5,78,7,86,208,0,
    81,21,9,161,2,47,9,87,165,90,16,80,133,4,165,192,0,16,190,162,16,18,
    86,18,98,224,15,20,6,14,90,165,90,170,74,1,17,3,243,169,2,17,132,12,
    209,0,84,85,14,155,134,2,128,20,5,80,160,0,5,90,2,0,160,16,85,85,169,
    86,169,86,168,212,106,229,67,8,168,5,170,0,170,178,66,1,5,2,161,6,169,
    82,1,137,21,2,165,86,165,130,32,85,80,182,160,0,135,2,85,133,36,99,
    5,134,38,161,26,107,1,88,163,16,226,9,106,128,16,104,212,81,228,225,
    13,146,0,80,48,85,85,162,2,74,36,170,74,42,20,169,90,163,0,41,110,64,
    21,80,135,2,33,224,82,80,118,205,129,132,14,37,0,82,160,81,41,90,63,
    131,58,169,106,129,16,160,16,194,32,229,15,0,0,18,1,69,0,159,0,99,10,
    0,8,175,5,21,85,84,141,2,1,44,5,44,21,143,16,28,85,42,85,5,64,161,0,
    1,192,0,0,96,27,85,85,21,64,1,39,85,130,1,95,40,65,44,69,42,140,20,
    143,16,22,17,17,132,10,85,21,80,17,5,80,0,176,16,81,85,129,1,89,81,
    0,80,251,1,87,139,20,143,16,29,142,46,148,0,21,160,0,175,208,47,245,
    1,84,81,0,0,131,20,129,16,251,225,16,63,0,255,47,19,63,21,161,16,147,
    0,5,63,9,241,131,15,43,141,12,143,2,8,133,14,9,85,5,235,162,0,103,163,
    16,69,1,56,1,63,9,163,243,47,123,42,0,40,0,32,31,3,1,131,12,42,84,41,
    84,37,84,5,139,0,19,10,84,9,16,21,0,140,25,135,16,10,80,9,134,64,225,
    14,10,81,64,9,15,23,170,98,168,0,160,0,192,0,0,0,1,4,0,64,5,64,0,153,
    0,80,90,21,80,138,2,84,160,0,31,10,80,32,96,0,42,32,3,128,106,128,106,
    82,170,0,33,128,18,160,170,96,129,2,33,128,2,160,2,0,0,34,241,1,170,
    10,33,128,10,168,32,52,80,85,5,161,16,32,21,226,0,85,105,85,21,97,130,
    2,1,64,85,85,240,162,14,38,226,1,41,129,16,80,42,64,160,42,37,64,0,
    106,170,64,170,96,64,149,18,2,170,170,66,170,3,66,149,66,161,66,1,64,
    243,1,95,3,169,160,0,85,2,161,16,5,20,123,192,0,1,112,0,19,128,2,5,
    80,129,132,18,9,80,160,90,170,90,42,132,6,98,106,170,80,149,2,160,192,
    86,164,14,80,165,66,5,64,170,251,90,165,16,5,161,48,161,0,5,80,2,192,
    65,3,21,21,84,69,84,5,143,84,130,2,84,168,86,33,160,21,34,36,1,170,
    90,37,168,85,2,106,57,149,80,21,160,9,0,166,16,165,86,158,2,54,169,
    90,1,151,0,210,13,127,9,153,69,166,1,168,86,130,37,228,1,106,85,240,
    225,10,144,1,226,17,128,16,162,16,149,106,21,48,81,85,85,224,15,22,
    165,70,5,198,84,2,20,169,26,169,225,6,146,0,191,101,207,15,13,170,234,
    1,246,6,68,81,167,5,243,162,0,49,224,41,52,66,165,170,22,60,34,169,
    170,23,171,10,159,0,0,139,20,90,115,85,165,29,162,34,24,90,149,64,47,
    24,106,149,17,0,28,244,26,161,8,219,173,26,143,2,10,161,12,149,232,
    3,65,149,164,16,247,227,15,128,16,114,5,129,34,165,32,138,48,0,160,
    0,1,91,0,159,0,14,64,160,0,9,80,16,176,143,2,10,130,6,168,16,4,170,
    0,170,101,170,2,19,241,1,128,170,32,10,36,3,138,10,255,13,1,85,21,138,
    2,85,253,85,171,16,80,171,14,225,1,89,225,5,64,248,136,16,96,144,0,
    75,84,65,85,85,113,5,64,161,0,131,7,240,1,85,21,64,235,33,135,2,4,34,
    5,225,1,84,162,14,112,16,16,128,5,132,18,105,64,128,106,49,168,106,
    168,103,35,66,170,66,49,97,128,90,243,1,129,16,154,10,21,4,146,12,5,
    80,37,80,21,192,8,64,246,85,240,5,161,16,224,1,23,69,60,118,8,80,21,
    81,21,80,18,80,160,244,90,17,176,1,18,34,106,21,160,134,86,164,14,66,
    85,84,85,1,166,16,67,154,90,3,85,85,37,84,192,3,180,211,7,152,0,81,
    28,13,21,166,1,160,179,90,240,7,85,193,8,1,168,85,129,16,206,149,8,
    112,164,16,85,68,192,3,17,36,69,154,26,131,24,85,85,165,206,11,149,
    47,207,15,13,169,86,233,1,105,58,64,80,220,21,224,15,68,85,224,29,52,
    66,154,248,170,23,246,5,175,10,3,159,0,0,139,20,105,85,170,149,136,
    18,170,161,0,90,60,106,32,255,170,224,1,43,132,48,162,6,233,27,16,234,
    29,127,143,2,14,86,128,34,166,16,225,15,128,16,84,100,224,160,0,145,
    3,23,113,149,170,1,67,0,146,0,160,2,160,2,163,1,112,15,31,64,160,0,
    143,2,10,141,12,168,0,168,115,168,10,51,143,4,3,12,85,85,79,15,226,
    171,14,225,1,174,16,90,168,168,170,135,16,12,85,85,5,0,32,116,144,7,
    85,62,85,85,21,185,9,128,2,151,14,36,168,16,163,21,225,1,80,165,14,
    64,0,85,133,18,7,41,0,0,170,160,170,131,12,18,192,129,16,82,19,85,85,
    37,64,165,40,66,165,66,209,11,80,34,21,64,60,149,64,85,210,13,51,193,
    1,161,0,68,230,85,130,20,140,16,166,16,64,85,147,4,112,90,128,106,212,
    21,65,130,2,97,170,53,97,128,90,66,16,85,81,85,1,35,129,4,165,82,161,
    0,85,85,84,227,13,59,144,0,149,80,192,3,177,0,58,69,140,2,152,62,150,
    8,129,106,194,7,20,161,86,28,161,170,161,170,21,128,16,164,16,85,231,
    17,131,4,85,151,0,149,86,206,11,175,2,0,63,26,165,90,234,1,202,3,0,
    160,16,85,226,224,15,4,227,31,193,7,165,90,170,138,8,62,149,86,169,
    141,12,207,31,14,138,20,224,5,136,10,95,169,86,160,0,106,143,16,1,212,
    12,225,15,64,199,168,8,162,6,136,2,165,86,165,139,12,63,14,43,160,26,
    85,89,232,9,106,128,16,105,227,1,192,194,13,146,0,0,169,1,85,0,159,
    0,141,85,141,2,1,28,5,122,28,21,28,157,8,141,10,92,85,92,255,85,12,
    32,170,16,32,10,32,10,212,141,20,143,16,0,80,64,161,0,1,192,0,0,154,
    64,97,21,64,49,87,85,128,1,175,0,89,65,28,69,26,139,20,143,16,23,136,
    97,132,10,85,21,80,97,5,80,88,0,80,19,85,161,1,25,81,0,125,80,1,23,
    139,20,139,16,143,62,30,150,0,21,167,160,0,248,1,84,17,0,84,85,97,235,
    225,16,95,0,140,56,95,43,21,230,1,5,31,9,143,129,15,29,10,0,8,130,1,
    245,47,133,2,199,149,0,5,135,14,9,85,5,160,0,9,93,139,16,1,104,1,111,
    9,243,47,11,42,24,64,40,0,32,230,15,87,1,5,0,64,5,64,0,144,0,42,139,
    160,0,2,80,21,80,138,2,84,16,105,63,10,80,16,57,64,16,0,170,100,2,128,
    49,144,1,170,2,3,128,10,2,160,2,128,170,144,0,10,3,3,128,10,168,10,
    80,85,5,164,16,51,244,7,85,21,116,83,85,85,165,14,239,143,2,4,130,16,
    128,6,90,64,88,16,32,221,11,20,1,85,32,18,160,0,21,255,192,0,129,2,
    66,40,162,14,38,226,1,41,16,50,42,64,42,5,64,128,106,3,170,106,170,
    64,170,64,149,3,0,83,66,170,66,149,66,160,66,127,128,90,243,1,141,16,
    17,133,14,20,194,0,240,98,195,14,135,2,19,87,80,160,90,48,170,90,42,
    86,50,106,170,80,159,149,2,160,86,164,14,21,102,21,222,193,64,161,0,
    21,80,18,195,16,131,18,83,198,21,192,0,132,2,84,168,86,121,17,75,170,
    90,5,168,85,18,106,22,31,86,160,66,168,162,5,85,19,151,0,236,244,13,
    31,7,244,35,193,12,86,131,19,19,106,243,85,225,10,97,132,16,162,16,
    149,106,33,245,224,15,54,38,52,41,101,207,15,13,170,63,136,14,85,85,
    208,13,130,33,21,1,161,49,249,163,5,162,0,97,144,22,52,114,160,170,
    190,228,15,100,168,209,10,170,10,159,0,8,129,20,89,224,165,93,160,34,
    90,90,149,106,128,144,106,8,106,149,15,1,1,93,0,148,0,168,160,0,9,134,
    2,64,188,16,57,80,16,63,10,141,6,34,170,200,2,67,147,3,170,10,37,138,
    10,34,80,85,5,138,15,64,85,21,122,127,85,85,165,10,102,164,14,15,4,
    226,5,128,6,149,143,16,7,176,3,170,170,87,85,92,85,255,144,0,169,16,
    129,2,41,50,168,14,228,1,57,255,34,133,16,0,240,15,144,0,36,0,33,221,
    20,1,16,64,161,0,131,7,2,64,230,65,135,2,197,10,5,0,84,162,14,224,1,
    224,16,3,163,16,7,64,128,106,168,97,106,168,7,146,14,170,66,170,66,
    54,1,128,90,243,1,129,16,154,66,96,25,80,37,80,21,192,8,244,13,85,21,
    177,224,1,39,69,76,102,80,21,81,26,36,80,160,90,33,244,7,85,50,145,
    106,37,160,86,164,14,66,85,84,147,2,70,154,90,165,6,37,84,193,3,233,
    150,8,148,0,244,11,15,7,21,166,1,160,90,103,240,7,85,193,8,1,168,85,
    129,16,149,8,156,112,164,16,85,68,192,3,17,36,154,169,26,133,8,165,
    206,11,149,207,15,13,169,86,126,233,1,105,58,64,80,21,224,15,68,231,
    85,128,64,52,66,154,170,23,246,5,197,175,10,3,159,0,0,139,20,105,85,
    149,136,18,170,222,161,0,198,43,52,106,48,128,14,228,15,52,1,67,0,148,
    0,160,2,160,2,197,1,115,143,2,27,64,160,0,47,10,143,8,3,168,10,51,17,
    143,4,0,64,85,21,249,6,0,85,85,241,250,1,47,2,164,14,47,4,143,16,14,
    85,85,5,127,122,85,94,59,47,3,8,228,1,25,154,140,12,241,15,168,170,
    119,161,16,32,132,4,254,64,66,7,35,151,14,36,8,226,1,240,80,165,14,
    131,4,55,68,0,0,170,120,160,170,135,12,130,16,50,133,10,37,64,24,165,
    66,165,66,208,47,148,0,21,64,61,149,64,85,192,8,69,193,1,161,0,68,204,
    227,3,140,16,166,16,64,85,147,4,16,128,233,106,66,148,0,2,170,69,128,
    90,146,2,16,85,81,163,2,165,82,161,0,39,85,85,84,150,14,149,80,193,
    3,244,3,115,150,0,69,140,2,126,150,8,129,106,194,7,3,36,161,86,161,
    170,161,170,37,153,128,16,164,16,85,17,107,23,149,86,207,206,11,175,
    2,0,26,165,90,234,1,202,3,0,228,160,16,85,224,15,4,85,1,197,7,165,71,
    90,170,138,8,149,86,169,141,12,207,31,14,202,138,20,224,5,136,10,169,
    86,160,0,106,143,16,1,0,169,1,4,0,64,5,64,0,144,0,8,103,0,10,160,0,
    0,64,21,140,2,16,118,57,80,16,63,10,130,6,42,52,160,2,38,170,0,170,
    176,0,0,168,192,2,97,64,128,170,144,0,10,170,2,168,2,68,170,2,129,3,
    0,80,5,80,0,17,64,9,64,10,161,7,64,21,80,222,1,135,2,130,12,84,63,13,
    132,6,164,2,0,255,42,52,112,160,16,137,16,241,1,144,0,68,45,16,84,5,
    162,0,1,131,9,192,11,21,100,17,85,7,18,85,9,11,84,60,9,80,10,5,130,
    1,1,164,2,64,115,128,106,136,16,224,35,128,14,0,168,192,18,193,163,
    20,128,15,72,85,85,0,85,5,55,160,0,69,85,131,11,129,2,21,48,128,1,192,
    86,49,10,84,168,86,169,86,204,10,164,17,161,16,170,90,134,16,1,64,110,
    170,106,80,133,18,80,177,48,192,13,85,243,66,67,132,32,156,0,144,13,
    85,64,209,0,252,161,14,130,15,129,2,130,16,133,17,160,0,65,170,134,
    86,135,20,10,80,169,90,224,13,132,18,7,42,84,42,64,169,106,16,69,13,
    160,16,168,170,42,0,70,80,168,215,81,130,32,145,0,80,192,0,69,160,0,
    165,15,245,129,2,169,17,97,129,13,3,64,64,1,204,132,51,132,16,128,52,
    170,90,229,51,80,84,247,41,192,32,226,47,225,15,160,0,169,16,128,82,
    53,5,66,169,225,64,120,81,18,69,247,132,14,157,0,129,4,133,32,19,65,
    138,52,16,230,192,32,133,68,18,32,138,106,129,84,20,182,80,146,95,0,
    227,15,64,74,129,2,41,255,64,40,51,43,225,48,42,162,16,24,130,163,81,
    23,80,138,106,128,106,24,208,66,162,95,23,10,241,1,1,0,0,80,5,80,0,
    0,8,37,0,10,0,148,0,80,21,139,2,84,131,160,0,31,9,160,90,160,90,42,
    18,1,163,2,168,106,170,106,170,0,168,160,18,81,170,1,2,168,2,170,48,
    2,42,0,33,50,10,168,10,196,170,16,33,0,84,5,16,1,75,64,0,20,21,84,16,
    85,39,33,130,14,85,9,11,84,9,64,10,7,5,80,160,90,170,90,1,163,2,50,
    130,16,106,169,103,164,16,170,2,36,200,2,3,102,85,5,160,0,69,85,75,
    0,80,68,85,21,64,85,24,129,65,26,84,168,86,169,86,10,80,21,84,50,80,
    53,0,84,42,165,64,48,106,21,170,80,164,16,66,56,163,2,170,66,119,50,
    156,0,85,85,255,64,224,13,49,163,29,129,2,34,116,225,17,33,1,170,86,
    135,20,10,80,169,90,125,135,18,42,160,16,2,18,48,96,168,250,145,14,
    21,32,1,19,161,13,80,192,0,254,69,193,32,2,99,82,72,131,33,65,176,64,
    160,0,1,195,17,132,18,10,85,9,57,80,170,90,193,15,17,128,16,84,41,206,
    192,32,224,13,101,80,169,112,128,48,21,107,66,169,34,23,81,18,5,132,
    14,223,157,0,129,4,75,65,232,33,50,192,32,227,31,159,52,96,138,106,
    225,67,4,226,48,128,64,215,5,66,9,64,2,5,134,14,65,247,163,65,133,2,
    12,168,16,2,84,136,48,1,193,160,66,132,64,3,64,170,0,10,170,255,128,
    80,8,161,16,132,42,130,10,161,97,136,2,84,238,71,136,48,227,1,87,84,
    16,163,16,19,171,80,16,80,24,64,16,64,16,176,128,81,132,48,2,160,80,
    144,0,1,2,0,84,5,84,1,0,152,0,32,85,21,85,137,2,170,85,170,85,129,9,
    25,86,170,86,9,0,10,12,23,90,170,90,41,16,165,2,170,5,106,170,42,168,
    0,170,86,170,106,1,2,161,0,24,10,3,42,130,14,5,5,85,69,85,0,64,5,21,
    88,128,16,85,24,0,80,26,84,168,25,86,169,86,10,6,81,169,10,3,39,42,
    64,170,106,169,42,33,221,132,18,166,16,36,2,103,34,156,0,64,145,224,
    13,33,0,80,163,0,64,85,0,228,225,1,134,2,128,18,16,170,66,135,20,10,
    33,80,169,90,7,42,84,42,64,67,16,42,22,80,170,0,168,162,16,24,20,66,
    170,2,130,2,20,85,85,175,80,128,12,69,193,32,84,161,0,3,98,193,8,16,
    84,64,85,64,85,1,129,161,1,134,18,10,85,9,80,170,74,31,8,84,41,0,12,
    194,32,8,100,94,69,81,18,5,132,14,157,0,129,4,27,216,65,193,1,25,85,
    138,32,0,42,0,254,138,212,43,4,160,16,134,48,1,82,39,224,64,18,1,133,
    2,85,85,21,84,253,21,72,28,136,50,31,4,140,32,161,82,170,246,10,160,
    16,1,130,42,130,10,5,162,0,135,2,251,21,2,23,133,66,27,130,16,84,111,
    19,229,139,32,32,144,101,144,32,10,84,133,8,5,190,16,137,2,21,16,105,
    132,78,15,11,128,16,128,80,63,25,168,1,4,96,85,101,85,0,152,0,64,80,
    85,85,138,2,170,29,86,169,86,130,10,25,90,169,10,42,0,167,2,3,170,106,
    169,42,170,0,170,23,111,1,2,161,0,24,10,115,137,11,137,16,126,160,14,
    64,22,225,1,8,49,197,9,145,0,19,10,80,169,90,169,9,42,64,0,155,160,
    16,6,0,168,84,132,2,2,2,83,70,80,128,12,69,160,0,0,80,67,240,1,114,
    8,32,6,64,85,1,33,84,0,84,135,18,10,85,9,80,1,26,84,41,0,170,42,138,
    42,218,24,196,32,22,2,101,19,81,18,249,5,132,12,244,15,150,0,129,4,
    27,65,85,102,28,85,153,41,1,42,0,12,160,16,247,10,180,34,2,68,5,64,
    2,67,7,131,2,85,85,21,80,21,56,12,236,136,50,15,4,136,66,19,0,28,160,
    16,42,169,168,131,62,1,130,10,5,162,0,0,64,125,133,2,21,98,119,5,29,
    128,16,84,211,79,19,21,69,2,67,10,84,139,8,60,63,46,42,80,15,23,143,
    6,3,47,62,15,14,1,84,0,159,0,99,42,160,0,40,179,1,64,168,5,16,0,16,
    1,16,0,64,255,21,18,135,2,23,127,5,194,8,31,13,162,2,145,25,136,16,
    80,5,2,0,80,1,95,0,0,0,21,2,55,5,52,248,227,15,63,14,160,2,52,149,0,
    143,16,5,85,85,46,0,84,5,66,1,64,240,1,16,245,21,66,19,54,19,84,31,
    7,80,249,20,135,36,43,162,16,47,2,160,14,85,5,7,160,0,21,85,65,85,64,
    241,1,156,0,143,192,10,50,85,85,1,160,5,135,2,128,14,253,16,138,36,
    139,16,160,16,90,131,51,95,1,85,91,128,15,69,130,1,80,196,14,133,17,
    81,99,166,162,0,145,0,65,24,169,86,98,194,15,6,42,80,170,90,169,90,
    128,14,20,191,42,112,41,129,30,20,70,143,64,0,156,0,238,5,169,33,7,
    135,34,32,0,161,16,6,104,80,169,16,131,64,170,162,0,169,106,175,41,
    132,30,170,82,168,166,14,137,2,135,14,234,193,27,149,0,27,131,16,1,
    104,42,160,0,217,41,162,16,99,170,33,16,170,90,0,36,66,170,66,169,66,
    169,106,80,170,106,224,13,2,3,168,2,168,96,170,170,225,15,135,2,2,170,
    0,1,5,0,64,5,64,0,160,0,1,191,0,129,1,21,0,137,2,5,79,11,153,0,170,
    77,112,42,48,40,230,1,170,34,145,168,165,2,80,5,32,0,80,1,3,32,0,80,
    0,84,21,80,33,247,135,2,192,0,2,22,129,12,80,140,16,29,153,137,20,99,
    64,41,70,28,84,5,73,162,0,1,64,0,85,64,84,21,223,66,38,19,84,140,18,
    5,70,6,234,21,7,131,32,31,5,85,192,12,5,64,15,21,85,65,85,64,48,157,
    0,160,14,63,50,85,85,128,18,56,130,20,17,135,16,245,131,2,135,32,163,
    3,135,48,79,5,85,224,14,69,125,194,13,80,196,14,229,16,131,2,226,32,
    132,3,80,32,134,18,169,86,135,36,42,80,170,90,111,169,90,128,14,132,
    16,42,160,0,130,46,75,250,196,67,140,48,156,0,131,13,137,33,119,0,86,
    153,32,80,169,86,160,1,85,80,169,163,160,16,131,68,170,162,0,169,106,
    41,163,67,189,139,14,143,32,5,64,224,47,151,0,139,2,131,16,1,171,165,
    1,224,15,42,160,0,41,136,48,170,49,96,160,16,160,17,81,66,170,66,169,
    10,66,169,106,170,106,224,1,2,99,13,168,2,168,170,170,225,95,135,2,
    2,252,113,135,12,165,14,15,8,143,16,4,225,15,65,41,112,80,160,161,16,
    82,66,66,170,106,85,168,106,192,13,10,161,0,168,48,170,208,145,0,226,
    1,130,2,42,96,2,1,1,0,80,5,80,0,80,1,0,160,0,0,80,0,84,0,84,21,114,
    80,21,138,2,224,0,31,0,64,1,0,129,0,1,80,160,90,160,90,0,1,152,0,168,
    106,170,106,170,0,40,70,22,170,97,2,168,2,165,2,50,82,10,168,64,170,
    147,2,84,5,48,147,1,48,0,85,49,21,84,49,175,39,130,14,84,140,16,84,
    55,161,16,128,20,76,21,64,50,106,41,22,34,170,50,170,66,41,27,7,85,
    5,160,0,14,21,85,65,85,64,80,159,0,0,194,14,62,84,85,85,70,82,128,20,
    130,35,19,102,160,90,52,32,168,80,20,132,2,86,170,66,147,14,42,5,10,
    165,16,3,175,85,224,14,69,162,13,80,164,14,229,16,131,2,230,227,32,
    131,3,161,2,131,16,169,86,128,36,163,0,6,80,42,80,170,90,169,160,16,
    35,1,168,64,170,64,170,106,169,106,207,128,32,101,18,42,0,70,21,249,
    54,234,150,0,129,13,137,33,71,0,70,32,64,115,169,86,160,1,130,52,64,
    80,169,160,16,134,131,36,224,15,64,170,66,169,32,227,51,77,170,2,160,
    0,10,168,243,13,21,42,189,129,2,135,32,64,224,47,151,0,43,19,1,174,
    164,1,17,42,160,0,41,129,68,33,16,250,170,17,160,16,129,65,18,160,30,
    169,112,255,170,50,225,15,130,78,52,81,16,50,186,147,16,131,12,65,224,
    48,161,65,135,2,85,224,66,237,21,120,132,82,139,16,84,225,15,49,41,
    135,135,62,51,66,170,106,128,160,16,130,30,239,131,94,162,14,65,82,
    42,180,32,136,10,161,97,249,136,2,83,24,44,194,49,47,9,64,128,220,160,
    16,40,112,160,144,65,6,18,1,4,0,84,5,84,1,160,0,0,130,85,1,85,85,21,
    84,21,138,2,0,0,84,0,84,1,80,1,80,66,0,80,161,1,0,84,168,86,32,24,64,
    1,64,0,1,224,2,170,90,48,170,90,41,37,0,170,106,170,10,106,169,0,40,
    0,149,0,170,17,16,2,168,2,170,73,10,168,10,16,170,10,170,2,146,2,85,
    5,85,14,21,85,65,85,64,0,31,2,193,14,124,85,85,135,16,130,18,160,18,
    193,15,5,169,159,90,12,106,41,135,2,147,0,11,160,16,23,5,64,85,69,130,
    13,80,132,14,229,16,243,101,227,32,129,3,163,2,33,169,86,128,36,53,
    36,42,84,34,135,18,80,44,66,190,164,14,37,10,166,16,131,32,156,0,141,
    33,21,173,0,22,32,16,169,224,48,163,0,42,102,160,14,169,160,16,8,82,
    169,64,8,77,74,169,11,42,168,196,34,133,14,65,208,40,141,2,1,1,136,
    17,42,84,42,114,84,41,129,68,164,0,32,80,169,160,16,195,160,36,16,66,
    169,66,169,224,48,123,132,16,74,96,34,209,13,128,2,42,96,215,3,132,
    64,129,12,65,224,48,5,160,81,160,10,251,36,3,39,128,1,131,30,143,16,
    3,41,135,48,10,115,66,170,106,128,161,16,80,161,61,236,168,129,78,36,
    20,42,181,34,134,10,80,223,5,162,0,135,2,21,18,39,224,13,130,62,247,
    43,143,16,7,133,48,5,160,16,0,160,14,6,219,52,132,8,194,5,5,160,0,137,
    2,21,16,250,41,130,10,41,135,16,39,127,8,2,16,192,170,24,160,16,128,
    170,1,81,0,144,0,170,162,0,40,0,42,132,209,1,143,2,13,168,2,168,2,57,
    170,181,74,16,2,17,52,106,16,10,108,1,168,51,145,0,42,1,128,7,2,226,
    42,35,51,226,4,0,64,5,16,167,42,192,5,40,211,13,64,21,16,105,131,17,
    89,168,66,168,82,170,88,119,128,16,90,161,11,6,163,16,0,19,70,146,129,
    23,25,10,168,3,80,5,162,0,34,10,64,1,162,13,0,80,21,34,200,0,134,2,
    34,84,32,88,168,82,48,168,86,160,88,16,90,42,66,195,41,5,163,16,72,
    169,64,42,162,2,107,132,14,34,19,0,2,2,138,132,32,193,128,8,50,132,
    10,85,85,0,84,21,60,161,0,85,1,162,15,1,82,122,168,55,86,0,84,24,50,
    41,163,21,129,18,113,129,16,106,100,17,227,30,66,170,66,127,82,66,52,
    98,131,10,49,192,30,82,123,159,0,0,0,162,0,163,5,132,2,160,1,1,130,
    19,148,227,2,129,16,169,90,135,20,42,192,32,169,251,106,134,18,166,
    16,4,72,133,12,5,226,30,37,115,85,85,240,32,85,21,160,0,1,94,68,64,
    82,85,137,2,80,48,135,20,223,80,130,34,132,18,42,64,80,228,55,80,119,
    64,168,208,64,86,0,168,2,134,8,87,34,5,38,64,34,21,255,33,2,132,4,246,
    2,133,34,160,0,137,52,0,84,134,66,51,57,80,169,0,16,129,64,19,66,169,
    175,178,32,23,1,28,1,24,131,2,12,251,162,16,8,128,65,10,160,81,10,64,
    0,160,160,32,6,10,1,1,0,0,64,5,64,42,0,42,37,0,40,0,148,0,64,21,140,
    2,0,4,26,168,82,168,82,170,24,170,168,90,160,0,2,24,106,64,10,170,112,
    0,168,192,4,18,145,0,42,170,2,96,168,2,225,4,4,170,170,10,168,196,10,
    32,128,5,0,80,5,96,10,101,64,1,128,13,97,21,80,1,0,38,54,0,80,0,84,
    32,40,160,16,98,86,160,40,81,42,66,41,37,134,64,82,72,169,64,42,227,
    1,147,0,171,34,134,16,2,2,138,226,15,10,144,2,73,66,5,135,10,84,21,
    161,0,85,1,225,129,15,194,15,34,138,2,168,86,0,84,171,104,162,16,41,
    101,80,130,16,106,37,139,16,195,30,66,170,66,130,18,66,4,245,37,128,
    10,113,80,162,0,85,158,0,0,247,66,128,1,162,17,130,2,112,1,131,19,66,
    41,129,16,169,90,135,20,42,192,32,169,106,237,134,18,166,16,84,24,0,
    144,11,225,11,5,197,226,30,160,17,128,12,85,85,64,192,0,21,87,160,0,
    1,52,64,130,16,85,137,2,64,175,32,135,20,80,130,34,84,161,3,64,160,
    16,247,48,193,55,32,48,64,168,208,64,225,43,189,2,16,168,18,129,30,
    130,8,66,5,89,22,64,18,21,223,33,0,20,64,85,246,18,226,5,131,36,131,
    50,38,84,132,66,37,57,80,169,0,32,224,45,36,66,169,43,192,32,42,168,
    39,1,28,1,24,255,131,2,28,162,16,24,128,65,134,48,33,192,88,247,132,
    64,35,224,104,130,98,39,2,0,132,48,255,131,58,3,135,2,163,16,87,136,
    66,82,99,183,23,72,80,130,82,71,64,82,71,0,131,114,168,0,168,1,0,0,
    80,5,80,10,64,1,65,64,0,164,0,21,80,21,80,0,4,136,2,0,84,0,84,32,24,
    168,18,86,168,86,160,24,170,90,0,80,66,41,23,106,0,74,169,64,192,42,
    21,145,0,42,168,2,170,2,99,42,0,1,34,170,170,10,65,168,146,2,128,16,
    5,89,84,48,85,1,104,80,0,53,80,0,42,168,86,86,0,84,40,80,161,16,41,
    231,1,17,197,106,24,163,14,66,170,66,36,2,117,108,84,32,193,30,164,
    0,85,156,0,0,219,82,128,1,129,17,84,130,2,0,1,226,1,74,34,84,129,16,
    169,90,135,20,42,192,32,91,169,106,134,18,80,165,16,100,66,39,180,50,
    160,10,5,193,30,224,9,5,128,10,85,85,85,64,192,0,21,160,0,1,68,64,122,
    82,85,137,2,80,48,135,20,80,130,34,247,84,161,7,80,160,16,64,64,160,
    2,160,3,135,64,80,168,170,42,170,194,57,17,117,32,168,34,160,4,18,0,
    2,5,89,6,64,2,21,189,33,6,64,85,244,2,226,5,131,36,131,50,38,84,132,
    66,81,68,0,85,34,80,169,0,32,0,100,0,68,224,37,33,66,169,192,32,42,
    59,168,0,16,194,20,130,26,75,1,56,239,131,2,60,162,16,56,84,229,55,
    4,192,88,183,162,0,5,64,227,79,8,2,0,96,255,5,225,47,1,135,2,163,16,
    87,136,66,82,221,99,23,72,80,130,82,131,62,65,64,245,82,131,96,131,
    48,134,98,128,6,80,68,80,255,161,16,137,2,97,121,130,16,24,1,25,222,
    132,80,23,35,64,4,66,98,8,1,1,0,84,5,64,1,64,0,1,166,0,21,85,21,85,
    1,80,0,24,4,85,85,0,0,137,2,168,86,65,0,84,57,170,90,170,90,41,2,57,
    106,170,106,169,64,42,134,10,138,170,145,0,66,170,66,58,10,17,132,0,
    115,84,5,80,21,134,8,0,238,85,45,129,16,224,0,84,17,2,128,1,228,1,226,
    1,3,81,169,90,71,42,161,64,64,106,5,1,80,170,0,176,163,16,70,2,5,20,
    85,5,84,238,21,160,0,128,17,130,10,64,192,0,194,32,20,191,64,18,85,
    137,2,16,160,0,135,20,224,12,98,192,13,84,161,7,32,84,42,64,32,225,
    64,193,25,130,34,160,16,168,170,42,170,102,160,2,84,193,0,192,33,2,
    168,98,160,4,213,0,226,4,130,16,5,86,64,82,21,158,174,33,85,64,85,18,
    226,5,137,52,22,88,84,41,195,29,81,161,23,16,80,169,141,0,0,0,0,68,
    193,38,193,49,169,14,192,32,42,168,0,16,163,46,129,26,11,251,1,8,131,
    2,12,162,16,8,84,229,47,102,4,80,228,45,5,64,42,196,61,6,255,2,0,225,
    31,4,225,47,3,133,2,165,16,251,5,136,66,2,21,5,120,80,130,82,190,18,
    114,64,2,20,130,48,33,131,2,127,80,42,160,0,131,88,67,119,35,55,253,
    99,55,35,55,132,80,23,99,64,235,68,4,32,73,0,136,4,64,97,255,57,33,
    57,130,94,56,33,57,225,14,224,26,97,25,143,16,1,1,8,96,85,101,85,145,
    0,1,85,248,0,162,0,5,135,2,195,2,143,4,6,5,80,80,5,80,58,64,16,85,5,
    85,5,9,84,10,84,0,84,48,0,2,16,36,5,1,168,0,170,17,2,85,5,84,5,168,
    5,164,7,251,85,143,16,15,15,12,79,3,160,16,74,0,8,99,161,2,84,9,113,
    69,85,1,225,5,175,160,0,143,14,4,0,143,4,7,69,68,54,16,101,192,2,64,
    38,19,85,169,47,9,69,239,225,8,140,28,159,0,0,133,4,69,83,192,11,68,
    42,162,16,1,80,70,84,2,64,4,62,69,5,16,10,129,2,12,157,0,162,12,123,
    84,21,130,8,71,130,32,226,1,5,83,0,133,28,85,69,84,5,80,9,80,85,10,
    80,18,84,64,84,66,64,84,6,4,12,4,7,0,146,0,170,38,0,160,2,161,0,170,
    2,192,55,130,4,45,64,0,128,128,3,106,133,56,194,4,170,243,129,2,133,
    8,192,5,160,0,55,10,170,97,7,55,42,170,42,170,106,16,132,10,165,134,
    64,143,16,5,168,82,160,2,135,14,128,82,0,64,134,6,72,140,8,104,0,82,
    222,86,136,10,49,90,136,2,162,16,141,14,138,18,140,168,57,170,2,128,
    160,0,133,4,72,109,0,26,162,3,7,42,162,8,133,2,40,254,225,1,129,38,
    137,12,160,16,10,64,142,16,12,1,8,96,85,101,85,147,0,65,85,236,64,160,
    0,7,131,2,0,16,143,4,10,5,216,80,16,226,1,1,160,5,48,64,5,0,0,5,4,1,
    1,65,0,40,8,0,42,0,106,85,112,0,5,130,36,24,84,5,168,5,164,23,190,85,
    132,16,0,130,8,197,13,143,14,0,143,4,6,82,25,80,85,85,69,39,161,16,
    1,69,219,41,137,2,161,2,84,103,161,7,69,143,28,3,248,157,0,131,4,195,
    5,136,16,162,16,104,80,5,98,64,69,192,12,138,14,0,5,85,15,8,255,68,
    114,133,8,161,9,147,0,143,2,4,192,11,10,72,128,10,84,65,1,80,4,69,5,
    47,16,69,21,192,16,21,132,14,0,138,16,128,1,24,4,69,4,16,0,4,11,0,1,
    64,0,32,131,4,64,64,94,2,0,135,6,4,209,13,36,130,42,16,36,1,168,2,69,
    69,4,160,2,5,65,168,10,133,8,69,4,1,0,65,93,137,16,4,124,4,137,32,155,
    0,3,1,88,0,128,160,14,90,133,56,176,63,0,0,228,170,129,2,132,8,49,170,
    2,135,10,5,13,0,168,10,170,10,136,12,33,64,240,133,26,136,80,44,240,
    10,144,0,162,0,170,107,2,160,162,0,227,13,1,48,128,48,217,131,42,131,
    6,129,16,170,136,2,17,170,86,157,40,16,170,90,141,12,46,137,18,168,
    7,23,162,2,168,2,128,160,0,131,4,109,129,6,20,162,3,135,8,24,17,136,
    2,40,58,192,22,170,2,10,160,16,140,14,21,143,18,14,1,8,96,85,101,85,
    147,0,64,85,193,65,192,0,9,81,85,80,85,0,168,160,0,141,4,129,228,3,
    65,64,5,64,0,5,16,1,6,1,1,65,0,8,17,0,8,0,90,129,2,0,1,168,4,120,0,
    0,36,8,84,5,47,168,1,164,7,101,134,16,131,14,159,0,10,48,133,4,1,84,
    3,70,0,5,1,47,69,0,21,21,64,10,17,9,47,160,2,1,84,7,69,162,0,135,10,
    197,1,245,133,28,153,0,130,14,134,16,132,32,69,98,0,12,134,12,80,5,
    64,65,192,12,90,0,64,5,85,15,6,4,69,0,16,0,27,4,0,1,64,135,24,128,2,
    128,96,131,132,38,16,85,4,85,1,85,133,4,184,49,97,1,137,28,161,0,135,
    6,65,21,30,5,64,69,21,120,137,16,65,31,3,175,16,22,1,34,0,139,14,144,
    65,103,35,17,85,1,6,4,5,0,145,27,2,133,8,65,4,1,0,65,21,135,18,85,1,
    4,28,4,29,4,18,0,95,6,1,128,2,128,35,131,56,241,80,35,158,132,8,1,168,
    2,39,161,16,138,12,129,32,250,64,135,10,134,80,12,157,0,135,42,128,
    160,0,217,64,136,6,113,170,137,2,64,170,86,230,88,75,143,30,5,138,18,
    168,90,209,10,144,0,3,162,0,162,2,170,2,128,160,0,253,131,4,131,6,65,
    137,8,128,16,138,2,32,2,80,140,12,5,60,21,143,18,14,1,16,16,84,21,160,
    0,85,85,0,16,84,1,84,0,0,21,85,21,246,85,145,0,133,2,210,1,56,1,0,143,
    4,10,11,16,64,16,64,80,57,0,16,2,128,1,42,80,41,80,0,80,160,2,0,0,0,
    168,0,152,0,4,170,3,2,168,2,170,2,170,86,225,15,75,137,16,85,95,13,
    85,85,95,33,0,90,247,145,0,6,128,14,12,161,16,21,15,9,81,184,193,1,
    47,5,85,81,136,2,33,85,0,168,0,22,80,18,84,27,21,84,188,5,28,21,140,
    12,153,0,161,32,7,17,88,85,81,1,80,6,192,32,21,64,82,0,64,6,80,2,0,
    40,133,32,179,64,11,17,192,4,160,16,81,21,130,4,75,143,14,2,17,129,
    12,85,85,134,18,17,80,102,55,0,192,17,160,7,80,1,3,161,0,3,80,0,64,
    42,64,41,64,132,30,172,113,49,0,38,16,39,132,2,4,91,16,1,241,18,74,
    160,21,153,0,9,209,0,44,130,4,0,1,177,1,169,38,129,8,168,192,2,130,
    2,34,170,10,168,10,170,129,10,135,10,170,42,168,106,170,42,232,104,
    147,0,21,81,170,141,16,16,0,243,80,92,43,209,32,133,6,42,1,82,80,135,
    12,1,34,90,134,2,2,168,42,30,170,106,170,106,88,146,16,88,138,32,63,
    42,1,104,176,1,71,130,38,147,0,130,22,215,131,4,242,3,133,14,0,48,2,
    134,2,224,1,120,32,74,138,12,160,16,58,47,1,1,20,16,84,21,160,0,85,
    144,0,0,95,85,1,192,0,21,0,19,131,2,23,24,83,1,84,1,226,5,143,4,6,16,
    64,35,16,64,0,160,4,4,85,0,160,5,0,80,0,16,0,0,24,0,4,0,4,1,170,0,168,
    0,170,85,93,0,0,240,0,152,71,225,15,137,16,85,63,4,0,84,130,8,196,13,
    137,4,3,79,6,8,2,64,85,85,20,9,0,16,127,4,20,7,145,0,134,2,15,2,164,
    16,140,28,215,45,133,38,28,84,28,80,16,224,16,85,22,80,18,84,23,20,
    162,16,21,31,132,6,85,85,17,2,135,2,229,17,135,4,64,161,32,84,52,17,
    85,17,84,1,192,80,55,128,16,80,0,64,21,64,213,4,224,48,132,32,64,18,
    85,54,64,128,25,130,4,16,16,4,16,1,32,24,0,40,0,42,0,112,16,0,30,4,
    0,1,0,4,17,1,137,6,4,0,4,84,1,170,2,136,42,0,16,84,5,170,10,134,12,
    16,0,64,9,84,85,170,106,169,7,0,4,123,137,16,16,23,4,16,145,35,74,239,
    44,0,27,136,18,0,0,105,135,14,17,2,50,165,115,17,10,135,10,20,0,16,
    42,165,40,27,0,128,80,168,170,8,20,111,2,80,134,12,157,0,4,226,0,135,
    18,128,24,52,32,169,86,136,2,17,90,40,42,30,168,106,170,106,40,138,
    30,47,0,29,249,10,149,1,130,22,131,4,242,3,132,6,106,0,69,0,2,138,10,
    10,170,74,138,2,42,0,111,16,1,1,16,84,21,84,6,84,85,1,144,0,68,85,0,
    85,65,85,21,173,160,0,3,0,16,1,196,1,3,64,25,128,4,1,84,1,226,5,105,
    5,86,0,135,8,16,0,0,64,0,24,0,1,4,4,1,68,0,42,0,104,98,129,2,0,41,224,
    1,168,0,152,39,175,21,128,16,5,162,10,84,108,131,14,159,0,10,36,133,
    4,5,80,135,8,16,64,0,64,11,16,4,20,1,84,7,0,135,2,45,242,1,0,0,118,
    20,86,131,24,17,255,166,16,133,18,149,0,133,36,101,132,4,192,7,131,
    16,87,132,32,80,50,0,54,80,224,13,224,16,136,54,129,2,0,0,84,22,0,20,
    4,64,5,16,16,4,16,135,22,64,8,21,16,0,4,0,136,4,0,16,54,0,6,0,135,42,
    33,4,240,48,40,118,80,5,208,24,23,145,28,0,136,6,129,16,250,85,134,
    32,129,4,102,131,8,17,80,138,12,42,0,1,64,140,2,0,29,1,136,42,161,0,
    16,5,70,16,0,64,84,143,128,36,88,0,4,85,134,64,49,6,184,52,2,0,56,1,
    27,0,0,204,170,137,14,0,170,2,135,4,1,170,150,10,23,20,0,42,4,138,32,
    129,18,62,1,68,168,106,16,240,22,206,76,133,14,243,4,241,56,178,0,133,
    6,81,168,86,136,2,33,64,168,90,88,21,42,64,105,241,57,138,30,95,2,65,
    133,14,0,0,2,254,149,1,130,22,129,4,212,3,134,6,48,209,4,135,2,48,10,
    168,74,143,14,26,65
};

static MTB * mtb_KPKP = NULL;

void initMTB_KPKP()
{
    mtb_KPKP = new MTB ("KPKP", 2, 38);
    mtb_KPKP->SetPackedData (mtbdata_KPKP);
    mtb_KPKP->Add (A2, A3, WHITE, 180);
    mtb_KPKP->Add (B2, B3, WHITE, 341);
    mtb_KPKP->Add (C2, C3, WHITE, 335);
    mtb_KPKP->Add (D2, D3, WHITE, 332);
    mtb_KPKP->Add (A3, A4, WHITE, 211);
    mtb_KPKP->Add (B3, B4, WHITE, 359);
    mtb_KPKP->Add (C3, C4, WHITE, 360);
    mtb_KPKP->Add (D3, D4, WHITE, 367);
    mtb_KPKP->Add (A4, A5, WHITE, 229);
    mtb_KPKP->Add (B4, B5, WHITE, 362);
    mtb_KPKP->Add (C4, C5, WHITE, 348);
    mtb_KPKP->Add (D4, D5, WHITE, 358);
    mtb_KPKP->Add (A5, A6, WHITE, 206);
    mtb_KPKP->Add (B5, B6, WHITE, 372);
    mtb_KPKP->Add (C5, C6, WHITE, 322);
    mtb_KPKP->Add (D5, D6, WHITE, 309);
    mtb_KPKP->Add (A6, A7, WHITE, 174);
    mtb_KPKP->Add (B6, B7, WHITE, 317);
    mtb_KPKP->Add (C6, C7, WHITE, 303);
    mtb_KPKP->Add (D6, D7, WHITE, 269);
    mtb_KPKP->Add (A5, B7, WHITE, 392);
    mtb_KPKP->Add (A4, B6, WHITE, 374);
    mtb_KPKP->Add (A3, B5, WHITE, 318);
    mtb_KPKP->Add (A2, B4, WHITE, 239);
    mtb_KPKP->Add (B5, A7, WHITE, 278);
    mtb_KPKP->Add (B4, A6, WHITE, 327);
    mtb_KPKP->Add (B3, A5, WHITE, 384);
    mtb_KPKP->Add (B2, A4, WHITE, 360);
    mtb_KPKP->Add (B5, C7, WHITE, 353);
    mtb_KPKP->Add (B4, C6, WHITE, 378);
    mtb_KPKP->Add (B3, C5, WHITE, 361);
    mtb_KPKP->Add (B2, C4, WHITE, 336);
    mtb_KPKP->Add (A5, B4, WHITE, 310);
    mtb_KPKP->Add (A6, B3, WHITE, 347);
    mtb_KPKP->Add (A7, B2, WHITE, 323);
    mtb_KPKP->Add (B5, C4, WHITE, 333);
    mtb_KPKP->Add (B6, C3, WHITE, 341);
    mtb_KPKP->Add (B7, C2, WHITE, 344);
}

//////////////////////////////////////////////////////////////////////
//
// KRPKR

static const byte mtbdata_KRPKR[17301] = {
    1,0,84,85,1,0,1,0,65,128,85,161,0,1,0,84,85,85,85,6,4,0,4,0,69,85,3,
    155,0,0,5,0,0,0,85,85,64,0,180,64,132,6,69,50,240,7,1,131,2,5,228,1,
    98,144,8,99,21,4,18,16,92,0,16,20,16,18,0,20,64,219,85,194,14,137,16,
    4,160,12,15,10,64,162,16,51,7,0,1,49,7,0,4,49,55,7,0,16,49,7,0,192,
    14,11,255,225,14,9,17,15,10,17,9,17,9,255,17,9,17,9,17,7,163,1,131,
    1,255,1,133,15,15,6,137,6,33,137,2,17,41,255,17,42,16,42,22,163,2,23,
    165,16,255,31,6,131,6,23,3,23,3,23,4,247,22,4,24,161,2,17,68,166,0,
    161,16,127,143,48,1,85,37,128,4,128,6,137,2,17,9,255,17,10,16,10,209,
    0,156,0,129,64,165,0,248,255,3,1,226,95,37,177,77,17,37,68,85,103,21,
    1,248,7,224,15,21,4,113,5,120,128,2,16,24,240,11,175,16,2,159,0,92,
    1,8,84,85,1,0,165,0,20,0,0,164,170,85,85,4,0,4,0,128,5,2,84,85,21,0,
    0,0,65,80,85,155,0,64,0,64,0,65,28,2,84,0,100,128,6,177,7,35,20,52,
    1,164,169,128,2,144,8,1,18,20,33,4,164,166,112,16,0,16,1,13,18,20,16,
    164,154,32,0,1,6,18,21,64,165,106,1,224,12,137,16,118,4,0,161,16,9,
    27,64,128,4,9,102,0,1,17,7,0,4,17,39,103,0,16,1,23,0,64,1,25,249,7,
    19,1,27,9,225,31,85,85,255,25,1,25,1,25,33,9,17,239,11,21,5,195,32,
    4,8,23,1,109,115,64,6,51,0,6,51,0,183,6,51,0,6,19,0,8,163,16,255,7,
    83,9,85,3,19,7,19,255,7,19,7,19,7,19,9,19,189,7,17,85,10,147,0,5,49,
    85,182,8,49,21,8,49,21,8,49,254,21,8,17,1,220,91,159,0,111,135,32,129,
    48,236,69,142,4,119,1,4,130,63,165,0,20,103,1,68,66,85,20,4,128,2,38,
    192,49,0,152,8,21,64,69,85,1,24,84,85,81,166,0,159,0,4,16,0,80,16,0,
    133,4,69,47,1,0,1,0,249,1,137,8,141,10,143,2,12,225,0,143,16,10,16,
    0,159,193,0,15,8,0,1,17,95,8,111,16,167,2,255,239,31,6,135,4,47,2,161,
    16,79,8,95,18,101,159,0,2,255,11,31,0,141,8,79,36,83,15,8,127,24,47,
    38,109,239,79,6,80,166,0,159,0,4,64,6,17,5,210,164,65,239,81,24,31,
    138,5,192,0,20,0,3,50,84,85,84,130,2,61,4,1,3,56,68,85,68,128,4,141,
    68,31,16,1,80,0,148,0,5,226,0,4,0,80,136,85,163,0,85,85,1,192,1,5,0,
    40,84,85,68,34,69,128,2,68,85,168,21,80,20,34,21,80,20,85,160,69,0,
    84,146,0,85,84,1,0,20,84,84,5,1,144,1,81,65,85,138,81,0,81,5,4,0,69,
    65,69,85,69,0,69,5,16,0,21,130,65,176,9,0,84,21,4,64,143,16,14,111,
    68,85,163,16,69,20,0,74,177,15,109,9,81,83,6,69,51,6,21,255,51,15,24,
    51,7,19,8,18,8,255,18,8,18,8,18,15,26,17,9,255,17,10,240,15,10,48,10,
    48,10,173,48,13,4,15,11,68,130,2,7,20,237,34,8,144,10,10,81,34,23,69,
    190,2,23,21,2,16,144,9,154,0,23,255,5,10,139,32,140,48,139,64,139,80,
    5,43,187,54,29,82,162,0,161,16,123,68,129,22,106,24,20,130,2,23,84,
    1,85,7,170,84,1,85,7,84,1,85,7,152,84,1,85,5,14,159,0,94,1,86,0,148,
    0,21,226,0,4,245,1,128,2,36,16,0,24,48,65,85,163,0,85,0,85,16,0,80,
    85,21,0,81,81,85,17,82,21,48,16,85,69,36,48,81,84,81,85,84,128,4,84,
    100,5,1,0,146,0,85,81,0,81,82,5,4,144,1,69,17,85,69,0,41,69,5,16,0,
    21,113,85,21,19,0,21,4,64,143,16,30,17,85,163,16,123,70,84,83,70,177,
    15,9,69,83,127,6,21,51,15,40,51,8,50,8,251,18,8,18,8,18,15,18,16,15,
    5,255,49,10,32,10,240,15,10,32,26,173,0,29,20,31,27,17,130,2,24,84,
    237,130,4,23,144,12,10,69,82,7,21,232,50,143,32,9,149,0,7,0,10,21,85,
    254,80,11,107,139,48,139,64,138,80,144,11,154,0,128,89,164,0,81,85,
    0,170,90,85,171,5,38,65,32,64,40,17,130,18,51,39,81,84,129,2,39,81,
    81,114,55,6,81,69,18,6,81,144,30,16,128,14,159,0,94,1,57,84,85,159,
    0,255,15,255,15,152,21,1,48,143,8,44,149,170,15,59,175,38,145,1,60,
    84,85,159,0,255,15,255,15,255,15,185,1,57,84,85,159,0,255,15,255,15,
    168,21,4,128,175,32,238,15,14,1,8,68,85,1,0,161,0,5,0,0,0,0,10,0,21,
    0,69,85,88,4,0,1,5,192,0,129,2,85,85,165,68,2,69,128,5,80,85,49,84,
    1,2,85,85,65,0,16,85,85,2,56,1,1,80,84,21,1,8,8,4,80,81,21,4,8,16,80,
    96,69,21,176,6,6,64,80,21,21,54,64,1,0,163,16,133,16,4,84,101,255,68,
    160,5,9,161,7,9,135,2,3,88,255,2,88,2,24,4,163,16,7,83,127,1,0,2,83,
    7,163,8,7,133,2,255,5,102,20,6,20,6,22,161,16,223,17,129,14,227,47,
    69,32,55,97,57,255,225,7,57,35,55,4,22,4,22,255,4,24,195,32,23,163,
    16,23,33,25,255,139,32,139,48,139,64,136,2,56,103,178,17,152,0,11,37,
    5,0,64,85,41,69,192,3,39,43,5,85,27,69,85,27,128,2,242,26,64,26,64,
    16,86,85,163,0,13,84,85,129,170,90,221,17,144,0,70,138,34,161,16,129,
    170,85,140,32,80,125,171,85,12,85,12,85,12,85,15,0,0,159,0,94,1,43,
    84,85,149,0,81,132,1,84,162,0,127,15,8,68,32,129,4,141,6,143,2,38,139,
    16,161,3,127,15,10,68,194,0,135,8,103,127,36,15,0,163,4,255,239,31,
    10,131,4,93,111,36,127,2,239,47,14,161,16,63,0,253,79,36,95,4,143,32,
    12,139,48,139,58,31,30,157,0,86,149,162,0,127,8,64,0,1,80,245,1,0,148,
    141,22,111,30,2,0,1,82,160,1,1,11,0,64,85,17,0,31,42,64,143,23,9,179,
    15,6,139,50,81,132,32,161,2,1,0,143,36,6,128,137,6,143,64,46,1,33,80,
    85,163,0,85,85,5,0,89,225,0,0,148,0,21,0,17,65,85,0,3,85,85,16,0,69,
    85,21,21,0,81,85,17,2,21,192,1,21,8,240,5,81,85,81,84,49,85,84,89,21,
    0,192,0,1,128,2,146,0,85,81,20,48,81,21,4,144,1,69,17,85,140,69,48,
    69,21,16,145,3,113,85,129,21,0,21,21,64,80,85,81,111,143,16,27,17,128,
    6,74,84,163,16,70,177,15,111,9,69,115,6,21,51,7,51,255,15,24,51,8,18,
    8,18,8,18,255,8,18,9,17,15,26,17,10,16,255,10,240,15,10,48,10,48,11,
    143,32,28,222,161,0,144,8,41,84,129,2,40,145,12,41,253,69,50,39,176,
    7,15,4,157,0,7,0,252,10,193,15,10,139,32,139,48,139,64,138,80,88,197,
    85,161,0,161,16,21,170,90,127,1,73,239,66,81,128,6,106,16,128,2,41,
    49,251,41,50,40,50,8,18,64,191,14,1,0,159,0,91,1,16,84,85,68,162,0,
    84,85,64,0,0,69,85,85,85,80,85,4,160,0,1,84,0,64,0,85,0,26,84,85,16,
    0,1,225,1,96,128,2,45,85,85,69,2,85,131,6,89,1,85,224,0,1,8,4,16,4,
    8,16,83,16,16,8,64,16,64,68,160,1,63,137,16,4,0,163,16,21,160,15,34,
    21,255,193,4,25,136,2,2,24,2,24,2,255,24,4,163,16,7,19,7,19,7,255,163,
    8,7,134,2,4,22,4,22,4,255,22,6,161,16,9,17,9,17,225,1,255,113,229,39,
    41,116,22,36,22,36,255,22,36,24,161,16,25,35,23,33,255,25,139,32,139,
    48,139,64,136,2,88,13,17,247,195,57,69,133,30,157,0,135,8,0,225,0,9,
    95,64,21,8,66,129,2,88,2,24,24,2,64,100,85,161,0,161,16,64,168,212,
    90,130,35,155,0,101,84,69,128,4,85,127,85,21,138,32,209,16,57,32,58,
    128,2,248,58,0,26,0,192,0,159,0,108,1,22,0,0,85,156,0,69,160,0,2,75,
    1,80,138,3,65,0,131,2,68,16,234,161,4,78,132,6,70,4,28,16,28,247,64,
    173,15,227,15,195,0,143,16,6,68,98,119,255,40,130,6,40,18,40,18,40,
    31,5,255,228,15,31,7,161,8,25,6,20,6,20,255,6,20,6,31,7,143,32,12,163,
    8,15,1,22,255,4,22,4,22,4,31,41,139,32,139,48,224,139,64,72,88,15,19,
    170,74,85,85,164,0,157,0,64,162,0,65,0,160,3,85,4,69,0,81,0,0,1,113,
    65,0,1,85,1,64,85,69,1,81,33,1,0,4,17,65,4,85,4,4,48,4,81,4,0,16,17,
    65,35,16,85,16,48,16,81,16,147,8,79,192,15,64,48,64,81,207,16,3,153,
    0,227,14,159,129,14,240,6,85,81,136,16,129,32,105,113,253,9,17,9,17,
    9,17,15,0,101,141,162,0,161,32,64,168,90,138,34,129,14,65,127,140,2,
    81,89,1,89,113,9,17,128,9,17,85,1,59,84,85,159,0,255,15,255,15,122,
    69,160,0,192,143,4,42,143,32,178,175,28,58,1,22,0,0,85,159,0,10,1,239,
    3,11,15,16,175,5,140,2,17,60,65,143,8,13,143,16,255,111,221,235,239,
    83,12,143,22,16,111,46,159,0,13,86,47,78,0,61,64,143,20,28,84,143,2,
    15,1,23,0,0,85,159,0,10,5,239,3,11,15,16,93,141,8,17,140,2,65,63,29,
    143,16,255,111,77,1,155,111,109,47,110,168,170,28,251,3,86,143,38,14,
    64,143,32,109,84,143,2,15,1,61,84,85,159,0,255,15,255,15,136,239,87,
    15,4,92,159,12,45,170,15,59,86,143,32,94,141,4,143,2,0,1,58,84,85,159,
    0,255,15,255,15,41,4,143,24,173,252,170,13,251,3,239,103,15,143,32,
    109,141,20,143,2,0,1,59,84,85,159,0,255,15,255,15,185,16,255,27,204,
    128,239,121,14,141,4,84,85,1,35,84,85,154,0,21,0,0,172,2,255,140,4,
    223,3,10,15,17,143,8,14,128,16,175,16,11,111,83,127,9,243,15,85,31,
    7,15,87,31,5,15,77,81,5,7,171,147,0,156,4,1,143,14,29,5,79,13,69,143,
    26,45,83,12,90,63,32,21,169,0,84,1,143,32,14,160,143,4,13,95,13,80,
    142,2,1,40,84,85,154,0,21,251,1,85,21,61,0,0,80,188,2,15,27,142,10,
    143,6,30,0,247,0,175,16,41,143,16,51,127,41,15,30,5,141,2,3,214,31,
    39,141,10,13,69,141,6,21,148,0,177,5,59,84,1,84,70,21,251,5,80,141,
    12,205,63,46,31,110,140,20,84,1,141,32,143,34,12,90,94,47,46,1,235,
    15,85,122,207,64,32,173,6,143,2,0,1,63,84,85,159,0,255,15,121,239,51,
    46,141,8,143,10,30,18,143,6,14,84,1,0,12,21,85,163,0,1,85,85,21,84,
    80,5,84,5,158,143,26,60,143,48,111,169,170,111,13,60,140,32,47,15,198,
    1,143,2,13,47,27,80,5,80,173,2,110,1,58,84,85,159,0,255,15,255,15,152,
    80,143,4,13,101,84,17,143,10,28,238,99,169,170,15,58,90,96,158,14,1,
    143,32,76,61,80,85,1,16,84,85,69,162,0,85,85,21,84,0,5,224,0,85,134,
    2,20,32,84,8,85,85,84,16,0,1,84,0,0,20,0,164,0,84,1,85,84,84,64,0,1,
    84,0,4,33,85,75,69,84,1,85,84,129,6,85,33,12,133,8,4,5,81,85,176,2,
    38,16,16,5,69,85,17,40,64,5,21,121,85,65,161,1,137,16,39,3,16,0,191,
    163,16,5,64,16,9,160,15,50,37,255,136,8,18,88,18,72,20,163,2,23,255,
    69,21,163,16,23,67,23,67,23,255,134,8,20,134,2,20,70,22,225,1,25,255,
    67,23,161,16,17,129,14,227,47,33,23,255,65,25,132,8,22,4,22,4,24,255,
    139,32,139,48,165,16,25,67,23,65,25,255,43,59,141,64,31,6,129,2,145,
    27,155,0,21,76,32,84,26,84,84,209,77,24,86,159,80,27,86,84,27,128,2,
    28,225,13,150,137,32,208,42,85,101,164,0,69,4,157,0,102,101,84,81,161,
    16,20,168,240,1,136,16,102,0,4,128,18,56,0,16,96,56,88,0,64,96,65,158,
    10,159,0,93,1,8,84,85,1,0,163,0,20,0,3,4,0,5,0,85,85,4,128,1,16,161,
    1,84,85,5,224,0,0,0,80,144,85,155,0,64,0,1,65,0,84,24,0,68,0,69,128,
    6,243,7,1,1,6,20,1,4,1,5,1,128,2,146,8,1,1,4,20,4,4,4,5,4,64,0,16,81,
    1,16,20,16,4,48,16,5,16,0,18,1,64,21,91,64,5,48,1,128,13,137,16,4,164,
    16,182,7,27,64,128,4,9,0,161,14,8,217,0,97,40,0,1,24,0,64,255,163,16,
    23,69,21,69,23,9,193,15,255,227,0,21,5,21,5,21,5,21,255,5,23,3,23,3,
    25,7,227,47,255,129,1,23,3,23,3,23,3,23,205,3,25,3,4,170,21,1,85,237,
    26,149,0,19,1,85,24,1,21,183,24,1,21,24,1,21,24,1,254,19,220,75,159,
    0,111,133,32,129,48,161,32,15,6,17,103,4,85,7,17,68,85,7,17,248,128,
    2,54,1,16,38,1,69,85,80,5,64,245,3,20,160,0,164,170,86,253,85,129,1,
    3,129,64,203,19,226,113,4,84,54,50,85,85,144,91,34,20,50,128,2,142,
    4,19,20,4,84,128,48,48,148,0,52,20,16,84,240,2,48,64,67,20,64,64,85,
    226,47,1,8,84,85,1,0,161,0,65,85,37,69,85,85,194,0,4,0,1,69,157,134,
    2,157,0,64,0,1,135,6,242,7,1,222,56,146,8,8,16,81,8,18,5,102,1,0,163,
    16,5,4,0,115,143,16,6,205,64,128,4,41,0,1,19,6,4,183,19,6,16,19,6,64,
    19,71,255,19,71,19,79,8,19,7,19,7,255,19,7,19,7,19,9,17,9,255,17,15,
    10,17,9,17,9,17,9,255,17,9,17,11,17,130,2,243,7,20,190,33,151,0,80,
    8,17,132,4,148,8,84,221,1,37,52,4,115,1,50,16,250,244,7,112,2,128,1,
    155,0,101,4,130,14,233,4,104,83,5,64,160,22,85,0,1,7,0,1,84,85,21,1,
    5,36,6,0,4,128,2,4,5,6,0,152,16,96,16,5,38,161,16,21,64,226,5,30,159,
    0,94,201,27,20,0,68,136,32,224,4,196,50,143,64,2,161,0,68,0,84,0,195,
    5,4,17,4,1,20,1,5,12,17,4,4,20,4,5,17,4,48,16,20,16,5,17,5,64,21,0,
    64,69,85,1,8,84,85,1,0,161,0,81,85,9,69,85,5,0,85,144,0,4,0,98,1,85,
    134,2,23,5,0,0,160,2,86,64,0,1,65,128,4,69,114,242,7,157,1,129,8,21,
    1,50,146,8,50,4,110,50,16,161,0,50,16,2,66,2,125,64,85,224,15,163,16,
    133,16,161,15,111,10,64,182,84,5,0,192,14,9,0,48,9,223,0,48,9,0,48,
    11,163,16,7,255,51,15,8,51,7,51,7,19,7,255,19,7,19,9,17,9,225,15,15,
    10,255,17,9,17,9,17,9,17,9,183,17,11,65,134,14,3,69,15,13,131,6,255,
    7,131,2,7,68,6,68,22,4,251,16,157,0,224,10,164,0,129,14,31,0,65,160,
    31,239,99,193,5,129,33,35,81,196,4,143,2,30,157,0,30,131,32,4,0,5,192,
    0,255,19,1,228,95,81,209,68,146,61,19,17,80,4,1,68,165,160,32,243,7,
    17,0,4,4,128,2,4,74,115,17,0,4,16,64,16,211,7,152,17,48,5,64,175,32,
    4,159,0,92,1,3,84,85,1,0,81,85,161,0,80,149,0,69,6,5,192,0,85,85,16,
    242,0,1,129,4,131,2,29,0,1,1,135,65,134,6,0,4,0,4,137,10,241,7,17,106,
    64,0,64,71,1,0,84,230,226,15,69,161,8,137,16,16,0,163,16,31,6,102,0,
    1,35,21,0,4,33,135,10,111,0,16,193,0,136,2,64,1,57,69,255,231,31,69,
    51,67,63,8,3,23,1,255,25,1,25,1,27,193,1,135,36,155,0,255,227,47,131,
    4,31,6,1,134,12,112,3,39,255,3,39,3,41,239,63,0,161,1,133,32,227,31,
    255,15,10,232,59,2,27,129,48,9,17,159,0,6,248,231,79,131,14,195,67,
    163,20,143,16,8,161,0,84,85,62,5,1,5,160,17,135,6,145,0,143,2,14,95,
    110,252,0,82,225,71,131,46,242,39,160,0,139,64,16,119,0,20,64,240,58,
    143,32,7,4,66,135,38,128,229,41,143,2,14,1,8,84,85,1,0,161,0,21,0,129,
    16,192,0,0,0,85,85,4,0,168,1,131,2,8,48,81,2,85,85,170,21,192,1,17,
    56,85,96,65,137,4,27,1,85,85,1,192,0,54,4,48,186,32,54,16,48,32,54,
    64,16,55,64,1,0,163,16,133,16,4,52,69,255,161,5,73,23,3,136,4,2,24,
    2,255,24,2,24,4,163,16,7,51,7,255,163,6,7,21,5,134,4,4,22,4,255,22,
    4,22,6,161,16,9,49,21,255,230,45,8,19,7,132,4,6,20,6,255,20,6,20,8,
    163,16,7,51,7,255,139,32,139,48,139,64,136,2,72,123,9,179,25,255,159,
    0,8,136,14,112,58,16,41,17,41,254,130,2,40,114,8,18,14,176,30,146,0,
    189,1,194,97,1,143,32,111,107,225,18,25,80,128,238,37,143,2,30,1,1,
    84,85,1,0,1,0,21,0,160,0,16,0,4,0,0,0,85,106,85,4,128,1,129,2,24,16,
    8,32,208,16,160,3,131,4,20,160,5,85,85,64,17,0,64,0,85,0,80,0,68,144,
    34,208,0,1,21,0,16,1,4,208,1,18,144,8,21,0,16,4,4,208,4,18,80,21,48,
    16,16,4,208,16,66,0,21,16,17,64,5,237,64,193,15,161,16,135,16,4,98,
    119,16,243,2,23,80,0,23,0,1,1,51,23,0,4,33,7,0,16,17,63,7,0,64,17,9,
    17,9,17,255,135,2,225,31,37,3,17,9,17,89,255,1,25,1,25,1,27,3,23,255,
    3,23,3,23,3,23,3,23,255,3,23,3,23,3,25,225,11,131,14,173,157,0,51,21,
    160,14,17,57,128,2,81,85,56,21,160,16,17,56,21,0,17,87,24,21,0,17,24,
    21,0,19,64,157,0,8,162,0,0,0,21,170,90,110,85,5,176,11,53,21,194,36,
    56,128,2,130,69,56,21,1,84,85,5,56,103,21,4,96,8,21,16,16,8,220,161,
    16,15,2,159,0,10,84,240,46,127,78,133,32,0,93,170,6,144,25,5,38,225,
    0,137,48,80,252,138,64,225,63,121,1,25,1,25,21,64,64,16,20,1,59,84,
    85,159,0,255,15,255,15,23,1,159,32,238,0,15,160,1,60,84,85,159,0,255,
    15,255,15,255,15,185,1,60,84,85,159,0,255,15,255,15,255,15,185,1,17,
    0,0,85,159,0,7,81,85,85,137,230,3,192,1,85,17,0,129,2,81,1,16,163,0,
    80,1,81,60,17,1,85,160,1,48,5,67,80,5,17,4,80,85,4,48,17,67,80,17,17,
    40,16,85,16,0,65,19,85,65,27,17,64,85,64,239,15,8,143,16,4,81,161,12,
    204,88,9,81,81,5,165,16,19,81,255,17,37,19,128,15,36,31,38,165,14,5,
    254,135,2,3,117,5,85,5,85,15,20,227,81,224,0,193,15,3,21,0,81,162,0,
    60,128,2,0,80,129,1,34,163,16,17,21,48,1,81,4,97,112,4,80,4,6,17,4,
    21,4,81,16,65,80,0,16,80,16,17,16,21,16,81,227,64,65,80,192,15,17,64,
    21,63,0,155,193,58,130,59,5,0,135,14,161,14,85,30,182,55,161,16,85,
    24,33,85,24,33,247,85,24,33,31,5,143,34,11,21,234,85,137,52,254,132,
    4,129,17,137,2,97,121,1,25,142,16,75,5,0,161,0,1,0,145,0,85,129,14,
    125,86,80,224,3,58,194,32,160,94,4,80,239,192,15,128,16,193,94,82,80,
    96,112,1,127,18,80,32,48,193,62,21,63,1,207,30,0,255,21,130,80,138,
    2,130,65,137,4,113,105,17,224,41,17,41,224,15,1,38,84,85,151,0,17,0,
    216,1,0,255,81,251,1,230,2,163,0,160,1,143,6,13,143,2,30,143,16,18,
    255,130,15,31,107,165,16,31,52,198,25,31,25,133,6,31,56,165,163,3,27,
    64,128,2,21,0,157,0,64,190,164,0,128,4,0,16,170,6,143,48,46,143,78,
    4,95,90,35,149,170,21,192,30,21,0,17,161,29,231,191,4,4,81,160,31,195,
    32,85,170,175,14,46,133,48,27,193,31,25,0,16,142,46,153,0,80,194,62,
    128,165,0,143,64,52,1,8,84,85,1,0,161,0,5,0,0,0,0,21,0,10,0,85,85,105,
    4,0,1,131,2,0,32,16,0,70,1,21,196,0,85,85,84,2,147,0,149,64,44,0,1,
    12,4,12,16,27,12,64,1,0,163,16,133,16,4,68,249,85,161,14,89,161,7,25,
    139,2,0,1,95,76,4,76,16,76,16,163,16,7,255,19,7,19,7,163,8,7,137,2,
    1,255,26,0,26,0,26,2,161,16,133,14,103,227,47,85,86,51,85,85,9,229,
    7,255,5,71,3,24,2,24,2,24,255,4,163,16,7,19,129,34,3,19,7,255,139,32,
    139,48,139,64,140,2,84,7,182,17,159,0,5,127,69,21,176,5,15,66,176,30,
    114,195,11,229,1,240,71,7,131,65,143,32,94,79,78,1,41,84,85,153,0,86,
    192,0,4,0,235,161,0,131,2,235,3,3,64,32,80,196,1,125,129,4,84,34,63,
    40,139,16,161,15,63,10,64,255,194,0,55,165,10,47,38,63,0,163,16,47,
    8,49,239,41,3,31,38,155,0,84,234,47,79,6,81,255,137,10,231,4,15,32,
    63,4,69,129,66,15,2,139,32,206,139,44,127,28,159,0,30,64,0,161,0,63,
    56,173,34,76,2,0,1,0,0,163,2,143,20,0,66,248,0,1,22,128,5,143,32,92,
    159,0,62,1,10,84,85,1,0,161,0,85,2,6,69,0,85,85,4,0,1,131,2,154,5,48,
    16,0,1,51,37,48,240,69,2,144,0,193,1,57,1,85,85,221,5,192,0,54,4,48,
    64,54,16,209,0,64,6,64,0,64,1,0,255,163,16,133,16,160,15,82,101,112,
    2,21,255,161,7,25,136,2,18,120,2,24,2,255,24,4,163,16,7,115,7,19,7,
    255,163,8,7,134,2,4,118,4,22,4,255,22,6,161,16,9,113,9,17,85,255,230,
    39,8,68,6,68,6,20,6,255,20,8,165,16,5,117,5,21,5,252,139,32,139,48,
    139,64,136,2,40,93,97,64,127,0,81,192,0,159,0,14,136,8,129,41,12,26,
    250,1,25,1,25,1,24,85,192,32,255,5,143,15,7,130,48,128,4,143,32,62,
    148,17,159,0,37,141,22,192,253,9,133,29,143,2,8,1,26,0,0,85,159,0,8,
    205,3,5,140,2,171,1,47,13,4,44,16,44,64,207,15,9,87,143,16,112,5,124,
    5,12,5,140,14,63,0,86,11,21,12,69,15,3,1,162,0,128,1,89,84,0,16,1,226,
    14,129,15,5,84,244,165,1,171,5,135,6,67,103,4,16,5,65,85,17,162,0,85,
    85,17,84,16,21,16,17,85,65,34,85,192,0,64,255,32,113,31,2,161,10,9,
    18,226,1,168,14,238,173,16,8,129,6,33,4,20,97,17,254,16,20,129,15,17,
    175,64,14,159,0,14,15,0,69,107,5,84,163,48,53,17,128,2,17,56,220,197,
    32,143,32,6,132,48,0,156,0,136,4,12,84,253,1,160,12,121,161,16,121,
    1,25,65,255,128,2,143,32,10,227,42,233,97,75,141,4,13,141,86,192,227,
    48,151,0,194,32,1,26,0,0,85,159,0,8,205,3,5,143,2,13,171,1,44,4,44,
    16,44,64,207,15,9,232,143,16,255,127,113,141,12,15,66,1,166,0,0,84,
    27,168,85,1,0,156,0,185,5,65,173,16,69,225,6,5,54,85,65,4,96,21,20,
    6,85,65,16,16,69,6,85,125,65,64,175,32,15,159,0,0,136,12,234,1,32,84,
    141,49,139,2,4,85,17,23,48,16,252,208,22,23,175,32,2,135,8,129,32,59,
    139,44,5,198,84,235,31,63,14,17,84,17,58,162,16,1,62,84,85,159,0,255,
    15,255,15,134,207,87,238,143,32,50,1,26,84,85,81,162,0,147,0,65,192,
    0,105,4,0,1,131,2,104,32,16,0,175,1,67,64,33,0,49,135,6,141,8,255,79,
    28,161,1,73,161,15,137,16,113,9,17,255,9,141,8,111,32,163,2,7,163,16,
    7,19,255,7,19,143,8,6,143,2,34,229,1,37,229,15,129,14,255,233,47,21,
    37,143,8,2,143,2,36,139,32,167,16,85,248,27,139,48,141,58,15,44,159,
    0,14,63,76,85,85,253,0,4,31,20,229,89,135,8,127,30,11,1,224,245,15,
    47,37,129,116,31,28,1,25,84,85,21,162,0,144,0,1,85,58,130,1,4,0,1,224,
    1,0,21,192,2,96,16,0,1,132,2,0,85,85,64,222,0,49,3,149,0,138,8,194,
    8,4,170,5,192,1,4,8,17,112,16,8,191,65,16,64,161,1,137,16,160,15,162,
    16,85,253,96,114,5,16,34,5,140,8,1,255,136,2,50,8,18,8,20,163,2,23,
    255,163,16,23,3,23,3,23,138,8,16,255,134,2,20,6,20,6,22,226,1,24,255,
    161,16,25,1,25,1,133,2,140,8,18,255,84,22,4,22,4,24,139,32,167,16,255,
    21,117,5,21,5,107,139,48,139,64,171,136,2,47,11,84,224,11,84,16,0,159,
    0,13,255,136,8,129,43,25,1,25,1,25,1,231,26,193,97,134,32,129,44,85,
    21,143,15,7,133,4,248,127,46,148,17,159,0,53,142,22,45,142,2,1,76,0,
    154,0,64,85,139,2,5,130,134,170,161,0,2,0,128,170,156,3,140,6,85,64,
    84,28,81,28,69,28,21,249,143,16,255,175,15,3,131,1,31,104,163,16,31,
    98,128,170,250,165,0,227,1,31,76,159,0,14,143,68,6,47,56,8,120,122,
    136,170,47,0,203,5,205,7,43,40,143,2,17,1,32,64,85,167,0,65,85,85,85,
    170,0,159,0,3,2,2,40,177,1,85,7,210,1,128,6,128,7,84,5,65,84,130,2,
    148,81,37,65,81,2,69,21,65,166,69,2,21,23,0,0,225,14,143,16,43,219,
    84,167,16,114,81,7,18,69,7,127,18,21,9,17,7,31,37,6,20,255,6,20,6,20,
    8,19,5,31,8,255,147,0,31,7,4,22,4,22,4,22,255,6,21,3,31,41,2,24,2,24,
    255,2,24,4,23,225,15,17,153,0,129,2,255,142,84,31,6,96,26,96,26,0,26,
    102,0,65,16,159,0,10,128,170,111,0,137,4,237,168,143,36,2,143,2,41,
    143,46,0,32,172,2,224,32,0,162,169,0,80,1,106,84,0,4,10,48,80,0,16,
    10,250,7,1,64,85,0,85,1,93,0,159,0,3,2,162,0,15,8,131,4,8,184,175,4,
    9,1,160,143,2,29,143,16,248,15,5,170,170,228,170,249,1,127,207,128,
    14,64,85,167,0,81,47,85,85,85,47,78,8,72,141,30,15,14,103,141,18,168,
    143,2,29,94,0,128,63,11,143,32,14,128,141,4,47,2,1,12,84,85,1,0,149,
    0,193,1,80,26,85,5,0,4,162,0,129,2,5,192,0,40,17,0,16,34,0,226,0,84,
    85,44,65,0,64,34,0,98,192,6,1,191,0,35,0,1,128,2,243,7,145,8,0,235,
    64,83,100,0,64,163,0,85,163,1,191,226,14,135,16,4,166,16,115,161,14,
    3,19,255,33,3,19,34,24,2,24,2,255,153,24,133,15,22,167,16,19,5,244,
    7,6,255,21,5,21,6,20,6,150,8,4,255,52,165,15,23,201,32,179,23,33,119,
    35,255,55,35,55,36,54,4,152,8,2,248,22,195,15,19,214,63,159,0,5,213,
    55,84,85,239,85,226,32,83,161,16,85,51,228,63,129,2,255,50,116,2,151,
    24,80,0,134,16,225,15,255,21,155,0,231,81,123,145,55,73,160,15,74,255,
    209,40,9,17,9,114,8,231,48,159,0,2,239,131,64,113,247,7,129,68,17,105,
    35,87,254,195,97,87,129,2,25,33,26,99,155,0,40,161,170,162,164,0,170,
    192,0,10,0,40,152,170,154,4,170,16,86,85,40,105,170,106,4,170,16,86,
    85,34,169,169,170,5,170,170,169,128,2,71,166,170,5,170,170,166,112,
    245,7,168,146,8,16,106,5,85,192,1,85,85,1,12,80,85,5,0,163,0,147,0,
    85,225,85,148,1,16,193,3,85,85,16,0,66,3,0,226,0,85,85,64,0,3,214,0,
    98,128,6,1,84,0,1,128,2,190,4,36,0,1,64,154,8,64,4,29,85,85,5,64,80,
    226,12,135,16,4,255,168,16,161,3,161,14,89,1,25,2,24,255,2,24,2,154,
    8,165,16,53,37,53,255,39,51,37,53,5,21,6,20,255,6,20,6,150,8,3,55,3,
    55,255,201,32,179,23,1,55,3,23,4,22,255,4,22,4,152,8,1,51,231,61,159,
    0,20,95,229,63,85,80,69,54,33,128,10,6,255,17,128,2,6,17,80,151,24,
    224,15,63,44,219,144,7,58,160,0,84,57,96,80,57,249,161,15,25,133,32,
    129,17,159,0,2,146,28,85,5,223,232,97,30,224,54,69,25,225,56,25,129,
    2,244,25,97,26,161,16,141,15,170,154,0,10,40,0,154,170,165,0,170,192,
    0,106,85,80,106,170,85,170,96,90,85,170,138,169,86,170,170,169,128,
    2,166,22,60,170,170,166,32,154,8,32,86,85,64,85,165,0,1,8,0,0,168,170,
    165,0,160,170,6,170,170,85,85,166,170,5,145,0,20,85,85,154,170,5,90,
    130,2,106,207,170,5,131,4,170,169,8,65,151,8,216,176,8,0,23,154,2,23,
    106,85,27,85,168,170,2,166,16,129,16,166,120,109,145,0,154,24,1,106,
    24,34,169,255,26,144,8,26,0,26,0,25,129,16,255,23,99,23,3,23,3,23,3,
    255,26,146,8,24,2,24,2,23,99,255,21,101,21,5,21,5,21,5,255,24,148,8,
    22,4,22,4,21,101,232,19,103,19,145,0,138,164,0,0,0,40,138,170,10,128,
    2,34,52,0,0,88,34,170,208,0,0,213,71,164,1,170,170,252,162,51,64,129,
    1,150,8,32,49,170,121,170,42,19,32,226,0,231,79,2,0,201,137,16,161,
    16,49,20,85,118,0,10,255,128,14,153,0,141,2,1,53,68,151,24,67,211,54,
    67,192,0,85,167,0,165,85,159,0,0,239,246,7,210,7,63,0,202,15,2,137,
    16,32,193,2,249,153,8,129,2,6,16,65,159,0,29,84,85,17,19,4,0,4,129,
    32,85,0,1,91,26,84,234,111,166,176,70,73,154,201,111,0,131,64,1,8,0,
    0,168,170,165,0,160,170,6,170,170,85,85,166,170,5,145,0,25,85,85,154,
    170,7,129,2,106,170,159,7,65,170,169,9,64,151,8,48,176,0,25,154,0,24,
    85,106,168,109,170,2,166,16,129,16,166,120,145,0,154,127,26,170,208,
    6,25,32,161,14,25,113,223,9,17,9,106,9,129,16,7,99,255,39,3,25,1,25,
    1,28,195,30,255,40,60,225,14,38,19,37,21,37,255,21,7,19,7,19,10,229,
    46,24,254,42,131,15,20,5,19,7,19,145,0,145,138,164,0,0,0,225,0,170,
    170,42,57,20,0,0,33,0,148,8,0,0,127,164,1,162,19,128,2,115,100,16,35,
    211,52,16,225,0,42,231,79,2,0,137,16,255,161,16,41,51,39,51,39,52,229,
    14,253,21,37,23,150,8,17,179,8,152,0,85,228,29,135,16,176,7,176,6,84,
    85,163,0,4,1,0,4,0,10,0,0,85,0,207,24,128,2,56,170,162,0,134,32,97,
    156,0,24,170,42,0,29,159,0,31,0,133,1,71,42,1,0,84,235,111,170,224,
    60,80,249,119,128,65,1,8,0,0,168,170,165,0,160,170,6,170,170,0,0,162,
    170,5,145,0,25,0,0,138,170,7,129,2,42,170,127,6,168,65,246,7,224,1,
    66,151,8,176,8,246,16,42,16,40,225,15,2,166,16,129,16,215,162,24,145,
    0,138,26,170,208,6,24,111,161,14,168,24,65,162,26,144,8,26,255,64,25,
    227,31,21,131,16,23,35,25,255,33,24,34,24,2,26,146,8,24,255,66,23,229,
    47,19,37,21,37,23,255,35,22,36,22,4,24,148,8,22,255,68,21,231,63,17,
    39,19,39,21,255,37,20,38,20,6,22,150,8,20,207,70,19,233,79,2,0,41,49,
    25,255,35,129,72,159,0,8,240,9,110,151,8,194,1,151,24,200,66,195,12,
    15,26,84,85,163,0,4,0,38,4,0,10,223,17,10,0,128,130,18,234,95,245,2,
    43,130,2,143,16,41,96,85,143,32,8,128,224,124,162,0,233,15,194,32,1,
    8,84,85,1,0,153,0,80,85,48,5,0,4,162,0,3,84,85,17,80,0,16,18,0,226,
    0,84,85,65,89,0,64,18,0,66,128,8,1,0,127,19,0,65,128,2,243,7,145,8,
    16,32,208,51,68,32,64,163,0,85,85,5,27,64,5,64,1,161,8,136,16,4,166,
    16,255,147,0,161,14,83,67,113,3,19,34,255,24,34,24,34,153,24,128,15,
    11,171,16,255,177,6,83,5,85,5,21,5,22,255,4,22,4,22,148,8,161,15,11,
    25,255,179,23,17,7,19,7,19,7,20,255,6,20,6,20,6,19,3,218,63,131,159,
    0,1,213,55,84,85,85,85,21,6,31,17,85,85,69,6,17,128,10,6,255,17,128,
    2,6,17,112,6,225,15,3,254,129,1,153,0,235,81,55,145,55,25,160,15,26,
    219,8,208,40,25,8,96,25,8,176,7,110,25,9,132,32,133,15,65,129,26,160,
    0,159,0,6,239,81,133,5,55,224,52,69,38,129,64,224,54,254,38,81,128,
    2,38,1,16,38,165,32,88,169,170,159,0,12,138,166,0,193,1,42,0,40,104,
    170,106,4,170,192,0,90,85,34,169,169,170,5,170,170,169,128,2,68,166,
    170,5,170,170,166,80,154,138,170,5,170,170,154,80,106,5,32,85,85,165,
    48,1,8,84,85,1,0,151,0,32,0,12,80,85,5,0,4,162,0,1,40,6,0,84,85,153,
    170,154,18,1,140,42,128,2,65,0,64,17,224,1,106,68,170,98,80,1,1,0,16,
    160,140,169,144,2,169,42,1,0,242,7,160,137,166,0,166,42,4,0,16,0,69,
    16,160,145,8,154,42,16,48,64,0,113,161,106,85,85,149,106,41,108,64,
    1,161,8,136,16,4,166,16,67,152,109,170,86,84,67,64,85,4,0,182,161,14,
    8,0,49,8,0,49,8,63,0,64,85,18,7,25,1,21,127,5,154,20,5,20,6,19,7,239,
    19,7,19,7,1,18,9,23,254,3,19,7,19,7,18,8,17,219,161,8,17,161,8,17,161,
    8,255,17,5,216,63,2,155,0,5,17,128,6,255,38,113,80,22,33,128,4,22,33,
    255,128,2,70,1,16,38,1,35,129,1,140,159,0,0,129,48,80,85,21,130,80,
    19,149,65,170,106,192,0,102,85,69,0,68,132,162,0,144,23,85,85,0,68,
    228,79,0,8,1,168,169,170,86,137,16,168,166,66,170,90,25,168,154,170,
    106,25,248,169,132,32,165,14,233,96,159,0,10,227,15,100,170,129,98,
    241,49,85,69,85,169,169,170,157,165,0,160,20,41,1,128,15,37,129,2,4,
    195,64,37,97,16,168,106,169,4,197,225,14,129,64,145,0,160,170,162,130,
    60,2,122,134,30,81,132,1,241,58,87,131,4,69,132,16,221,106,224,50,229,
    111,162,130,64,128,2,100,162,222,114,0,20,162,34,0,20,35,0,85,85,1,
    10,80,85,5,0,163,0,0,226,0,112,85,85,144,1,148,0,193,1,85,85,16,161,
    0,3,0,18,85,85,64,0,84,3,0,192,0,74,193,4,1,84,0,20,0,1,10,1,128,2,
    4,36,0,25,0,4,10,4,48,152,8,10,16,195,48,100,161,1,10,64,5,0,165,16,
    123,131,16,4,40,17,161,14,57,64,38,109,51,0,97,24,0,33,24,0,255,33,
    24,131,15,25,165,16,21,39,19,255,37,21,37,21,6,20,6,20,255,6,20,5,23,
    3,23,201,32,179,23,255,1,23,3,23,4,22,4,22,253,4,22,195,15,19,231,61,
    159,0,20,229,63,85,255,48,23,161,16,193,16,21,113,1,21,254,33,1,21,
    225,15,31,44,144,7,26,160,0,223,84,25,64,80,25,178,39,24,133,32,17,
    129,17,85,85,5,64,85,85,37,199,64,159,0,4,243,55,106,85,26,25,224,54,
    255,224,0,7,128,2,32,7,65,9,65,139,10,16,64,160,170,165,0,170,194,0,
    97,157,0,138,70,193,1,42,0,106,170,66,69,170,80,90,85,170,169,22,40,
    170,170,169,128,2,166,22,170,170,163,166,64,154,22,170,170,154,64,64,
    150,8,85,192,1,90,85,1,8,84,85,1,0,163,0,0,0,1,21,0,149,0,85,85,20,
    0,154,3,147,0,85,85,148,1,32,64,192,1,31,85,85,64,0,3,128,2,0,128,4,
    116,242,7,128,145,8,128,1,112,4,1,128,233,4,80,64,80,16,97,128,16,228,
    16,0,16,242,7,128,64,163,1,1,219,0,165,16,131,16,20,6,147,0,16,8,255,
    17,161,14,25,98,24,2,24,2,255,24,208,8,130,15,23,165,16,5,21,5,255,
    23,3,21,5,19,7,19,7,255,19,7,19,9,19,7,19,7,255,202,32,22,7,17,41,1,
    25,1,231,25,1,27,1,85,85,17,159,0,31,255,148,8,240,7,163,65,18,1,84,
    147,24,112,254,4,244,71,130,2,104,133,32,111,38,177,24,225,0,64,1,4,
    165,0,0,80,21,4,21,32,4,1,16,53,0,64,21,16,25,21,16,1,64,53,128,30,
    64,21,220,130,17,145,0,145,24,21,213,1,15,1,145,36,64,63,85,16,84,143,
    16,9,129,68,134,32,160,0,129,2,248,118,0,17,38,161,32,16,64,168,140,
    170,5,170,170,128,192,0,159,0,12,42,40,0,106,170,5,170,17,85,170,128,
    169,6,170,170,169,106,85,170,138,166,6,170,170,166,112,154,6,52,170,
    170,154,112,150,8,85,192,1,106,0,85,1,12,84,85,169,170,163,0,147,0,
    85,32,85,20,0,1,148,0,0,0,7,128,0,170,0,85,85,144,1,194,1,74,17,130,
    128,2,64,0,3,0,192,0,164,66,129,4,1,33,128,1,144,2,1,82,130,1,96,4,
    33,128,4,64,41,4,130,4,64,16,33,128,16,24,64,16,130,16,16,242,7,128,
    64,0,85,85,21,64,130,64,169,170,219,86,164,16,147,0,20,160,10,137,16,
    16,68,109,117,64,6,19,0,161,14,24,0,183,65,24,0,65,24,0,128,15,27,255,
    165,16,21,67,23,67,23,5,21,255,3,23,3,23,3,23,3,25,255,3,23,1,25,1,
    25,3,23,255,1,25,1,25,1,25,1,27,31,1,85,85,149,16,227,61,197,62,250,
    1,191,18,155,0,2,20,65,128,10,22,65,252,128,2,22,65,0,22,33,19,149,
    197,170,165,0,145,0,22,85,20,116,148,124,129,4,85,144,29,12,156,16,
    102,16,84,231,21,225,0,100,112,80,21,1,20,55,32,64,21,2,167,16,21,132,
    17,159,0,10,255,142,14,79,8,208,9,58,129,2,57,97,58,218,129,65,244,
    62,148,0,2,150,30,145,42,21,22,174,130,164,47,128,212,7,66,161,63,130,
    65,195,15,238,130,1,195,97,66,130,1,128,64,229,111,236,130,1,16,37,
    130,160,0,129,32,85,0,85,1,33,168,170,155,0,0,0,130,170,237,163,0,133,
    2,156,4,15,77,130,166,16,3,138,255,95,93,161,15,83,133,16,31,92,195,
    31,17,39,166,207,32,94,159,0,138,0,0,2,170,161,0,176,1,98,168,2,130,
    2,224,37,168,170,168,177,2,160,2,227,1,162,33,170,10,0,160,111,2,0,
    148,40,1,42,228,0,4,192,42,249,129,1,143,56,67,229,55,128,16,239,29,
    45,173,2,20,0,67,65,22,209,29,170,0,168,84,238,117,143,195,31,130,32,
    170,0,160,128,8,7,208,73,128,196,30,6,0,0,1,12,84,85,169,170,165,0,
    145,0,85,32,85,166,2,5,148,2,0,0,24,85,85,154,170,5,17,0,0,125,42,170,
    7,129,6,246,7,178,8,128,2,6,36,37,168,6,129,8,170,18,37,168,162,18,
    18,66,37,169,66,85,224,15,205,86,166,16,145,0,166,2,7,129,16,154,180,
    160,10,57,42,10,16,169,10,170,102,170,6,7,49,170,18,7,33,255,170,192,
    14,43,7,35,23,3,23,255,3,25,1,26,0,23,3,23,255,3,23,5,21,5,21,5,21,
    255,5,23,3,24,2,21,5,21,200,5,21,1,136,2,163,0,0,0,141,136,209,59,0,
    162,2,115,161,1,128,247,70,83,55,69,144,0,168,19,160,11,255,129,1,52,
    67,55,67,55,67,49,148,176,14,149,0,2,128,208,0,20,166,0,16,61,0,148,
    85,233,79,193,37,23,161,16,40,95,1,2,87,168,128,22,103,128,6,8,121,
    17,169,40,1,17,157,0,162,170,172,167,0,79,19,0,87,40,128,24,23,170,
    102,6,104,128,10,23,170,18,130,2,22,40,170,66,105,64,21,116,16,84,25,
    16,86,129,84,128,4,40,168,0,197,63,17,132,48,116,2,170,166,74,90,160,
    246,39,67,106,73,169,106,85,85,1,12,0,0,168,170,163,0,147,0,0,32,0,
    162,10,3,160,10,130,10,153,0,16,138,170,5,131,4,42,170,245,7,129,2,
    244,7,212,8,112,2,67,168,219,192,0,129,8,47,12,168,208,0,137,16,162,
    192,14,109,9,138,160,10,9,42,170,16,144,0,168,127,90,170,193,10,137,
    12,143,2,14,209,6,83,133,16,255,69,85,71,83,9,17,10,16,255,165,12,133,
    14,143,2,12,243,6,33,55,35,55,255,37,53,39,51,8,18,163,12,135,14,184,
    143,2,10,152,0,2,240,8,126,197,47,0,0,219,136,56,161,16,40,56,65,168,
    56,232,162,27,136,14,143,2,8,157,0,20,166,0,16,0,18,149,85,85,85,231,
    79,2,0,121,237,42,32,98,61,162,69,128,6,162,252,112,150,8,64,177,40,
    86,192,17,192,0,21,128,85,163,0,16,84,17,86,129,84,17,85,85,162,84,
    53,161,84,128,217,96,157,0,185,13,169,146,98,53,168,0,255,240,9,134,
    28,129,44,95,19,137,10,92,159,0,19,233,111,32,144,73,170,166,167,0,
    168,166,170,90,66,170,154,55,168,154,170,106,55,0,169,106,168,106,85,
    85,1,8,84,85,169,170,167,0,170,170,20,0,0,162,170,5,130,128,2,85,48,
    85,154,170,5,145,0,85,85,106,205,170,6,144,6,85,85,250,7,33,166,250,
    24,1,151,8,176,8,0,56,85,224,15,187,86,168,16,170,224,14,7,129,16,154,
    8,109,145,0,106,9,145,6,169,8,81,166,255,10,144,8,10,48,9,129,16,9,
    113,255,7,19,7,19,8,18,8,18,255,10,146,8,8,50,7,19,7,19,255,5,21,5,
    21,6,20,6,20,240,8,148,8,6,52,5,85,85,168,159,170,163,0,2,0,225,0,21,
    35,23,166,35,145,0,42,116,0,0,0,144,6,64,138,168,99,0,0,138,168,168,
    63,2,0,0,149,8,164,1,144,4,19,128,2,249,129,1,38,96,227,0,156,0,231,
    79,0,0,200,137,16,161,16,129,4,80,84,166,0,0,105,17,85,85,85,0,54,2,
    0,40,251,215,1,22,85,100,151,24,82,0,226,30,159,165,0,129,14,170,86,
    25,144,12,156,0,246,7,207,16,95,2,137,18,168,10,137,16,48,129,36,249,
    153,8,128,2,41,129,48,159,0,14,141,6,81,85,17,51,16,0,18,129,32,84,
    0,4,17,58,80,168,154,57,170,106,168,0,58,85,85,1,8,0,0,168,170,167,
    0,170,170,20,0,0,162,170,5,130,130,2,138,194,170,5,145,0,0,0,42,170,
    4,123,168,42,34,216,7,35,151,8,162,2,229,23,176,8,0,22,170,42,225,15,
    2,118,168,16,170,176,6,7,129,16,138,8,145,0,205,42,7,50,170,168,6,83,
    162,255,10,144,8,10,48,9,227,31,7,129,16,255,7,19,7,19,6,20,6,20,255,
    10,146,8,8,50,7,229,47,5,19,255,5,21,5,21,4,22,4,22,255,8,148,8,6,52,
    5,231,63,3,21,255,3,23,3,131,60,159,0,6,160,8,140,2,97,252,149,8,164,
    1,149,24,164,16,224,0,28,183,55,0,228,168,137,16,80,162,28,80,84,166,
    0,1,118,105,85,127,0,141,18,152,8,2,25,64,230,2,137,32,17,129,14,170,
    86,24,143,12,1,82,40,170,22,168,97,81,85,19,15,16,0,18,0,40,44,129,
    2,233,95,248,240,13,74,49,137,16,181,56,159,0,38,168,1,16,0,84,168,
    166,169,0,170,90,168,136,154,57,170,106,168,58,85,85,1,8,0,0,168,170,
    167,0,170,170,20,0,0,162,170,5,130,130,2,138,195,170,5,145,0,0,0,42,
    170,7,191,33,248,7,160,34,151,8,131,4,23,176,8,215,0,24,225,15,2,168,
    16,170,208,6,7,109,129,16,138,8,145,0,42,10,80,168,155,8,48,170,162,
    8,81,138,10,255,144,8,9,227,31,7,17,7,19,7,255,19,9,17,8,18,8,18,10,
    255,146,8,7,229,47,5,19,5,21,5,255,21,7,19,6,20,6,20,8,255,148,8,5,
    231,63,3,21,3,23,3,255,23,5,21,4,22,4,22,6,243,150,8,3,224,0,156,0,
    215,71,0,0,57,255,65,41,51,129,74,15,6,160,26,239,2,1,201,63,228,137,
    32,161,0,129,14,127,30,81,85,67,16,27,0,18,0,40,223,17,8,129,18,2,17,
    58,233,95,170,10,139,16,129,48,79,40,16,209,12,164,84,143,32,9,2,209,
    0,168,42,169,0,0,0,0,1,8,84,85,169,42,165,0,165,42,6,0,0,85,85,166,
    170,5,145,0,20,85,85,154,42,5,90,130,4,106,195,170,5,33,0,0,170,168,
    8,239,128,6,246,7,178,8,128,2,26,87,129,8,22,118,64,85,224,15,167,16,
    129,16,166,160,6,41,108,154,42,23,33,106,128,4,41,170,136,168,26,170,
    170,166,26,170,170,255,26,25,192,5,192,14,11,23,3,23,255,3,23,3,23,
    3,26,0,26,255,0,25,1,25,3,21,5,21,255,5,21,5,21,5,24,2,24,225,2,23,
    3,23,85,85,168,42,4,163,0,0,0,168,42,160,224,0,34,192,42,99,160,1,170,
    160,2,0,0,111,138,42,3,17,10,70,83,71,31,86,170,170,162,3,128,2,129,
    1,68,196,85,53,69,85,85,0,159,0,8,8,161,0,48,81,166,0,64,0,85,86,227,
    233,79,160,8,8,100,170,170,10,25,239,192,2,198,63,81,128,2,74,101,32,
    192,0,205,137,14,129,30,157,0,138,170,55,15,2,169,95,24,165,145,2,2,
    24,128,8,233,95,176,22,202,192,14,56,128,2,1,0,39,5,128,6,64,85,84,
    35,64,80,64,88,0,222,82,80,137,10,2,191,16,3,155,0,132,48,68,32,10,
    168,154,71,160,154,170,106,160,168,72,160,48,1,9,84,85,41,42,165,0,
    1,0,36,145,0,34,42,3,2,42,225,1,85,48,85,154,170,3,19,85,85,106,195,
    170,5,17,0,0,42,168,5,119,242,7,0,20,0,132,2,10,5,68,155,118,225,1,
    41,42,167,16,129,16,34,224,2,111,41,154,160,14,41,106,24,145,0,225,
    14,255,41,17,41,17,41,17,43,167,16,255,3,21,5,21,5,23,3,23,253,229,
    31,21,37,21,37,21,2,10,237,161,0,48,224,0,2,10,17,129,1,2,254,130,6,
    195,31,33,71,21,37,21,130,12,255,2,161,0,131,1,231,47,133,17,143,2,
    0,67,83,160,131,64,155,0,16,164,0,85,85,0,0,162,160,160,10,64,4,85,
    85,64,50,127,32,8,3,176,5,136,16,163,16,233,63,163,49,46,63,0,168,170,
    69,130,192,0,129,74,150,0,110,8,0,162,8,107,85,6,179,1,246,7,45,168,
    42,0,146,8,162,165,0,128,2,162,111,96,138,85,96,138,145,38,5,16,41,
    160,48,169,42,7,84,16,85,84,0,3,68,80,84,80,85,82,85,242,85,135,20,
    192,95,196,48,153,0,165,10,5,45,149,170,165,145,2,6,8,17,26,179,88,
    129,2,74,24,32,41,2,23,34,129,48,36,2,21,20,2,4,176,28,74,170,2,23,
    160,2,143,16,0,32,22,137,0,193,39,168,32,162,21,0,162,36,129,38,32,
    154,21,0,154,240,56,64,64,32,106,21,0,106,0,64,85,0,85,1,9,0,0,40,170,
    164,0,168,0,51,146,0,34,170,4,132,2,10,170,4,9,50,85,85,106,170,4,169,
    170,12,16,85,85,170,169,4,18,0,41,0,42,162,4,160,131,6,42,154,20,4,
    152,0,16,82,106,4,104,3,0,64,85,85,40,170,2,165,16,109,130,12,34,160,
    8,137,16,10,80,41,106,153,160,14,41,170,169,118,146,0,42,162,153,118,
    34,42,154,22,34,42,106,255,22,36,22,36,22,4,22,4,255,22,4,22,4,22,4,
    22,4,231,22,6,20,130,12,32,170,161,0,130,1,252,70,84,54,68,54,68,146,
    0,40,201,162,161,0,224,58,162,40,82,40,154,159,33,128,13,154,40,70,
    4,72,2,206,24,2,130,2,8,2,163,0,0,226,65,130,64,100,85,85,64,1,160,
    224,2,67,0,1,19,85,85,0,0,82,249,156,0,131,16,114,104,114,2,168,170,
    20,53,2,168,168,128,24,162,54,0,81,168,162,128,2,138,54,0,168,10,243,
    130,78,150,0,192,14,31,0,167,15,8,0,145,32,112,152,8,2,192,0,144,52,
    166,0,2,170,42,106,0,0,213,87,17,86,240,3,164,24,155,85,128,2,168,86,
    21,64,86,143,14,0,168,213,99,48,170,129,4,69,52,65,4,47,73,5,161,65,
    154,56,129,2,246,103,29,242,56,85,41,2,54,240,40,160,79,2,157,54,226,
    24,42,2,54,225,25,158,0,160,4,9,2,0,168,32,6,6,4,6,0,4,0,80,32,154,
    6,129,48,48,64,32,106,6,98,1,8,84,85,169,170,167,0,170,170,16,85,85,
    166,170,7,170,170,0,41,0,138,170,5,10,130,4,106,170,151,5,145,0,85,
    85,248,7,165,130,2,105,114,113,154,40,17,151,8,106,85,224,15,183,86,
    168,16,170,208,6,105,170,224,14,7,108,129,16,106,8,146,0,169,8,48,170,
    223,166,8,81,154,10,144,8,9,113,255,9,81,9,81,7,19,7,19,255,8,18,8,
    18,10,146,8,7,19,255,7,19,7,19,5,21,5,21,255,6,20,6,20,8,148,8,5,21,
    19,5,170,170,162,164,0,0,0,225,0,244,21,35,23,35,146,0,168,115,0,130,
    0,0,160,170,170,42,162,99,7,0,0,42,162,160,10,224,2,148,8,255,164,1,
    144,4,3,128,2,114,199,63,161,16,159,0,0,57,231,79,0,0,137,16,17,129,
    4,64,81,2,166,0,1,165,85,85,85,0,38,63,8,0,160,215,1,6,69,83,57,171,
    64,128,10,160,168,0,0,145,12,90,9,255,16,156,0,133,32,2,79,1,138,18,
    228,30,38,63,128,36,169,10,41,227,46,39,128,6,159,0,13,136,137,22,240,
    47,170,69,85,67,65,0,1,73,0,161,0,0,80,0,16,16,58,64,160,106,57,85,
    85,1,8,84,85,1,0,161,0,41,0,129,0,224,0,169,0,85,85,20,0,19,3,0,0,84,
    0,85,85,144,1,134,148,0,177,1,85,85,64,0,3,196,2,229,85,242,7,33,144,
    8,168,1,128,2,4,34,33,40,4,64,4,168,4,64,145,16,33,40,16,64,16,168,
    16,144,16,242,7,40,64,161,1,168,64,1,219,0,163,16,133,16,20,86,99,16,
    88,123,145,1,64,22,148,0,161,14,8,0,81,111,8,0,81,8,0,130,15,9,163,
    16,255,7,85,5,87,3,21,5,22,255,4,19,7,19,7,19,9,17,255,9,19,7,201,32,
    195,31,49,7,52,254,6,49,9,49,9,17,11,17,191,85,224,32,169,215,61,159,
    0,22,148,8,240,7,192,16,255,69,81,97,69,81,97,69,1,242,43,133,32,47,
    38,177,24,33,1,4,163,0,0,41,4,0,80,1,4,169,4,89,1,16,19,169,160,15,
    225,0,1,64,119,19,169,160,16,65,9,84,15,1,129,21,183,194,21,130,64,
    80,143,4,7,145,32,1,208,40,133,32,254,160,0,145,6,6,16,129,2,6,226,
    64,160,32,81,169,170,21,170,192,0,86,170,150,91,22,170,224,1,85,224,
    0,153,0,0,140,2,98,96,168,22,193,1,2,170,166,22,138,170,192,0,85,170,
    154,22,170,64,40,85,170,106,21,85,33,85,1,12,84,85,1,0,163,0,147,0,
    85,42,85,4,0,3,20,224,1,4,128,2,69,16,0,1,18,0,40,64,8,41,64,64,0,5,
    0,192,0,85,85,183,244,7,179,8,1,64,149,8,4,81,64,140,83,161,0,0,0,16,
    64,244,7,1,3,64,85,85,1,64,1,0,165,16,223,147,0,161,14,137,16,16,68,
    117,97,25,251,34,24,34,24,34,24,0,224,14,255,27,165,16,21,69,21,69,
    21,7,255,19,8,18,8,148,8,6,18,5,255,23,3,23,3,23,3,23,5,255,21,6,20,
    6,150,8,4,20,3,120,20,85,163,0,192,1,196,0,159,0,10,73,85,70,68,0,67,
    85,85,65,24,33,219,1,24,33,1,24,33,1,24,224,33,19,173,12,215,71,128,
    170,170,170,227,6,228,34,151,0,21,68,0,168,129,18,20,22,0,1,104,128,
    2,9,6,0,204,4,18,6,0,16,18,6,0,126,64,105,17,14,167,13,129,46,129,98,
    153,0,207,17,88,128,32,85,81,8,241,56,192,32,31,151,24,4,0,80,16,231,
    95,192,15,16,149,118,131,32,64,85,165,0,65,192,10,81,112,126,32,20,
    227,1,159,0,64,1,12,84,85,1,0,163,0,147,0,85,40,85,4,0,5,0,192,0,85,
    85,64,16,0,1,146,170,154,170,170,2,170,138,170,85,85,64,0,9,127,85,
    85,244,7,4,128,2,151,8,32,0,226,19,36,0,180,7,1,64,21,192,0,123,1,0,
    165,16,147,0,161,14,137,16,16,20,255,69,49,73,50,89,17,41,17,127,41,
    64,37,5,37,5,23,3,255,19,7,27,196,30,40,60,3,24,255,37,23,35,23,37,
    5,17,9,255,25,230,46,8,26,101,40,3,41,198,4,192,0,245,6,85,85,5,40,
    49,219,153,1,136,63,65,8,17,1,8,110,17,1,8,17,1,8,17,3,198,85,156,0,
    151,39,80,85,21,130,17,89,44,9,0,68,166,0,84,242,40,167,47,84,76,85,
    21,72,0,4,128,2,72,0,242,16,80,72,161,16,15,2,8,0,167,0,59,128,170,
    10,228,50,151,0,167,5,89,208,1,169,192,0,38,8,208,9,9,24,8,4,154,128,
    2,24,8,16,64,24,9,192,15,218,9,144,24,151,0,64,230,64,143,14,2,81,192,
    0,192,65,136,37,47,52,1,12,84,85,1,0,163,0,147,0,85,34,85,4,0,5,0,0,
    20,128,2,66,16,0,1,146,170,154,170,17,20,85,85,64,0,5,0,192,0,85,219,
    85,244,7,179,8,1,48,153,8,4,32,140,51,97,0,0,16,32,4,1,3,64,85,85,1,
    64,1,0,165,16,111,147,0,4,24,129,16,16,20,69,161,14,253,73,114,8,18,
    8,18,8,0,255,224,14,11,165,16,5,23,3,19,7,255,23,3,24,2,24,2,24,2,255,
    21,7,19,7,21,5,17,9,255,21,5,22,4,22,4,22,4,226,19,9,23,181,39,85,85,
    5,8,182,146,128,63,153,8,17,65,8,17,219,1,56,1,1,24,1,1,24,185,1,19,
    85,156,0,244,32,6,146,170,87,165,0,86,224,3,169,86,64,160,22,194,16,
    249,230,79,129,2,112,6,18,86,0,16,237,18,86,161,16,95,16,40,128,29,
    153,0,1,125,72,81,208,101,25,209,40,25,160,0,80,243,9,193,31,9,131,
    32,139,14,128,170,141,2,138,157,0,229,15,68,0,72,128,4,168,232,111,
    174,8,128,48,104,56,8,64,112,22,232,8,64,112,134,16,9,48,105,85,1,12,
    84,85,1,0,163,0,147,0,85,40,85,4,0,5,0,192,0,85,85,80,16,0,5,0,48,85,
    85,64,139,0,1,66,0,72,128,2,136,112,255,244,7,36,0,151,8,32,0,71,32,
    132,48,67,64,1,64,85,192,0,1,253,0,165,16,147,0,161,14,137,16,97,121,
    64,254,68,21,2,41,1,41,1,41,255,64,21,53,21,53,23,51,23,255,51,5,21,
    12,195,30,24,12,176,7,241,35,55,19,39,19,132,170,170,255,36,21,37,19,
    7,26,229,46,8,252,26,146,8,17,41,4,192,0,245,6,85,109,85,5,134,32,3,
    17,24,1,73,182,24,1,1,24,1,1,24,1,238,1,24,1,19,85,156,0,244,32,32,
    237,128,128,32,129,82,41,17,152,43,33,8,163,247,5,31,53,8,168,0,0,170,
    10,142,16,254,175,7,10,139,18,143,2,30,209,29,229,64,131,17,192,32,
    88,160,81,170,17,4,207,31,53,1,12,80,85,5,0,163,0,147,0,85,192,85,148,
    1,18,80,85,85,85,16,176,0,1,26,224,1,129,1,85,85,64,173,0,1,74,128,
    2,74,96,128,6,1,10,65,10,1,0,0,192,0,1,0,158,4,49,10,4,0,16,80,146,
    8,120,10,16,16,0,16,34,10,64,3,85,85,10,64,5,64,5,192,12,95,137,16,
    4,170,16,80,224,15,19,5,161,14,253,9,82,8,82,8,18,8,0,255,128,15,11,
    165,16,5,121,1,19,7,255,19,7,19,7,19,7,19,7,249,19,9,19,7,25,227,47,
    85,85,255,9,17,9,17,9,17,57,1,255,25,1,21,233,61,159,0,18,19,33,193,
    16,255,5,17,34,4,17,34,52,65,253,2,149,24,224,15,19,129,1,159,0,10,
    133,15,10,237,108,128,32,42,192,15,84,41,80,80,191,41,80,64,9,61,129,
    12,231,48,159,0,0,183,15,1,192,32,69,41,128,2,5,25,33,249,25,33,26,
    32,143,32,7,149,3,154,170,66,165,0,170,192,0,106,85,106,170,53,132,
    170,64,90,85,170,169,54,170,81,170,169,0,166,54,170,170,166,232,0,154,
    8,0,54,85,192,1,85,85,1,12,80,85,5,0,161,0,149,0,85,210,85,165,1,161,
    3,85,16,16,0,1,165,0,226,0,16,160,2,64,0,1,0,86,98,64,129,6,1,2,0,131,
    1,128,2,190,4,2,0,67,80,154,8,0,146,7,11,85,85,5,64,5,64,5,130,13,127,
    135,16,4,166,16,99,161,14,9,17,9,255,18,8,18,8,18,154,8,163,16,7,255,
    51,7,55,145,0,195,30,73,51,39,255,52,38,52,38,52,152,8,17,5,199,167,
    13,159,0,20,229,46,85,85,69,6,17,255,128,10,6,17,128,2,6,17,80,151,
    24,246,224,15,63,44,240,6,58,160,0,84,57,96,254,80,57,129,15,25,135,
    32,161,17,159,0,0,146,28,31,85,5,85,4,168,49,28,224,54,161,16,255,22,
    225,56,25,129,2,25,113,10,49,181,15,0,235,13,2,247,7,178,71,26,100,
    106,84,16,96,160,10,74,68,42,48,32,20,1,80,85,10,52,42,48,32,211,4,
    16,52,42,144,8,32,16,112,86,4,42,128,15,37,192,0,10,4,241,0,255,69,
    232,16,39,57,231,111,133,80,54,68,248,54,68,54,148,8,21,133,48,85,85,
    1,8,84,85,169,170,163,0,165,170,134,170,192,0,85,85,166,170,3,147,0,
    21,85,85,154,170,3,90,224,1,154,60,128,2,106,170,3,133,4,244,7,33,170,
    118,170,169,96,149,8,177,8,166,48,69,232,154,65,48,5,106,193,1,169,
    170,222,86,164,16,131,16,166,70,147,0,161,14,89,255,106,70,116,1,24,
    2,24,2,255,24,227,14,25,165,16,21,69,21,69,255,21,5,21,8,18,8,18,8,
    255,148,8,5,53,3,55,3,55,3,64,51,98,162,0,85,85,98,170,170,63,0,0,0,
    19,6,20,6,20,254,6,149,24,4,55,1,57,1,51,68,20,85,163,0,85,85,90,192,
    0,16,68,85,80,4,85,85,10,48,42,40,85,0,1,3,85,161,1,0,42,255,1,149,
    8,162,16,54,116,6,195,15,226,16,115,159,0,13,138,166,0,227,1,93,16,
    1,101,127,176,24,85,135,16,34,193,16,231,79,129,2,54,254,242,56,15,
    17,157,0,208,6,52,129,34,193,0,51,175,20,129,32,84,42,166,176,54,41,
    193,15,255,41,31,19,15,8,129,48,234,111,128,64,42,16,224,42,16,41,129,
    16,85,85,1,8,84,85,169,170,163,0,165,170,134,170,192,0,85,85,166,170,
    3,147,0,20,85,85,154,170,5,170,16,85,63,85,106,170,5,131,4,244,7,36,
    128,2,254,149,8,18,32,55,16,32,54,177,9,55,169,170,86,164,16,131,16,
    166,54,147,0,191,161,14,73,106,56,98,113,25,49,223,25,49,25,106,7,131,
    16,5,37,255,5,37,7,35,23,3,28,195,30,255,8,28,129,15,20,37,3,23,3,255,
    23,5,21,5,21,10,229,46,24,255,10,163,15,2,23,33,9,17,9,246,19,7,19,
    7,20,1,5,20,255,4,5,24,197,47,16,215,24,159,0,8,155,55,161,129,17,21,
    90,192,0,106,85,16,1,143,165,0,128,2,1,42,1,167,47,112,134,32,207,97,
    16,136,16,170,106,16,95,17,159,0,14,3,229,17,20,85,42,1,0,84,89,250,
    209,40,41,209,23,41,228,48,15,13,146,166,0,34,16,0,0,232,31,85,85,74,
    217,1,3,85,16,85,0,1,0,1,239,111,26,0,129,48,85,85,1,8,84,85,169,170,
    163,0,165,170,134,170,192,0,85,85,166,170,3,147,0,17,85,85,154,170,
    5,170,170,90,60,128,2,106,170,5,131,4,244,7,33,170,118,170,169,80,149,
    8,177,8,166,32,57,227,154,32,54,193,1,169,170,86,164,16,109,131,16,
    166,38,147,0,154,40,49,106,255,40,82,161,14,56,34,56,34,56,255,227,
    14,57,165,16,21,37,21,39,19,255,39,19,8,18,8,18,8,18,255,7,21,3,23,
    3,23,5,21,255,5,21,6,20,6,20,6,20,255,5,23,1,25,1,25,3,23,255,3,23,
    4,22,4,22,4,22,208,195,15,226,16,159,0,13,138,166,0,42,0,0,71,0,10,
    215,71,170,90,85,194,20,230,79,153,130,2,134,16,170,166,114,6,170,154,
    159,18,6,170,106,18,15,15,157,0,208,6,224,116,129,8,193,0,19,20,85,
    0,1,23,0,84,170,1,232,95,166,240,37,136,16,248,194,15,120,143,32,20,
    249,7,224,15,143,18,7,16,85,7,42,1,0,0,170,86,26,145,6,128,157,8,27,
    85,1,8,84,85,1,0,163,0,0,0,134,42,192,0,85,85,166,0,3,147,0,25,85,85,
    16,0,7,129,2,64,0,247,7,81,244,7,212,8,80,4,72,33,215,154,8,32,212,
    7,5,192,0,85,224,15,165,16,107,131,16,166,38,147,0,16,42,0,144,7,163,
    41,80,1,10,0,0,4,10,255,144,8,10,64,5,133,16,37,5,21,255,5,25,1,25,
    1,26,0,26,248,146,8,24,66,19,7,19,0,0,255,10,4,19,7,23,3,23,3,255,24,
    2,24,148,8,22,68,17,3,19,151,0,69,85,10,249,1,85,21,8,109,81,21,8,65,
    69,8,65,5,183,56,1,5,24,1,5,153,24,160,15,155,29,159,0,4,2,0,165,0,
    3,34,22,81,132,2,1,21,80,193,32,0,34,4,206,21,64,128,16,34,16,53,0,
    16,98,34,64,37,97,85,85,10,224,46,135,10,228,11,160,170,170,170,244,
    10,159,0,3,255,129,68,233,95,129,20,73,130,2,72,114,8,168,18,246,7,
    5,226,31,2,164,0,0,85,255,5,192,0,159,0,0,205,16,137,16,128,48,235,
    111,144,73,22,74,4,0,80,74,16,217,7,51,1,8,84,85,1,0,163,0,21,0,1,5,
    0,0,0,85,85,166,170,50,3,128,170,240,1,128,2,16,0,3,39,0,0,42,50,64,
    0,7,49,223,244,7,19,49,4,24,33,149,8,210,8,185,32,88,85,224,15,165,
    16,131,16,166,170,182,37,51,16,38,51,64,42,144,0,143,1,10,0,0,4,10,
    144,8,10,255,64,9,129,16,37,5,21,5,21,255,5,25,1,26,0,26,146,8,24,251,
    66,23,3,19,7,19,128,225,11,143,244,6,17,0,0,32,4,23,35,252,8,18,8,148,
    8,6,84,5,85,110,85,65,164,0,145,0,5,226,0,37,242,15,57,0,20,85,19,129,
    2,129,16,80,85,255,19,163,16,5,38,4,38,149,24,37,132,117,4,85,85,161,
    170,165,0,170,200,170,129,32,159,0,14,84,85,53,0,85,149,106,224,16,
    170,169,53,106,193,1,170,214,212,87,0,128,2,166,64,154,5,64,186,154,
    64,106,53,0,144,8,66,20,185,64,16,101,230,30,147,0,225,32,40,0,159,
    17,161,31,0,0,224,7,160,51,123,233,95,255,130,2,104,114,8,18,10,16,
    168,0,127,159,0,2,32,192,15,97,117,233,111,128,48,59,139,144,73,58,
    4,0,80,58,16,252,7,0,160,16,1,8,84,85,1,0,153,0,80,85,48,5,0,4,162,
    0,3,84,85,17,65,0,16,24,84,85,65,0,64,101,16,72,196,0,128,8,1,0,16,
    8,221,84,128,2,242,7,8,4,16,146,7,8,162,4,16,64,161,0,9,64,5,50,223,
    1,161,8,136,16,4,166,16,147,0,161,14,73,255,97,65,53,2,40,2,40,2,31,
    40,0,64,85,18,7,27,177,6,255,19,5,27,193,31,17,39,19,39,239,19,39,19,
    39,1,18,9,25,251,195,47,17,7,25,1,17,73,8,109,17,9,8,17,9,8,17,9,251,
    8,17,5,218,63,159,0,1,135,63,21,8,109,17,69,8,17,5,8,17,5,187,8,17,
    5,8,17,3,85,159,0,13,220,168,47,194,1,5,72,192,36,193,32,5,8,102,1,
    80,98,69,8,4,128,2,24,110,8,16,32,24,9,4,235,95,151,0,63,40,0,32,232,
    48,7,55,99,55,254,67,55,67,55,3,23,193,31,135,32,188,81,192,0,69,160,
    0,159,0,6,129,4,1,105,65,170,106,120,90,85,169,169,170,153,56,128,2,
    166,170,56,80,154,170,168,56,80,106,5,165,192,0,85,85,1,10,84,85,1,
    0,145,0,8,192,0,0,40,0,20,0,80,85,5,0,193,4,162,0,195,2,84,85,17,0,
    16,81,32,24,18,40,128,2,65,0,64,40,33,170,74,32,66,96,1,1,137,0,0,168,
    169,170,0,2,1,137,16,242,7,168,166,170,0,2,4,132,16,81,16,168,154,170,
    32,2,160,16,64,64,17,169,106,165,106,118,169,106,160,1,161,8,136,16,
    4,166,16,195,2,219,16,116,101,64,21,36,0,161,14,108,40,0,81,40,0,81,
    8,0,127,64,85,50,7,51,7,53,5,255,51,7,20,6,19,7,19,7,186,19,7,1,18,
    9,17,9,2,247,0,196,47,17,39,1,25,24,2,182,24,1,169,24,1,169,24,1,254,
    169,24,1,21,210,63,148,0,17,121,237,8,128,34,3,65,21,8,65,69,182,8,
    65,165,56,1,165,24,1,238,165,24,1,19,85,159,0,13,227,83,195,33,172,
    8,56,64,192,36,73,224,0,53,168,102,169,90,192,32,55,168,166,128,2,8,
    103,168,154,16,8,169,106,113,129,48,13,197,31,32,0,168,170,129,92,231,
    14,80,227,192,30,199,33,227,4,131,4,85,85,81,133,20,25,134,16,170,169,
    86,225,1,118,170,166,155,128,2,24,170,154,32,24,165,160,16,69,128,1,
    170,153,0,150,170,86,136,12,69,93,143,35,9,89,192,0,73,48,131,63,165,
    0,106,255,84,101,128,2,82,5,16,224,46,3,0,129,48,105,85,1,10,84,85,
    1,0,163,0,85,160,1,153,21,224,0,20,0,3,147,0,85,85,129,148,1,66,64,
    85,85,85,64,0,7,1,106,0,170,170,106,32,128,4,6,242,7,42,1,170,170,42,
    0,128,2,157,4,113,42,4,64,0,64,16,60,81,42,16,0,48,0,146,8,42,205,64,
    0,48,1,0,165,16,131,16,20,174,6,147,0,16,10,64,224,15,3,21,219,0,161,
    14,24,0,1,24,0,1,255,24,177,24,27,165,16,21,5,21,9,255,17,3,23,3,23,
    3,23,3,255,23,3,25,3,23,3,23,10,63,162,0,85,85,25,1,25,33,9,254,17,
    9,17,11,17,3,159,0,24,128,8,127,0,42,4,81,9,65,9,65,216,57,1,27,1,160,
    10,31,26,42,0,237,170,192,0,23,128,32,86,25,0,90,191,25,0,106,25,5,
    239,27,7,128,28,224,36,95,202,2,40,59,170,225,0,56,129,6,57,254,129,
    2,57,1,26,225,48,240,46,146,0,144,40,112,85,21,213,1,111,1,129,4,86,
    85,64,57,85,106,170,165,0,128,64,176,8,170,169,1,54,170,170,169,106,
    85,170,166,20,54,170,170,166,128,2,154,54,170,96,170,154,0,154,8,106,
    85,1,12,84,85,169,170,163,0,147,0,85,32,85,166,0,3,148,0,0,0,4,150,
    0,85,85,154,10,3,168,0,10,0,0,170,10,85,85,106,128,2,3,104,2,0,0,106,
    2,18,85,85,170,1,3,168,1,128,4,165,1,128,2,4,3,168,4,112,4,74,16,16,
    3,168,16,16,16,16,145,64,3,169,64,193,1,169,170,86,183,164,16,147,0,
    166,160,14,137,16,154,32,57,254,33,57,34,56,2,24,2,24,238,170,226,14,
    25,165,16,170,129,12,48,5,221,20,36,5,40,128,2,33,5,104,219,96,33,5,
    40,36,5,40,36,105,5,40,36,53,41,130,1,137,2,4,161,0,84,85,137,2,168,
    129,12,2,68,4,0,49,85,85,4,2,20,67,0,16,50,85,85,16,0,1,194,161,14,
    165,16,1,64,0,0,1,81,63,85,85,0,2,192,1,146,8,128,2,50,247,96,114,0,
    18,32,64,161,0,0,8,18,0,64,5,0,115,84,85,176,129,240,3,168,160,14,35,
    85,85,21,55,85,85,85,21,161,16,41,18,242,7,27,32,85,85,105,8,113,41,
    8,111,65,41,8,65,41,56,1,19,149,208,12,154,0,162,2,165,0,128,240,5,
    130,150,192,60,91,170,2,101,168,194,3,229,79,51,170,1,104,224,7,135,
    16,0,4,130,2,49,102,0,16,114,6,0,64,105,183,17,8,149,194,0,167,13,40,
    224,65,237,15,246,153,0,128,50,161,16,132,32,130,48,84,137,16,80,222,
    80,105,80,64,9,67,244,94,144,0,152,130,208,9,84,85,135,28,130,78,2,
    170,254,0,165,0,130,2,56,132,4,54,129,64,160,74,238,6,21,97,32,18,5,
    17,32,192,66,5,129,16,85,85,1,12,84,85,169,170,165,0,145,0,85,34,85,
    166,0,3,150,0,0,192,0,16,85,85,154,10,3,170,10,0,2,0,170,10,85,85,106,
    10,5,38,0,0,106,128,2,170,1,5,128,4,181,1,96,4,37,16,4,16,16,172,37,
    16,16,16,64,37,193,1,169,109,170,86,166,16,145,0,166,160,14,137,16,
    154,255,160,12,89,65,89,2,24,2,24,255,2,24,227,14,25,167,16,19,37,21,
    255,37,21,39,19,7,19,7,19,255,7,19,7,21,5,21,3,23,215,3,23,4,2,16,2,
    163,15,3,255,21,5,21,5,21,53,7,19,220,7,17,4,2,163,0,192,5,128,14,170,
    127,2,106,116,48,72,51,71,51,250,71,51,7,195,15,195,0,149,0,149,64,
    16,169,85,4,84,165,0,21,84,85,101,85,20,64,91,162,10,117,2,208,128,
    34,162,14,36,106,224,3,0,1,0,163,4,37,66,129,2,4,0,16,37,30,2,16,0,
    64,21,2,136,16,147,0,126,170,2,22,225,11,192,28,111,6,192,3,161,16,
    132,1,117,42,1,0,84,137,16,42,45,4,0,80,105,42,193,15,104,42,189,0,
    25,129,226,0,135,32,195,31,135,14,42,227,193,14,160,64,165,0,130,2,
    10,170,9,37,157,128,16,224,54,170,6,37,80,49,18,216,37,0,17,66,37,1,
    85,85,1,10,84,85,169,170,165,0,170,192,0,21,85,85,166,170,3,150,128,
    2,150,48,48,154,170,3,147,0,85,85,106,167,170,5,170,16,85,85,246,7,
    145,8,254,49,37,82,48,37,82,48,38,3,85,105,170,106,169,170,86,166,16,
    111,129,16,166,54,67,154,54,147,0,161,14,63,73,170,169,56,1,17,57,17,
    127,57,106,7,35,7,35,5,37,255,5,37,23,3,24,2,28,195,30,255,8,23,37,
    5,21,3,23,3,255,23,5,21,6,20,10,229,46,24,255,5,23,35,7,17,9,17,9,246,
    19,7,20,6,20,6,5,20,238,18,5,19,9,169,130,30,179,8,159,0,10,131,104,
    166,0,168,85,85,169,104,128,17,67,53,104,192,0,169,85,64,4,69,26,128,
    2,5,168,4,167,47,176,14,153,135,16,124,170,106,16,74,131,32,159,0,46,
    229,17,80,13,84,168,4,0,80,73,160,0,86,218,41,195,32,43,86,228,44,15,
    8,72,54,52,64,0,0,176,32,7,41,217,1,85,6,64,84,0,4,0,4,239,111,10,129,
    48,0,85,85,1,8,80,85,5,0,161,0,165,170,0,170,170,165,0,149,170,85,85,
    129,0,152,0,21,0,85,85,16,0,133,3,19,85,85,64,0,5,96,164,192,0,128,
    6,1,1,170,169,1,128,164,169,128,2,4,1,170,166,1,128,201,166,16,242,
    7,170,154,1,128,154,128,16,210,7,170,106,149,106,170,106,27,128,106,
    5,0,163,16,133,16,4,161,10,121,40,16,22,147,0,161,14,41,0,1,153,19,
    5,0,4,19,5,0,16,159,19,5,0,64,19,7,19,7,255,25,1,21,5,23,3,19,7,255,
    19,7,19,7,19,9,17,9,255,25,195,31,17,7,21,5,17,9,252,17,9,17,9,17,5,
    199,45,128,123,170,160,192,0,233,63,159,0,2,197,47,85,176,20,182,7,
    161,16,149,120,1,149,24,1,225,149,24,1,27,160,170,170,0,200,17,159,
    0,14,231,79,0,85,9,170,169,204,106,192,32,7,170,166,128,2,8,170,204,
    154,96,56,170,106,65,26,170,143,10,140,32,32,0,40,198,1,193,15,160,
    6,170,143,36,0,22,170,192,95,170,24,170,32,170,170,24,170,32,170,24,
    149,162,16,124,165,170,165,0,128,64,194,12,147,0,144,36,85,59,149,85,
    21,245,1,78,129,4,80,192,0,255,131,63,165,0,193,30,57,65,57,128,2,224,
    46,128,51,129,48,106,85,1,8,84,85,1,0,161,0,169,2,65,169,170,192,0,
    0,85,85,4,0,83,3,84,160,1,84,128,2,80,0,3,52,147,0,85,85,148,1,245,
    1,85,242,7,1,14,170,1,170,170,168,224,0,64,18,21,170,4,170,170,192,
    0,4,48,16,58,161,0,170,16,48,32,0,64,113,109,170,64,0,16,1,128,13,137,
    16,4,183,166,16,115,80,6,147,0,64,11,224,15,182,3,21,0,161,14,24,0,
    1,24,127,0,64,67,23,67,23,69,21,255,5,21,10,194,15,1,23,3,23,255,3,
    23,3,25,1,25,3,23,231,3,23,10,146,8,85,85,25,1,255,25,33,9,17,11,18,
    8,17,199,3,159,0,24,0,0,170,0,149,8,160,12,243,8,114,8,98,42,169,2,
    194,32,199,22,36,239,15,24,0,170,2,192,0,22,110,192,15,90,25,0,106,
    25,141,32,129,48,35,86,85,169,143,12,8,2,170,170,192,22,127,202,2,160,
    27,208,3,26,129,6,25,129,2,236,26,225,48,224,46,168,0,86,192,2,147,
    0,5,240,84,208,0,193,0,79,5,129,4,89,85,1,170,85,216,7,170,146,8,166,
    166,0,170,96,43,85,170,154,54,170,64,85,224,32,64,53,170,64,85
};

static MTB * mtb_KRPKR = NULL;

void initMTB_KRPKR()
{
    mtb_KRPKR = new MTB ("KRPKR", 2, 86);
    mtb_KRPKR->SetPackedData (mtbdata_KRPKR);
    mtb_KRPKR->Add (A7, A8, C8, WHITE, 235);
    mtb_KRPKR->Add (A7, A8, C7, WHITE, 248);
    mtb_KRPKR->Add (A7, A8, D7, WHITE, 134);
    mtb_KRPKR->Add (A7, A6, A8, WHITE, 226);
    mtb_KRPKR->Add (A7, B6, A8, WHITE, 226);
    mtb_KRPKR->Add (B7, B8, D7, WHITE, 24);
    mtb_KRPKR->Add (B7, B8, D8, WHITE, 13);
    mtb_KRPKR->Add (B7, B8, E7, WHITE, 19);
    mtb_KRPKR->Add (B7, A6, B8, WHITE, 244);
    mtb_KRPKR->Add (B7, A6, C7, WHITE, 135);
    mtb_KRPKR->Add (B7, B6, B8, WHITE, 223);
    mtb_KRPKR->Add (B7, C6, B8, WHITE, 226);
    mtb_KRPKR->Add (B7, C6, A7, WHITE, 229);
    mtb_KRPKR->Add (B7, C6, E7, WHITE, 24);
    mtb_KRPKR->Add (C7, C8, A7, WHITE, 54);
    mtb_KRPKR->Add (C7, C8, A6, WHITE, 51);
    mtb_KRPKR->Add (C7, C8, E7, WHITE, 31);
    mtb_KRPKR->Add (C7, C8, E6, WHITE, 31);
    mtb_KRPKR->Add (C7, C8, F7, WHITE, 23);
    mtb_KRPKR->Add (D7, D8, B7, WHITE, 83);
    mtb_KRPKR->Add (D7, D8, C6, WHITE, 97);
    mtb_KRPKR->Add (D7, D8, E6, WHITE, 67);
    mtb_KRPKR->Add (D7, D8, F7, WHITE, 38);
    mtb_KRPKR->Add (D7, C6, D8, WHITE, 247);
    mtb_KRPKR->Add (A6, A7, C6, WHITE, 287);
    mtb_KRPKR->Add (A6, A7, C7, WHITE, 244);
    mtb_KRPKR->Add (A6, A7, C8, WHITE, 236);
    mtb_KRPKR->Add (A6, A7, D7, WHITE, 216);
    mtb_KRPKR->Add (A6, B6, A8, WHITE, 191);
    mtb_KRPKR->Add (A6, B5, A7, WHITE, 283);
    mtb_KRPKR->Add (B6, B7, D6, WHITE, 18);
    mtb_KRPKR->Add (B6, B7, D7, WHITE, 13);
    mtb_KRPKR->Add (B6, B7, D8, WHITE, 13);
    mtb_KRPKR->Add (B6, B8, A6, WHITE, 287);
    mtb_KRPKR->Add (B6, B8, C6, WHITE, 122);
    mtb_KRPKR->Add (B6, A6, B8, WHITE, 175);
    mtb_KRPKR->Add (B6, A6, C8, WHITE, 122);
    mtb_KRPKR->Add (B6, C6, B8, WHITE, 197);
    mtb_KRPKR->Add (C6, C7, A6, WHITE, 192);
    mtb_KRPKR->Add (C6, C7, A7, WHITE, 123);
    mtb_KRPKR->Add (C6, C7, E7, WHITE, 17);
    mtb_KRPKR->Add (C6, B6, C8, WHITE, 128);
    mtb_KRPKR->Add (C6, D6, C8, WHITE, 197);
    mtb_KRPKR->Add (A7, A8, C8, BLACK, 80);
    mtb_KRPKR->Add (A7, A8, C7, BLACK, 181);
    mtb_KRPKR->Add (A7, A8, D7, BLACK, 75);
    mtb_KRPKR->Add (A7, A6, A8, BLACK, 282);
    mtb_KRPKR->Add (A7, B6, A8, BLACK, 249);
    mtb_KRPKR->Add (B7, B8, D7, BLACK, 266);
    mtb_KRPKR->Add (B7, B8, D8, BLACK, 251);
    mtb_KRPKR->Add (B7, B8, E7, BLACK, 211);
    mtb_KRPKR->Add (B7, A6, B8, BLACK, 291);
    mtb_KRPKR->Add (B7, A6, C7, BLACK, 350);
    mtb_KRPKR->Add (B7, B6, B8, BLACK, 275);
    mtb_KRPKR->Add (B7, C6, B8, BLACK, 296);
    mtb_KRPKR->Add (B7, C6, A7, BLACK, 305);
    mtb_KRPKR->Add (B7, C6, E7, BLACK, 134);
    mtb_KRPKR->Add (C7, C8, A7, BLACK, 281);
    mtb_KRPKR->Add (C7, C8, A6, BLACK, 265);
    mtb_KRPKR->Add (C7, C8, E7, BLACK, 281);
    mtb_KRPKR->Add (C7, C8, E6, BLACK, 245);
    mtb_KRPKR->Add (C7, C8, F7, BLACK, 217);
    mtb_KRPKR->Add (D7, D8, B7, BLACK, 293);
    mtb_KRPKR->Add (D7, D8, C6, BLACK, 332);
    mtb_KRPKR->Add (D7, D8, E6, BLACK, 345);
    mtb_KRPKR->Add (D7, D8, F7, BLACK, 280);
    mtb_KRPKR->Add (D7, C6, D8, BLACK, 306);
    mtb_KRPKR->Add (A6, A7, C6, BLACK, 267);
    mtb_KRPKR->Add (A6, A7, C7, BLACK, 254);
    mtb_KRPKR->Add (A6, A7, C8, BLACK, 265);
    mtb_KRPKR->Add (A6, A7, D7, BLACK, 215);
    mtb_KRPKR->Add (A6, B6, A8, BLACK, 268);
    mtb_KRPKR->Add (A6, B5, A7, BLACK, 263);
    mtb_KRPKR->Add (B6, B7, D6, BLACK, 264);
    mtb_KRPKR->Add (B6, B7, D7, BLACK, 236);
    mtb_KRPKR->Add (B6, B7, D8, BLACK, 244);
    mtb_KRPKR->Add (B6, B8, A6, BLACK, 265);
    mtb_KRPKR->Add (B6, B8, C6, BLACK, 286);
    mtb_KRPKR->Add (B6, A6, B8, BLACK, 264);
    mtb_KRPKR->Add (B6, A6, C8, BLACK, 331);
    mtb_KRPKR->Add (B6, C6, B8, BLACK, 276);
    mtb_KRPKR->Add (C6, C7, A6, BLACK, 387);
    mtb_KRPKR->Add (C6, C7, A7, BLACK, 305);
    mtb_KRPKR->Add (C6, C7, E7, BLACK, 246);
    mtb_KRPKR->Add (C6, B6, C8, BLACK, 305);
    mtb_KRPKR->Add (C6, D6, C8, BLACK, 280);
}

//////////////////////////////////////////////////////////////////////
//
// KPPKP

static const byte mtbdata_KPPKP[1992] = {
    1,32,80,85,147,0,64,85,65,85,244,69,224,0,5,143,2,255,63,77,85,63,45,
    0,188,80,143,16,44,69,194,0,137,12,47,0,139,4,1,159,84,107,1,80,143,
    32,44,31,2,229,83,231,6,205,57,137,2,1,5,80,15,62,93,0,236,29,192,16,
    133,10,1,0,150,22,15,96,65,136,85,15,10,106,85,105,95,3,1,35,80,85,
    149,0,64,85,65,192,0,227,7,143,2,255,63,205,15,0,65,85,81,60,148,139,
    6,59,0,80,143,16,48,84,143,18,11,85,201,85,231,85,81,1,84,27,1,80,141,
    143,32,60,79,14,1,84,0,152,22,17,0,144,152,20,31,94,64,85,31,34,1,32,
    80,85,147,0,5,85,21,85,58,1,85,0,228,1,143,2,255,47,79,69,44,151,85,
    47,29,5,80,44,64,143,16,28,15,18,197,141,6,123,60,64,21,64,47,32,81,
    85,60,84,60,64,43,84,44,80,82,12,64,143,32,60,85,45,84,0,150,20,159,
    69,81,80,0,245,105,129,12,1,150,22,64,15,97,85,15,18,1,32,80,85,145,
    0,1,84,0,84,155,1,160,0,0,84,242,1,143,2,96,85,63,45,31,143,16,45,69,
    85,64,192,10,224,10,35,144,0,171,63,12,142,10,80,44,64,44,0,143,16,
    12,85,31,2,65,160,0,64,230,1,0,111,14,80,120,44,64,44,162,16,47,4,195,
    64,85,85,255,81,0,159,0,6,161,15,62,135,2,49,160,16,253,58,96,58,0,
    143,32,14,253,33,133,18,81,107,164,13,65,198,35,131,8,1,21,85,18,255,
    224,48,134,12,17,48,134,2,164,16,143,48,24,139,17,254,197,36,85,128,
    66,162,8,70,192,32,225,32,131,2,31,9,84,10,84,66,148,56,34,146,16,253,
    40,60,197,27,47,2,1,41,1,65,240,162,16,8,226,48,138,12,54,41,84,42,
    112,84,41,98,74,32,1,32,64,85,145,0,0,84,1,84,59,5,84,0,160,0,242,1,
    143,2,91,69,143,16,109,75,161,16,5,140,4,21,85,49,1,16,74,51,85,31,
    13,0,80,28,64,28,70,0,0,143,18,11,5,84,21,26,159,0,2,241,5,196,0,134,
    16,40,16,80,5,84,191,129,25,22,64,16,224,4,22,160,16,15,8,126,159,0,
    4,81,140,2,161,53,7,225,36,53,34,103,80,69,230,9,18,64,1,135,4,3,153,
    31,29,15,24,64,85,17,135,2,0,85,123,1,17,211,91,131,14,164,16,15,70,
    65,225,49,224,86,32,224,37,23,42,84,41,84,255,5,146,16,136,2,31,63,
    7,21,117,132,14,16,8,169,84,37,2,1,32,80,85,145,0,5,85,21,84,57,1,84,
    0,160,0,242,1,129,2,85,17,143,18,55,85,85,69,228,1,53,193,0,59,52,84,
    21,161,7,228,7,19,21,128,4,3,165,4,5,80,21,80,5,84,161,0,111,23,1,113,
    4,69,140,16,161,13,57,255,1,197,0,51,227,15,134,12,21,37,20,255,8,18,
    15,22,129,7,55,149,0,135,32,231,4,217,133,10,242,0,71,64,41,128,2,0,
    0,255,24,34,138,16,159,0,18,31,8,84,200,9,0,135,160,16,72,0,0,0,4,11,
    51,245,10,211,24,159,0,34,132,32,91,64,60,0,122,60,0,47,28,207,33,10,
    129,66,138,2,84,60,91,80,21,33,0,25,32,0,47,56,247,233,45,132,96,168,
    16,2,59,80,224,15,54,254,141,10,143,2,30,63,2,201,32,2,168,16,132,96,
    0,1,42,160,170,145,0,0,160,0,2,16,213,0,226,1,143,2,224,10,76,42,143,
    8,14,168,81,76,160,76,128,143,16,28,170,170,138,106,12,170,12,30,168,
    28,160,28,191,128,143,32,28,42,192,0,27,159,0,0,28,160,16,253,26,64,
    26,64,143,32,24,47,20,133,6,128,255,0,80,224,48,134,10,81,96,134,2,
    1,151,16,15,70,128,170,2,168,120,1,43,243,105,170,21,160,0,22,1,128,
    136,2,222,136,14,77,15,34,130,160,16,58,0,26,174,170,23,85,160,0,86,
    160,2,133,8,135,2,1,35,160,170,147,0,2,170,0,194,0,213,5,143,2,255,
    63,77,10,60,42,60,170,86,141,8,168,60,160,12,128,143,16,28,159,0,2,
    42,130,170,128,47,10,168,44,160,44,175,128,47,32,162,143,18,11,170,
    8,34,192,32,252,42,48,42,48,143,32,42,159,0,0,135,6,162,191,170,66,
    168,136,10,49,245,105,129,2,49,175,150,22,15,14,162,192,27,138,170,
    33,182,9,120,240,139,6,12,194,32,106,15,17,1,32,160,170,145,0,0,168,
    10,168,56,0,168,2,192,0,242,1,143,2,79,21,168,53,26,168,21,143,14,89,
    143,16,14,10,140,4,42,83,143,12,30,160,60,128,12,0,0,95,12,231,160,
    16,105,49,138,8,170,170,44,193,0,95,42,160,28,128,28,80,31,8,159,0,
    14,215,16,139,14,31,2,160,28,128,28,194,32,30,31,10,138,170,136,31,
    5,225,84,194,16,132,2,128,128,140,18,5,170,10,160,5,160,195,2,64,134,
    12,128,21,128,2,48,61,22,0,21,162,16,143,32,20,227,98,151,0,128,239,
    192,19,139,16,96,75,170,66,148,7,130,12,254,65,145,21,85,178,32,47,
    4,129,10,180,5,79,3,60,149,170,154,192,0,103,19,136,58,170,210,26,32,
    60,168,60,168,2,15,1,1,0,160,170,170,170,0,160,2,120,160,0,160,0,225,
    0,240,1,143,2,79,5,160,37,6,160,5,56,10,168,139,4,42,107,60,0,63,14,
    141,14,128,60,0,225,1,51,136,16,0,4,59,160,0,0,168,224,10,238,192,0,
    17,160,16,10,0,194,14,8,143,16,16,236,128,92,18,88,0,9,159,0,4,0,111,
    170,2,162,15,15,3,168,15,15,112,10,212,96,26,134,2,128,160,0,138,224,
    2,138,124,170,130,160,1,159,0,2,194,68,227,14,18,128,255,170,81,137,
    36,142,52,17,226,48,132,20,164,16,199,134,64,81,134,2,160,170,162,164,
    13,133,1,124,155,0,128,160,19,32,164,33,164,35,8,5,63,168,6,168,137,
    42,130,76,1,192,32,134,2,219,164,16,15,2,143,30,0,162,194,30,105,128,
    196,15,224,167,51,92,160,50,5,21,160,22,160,255,21,160,16,225,32,136,
    2,146,14,95,2,129,14,229,48,199,89,139,16,39,5,170,6,192,0,224,16,208,
    59,226,82,136,12,160,53,85,160,86,88,160,85,160,0,22,132,14,137,2,1,
    0,32,170,10,170,0,160,0,108,160,2,160,0,129,1,170,144,0,143,2,78,21,
    16,160,21,160,22,52,10,170,42,85,170,10,140,4,42,143,14,46,128,60,0,
    81,140,16,0,7,170,128,32,10,160,10,58,11,168,42,74,161,12,138,10,168,
    15,15,231,128,12,162,16,8,0,20,72,1,207,17,135,14,159,0,1,168,2,162,
    0,36,228,1,255,52,20,1,22,160,16,26,112,10,139,56,159,0,22,34,170,2,
    130,1,128,16,25,193,15,138,168,10,3,132,36,2,162,95,4,168,2,128,129,
    21,132,20,102,132,64,223,1,134,2,159,0,30,128,160,0,163,31,228,51,48,
    135,231,31,128,12,168,21,168,22,129,16,160,16,238,134,78,36,143,2,2,
    31,34,130,88,18,32,212,162,192,0,6,168,2,128,81,85,26,160,85,160,86,
    164,14,95,2,149,160,0,215,150,136,10,95,30,21,0,22,160,18,161,16,242,
    136,16,224,48,106,114,36,161,86,48,128,84,32,1,0,160,170,170,170,0,
    168,10,22,160,0,160,2,192,0,0,241,1,129,2,18,168,0,168,2,0,0,168,41,
    49,34,170,2,17,36,10,168,138,160,0,34,160,129,8,10,160,42,162,208,42,
    19,4,10,132,4,21,128,26,6,128,21,128,2,128,2,192,12,9,203,0,160,0,1,
    10,170,139,16,42,160,2,173,26,1,170,225,15,34,24,81,138,151,24,81,42,
    162,66,128,2,128,4,62,4,0,16,129,14,160,12,4,35,15,8,108,168,170,139,
    32,192,0,160,226,15,53,170,44,170,128,170,60,170,81,52,128,102,10,128,
    193,20,136,16,0,21,2,54,255,0,57,159,0,14,49,19,132,2,224,10,19,237,
    36,22,36,1,128,229,15,132,14,0,183,161,28,8,0,17,9,138,192,26,255,17,
    4,245,194,68,136,2,225,4,163,35,147,0,5,128,40,5,172,196,15,130,12,
    168,129,60,10,160,16,132,2,160,190,26,129,14,0,136,64,50,143,32,6,184,
    9,68,248,138,138,16,130,66,41,160,29,42,160,26,255,160,34,228,11,130,
    78,33,160,16,137,2,49,254,133,12,153,17,79,14,128,30,192,0,140,16,192,
    104,58,255,160,49,163,16,132,94,49,242,24,133,2,145,0,56,50,170,26,
    192,0,136,24,63,30,168,26,127,168,21,230,61,133,16,224,45,43,162,16,
    138,112,0,144,0
};

static MTB * mtb_KPPKP = NULL;

void initMTB_KPPKP()
{
    mtb_KPPKP = new MTB ("KPPKP", 2, 12);
    mtb_KPPKP->SetPackedData (mtbdata_KPPKP);
    mtb_KPPKP->Add (A6, B5, A7, WHITE, 86);
    mtb_KPPKP->Add (A5, B6, A7, WHITE, 70);
    mtb_KPPKP->Add (A5, B5, A7, WHITE, 86);
    mtb_KPPKP->Add (A4, B5, A7, WHITE, 186);
    mtb_KPPKP->Add (A5, B4, A6, WHITE, 163);
    mtb_KPPKP->Add (A4, B4, A6, WHITE, 195);
    mtb_KPPKP->Add (A6, B5, A7, BLACK, 132);
    mtb_KPPKP->Add (A5, B6, A7, BLACK, 109);
    mtb_KPPKP->Add (A5, B5, A7, BLACK, 182);
    mtb_KPPKP->Add (A4, B5, A7, BLACK, 248);
    mtb_KPPKP->Add (A5, B4, A6, BLACK, 226);
    mtb_KPPKP->Add (A4, B4, A6, BLACK, 309);
}


//////////////////////////////////////////////////////////////////////


static void initMTBs (void)
{
    initMTB_KQK();
    initMTB_KRK();
    initMTB_KPK();
    initMTB_KQKQ();
    initMTB_KQKP();
    initMTB_KRKP();
    initMTB_KPKP();
    initMTB_KRPKR();
    initMTB_KPPKP();
}


#endif // SCID_MTBDATA_H

//////////////////////////////////////////////////////////////////////
//  EOF: mtbdata.h
//////////////////////////////////////////////////////////////////////
