#!/usr/bin/env python3
# -*- coding: UTF-8 -*-

# txt2pot.py for Tux Paint Stamps collection
#
# Last modified 2023-01-03
#
# Updates stamp description localization template (".pot")
# to capture any new strings, or changes to the main English
# translations, found within the stamp description files
# ("stampname.txt"), which contain both the textual description
# of the stamp in English, plus all languages it has been translated to.
# (As generated by "po2txt.py").

import sys, os, string
from time import gmtime, strftime

poHeader="""# Tuxpaint-stamps [Language] translation.
# Copyright (C) 2002-""".encode()+\
strftime("%Y", gmtime()).encode()+"\n".encode()+\
"""# This file is distributed under the same license as the Tuxpaint-stamps package.
# [Translator's name] <translator@email.address>, """.encode()+\
strftime("%Y", gmtime()).encode()+"\n"\
"""#
msgid ""
msgstr ""
"Project-Id-Version: tuxpaint-stamps\\n"
"Report-Msgid-Bugs-To: tuxpaint-i18n@lists.sourceforge.net\\n"
"MIME-Version: 1.0\\n"
"POT-Creation-Date: """.encode()+\
strftime("%Y-%m-%d %H:%M:%S+0000", gmtime()).encode()+"\\n\"\n"\
""""PO-Revision-Date: \\n"
"Content-Type: text/plain; charset=UTF-8\\n"
"Content-Transfer-Encoding: 8bit\\n"
""".encode()
localeList = []


def lister(poLocale, dirname, filesindir):
    filesindir.sort()
    for fname in filesindir:
        fnlist = os.path.splitext(fname)
        if fnlist[1] == ".txt":
            print(dirname + "/" + fname)
            if os.path.exists(dirname + "/" + fnlist[0] + '.svg') : #Check for SVG
                imgfile = fnlist[0] + '.svg'
            else :
                imgfile = fnlist[0] + '.png' # Else, assuming PNG
            txtFile = open(os.path.join(dirname, fname), 'rb')
            # write stamp filename down follow mark('#').
            poFile.write(('\n#: ' + dirname + '/' + fnlist[0] + '\n').encode())
            # provide an URL for viewing the stamp online
            poFile.write(('#. View at https://tuxpaint.org/stamps/' + dirname[3:] + '/' + imgfile + '\n').encode())
            # write description in msgid.
            line = txtFile.readline().decode()
            if line[-1:] == "\n" :
                line = line[:-1]
            line = line.replace('"', '\\"')
            print(" ==> <<" + line + ">>")
            poFile.write(('msgid "' + line + '"\n').encode())
            localeString = ""
            for lineEnc in txtFile.readlines():
                line = lineEnc.decode()
                # replace " to \"
                line = line.replace('"', '\\"')
                splitup = line.find('.utf8')
                if splitup != -1 and line[0] != '#' :
                    locale = line[:splitup]
                    if locale not in localeList:
                        localeList.append(locale)
                    if locale == poLocale:
                        localeString = line[string.find(line, "=") + 1:-1]
            txtFile.close()
            # write translation or empty string in msgstr.
            poFile.write(('msgstr "' + localeString + '"\n').encode())

if __name__ == '__main__':
    poFile = open('./tuxpaint-stamps.pot', 'wb')
    print(">>", poFile.name)
    poFile.write(poHeader)

    # Previously:  os.path.walk('../stamps/', lister, None)

    for root, dirs, files in sorted(os.walk('../stamps')):
        lister(None, root, sorted(files))

    poFile.close()
