//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Project/LinkInstrumentManager.h
//! @brief     Defines class LinkInstrumentManager
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_PROJECT_LINKINSTRUMENTMANAGER_H
#define BORNAGAIN_GUI_MODEL_PROJECT_LINKINSTRUMENTMANAGER_H

#include <QList>
#include <QObject>
#include <QStringList>
#include <QVector>

class InstrumentItem;
class ProjectDocument;
class RealItem;

//! The LinkInstrumentManager class provides communication between InstrumentModel and
//! RealModel. Particularly, it notifies RealItem about changes in linked instruments
//! to adjust axes of IntensityDataItem.

class LinkInstrumentManager : public QObject {
    Q_OBJECT

public:
    LinkInstrumentManager(ProjectDocument* document);

    //! Returns true if RealItem can be linked to the instrument (same number of bins).
    //! Also offers dialog to adjust instrument to match shape of real data.
    //! quiet defines whether a "not possible" message box is shown if link is not possible. Use
    //! this e.g. for unit tests. The question for adjusting the instrument is not suppressed by
    //! this flag.
    bool canLinkDataToInstrument(const RealItem* realItem, const QString& identifier,
                                 QWidget* parent);

signals:
    void linkToInstrumentChanged(const RealItem* realItem);

private:
    void onInstrumentChanged(const InstrumentItem* instrument);
    void onInstrumentAddedOrRemoved();

private:
    ProjectDocument* m_document;
};

#endif // BORNAGAIN_GUI_MODEL_PROJECT_LINKINSTRUMENTMANAGER_H
