{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetMaxExtent: Single;
    procedure SetMaxExtent(const Value: Single);
    function GetDepth: Single;
    procedure SetDepth(const Value: Single);
  public
    procedure SetString(const Value: array of string);
    procedure SetString(const Value: TCastleStringList);
    procedure SetLength(const Value: array of Single);
    procedure SetLength(const Value: TSingleList);
    property MaxExtent: Single read GetMaxExtent write SetMaxExtent;
    property Depth: Single read GetDepth write SetDepth;

{$endif read_interface}

{$ifdef read_implementation}

{ TText3DNode ----------------------------------------------- }

procedure TText3DNode.SetString(const Value: array of string);
begin
  FdString.Send(Value);
end;

procedure TText3DNode.SetString(const Value: TCastleStringList);
begin
  FdString.Send(Value);
end;

procedure TText3DNode.SetLength(const Value: array of Single);
begin
  FdLength.Send(Value);
end;

procedure TText3DNode.SetLength(const Value: TSingleList);
begin
  FdLength.Send(Value);
end;

function TText3DNode.GetMaxExtent: Single;
begin
  Result := FdMaxExtent.Value;
end;

procedure TText3DNode.SetMaxExtent(const Value: Single);
begin
  FdMaxExtent.Send(Value);
end;

function TText3DNode.GetDepth: Single;
begin
  Result := FdDepth.Value;
end;

procedure TText3DNode.SetDepth(const Value: Single);
begin
  FdDepth.Send(Value);
end;

{$endif read_implementation}
