from __future__ import absolute_import, division, print_function
import iotbx.pdb
from cctbx.crystal import super_cell
import mmtbx.model
import libtbx.load_env
from libtbx.utils import null_out
import math
from scitbx.array_family import flex

pdb_str_1yjp = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1      2
ATOM      1  N   GLY A   1      -9.009   4.612   6.102  1.00 16.77           N
ATOM      2  CA  GLY A   1      -9.052   4.207   4.651  1.00 16.57           C
ATOM      3  C   GLY A   1      -8.015   3.140   4.419  1.00 16.16           C
ATOM      4  O   GLY A   1      -7.523   2.521   5.381  1.00 16.78           O
ATOM      5  N   ASN A   2      -7.656   2.923   3.155  1.00 15.02           N
ATOM      6  CA  ASN A   2      -6.522   2.038   2.831  1.00 14.10           C
ATOM      7  C   ASN A   2      -5.241   2.537   3.427  1.00 13.13           C
ATOM      8  O   ASN A   2      -4.978   3.742   3.426  1.00 11.91           O
ATOM      9  CB  ASN A   2      -6.346   1.881   1.341  1.00 15.38           C
ATOM     10  CG  ASN A   2      -7.584   1.342   0.692  1.00 14.08           C
ATOM     11  OD1 ASN A   2      -8.025   0.227   1.016  1.00 17.46           O
ATOM     12  ND2 ASN A   2      -8.204   2.155  -0.169  1.00 11.72           N
ATOM     13  N   ASN A   3      -4.438   1.590   3.905  1.00 12.26           N
ATOM     14  CA  ASN A   3      -3.193   1.904   4.589  1.00 11.74           C
ATOM     15  C   ASN A   3      -1.955   1.332   3.895  1.00 11.10           C
ATOM     16  O   ASN A   3      -1.872   0.119   3.648  1.00 10.42           O
ATOM     17  CB  ASN A   3      -3.259   1.378   6.042  1.00 12.15           C
ATOM     18  CG  ASN A   3      -2.006   1.739   6.861  1.00 12.82           C
ATOM     19  OD1 ASN A   3      -1.702   2.925   7.072  1.00 15.05           O
ATOM     20  ND2 ASN A   3      -1.271   0.715   7.306  1.00 13.48           N
ATOM     21  N   GLN A   4      -1.005   2.228   3.598  1.00 10.29           N
ATOM     22  CA  GLN A   4       0.384   1.888   3.199  1.00 10.53           C
ATOM     23  C   GLN A   4       1.435   2.606   4.088  1.00 10.24           C
ATOM     24  O   GLN A   4       1.547   3.843   4.115  1.00  8.86           O
ATOM     25  CB  GLN A   4       0.656   2.148   1.711  1.00  9.80           C
ATOM     26  CG  GLN A   4       1.944   1.458   1.213  1.00 10.25           C
ATOM     27  CD  GLN A   4       2.504   2.044  -0.089  1.00 12.43           C
ATOM     28  OE1 GLN A   4       2.744   3.268  -0.190  1.00 14.62           O
ATOM     29  NE2 GLN A   4       2.750   1.161  -1.091  1.00  9.05           N
ATOM     30  N   GLN A   5       2.154   1.821   4.871  1.00 10.38           N
ATOM     31  CA  GLN A   5       3.270   2.361   5.640  1.00 11.39           C
ATOM     32  C   GLN A   5       4.594   1.768   5.172  1.00 11.52           C
ATOM     33  O   GLN A   5       4.768   0.546   5.054  1.00 12.05           O
ATOM     34  CB  GLN A   5       3.056   2.183   7.147  1.00 11.96           C
ATOM     35  CG  GLN A   5       1.829   2.950   7.647  1.00 10.81           C
ATOM     36  CD  GLN A   5       1.344   2.414   8.954  1.00 13.10           C
ATOM     37  OE1 GLN A   5       0.774   1.325   9.002  1.00 10.65           O
ATOM     38  NE2 GLN A   5       1.549   3.187  10.039  1.00 12.30           N
ATOM     39  N   ASN A   6       5.514   2.664   4.856  1.00 11.99           N
ATOM     40  CA  ASN A   6       6.831   2.310   4.318  1.00 12.30           C
ATOM     41  C   ASN A   6       7.854   2.761   5.324  1.00 13.40           C
ATOM     42  O   ASN A   6       8.219   3.943   5.374  1.00 13.92           O
ATOM     43  CB  ASN A   6       7.065   3.016   2.993  1.00 12.13           C
ATOM     44  CG  ASN A   6       5.961   2.735   2.003  1.00 12.77           C
ATOM     45  OD1 ASN A   6       5.798   1.604   1.551  1.00 14.27           O
ATOM     46  ND2 ASN A   6       5.195   3.747   1.679  1.00 10.07           N
ATOM     47  N   TYR A   7       8.292   1.817   6.147  1.00 14.70           N
ATOM     48  CA  TYR A   7       9.159   2.144   7.299  1.00 15.18           C
ATOM     49  C   TYR A   7      10.603   2.331   6.885  1.00 15.91           C
ATOM     50  O   TYR A   7      11.041   1.811   5.855  1.00 15.76           O
ATOM     51  CB  TYR A   7       9.061   1.065   8.369  1.00 15.35           C
ATOM     52  CG  TYR A   7       7.665   0.929   8.902  1.00 14.45           C
ATOM     53  CD1 TYR A   7       6.771   0.021   8.327  1.00 15.68           C
ATOM     54  CD2 TYR A   7       7.210   1.756   9.920  1.00 14.80           C
ATOM     55  CE1 TYR A   7       5.480  -0.094   8.796  1.00 13.46           C
ATOM     56  CE2 TYR A   7       5.904   1.649  10.416  1.00 14.33           C
ATOM     57  CZ  TYR A   7       5.047   0.729   9.831  1.00 15.09           C
ATOM     58  OH  TYR A   7       3.766   0.589  10.291  1.00 14.39           O
ATOM     59  OXT TYR A   7      11.358   2.999   7.612  1.00 17.49           O
TER      60      TYR A   7
HETATM   61  O   HOH A   8      -6.471   5.227   7.124  1.00 22.62           O
HETATM   62  O   HOH A   9      10.431   1.858   3.216  1.00 19.71           O
HETATM   63  O   HOH A  10     -11.286   1.756  -1.468  1.00 17.08           O
HETATM   64  O   HOH A  11      11.808   4.179   9.970  1.00 23.99           O
HETATM   65  O   HOH A  12      13.605   1.327   9.198  1.00 26.17           O
HETATM   66  O   HOH A  13      -2.749   3.429  10.024  1.00 39.15           O
HETATM   67  O   HOH A  14      -1.500   0.682  10.967  1.00 43.49           O
"""

pdb_str_3q2c = """
CRYST1   83.308   27.817   48.257  90.00 111.65  90.00 C 1 2 1
SCALE1      0.012004  0.000000  0.004765        0.00000
SCALE2      0.000000  0.035949  0.000000        0.00000
SCALE3      0.000000  0.000000  0.022295        0.00000
ATOM      1  N   PRO A   2      15.485  -5.578  -4.008  1.00106.63           N
ATOM      2  CA  PRO A   2      14.818  -5.574  -2.702  1.00103.27           C
ATOM      3  C   PRO A   2      15.479  -6.558  -1.746  1.00104.30           C
ATOM      4  O   PRO A   2      14.839  -7.506  -1.291  1.00110.99           O
ATOM      5  CB  PRO A   2      13.388  -6.036  -3.029  1.00106.01           C
ATOM      6  CG  PRO A   2      13.419  -6.509  -4.459  1.00103.99           C
ATOM      7  CD  PRO A   2      14.530  -5.765  -5.112  1.00108.07           C
ATOM      8  N   LEU A   3      16.755  -6.326  -1.457  1.00 76.14           N
ATOM      9  CA  LEU A   3      17.526  -7.192  -0.572  1.00 77.68           C
ATOM     10  C   LEU A   3      16.850  -7.375   0.789  1.00 80.25           C
ATOM     11  O   LEU A   3      16.086  -6.511   1.231  1.00 77.25           O
ATOM     12  CB  LEU A   3      18.939  -6.631  -0.382  1.00 78.55           C
ATOM     13  CG  LEU A   3      19.865  -6.560  -1.602  1.00 79.95           C
ATOM     14  CD1 LEU A   3      19.359  -5.549  -2.630  1.00 79.02           C
ATOM     15  CD2 LEU A   3      21.295  -6.233  -1.179  1.00 66.74           C
ATOM     16  N   PRO A   4      17.129  -8.506   1.458  1.00 98.25           N
ATOM     17  CA  PRO A   4      16.578  -8.793   2.789  1.00 98.84           C
ATOM     18  C   PRO A   4      16.895  -7.681   3.787  1.00 94.48           C
ATOM     19  O   PRO A   4      17.976  -7.091   3.713  1.00 94.28           O
ATOM     20  CB  PRO A   4      17.305 -10.081   3.194  1.00 98.59           C
ATOM     21  CG  PRO A   4      17.680 -10.724   1.906  1.00 92.99           C
ATOM     22  CD  PRO A   4      17.997  -9.593   0.973  1.00 92.73           C
ATOM     23  N   LYS A   5      15.969  -7.399   4.701  1.00 59.25           N
ATOM     24  CA  LYS A   5      16.211  -6.387   5.721  1.00 53.50           C
ATOM     25  C   LYS A   5      17.208  -6.898   6.753  1.00 51.59           C
ATOM     26  O   LYS A   5      17.223  -8.087   7.077  1.00 54.23           O
ATOM     27  CB  LYS A   5      14.905  -5.960   6.395  1.00 53.07           C
ATOM     28  CG  LYS A   5      14.225  -7.045   7.204  1.00 49.36           C
ATOM     29  CD  LYS A   5      12.845  -6.589   7.657  1.00 42.75           C
ATOM     30  CE  LYS A   5      12.167  -7.653   8.502  1.00 50.57           C
ATOM     31  NZ  LYS A   5      10.848  -7.202   9.030  1.00 51.11           N
ATOM     32  N   PRO A   6      18.049  -5.995   7.272  1.00 45.91           N
ATOM     33  CA  PRO A   6      19.118  -6.361   8.204  1.00 42.91           C
ATOM     34  C   PRO A   6      18.560  -6.628   9.589  1.00 40.34           C
ATOM     35  O   PRO A   6      17.359  -6.505   9.810  1.00 42.02           O
ATOM     36  CB  PRO A   6      19.991  -5.101   8.256  1.00 42.35           C
ATOM     37  CG  PRO A   6      19.398  -4.133   7.253  1.00 44.97           C
ATOM     38  CD  PRO A   6      17.988  -4.543   7.050  1.00 43.21           C
ATOM     39  N   THR A   7      19.438  -6.976  10.518  1.00 42.39           N
ATOM     40  CA  THR A   7      19.038  -7.191  11.895  1.00 37.75           C
ATOM     41  C   THR A   7      19.695  -6.130  12.757  1.00 33.81           C
ATOM     42  O   THR A   7      20.915  -6.056  12.828  1.00 41.62           O
ATOM     43  CB  THR A   7      19.462  -8.584  12.384  1.00 44.13           C
ATOM     44  OG1 THR A   7      19.111  -9.563  11.397  1.00 51.90           O
ATOM     45  CG2 THR A   7      18.779  -8.927  13.703  1.00 35.96           C
ATOM     46  N   LEU A   8      18.878  -5.303  13.398  1.00 26.28           N
ATOM     47  CA  LEU A   8      19.362  -4.217  14.243  1.00 27.06           C
ATOM     48  C   LEU A   8      19.041  -4.509  15.706  1.00 29.60           C
ATOM     49  O   LEU A   8      17.904  -4.829  16.053  1.00 29.31           O
ATOM     50  CB  LEU A   8      18.728  -2.890  13.799  1.00 25.14           C
ATOM     51  CG  LEU A   8      18.876  -1.599  14.614  1.00 20.65           C
ATOM     52  CD1 LEU A   8      20.287  -1.050  14.606  1.00 18.33           C
ATOM     53  CD2 LEU A   8      17.917  -0.559  14.063  1.00 26.48           C
ATOM     54  N   TRP A   9      20.045  -4.414  16.569  1.00 29.25           N
ATOM     55  CA  TRP A   9      19.808  -4.632  17.988  1.00 29.09           C
ATOM     56  C   TRP A   9      20.677  -3.722  18.855  1.00 31.04           C
ATOM     57  O   TRP A   9      21.518  -2.979  18.346  1.00 29.39           O
ATOM     58  CB  TRP A   9      20.005  -6.108  18.351  1.00 30.29           C
ATOM     59  CG  TRP A   9      21.430  -6.564  18.315  1.00 33.54           C
ATOM     60  CD1 TRP A   9      22.255  -6.753  19.384  1.00 30.39           C
ATOM     61  CD2 TRP A   9      22.202  -6.888  17.149  1.00 33.03           C
ATOM     62  NE1 TRP A   9      23.494  -7.172  18.959  1.00 34.81           N
ATOM     63  CE2 TRP A   9      23.486  -7.265  17.591  1.00 33.71           C
ATOM     64  CE3 TRP A   9      21.933  -6.894  15.778  1.00 32.04           C
ATOM     65  CZ2 TRP A   9      24.496  -7.644  16.711  1.00 35.53           C
ATOM     66  CZ3 TRP A   9      22.937  -7.272  14.907  1.00 35.61           C
ATOM     67  CH2 TRP A   9      24.204  -7.639  15.376  1.00 36.14           C
ATOM     68  N   ALA A  10      20.454  -3.773  20.164  1.00 32.99           N
ATOM     69  CA  ALA A  10      21.194  -2.937  21.093  1.00 31.63           C
ATOM     70  C   ALA A  10      21.880  -3.776  22.160  1.00 38.15           C
ATOM     71  O   ALA A  10      21.331  -4.776  22.631  1.00 39.89           O
ATOM     72  CB  ALA A  10      20.271  -1.933  21.737  1.00 36.46           C
ATOM     73  N   GLU A  11      23.084  -3.359  22.535  1.00 38.56           N
ATOM     74  CA  GLU A  11      23.835  -4.008  23.599  1.00 38.57           C
ATOM     75  C   GLU A  11      24.169  -2.984  24.673  1.00 40.20           C
ATOM     76  O   GLU A  11      24.746  -1.942  24.367  1.00 43.74           O
ATOM     77  CB  GLU A  11      25.121  -4.609  23.038  1.00 38.07           C
ATOM     78  CG  GLU A  11      24.885  -5.629  21.944  1.00 45.66           C
ATOM     79  CD  GLU A  11      26.164  -6.267  21.457  1.00 48.79           C
ATOM     80  OE1 GLU A  11      27.231  -5.619  21.550  1.00 48.99           O
ATOM     81  OE2 GLU A  11      26.102  -7.417  20.975  1.00 48.99           O
ATOM     82  N   PRO A  12      23.824  -3.275  25.940  1.00 34.15           N
ATOM     83  CA  PRO A  12      23.218  -4.519  26.436  1.00 37.83           C
ATOM     84  C   PRO A  12      21.748  -4.673  26.053  1.00 38.95           C
ATOM     85  O   PRO A  12      21.243  -5.797  26.031  1.00 42.06           O
ATOM     86  CB  PRO A  12      23.329  -4.383  27.962  1.00 38.94           C
ATOM     87  CG  PRO A  12      24.268  -3.232  28.198  1.00 40.87           C
ATOM     88  CD  PRO A  12      24.091  -2.329  27.034  1.00 33.86           C
ATOM     89  N   GLY A  13      21.071  -3.564  25.769  1.00 28.63           N
ATOM     90  CA  GLY A  13      19.665  -3.608  25.415  1.00 24.42           C
ATOM     91  C   GLY A  13      19.141  -2.262  24.969  1.00 24.18           C
ATOM     92  O   GLY A  13      19.877  -1.279  24.960  1.00 25.85           O
ATOM     93  N   SER A  14      17.864  -2.219  24.605  1.00 33.49           N
ATOM     94  CA  SER A  14      17.251  -1.006  24.075  1.00 35.19           C
ATOM     95  C   SER A  14      16.749  -0.065  25.167  1.00 35.94           C
ATOM     96  O   SER A  14      16.445   1.098  24.900  1.00 38.04           O
ATOM     97  CB  SER A  14      16.104  -1.361  23.135  1.00 38.06           C
ATOM     98  OG  SER A  14      15.141  -2.144  23.809  1.00 45.33           O
ATOM     99  N   VAL A  15      16.652  -0.564  26.393  1.00 27.57           N
ATOM    100  CA  VAL A  15      16.361   0.306  27.520  1.00 26.82           C
ATOM    101  C   VAL A  15      17.615   0.424  28.356  1.00 33.22           C
ATOM    102  O   VAL A  15      17.977  -0.515  29.060  1.00 41.09           O
ATOM    103  CB  VAL A  15      15.238  -0.241  28.417  1.00 30.18           C
ATOM    104  CG1 VAL A  15      14.847   0.804  29.448  1.00 29.17           C
ATOM    105  CG2 VAL A  15      14.025  -0.635  27.592  1.00 30.77           C
ATOM    106  N   ILE A  16      18.292   1.564  28.269  1.00 32.55           N
ATOM    107  CA  ILE A  16      19.470   1.784  29.094  1.00 36.32           C
ATOM    108  C   ILE A  16      19.362   3.074  29.909  1.00 36.86           C
ATOM    109  O   ILE A  16      18.959   4.119  29.404  1.00 34.13           O
ATOM    110  CB  ILE A  16      20.786   1.782  28.276  1.00 35.91           C
ATOM    111  CG1 ILE A  16      21.013   3.138  27.620  1.00 36.74           C
ATOM    112  CG2 ILE A  16      20.807   0.644  27.254  1.00 27.28           C
ATOM    113  CD1 ILE A  16      22.472   3.471  27.470  1.00 42.86           C
ATOM    114  N   THR A  17      19.726   2.988  31.181  1.00 40.41           N
ATOM    115  CA  THR A  17      19.623   4.128  32.075  1.00 38.88           C
ATOM    116  C   THR A  17      20.483   5.283  31.582  1.00 36.89           C
ATOM    117  O   THR A  17      21.406   5.085  30.797  1.00 40.95           O
ATOM    118  CB  THR A  17      20.004   3.739  33.514  1.00 36.95           C
ATOM    119  OG1 THR A  17      20.447   4.901  34.223  1.00 39.63           O
ATOM    120  CG2 THR A  17      21.108   2.700  33.508  1.00 38.83           C
ATOM    121  N   GLN A  18      20.172   6.492  32.031  1.00 40.38           N
ATOM    122  CA  GLN A  18      20.881   7.665  31.544  1.00 39.76           C
ATOM    123  C   GLN A  18      22.315   7.697  32.043  1.00 43.39           C
ATOM    124  O   GLN A  18      22.597   7.309  33.173  1.00 46.10           O
ATOM    125  CB  GLN A  18      20.168   8.955  31.947  1.00 41.08           C
ATOM    126  CG  GLN A  18      20.554  10.126  31.058  1.00 45.15           C
ATOM    127  CD  GLN A  18      20.475  11.466  31.755  1.00 47.34           C
ATOM    128  OE1 GLN A  18      20.137  11.552  32.940  1.00 47.59           O
ATOM    129  NE2 GLN A  18      20.791  12.530  31.018  1.00 42.22           N
ATOM    130  N   GLY A  19      23.219   8.170  31.192  1.00 46.53           N
ATOM    131  CA  GLY A  19      24.621   8.268  31.547  1.00 39.90           C
ATOM    132  C   GLY A  19      25.368   6.992  31.227  1.00 40.68           C
ATOM    133  O   GLY A  19      26.584   7.003  31.057  1.00 46.08           O
ATOM    134  N   SER A  20      24.635   5.888  31.149  1.00 39.27           N
ATOM    135  CA  SER A  20      25.230   4.601  30.819  1.00 41.46           C
ATOM    136  C   SER A  20      25.448   4.469  29.316  1.00 40.29           C
ATOM    137  O   SER A  20      24.853   5.209  28.531  1.00 39.63           O
ATOM    138  CB  SER A  20      24.352   3.460  31.330  1.00 41.45           C
ATOM    139  OG  SER A  20      24.267   3.490  32.744  1.00 49.64           O
ATOM    140  N   PRO A  21      26.318   3.532  28.913  1.00 39.41           N
ATOM    141  CA  PRO A  21      26.610   3.306  27.497  1.00 37.40           C
ATOM    142  C   PRO A  21      25.640   2.329  26.843  1.00 37.33           C
ATOM    143  O   PRO A  21      24.987   1.522  27.514  1.00 39.50           O
ATOM    144  CB  PRO A  21      28.011   2.673  27.523  1.00 38.85           C
ATOM    145  CG  PRO A  21      28.473   2.737  28.960  1.00 38.49           C
ATOM    146  CD  PRO A  21      27.233   2.771  29.775  1.00 41.28           C
ATOM    147  N   VAL A  22      25.552   2.415  25.523  1.00 33.52           N
ATOM    148  CA  VAL A  22      24.875   1.405  24.730  1.00 32.93           C
ATOM    149  C   VAL A  22      25.457   1.444  23.329  1.00 29.93           C
ATOM    150  O   VAL A  22      25.881   2.492  22.852  1.00 34.04           O
ATOM    151  CB  VAL A  22      23.347   1.613  24.682  1.00 31.65           C
ATOM    152  CG1 VAL A  22      23.009   2.948  24.054  1.00 30.11           C
ATOM    153  CG2 VAL A  22      22.687   0.481  23.913  1.00 28.87           C
ATOM    154  N   THR A  23      25.499   0.293  22.679  1.00 23.69           N
ATOM    155  CA  THR A  23      25.987   0.227  21.321  1.00 26.16           C
ATOM    156  C   THR A  23      24.894  -0.331  20.423  1.00 28.36           C
ATOM    157  O   THR A  23      24.357  -1.406  20.676  1.00 31.25           O
ATOM    158  CB  THR A  23      27.244  -0.653  21.228  1.00 25.03           C
ATOM    159  OG1 THR A  23      28.208  -0.209  22.189  1.00 29.25           O
ATOM    160  CG2 THR A  23      27.848  -0.572  19.844  1.00 27.87           C
ATOM    161  N   LEU A  24      24.546   0.411  19.382  1.00 38.96           N
ATOM    162  CA  LEU A  24      23.614  -0.106  18.393  1.00 40.23           C
ATOM    163  C   LEU A  24      24.379  -0.955  17.386  1.00 39.39           C
ATOM    164  O   LEU A  24      25.516  -0.644  17.033  1.00 39.33           O
ATOM    165  CB  LEU A  24      22.869   1.029  17.697  1.00 38.06           C
ATOM    166  CG  LEU A  24      22.079   1.925  18.645  1.00 37.89           C
ATOM    167  CD1 LEU A  24      21.022   2.692  17.878  1.00 36.61           C
ATOM    168  CD2 LEU A  24      21.434   1.092  19.735  1.00 37.89           C
ATOM    169  N   ARG A  25      23.748  -2.031  16.934  1.00 35.06           N
ATOM    170  CA  ARG A  25      24.406  -2.997  16.069  1.00 35.31           C
ATOM    171  C   ARG A  25      23.493  -3.374  14.914  1.00 34.80           C
ATOM    172  O   ARG A  25      22.292  -3.542  15.104  1.00 35.61           O
ATOM    173  CB  ARG A  25      24.762  -4.247  16.873  1.00 38.69           C
ATOM    174  CG  ARG A  25      25.688  -3.991  18.048  1.00 36.05           C
ATOM    175  CD  ARG A  25      27.081  -3.703  17.551  1.00 37.65           C
ATOM    176  NE  ARG A  25      27.493  -4.711  16.582  1.00 39.66           N
ATOM    177  CZ  ARG A  25      28.189  -5.800  16.889  1.00 45.65           C
ATOM    178  NH1 ARG A  25      28.568  -6.020  18.143  1.00 42.47           N
ATOM    179  NH2 ARG A  25      28.513  -6.666  15.939  1.00 46.19           N
ATOM    180  N   CYS A  26      24.066  -3.507  13.721  1.00 34.47           N
ATOM    181  CA  CYS A  26      23.309  -3.906  12.539  1.00 32.24           C
ATOM    182  C   CYS A  26      24.093  -4.927  11.723  1.00 39.91           C
ATOM    183  O   CYS A  26      25.233  -4.675  11.340  1.00 45.76           O
ATOM    184  CB  CYS A  26      22.987  -2.683  11.680  1.00 32.03           C
ATOM    185  SG  CYS A  26      22.107  -3.044  10.140  1.00 37.65           S
ATOM    186  N   GLN A  27      23.489  -6.085  11.472  1.00 54.55           N
ATOM    187  CA  GLN A  27      24.137  -7.126  10.679  1.00 57.28           C
ATOM    188  C   GLN A  27      23.205  -7.630   9.584  1.00 61.63           C
ATOM    189  O   GLN A  27      22.076  -8.036   9.863  1.00 69.61           O
ATOM    190  CB  GLN A  27      24.575  -8.285  11.574  1.00 62.26           C
ATOM    191  CG  GLN A  27      25.415  -9.338  10.863  1.00 67.17           C
ATOM    192  CD  GLN A  27      25.928 -10.416  11.801  1.00 72.17           C
ATOM    193  OE1 GLN A  27      26.616 -10.128  12.785  1.00 68.28           O
ATOM    194  NE2 GLN A  27      25.601 -11.669  11.496  1.00 77.49           N
ATOM    195  N   GLY A  28      23.683  -7.619   8.342  1.00 46.31           N
ATOM    196  CA  GLY A  28      22.832  -7.927   7.205  1.00 48.44           C
ATOM    197  C   GLY A  28      23.205  -9.140   6.373  1.00 57.20           C
ATOM    198  O   GLY A  28      22.460 -10.118   6.322  1.00 58.11           O
ATOM    199  N   SER A  29      24.352  -9.079   5.704  1.00 70.60           N
ATOM    200  CA  SER A  29      24.746 -10.139   4.781  1.00 71.88           C
ATOM    201  C   SER A  29      26.257 -10.354   4.710  1.00 85.24           C
ATOM    202  O   SER A  29      26.774 -11.339   5.238  1.00 88.84           O
ATOM    203  CB  SER A  29      24.200  -9.851   3.384  1.00 68.45           C
ATOM    204  OG  SER A  29      24.923 -10.575   2.408  1.00 70.32           O
ATOM    205  N   LEU A  30      26.958  -9.436   4.047  1.00 82.21           N
ATOM    206  CA  LEU A  30      28.400  -9.557   3.850  1.00 88.27           C
ATOM    207  C   LEU A  30      29.134  -9.384   5.173  1.00105.96           C
ATOM    208  O   LEU A  30      28.504  -9.234   6.218  1.00111.16           O
ATOM    209  CB  LEU A  30      28.890  -8.526   2.834  1.00 83.42           C
ATOM    210  CG  LEU A  30      30.281  -8.731   2.241  1.00 85.42           C
ATOM    211  CD1 LEU A  30      30.333 -10.038   1.465  1.00 83.93           C
ATOM    212  CD2 LEU A  30      30.647  -7.552   1.359  1.00 80.69           C
ATOM    213  N   GLU A  31      30.464  -9.398   5.126  1.00174.21           N
ATOM    214  CA  GLU A  31      31.276  -9.294   6.338  1.00180.00           C
ATOM    215  C   GLU A  31      31.178  -7.910   6.976  1.00176.97           C
ATOM    216  O   GLU A  31      30.961  -7.792   8.181  1.00178.75           O
ATOM    217  CB  GLU A  31      32.742  -9.637   6.041  1.00190.24           C
ATOM    218  CG  GLU A  31      33.613  -9.846   7.283  1.00198.59           C
ATOM    219  CD  GLU A  31      35.056 -10.194   6.941  1.00215.78           C
ATOM    220  OE1 GLU A  31      35.631  -9.561   6.029  1.00215.57           O
ATOM    221  OE2 GLU A  31      35.619 -11.097   7.594  1.00220.02           O
ATOM    222  N   THR A  32      31.330  -6.867   6.163  1.00184.84           N
ATOM    223  CA  THR A  32      31.342  -5.495   6.668  1.00177.96           C
ATOM    224  C   THR A  32      31.050  -4.462   5.582  1.00166.46           C
ATOM    225  O   THR A  32      30.617  -4.804   4.479  1.00159.76           O
ATOM    226  CB  THR A  32      32.725  -5.129   7.290  1.00174.76           C
ATOM    227  OG1 THR A  32      33.778  -5.505   6.390  1.00188.26           O
ATOM    228  CG2 THR A  32      32.938  -5.814   8.633  1.00163.04           C
ATOM    229  N   GLN A  33      31.240  -3.195   5.945  1.00150.13           N
ATOM    230  CA  GLN A  33      31.560  -2.112   5.001  1.00151.57           C
ATOM    231  C   GLN A  33      30.466  -1.213   4.408  1.00148.98           C
ATOM    232  O   GLN A  33      30.793  -0.177   3.823  1.00156.27           O
ATOM    233  CB  GLN A  33      32.458  -2.613   3.862  1.00154.21           C
ATOM    234  CG  GLN A  33      31.745  -2.829   2.519  1.00162.95           C
ATOM    235  CD  GLN A  33      32.724  -2.844   1.365  1.00169.47           C
ATOM    236  OE1 GLN A  33      33.850  -2.371   1.504  1.00171.83           O
ATOM    237  NE2 GLN A  33      32.306  -3.385   0.224  1.00167.22           N
ATOM    238  N   GLU A  34      29.197  -1.583   4.523  1.00 71.44           N
ATOM    239  CA  GLU A  34      28.141  -0.743   3.960  1.00 63.74           C
ATOM    240  C   GLU A  34      26.872  -0.741   4.798  1.00 52.69           C
ATOM    241  O   GLU A  34      25.837  -1.226   4.363  1.00 54.38           O
ATOM    242  CB  GLU A  34      27.831  -1.156   2.517  1.00 72.37           C
ATOM    243  CG  GLU A  34      28.723  -0.498   1.472  1.00 81.89           C
ATOM    244  CD  GLU A  34      28.332   0.943   1.183  1.00 85.22           C
ATOM    245  OE1 GLU A  34      28.419   1.788   2.102  1.00 78.83           O
ATOM    246  OE2 GLU A  34      27.939   1.227   0.030  1.00 82.48           O
ATOM    247  N   TYR A  35      26.960  -0.182   6.000  1.00 47.54           N
ATOM    248  CA  TYR A  35      25.799  -0.043   6.871  1.00 42.81           C
ATOM    249  C   TYR A  35      25.445   1.426   7.037  1.00 42.17           C
ATOM    250  O   TYR A  35      26.319   2.287   6.965  1.00 46.78           O
ATOM    251  CB  TYR A  35      26.067  -0.674   8.245  1.00 43.61           C
ATOM    252  CG  TYR A  35      26.275  -2.168   8.198  1.00 46.41           C
ATOM    253  CD1 TYR A  35      27.552  -2.716   8.230  1.00 47.05           C
ATOM    254  CD2 TYR A  35      25.192  -3.033   8.110  1.00 44.63           C
ATOM    255  CE1 TYR A  35      27.742  -4.089   8.177  1.00 52.72           C
ATOM    256  CE2 TYR A  35      25.371  -4.401   8.056  1.00 48.98           C
ATOM    257  CZ  TYR A  35      26.645  -4.925   8.088  1.00 53.69           C
ATOM    258  OH  TYR A  35      26.816  -6.291   8.033  1.00 63.69           O
ATOM    259  N   HIS A  36      24.164   1.717   7.248  1.00 46.76           N
ATOM    260  CA  HIS A  36      23.748   3.077   7.582  1.00 44.97           C
ATOM    261  C   HIS A  36      22.618   3.086   8.599  1.00 37.19           C
ATOM    262  O   HIS A  36      21.584   2.464   8.389  1.00 35.70           O
ATOM    263  CB  HIS A  36      23.332   3.868   6.339  1.00 49.45           C
ATOM    264  CG  HIS A  36      22.770   5.219   6.656  1.00 49.72           C
ATOM    265  ND1 HIS A  36      21.476   5.578   6.351  1.00 43.69           N
ATOM    266  CD2 HIS A  36      23.319   6.287   7.284  1.00 53.80           C
ATOM    267  CE1 HIS A  36      21.256   6.817   6.759  1.00 42.94           C
ATOM    268  NE2 HIS A  36      22.357   7.266   7.333  1.00 47.39           N
ATOM    269  N   LEU A  37      22.834   3.799   9.699  1.00 32.51           N
ATOM    270  CA  LEU A  37      21.846   3.928  10.757  1.00 30.38           C
ATOM    271  C   LEU A  37      21.170   5.287  10.662  1.00 33.63           C
ATOM    272  O   LEU A  37      21.786   6.254  10.216  1.00 37.58           O
ATOM    273  CB  LEU A  37      22.518   3.790  12.123  1.00 25.75           C
ATOM    274  CG  LEU A  37      21.576   3.843  13.328  1.00 30.26           C
ATOM    275  CD1 LEU A  37      20.706   2.600  13.381  1.00 28.08           C
ATOM    276  CD2 LEU A  37      22.358   3.998  14.621  1.00 31.13           C
ATOM    277  N   TYR A  38      19.905   5.360  11.072  1.00 30.74           N
ATOM    278  CA  TYR A  38      19.185   6.635  11.102  1.00 30.03           C
ATOM    279  C   TYR A  38      18.015   6.636  12.092  1.00 27.68           C
ATOM    280  O   TYR A  38      17.517   5.581  12.475  1.00 27.73           O
ATOM    281  CB  TYR A  38      18.711   7.043   9.696  1.00 29.92           C
ATOM    282  CG  TYR A  38      17.588   6.206   9.127  1.00 31.24           C
ATOM    283  CD1 TYR A  38      16.265   6.616   9.246  1.00 34.90           C
ATOM    284  CD2 TYR A  38      17.848   5.009   8.464  1.00 31.67           C
ATOM    285  CE1 TYR A  38      15.232   5.859   8.737  1.00 29.06           C
ATOM    286  CE2 TYR A  38      16.823   4.244   7.947  1.00 32.77           C
ATOM    287  CZ  TYR A  38      15.512   4.674   8.088  1.00 35.23           C
ATOM    288  OH  TYR A  38      14.477   3.919   7.571  1.00 34.61           O
ATOM    289  N   ARG A  39      17.608   7.828  12.517  1.00 28.24           N
ATOM    290  CA  ARG A  39      16.421   8.006  13.347  1.00 28.17           C
ATOM    291  C   ARG A  39      15.389   8.729  12.496  1.00 31.77           C
ATOM    292  O   ARG A  39      15.735   9.663  11.771  1.00 32.15           O
ATOM    293  CB  ARG A  39      16.763   8.832  14.580  1.00 27.17           C
ATOM    294  CG  ARG A  39      15.653   8.928  15.591  1.00 29.00           C
ATOM    295  CD  ARG A  39      16.145   9.583  16.871  1.00 30.23           C
ATOM    296  NE  ARG A  39      16.606  10.951  16.654  1.00 32.06           N
ATOM    297  CZ  ARG A  39      16.931  11.791  17.633  1.00 32.54           C
ATOM    298  NH1 ARG A  39      16.845  11.397  18.897  1.00 29.97           N
ATOM    299  NH2 ARG A  39      17.337  13.023  17.350  1.00 32.83           N
ATOM    300  N   GLU A  40      14.124   8.324  12.598  1.00 46.55           N
ATOM    301  CA  GLU A  40      13.155   8.620  11.536  1.00 55.06           C
ATOM    302  C   GLU A  40      12.334   9.922  11.544  1.00 59.80           C
ATOM    303  O   GLU A  40      12.095  10.498  10.473  1.00 66.32           O
ATOM    304  CB  GLU A  40      12.236   7.424  11.298  1.00 59.85           C
ATOM    305  CG  GLU A  40      11.478   6.961  12.514  1.00 52.88           C
ATOM    306  CD  GLU A  40      10.633   5.749  12.203  1.00 58.68           C
ATOM    307  OE1 GLU A  40       9.395   5.849  12.328  1.00 57.20           O
ATOM    308  OE2 GLU A  40      11.205   4.710  11.797  1.00 58.00           O
ATOM    309  N   LYS A  41      11.893  10.381  12.710  1.00 35.99           N
ATOM    310  CA  LYS A  41      11.136  11.626  12.766  1.00 34.46           C
ATOM    311  C   LYS A  41      12.076  12.779  13.053  1.00 33.38           C
ATOM    312  O   LYS A  41      11.731  13.946  12.867  1.00 31.03           O
ATOM    313  CB  LYS A  41      10.054  11.563  13.841  1.00 38.44           C
ATOM    314  CG  LYS A  41       9.027  10.461  13.647  1.00 36.85           C
ATOM    315  CD  LYS A  41       8.202  10.692  12.405  1.00 43.50           C
ATOM    316  CE  LYS A  41       7.190   9.575  12.186  1.00 50.50           C
ATOM    317  NZ  LYS A  41       6.189   9.525  13.290  1.00 59.24           N
ATOM    318  N   LYS A  42      13.282  12.438  13.481  1.00 31.87           N
ATOM    319  CA  LYS A  42      14.250  13.444  13.846  1.00 33.15           C
ATOM    320  C   LYS A  42      15.648  12.878  13.675  1.00 37.79           C
ATOM    321  O   LYS A  42      15.975  11.844  14.255  1.00 39.53           O
ATOM    322  CB  LYS A  42      14.007  13.869  15.292  1.00 38.19           C
ATOM    323  CG  LYS A  42      14.814  15.078  15.736  1.00 40.43           C
ATOM    324  CD  LYS A  42      14.424  15.513  17.137  1.00 35.80           C
ATOM    325  CE  LYS A  42      15.327  16.626  17.627  1.00 47.09           C
ATOM    326  NZ  LYS A  42      15.045  16.996  19.037  1.00 50.00           N
ATOM    327  N   THR A  43      16.470  13.552  12.873  1.00 53.64           N
ATOM    328  CA  THR A  43      17.815  13.060  12.574  1.00 52.24           C
ATOM    329  C   THR A  43      18.658  12.961  13.835  1.00 45.99           C
ATOM    330  O   THR A  43      18.635  13.857  14.678  1.00 48.01           O
ATOM    331  CB  THR A  43      18.561  13.952  11.552  1.00 56.40           C
ATOM    332  OG1 THR A  43      18.721  15.270  12.088  1.00 65.94           O
ATOM    333  CG2 THR A  43      17.807  14.028  10.230  1.00 59.69           C
ATOM    334  N   ALA A  44      19.395  11.863  13.958  1.00 37.33           N
ATOM    335  CA  ALA A  44      20.262  11.640  15.106  1.00 34.09           C
ATOM    336  C   ALA A  44      21.690  12.036  14.767  1.00 38.95           C
ATOM    337  O   ALA A  44      22.459  11.235  14.237  1.00 41.38           O
ATOM    338  CB  ALA A  44      20.204  10.188  15.541  1.00 33.35           C
ATOM    339  N   LEU A  45      22.042  13.275  15.084  1.00 45.66           N
ATOM    340  CA  LEU A  45      23.336  13.829  14.706  1.00 43.44           C
ATOM    341  C   LEU A  45      24.516  12.986  15.176  1.00 43.29           C
ATOM    342  O   LEU A  45      25.550  12.938  14.512  1.00 46.95           O
ATOM    343  CB  LEU A  45      23.460  15.255  15.238  1.00 46.67           C
ATOM    344  CG  LEU A  45      22.368  16.200  14.736  1.00 44.45           C
ATOM    345  CD1 LEU A  45      21.996  17.225  15.800  1.00 49.95           C
ATOM    346  CD2 LEU A  45      22.794  16.871  13.440  1.00 42.68           C
ATOM    347  N   TRP A  46      24.364  12.318  16.314  1.00 36.12           N
ATOM    348  CA  TRP A  46      25.473  11.575  16.904  1.00 37.97           C
ATOM    349  C   TRP A  46      25.958  10.446  15.999  1.00 37.72           C
ATOM    350  O   TRP A  46      27.079   9.960  16.143  1.00 41.25           O
ATOM    351  CB  TRP A  46      25.087  11.025  18.276  1.00 39.53           C
ATOM    352  CG  TRP A  46      24.063   9.946  18.210  1.00 38.49           C
ATOM    353  CD1 TRP A  46      22.709  10.086  18.346  1.00 34.41           C
ATOM    354  CD2 TRP A  46      24.304   8.554  17.983  1.00 36.17           C
ATOM    355  NE1 TRP A  46      22.095   8.864  18.217  1.00 32.14           N
ATOM    356  CE2 TRP A  46      23.052   7.906  17.996  1.00 33.24           C
ATOM    357  CE3 TRP A  46      25.458   7.789  17.773  1.00 36.92           C
ATOM    358  CZ2 TRP A  46      22.922   6.532  17.806  1.00 31.14           C
ATOM    359  CZ3 TRP A  46      25.326   6.422  17.585  1.00 34.54           C
ATOM    360  CH2 TRP A  46      24.066   5.809  17.602  1.00 31.53           C
ATOM    361  N   ILE A  47      25.114  10.034  15.064  1.00 30.79           N
ATOM    362  CA  ILE A  47      25.471   8.967  14.139  1.00 31.33           C
ATOM    363  C   ILE A  47      26.510   9.442  13.137  1.00 34.42           C
ATOM    364  O   ILE A  47      27.372   8.676  12.711  1.00 36.09           O
ATOM    365  CB  ILE A  47      24.238   8.463  13.359  1.00 32.97           C
ATOM    366  CG1 ILE A  47      23.143   8.017  14.334  1.00 29.18           C
ATOM    367  CG2 ILE A  47      24.632   7.350  12.396  1.00 28.55           C
ATOM    368  CD1 ILE A  47      21.946   7.380  13.682  1.00 25.77           C
ATOM    369  N   THR A  48      26.422  10.715  12.764  1.00 46.35           N
ATOM    370  CA  THR A  48      27.297  11.285  11.741  1.00 46.26           C
ATOM    371  C   THR A  48      28.706  11.486  12.265  1.00 42.49           C
ATOM    372  O   THR A  48      29.551  12.048  11.578  1.00 40.98           O
ATOM    373  CB  THR A  48      26.783  12.655  11.239  1.00 48.23           C
ATOM    374  OG1 THR A  48      27.011  13.654  12.243  1.00 53.86           O
ATOM    375  CG2 THR A  48      25.300  12.592  10.911  1.00 46.67           C
ATOM    376  N   ARG A  49      28.955  11.037  13.488  1.00 42.52           N
ATOM    377  CA  ARG A  49      30.264  11.220  14.094  1.00 42.89           C
ATOM    378  C   ARG A  49      30.961   9.893  14.385  1.00 43.11           C
ATOM    379  O   ARG A  49      32.084   9.872  14.880  1.00 46.37           O
ATOM    380  CB  ARG A  49      30.147  12.062  15.363  1.00 45.88           C
ATOM    381  CG  ARG A  49      29.637  13.466  15.109  1.00 45.23           C
ATOM    382  CD  ARG A  49      29.731  14.314  16.362  1.00 48.49           C
ATOM    383  NE  ARG A  49      28.425  14.550  16.977  1.00 57.01           N
ATOM    384  CZ  ARG A  49      27.981  13.944  18.078  1.00 52.45           C
ATOM    385  NH1 ARG A  49      28.730  13.047  18.709  1.00 45.07           N
ATOM    386  NH2 ARG A  49      26.778  14.239  18.552  1.00 54.17           N
ATOM    387  N   ILE A  50      30.296   8.787  14.071  1.00 38.47           N
ATOM    388  CA  ILE A  50      30.878   7.465  14.275  1.00 38.24           C
ATOM    389  C   ILE A  50      31.943   7.194  13.205  1.00 37.30           C
ATOM    390  O   ILE A  50      31.660   7.262  12.015  1.00 42.79           O
ATOM    391  CB  ILE A  50      29.784   6.366  14.248  1.00 35.72           C
ATOM    392  CG1 ILE A  50      28.698   6.655  15.292  1.00 33.68           C
ATOM    393  CG2 ILE A  50      30.385   4.996  14.495  1.00 34.98           C
ATOM    394  CD1 ILE A  50      29.169   6.534  16.724  1.00 30.85           C
ATOM    395  N   PRO A  51      33.181   6.904  13.626  1.00 37.83           N
ATOM    396  CA  PRO A  51      34.250   6.663  12.650  1.00 36.78           C
ATOM    397  C   PRO A  51      33.880   5.551  11.674  1.00 42.27           C
ATOM    398  O   PRO A  51      33.206   4.600  12.063  1.00 45.37           O
ATOM    399  CB  PRO A  51      35.430   6.229  13.524  1.00 39.06           C
ATOM    400  CG  PRO A  51      35.152   6.833  14.855  1.00 42.33           C
ATOM    401  CD  PRO A  51      33.662   6.810  15.014  1.00 37.88           C
ATOM    402  N   GLN A  52      34.323   5.672  10.426  1.00 36.89           N
ATOM    403  CA  GLN A  52      34.013   4.691   9.393  1.00 34.37           C
ATOM    404  C   GLN A  52      34.410   3.277   9.778  1.00 37.84           C
ATOM    405  O   GLN A  52      33.791   2.317   9.335  1.00 41.24           O
ATOM    406  CB  GLN A  52      34.701   5.065   8.083  1.00 42.19           C
ATOM    407  CG  GLN A  52      34.300   6.424   7.537  1.00 52.07           C
ATOM    408  CD  GLN A  52      32.837   6.485   7.103  1.00 60.88           C
ATOM    409  OE1 GLN A  52      31.965   5.859   7.709  1.00 52.64           O
ATOM    410  NE2 GLN A  52      32.565   7.250   6.046  1.00 64.89           N
ATOM    411  N   GLU A  53      35.452   3.145  10.589  1.00 44.81           N
ATOM    412  CA  GLU A  53      35.929   1.824  10.986  1.00 45.37           C
ATOM    413  C   GLU A  53      34.854   1.051  11.733  1.00 45.68           C
ATOM    414  O   GLU A  53      34.726  -0.161  11.568  1.00 47.32           O
ATOM    415  CB  GLU A  53      37.190   1.927  11.845  1.00 52.17           C
ATOM    416  CG  GLU A  53      38.425   2.389  11.090  1.00 57.62           C
ATOM    417  CD  GLU A  53      38.263   3.779  10.507  1.00 66.13           C
ATOM    418  OE1 GLU A  53      37.653   4.644  11.178  1.00 57.96           O
ATOM    419  OE2 GLU A  53      38.747   4.009   9.377  1.00 78.94           O
ATOM    420  N   LEU A  54      34.087   1.760  12.555  1.00 49.40           N
ATOM    421  CA  LEU A  54      32.988   1.160  13.303  1.00 44.43           C
ATOM    422  C   LEU A  54      31.784   0.926  12.398  1.00 45.66           C
ATOM    423  O   LEU A  54      31.272  -0.191  12.301  1.00 47.83           O
ATOM    424  CB  LEU A  54      32.588   2.060  14.474  1.00 40.98           C
ATOM    425  CG  LEU A  54      33.603   2.214  15.609  1.00 43.71           C
ATOM    426  CD1 LEU A  54      33.192   3.325  16.561  1.00 40.12           C
ATOM    427  CD2 LEU A  54      33.772   0.907  16.360  1.00 43.14           C
ATOM    428  N   VAL A  55      31.337   1.991  11.740  1.00 38.70           N
ATOM    429  CA  VAL A  55      30.210   1.919  10.816  1.00 36.21           C
ATOM    430  C   VAL A  55      30.362   0.760   9.835  1.00 38.60           C
ATOM    431  O   VAL A  55      29.386   0.093   9.497  1.00 41.48           O
ATOM    432  CB  VAL A  55      30.038   3.241  10.038  1.00 33.73           C
ATOM    433  CG1 VAL A  55      29.057   3.065   8.900  1.00 35.92           C
ATOM    434  CG2 VAL A  55      29.589   4.356  10.972  1.00 27.41           C
ATOM    435  N   LYS A  56      31.587   0.514   9.385  1.00 33.26           N
ATOM    436  CA  LYS A  56      31.847  -0.594   8.477  1.00 37.06           C
ATOM    437  C   LYS A  56      31.595  -1.929   9.155  1.00 39.64           C
ATOM    438  O   LYS A  56      31.192  -2.892   8.514  1.00 50.92           O
ATOM    439  CB  LYS A  56      33.273  -0.535   7.935  1.00 42.52           C
ATOM    440  CG  LYS A  56      33.485   0.539   6.885  1.00 47.36           C
ATOM    441  CD  LYS A  56      34.906   0.510   6.335  1.00 58.42           C
ATOM    442  CE  LYS A  56      35.113   1.583   5.274  1.00 59.33           C
ATOM    443  NZ  LYS A  56      36.527   1.647   4.813  1.00 62.90           N
ATOM    444  N   LYS A  57      31.827  -1.988  10.457  1.00 39.30           N
ATOM    445  CA  LYS A  57      31.552  -3.206  11.202  1.00 37.89           C
ATOM    446  C   LYS A  57      30.108  -3.219  11.673  1.00 36.28           C
ATOM    447  O   LYS A  57      29.672  -4.149  12.353  1.00 36.11           O
ATOM    448  CB  LYS A  57      32.495  -3.331  12.395  1.00 46.21           C
ATOM    449  CG  LYS A  57      33.929  -3.670  12.023  1.00 46.85           C
ATOM    450  CD  LYS A  57      34.798  -3.803  13.264  1.00 45.98           C
ATOM    451  CE  LYS A  57      34.816  -2.506  14.052  1.00 42.31           C
ATOM    452  NZ  LYS A  57      35.557  -2.639  15.330  1.00 40.82           N
ATOM    453  N   GLY A  58      29.366  -2.183  11.300  1.00 38.30           N
ATOM    454  CA  GLY A  58      27.974  -2.069  11.689  1.00 35.74           C
ATOM    455  C   GLY A  58      27.846  -1.817  13.175  1.00 34.31           C
ATOM    456  O   GLY A  58      26.990  -2.401  13.845  1.00 32.35           O
ATOM    457  N   GLN A  59      28.707  -0.944  13.689  1.00 35.11           N
ATOM    458  CA  GLN A  59      28.717  -0.624  15.110  1.00 31.55           C
ATOM    459  C   GLN A  59      28.510   0.862  15.329  1.00 30.96           C
ATOM    460  O   GLN A  59      29.191   1.685  14.722  1.00 31.62           O
ATOM    461  CB  GLN A  59      30.034  -1.053  15.754  1.00 37.44           C
ATOM    462  CG  GLN A  59      30.383  -2.512  15.533  1.00 39.53           C
ATOM    463  CD  GLN A  59      31.508  -2.983  16.422  1.00 33.29           C
ATOM    464  OE1 GLN A  59      31.785  -2.388  17.464  1.00 30.64           O
ATOM    465  NE2 GLN A  59      32.160  -4.065  16.020  1.00 38.92           N
ATOM    466  N   PHE A  60      27.570   1.194  16.208  1.00 30.95           N
ATOM    467  CA  PHE A  60      27.257   2.580  16.516  1.00 30.25           C
ATOM    468  C   PHE A  60      27.218   2.793  18.032  1.00 31.14           C
ATOM    469  O   PHE A  60      26.168   2.706  18.659  1.00 32.64           O
ATOM    470  CB  PHE A  60      25.931   2.974  15.861  1.00 31.42           C
ATOM    471  CG  PHE A  60      25.890   2.711  14.381  1.00 28.09           C
ATOM    472  CD1 PHE A  60      25.619   1.442  13.899  1.00 30.42           C
ATOM    473  CD2 PHE A  60      26.130   3.727  13.473  1.00 26.96           C
ATOM    474  CE1 PHE A  60      25.583   1.191  12.537  1.00 31.23           C
ATOM    475  CE2 PHE A  60      26.093   3.484  12.110  1.00 29.69           C
ATOM    476  CZ  PHE A  60      25.820   2.213  11.642  1.00 31.83           C
ATOM    477  N   PRO A  61      28.382   3.071  18.626  1.00 31.22           N
ATOM    478  CA  PRO A  61      28.515   3.173  20.078  1.00 31.16           C
ATOM    479  C   PRO A  61      27.941   4.467  20.632  1.00 35.39           C
ATOM    480  O   PRO A  61      27.935   5.493  19.954  1.00 40.01           O
ATOM    481  CB  PRO A  61      30.035   3.172  20.290  1.00 32.43           C
ATOM    482  CG  PRO A  61      30.628   2.753  18.982  1.00 29.56           C
ATOM    483  CD  PRO A  61      29.676   3.234  17.951  1.00 33.05           C
ATOM    484  N   ILE A  62      27.465   4.403  21.869  1.00 33.26           N
ATOM    485  CA  ILE A  62      27.128   5.589  22.639  1.00 34.29           C
ATOM    486  C   ILE A  62      27.734   5.397  24.020  1.00 35.54           C
ATOM    487  O   ILE A  62      27.289   4.552  24.791  1.00 38.36           O
ATOM    488  CB  ILE A  62      25.609   5.787  22.756  1.00 31.39           C
ATOM    489  CG1 ILE A  62      24.993   6.003  21.369  1.00 30.92           C
ATOM    490  CG2 ILE A  62      25.302   6.956  23.668  1.00 27.51           C
ATOM    491  CD1 ILE A  62      23.517   5.678  21.292  1.00 25.84           C
ATOM    492  N   LEU A  63      28.772   6.166  24.319  1.00 33.54           N
ATOM    493  CA  LEU A  63      29.485   6.006  25.575  1.00 33.87           C
ATOM    494  C   LEU A  63      28.654   6.483  26.755  1.00 34.09           C
ATOM    495  O   LEU A  63      28.600   5.824  27.791  1.00 38.47           O
ATOM    496  CB  LEU A  63      30.825   6.741  25.524  1.00 37.15           C
ATOM    497  CG  LEU A  63      32.008   5.927  24.994  1.00 35.23           C
ATOM    498  CD1 LEU A  63      31.614   5.123  23.763  1.00 34.73           C
ATOM    499  CD2 LEU A  63      33.198   6.826  24.697  1.00 34.34           C
ATOM    500  N   SER A  64      28.001   7.628  26.589  1.00 39.81           N
ATOM    501  CA  SER A  64      27.174   8.209  27.644  1.00 39.25           C
ATOM    502  C   SER A  64      25.839   8.693  27.085  1.00 35.86           C
ATOM    503  O   SER A  64      25.730   9.813  26.593  1.00 36.22           O
ATOM    504  CB  SER A  64      27.915   9.362  28.324  1.00 37.53           C
ATOM    505  OG  SER A  64      27.094  10.012  29.276  1.00 40.76           O
ATOM    506  N   ILE A  65      24.824   7.843  27.171  1.00 32.82           N
ATOM    507  CA  ILE A  65      23.532   8.148  26.576  1.00 33.62           C
ATOM    508  C   ILE A  65      22.802   9.294  27.285  1.00 37.58           C
ATOM    509  O   ILE A  65      22.736   9.339  28.514  1.00 37.58           O
ATOM    510  CB  ILE A  65      22.628   6.902  26.524  1.00 32.48           C
ATOM    511  CG1 ILE A  65      21.705   6.976  25.306  1.00 32.39           C
ATOM    512  CG2 ILE A  65      21.842   6.753  27.817  1.00 33.77           C
ATOM    513  CD1 ILE A  65      20.775   5.790  25.153  1.00 32.46           C
ATOM    514  N   THR A  66      22.264  10.219  26.492  1.00 37.85           N
ATOM    515  CA  THR A  66      21.488  11.340  27.004  1.00 34.24           C
ATOM    516  C   THR A  66      20.030  11.171  26.603  1.00 34.58           C
ATOM    517  O   THR A  66      19.682  10.226  25.897  1.00 33.82           O
ATOM    518  CB  THR A  66      22.002  12.678  26.446  1.00 36.56           C
ATOM    519  OG1 THR A  66      21.568  12.839  25.090  1.00 37.90           O
ATOM    520  CG2 THR A  66      23.517  12.726  26.490  1.00 37.76           C
ATOM    521  N   TRP A  67      19.181  12.094  27.043  1.00 33.92           N
ATOM    522  CA  TRP A  67      17.758  12.036  26.720  1.00 31.32           C
ATOM    523  C   TRP A  67      17.515  12.146  25.227  1.00 32.50           C
ATOM    524  O   TRP A  67      16.652  11.462  24.673  1.00 35.37           O
ATOM    525  CB  TRP A  67      17.003  13.150  27.436  1.00 32.36           C
ATOM    526  CG  TRP A  67      17.104  13.050  28.902  1.00 37.45           C
ATOM    527  CD1 TRP A  67      17.749  13.911  29.740  1.00 38.71           C
ATOM    528  CD2 TRP A  67      16.564  12.008  29.726  1.00 37.42           C
ATOM    529  NE1 TRP A  67      17.630  13.477  31.041  1.00 40.01           N
ATOM    530  CE2 TRP A  67      16.910  12.309  31.058  1.00 37.43           C
ATOM    531  CE3 TRP A  67      15.818  10.853  29.466  1.00 32.99           C
ATOM    532  CZ2 TRP A  67      16.536  11.496  32.129  1.00 35.16           C
ATOM    533  CZ3 TRP A  67      15.447  10.048  30.529  1.00 35.19           C
ATOM    534  CH2 TRP A  67      15.808  10.373  31.844  1.00 35.98           C
ATOM    535  N   GLU A  68      18.280  13.015  24.581  1.00 41.58           N
ATOM    536  CA  GLU A  68      18.090  13.300  23.168  1.00 42.76           C
ATOM    537  C   GLU A  68      18.445  12.107  22.276  1.00 42.57           C
ATOM    538  O   GLU A  68      18.168  12.122  21.081  1.00 47.68           O
ATOM    539  CB  GLU A  68      18.894  14.540  22.769  1.00 52.13           C
ATOM    540  CG  GLU A  68      18.187  15.460  21.765  1.00 68.21           C
ATOM    541  CD  GLU A  68      18.612  15.217  20.319  1.00 63.16           C
ATOM    542  OE1 GLU A  68      17.862  15.619  19.400  1.00 56.99           O
ATOM    543  OE2 GLU A  68      19.695  14.628  20.103  1.00 64.18           O
ATOM    544  N   HIS A  69      19.045  11.073  22.857  1.00 39.18           N
ATOM    545  CA  HIS A  69      19.390   9.869  22.101  1.00 36.73           C
ATOM    546  C   HIS A  69      18.189   8.958  21.846  1.00 38.57           C
ATOM    547  O   HIS A  69      18.174   8.184  20.886  1.00 37.24           O
ATOM    548  CB  HIS A  69      20.469   9.072  22.825  1.00 33.74           C
ATOM    549  CG  HIS A  69      21.834   9.664  22.709  1.00 34.44           C
ATOM    550  ND1 HIS A  69      22.764   9.216  21.795  1.00 37.89           N
ATOM    551  CD2 HIS A  69      22.432  10.668  23.391  1.00 37.54           C
ATOM    552  CE1 HIS A  69      23.875   9.917  21.920  1.00 35.09           C
ATOM    553  NE2 HIS A  69      23.699  10.806  22.882  1.00 35.96           N
ATOM    554  N   ALA A  70      17.193   9.040  22.720  1.00 39.91           N
ATOM    555  CA  ALA A  70      16.013   8.195  22.606  1.00 37.36           C
ATOM    556  C   ALA A  70      15.318   8.405  21.266  1.00 38.20           C
ATOM    557  O   ALA A  70      15.293   9.519  20.737  1.00 37.75           O
ATOM    558  CB  ALA A  70      15.059   8.476  23.748  1.00 35.90           C
ATOM    559  N   GLY A  71      14.761   7.331  20.717  1.00 36.88           N
ATOM    560  CA  GLY A  71      14.025   7.426  19.470  1.00 37.40           C
ATOM    561  C   GLY A  71      13.919   6.109  18.729  1.00 38.44           C
ATOM    562  O   GLY A  71      14.335   5.065  19.228  1.00 41.46           O
ATOM    563  N   ARG A  72      13.368   6.166  17.522  1.00 38.86           N
ATOM    564  CA  ARG A  72      13.171   4.976  16.707  1.00 37.80           C
ATOM    565  C   ARG A  72      14.251   4.899  15.640  1.00 33.74           C
ATOM    566  O   ARG A  72      14.361   5.786  14.794  1.00 34.13           O
ATOM    567  CB  ARG A  72      11.789   5.016  16.057  1.00 40.54           C
ATOM    568  CG  ARG A  72      11.116   3.664  15.920  1.00 40.52           C
ATOM    569  CD  ARG A  72       9.650   3.760  16.317  1.00 47.93           C
ATOM    570  NE  ARG A  72       8.817   2.794  15.605  1.00 54.34           N
ATOM    571  CZ  ARG A  72       8.129   3.074  14.501  1.00 56.83           C
ATOM    572  NH1 ARG A  72       8.170   4.294  13.982  1.00 57.72           N
ATOM    573  NH2 ARG A  72       7.398   2.138  13.914  1.00 53.13           N
ATOM    574  N   TYR A  73      15.048   3.837  15.687  1.00 28.12           N
ATOM    575  CA  TYR A  73      16.180   3.688  14.781  1.00 25.32           C
ATOM    576  C   TYR A  73      15.971   2.549  13.793  1.00 25.96           C
ATOM    577  O   TYR A  73      15.430   1.507  14.140  1.00 27.92           O
ATOM    578  CB  TYR A  73      17.473   3.475  15.578  1.00 25.12           C
ATOM    579  CG  TYR A  73      17.921   4.706  16.334  1.00 23.94           C
ATOM    580  CD1 TYR A  73      17.315   5.074  17.525  1.00 25.91           C
ATOM    581  CD2 TYR A  73      18.944   5.506  15.848  1.00 29.58           C
ATOM    582  CE1 TYR A  73      17.719   6.205  18.212  1.00 27.20           C
ATOM    583  CE2 TYR A  73      19.357   6.636  16.530  1.00 26.21           C
ATOM    584  CZ  TYR A  73      18.742   6.980  17.707  1.00 24.65           C
ATOM    585  OH  TYR A  73      19.151   8.105  18.380  1.00 26.73           O
ATOM    586  N   CYS A  74      16.392   2.766  12.554  1.00 31.80           N
ATOM    587  CA  CYS A  74      16.362   1.735  11.527  1.00 31.81           C
ATOM    588  C   CYS A  74      17.694   1.765  10.813  1.00 32.31           C
ATOM    589  O   CYS A  74      18.436   2.740  10.905  1.00 34.13           O
ATOM    590  CB  CYS A  74      15.252   2.004  10.513  1.00 33.70           C
ATOM    591  SG  CYS A  74      13.566   1.876  11.149  1.00 40.44           S
ATOM    592  N   CYS A  75      18.007   0.704  10.091  1.00 34.86           N
ATOM    593  CA  CYS A  75      19.234   0.712   9.325  1.00 37.28           C
ATOM    594  C   CYS A  75      19.127  -0.155   8.082  1.00 40.95           C
ATOM    595  O   CYS A  75      18.339  -1.100   8.031  1.00 39.36           O
ATOM    596  CB  CYS A  75      20.407   0.272  10.194  1.00 40.04           C
ATOM    597  SG  CYS A  75      20.860  -1.454  10.006  1.00 47.01           S
ATOM    598  N   ILE A  76      19.917   0.197   7.074  1.00 42.13           N
ATOM    599  CA  ILE A  76      20.000  -0.583   5.853  1.00 43.71           C
ATOM    600  C   ILE A  76      21.459  -0.718   5.460  1.00 47.65           C
ATOM    601  O   ILE A  76      22.280   0.143   5.767  1.00 49.05           O
ATOM    602  CB  ILE A  76      19.253   0.087   4.696  1.00 42.71           C
ATOM    603  CG1 ILE A  76      20.175   1.055   3.966  1.00 44.03           C
ATOM    604  CG2 ILE A  76      18.015   0.810   5.201  1.00 46.65           C
ATOM    605  CD1 ILE A  76      19.441   2.028   3.090  1.00 52.25           C
ATOM    606  N   TYR A  77      21.780  -1.814   4.789  1.00 46.86           N
ATOM    607  CA  TYR A  77      23.110  -2.003   4.252  1.00 47.29           C
ATOM    608  C   TYR A  77      23.008  -2.075   2.737  1.00 53.70           C
ATOM    609  O   TYR A  77      21.939  -1.844   2.176  1.00 55.80           O
ATOM    610  CB  TYR A  77      23.728  -3.283   4.812  1.00 52.16           C
ATOM    611  CG  TYR A  77      22.912  -4.517   4.537  1.00 49.48           C
ATOM    612  CD1 TYR A  77      23.185  -5.321   3.443  1.00 55.78           C
ATOM    613  CD2 TYR A  77      21.865  -4.876   5.366  1.00 54.64           C
ATOM    614  CE1 TYR A  77      22.438  -6.454   3.182  1.00 62.58           C
ATOM    615  CE2 TYR A  77      21.109  -6.007   5.114  1.00 62.30           C
ATOM    616  CZ  TYR A  77      21.400  -6.793   4.020  1.00 64.82           C
ATOM    617  OH  TYR A  77      20.649  -7.922   3.763  1.00 68.03           O
ATOM    618  N   GLY A  78      24.114  -2.386   2.071  1.00 49.20           N
ATOM    619  CA  GLY A  78      24.083  -2.570   0.633  1.00 50.24           C
ATOM    620  C   GLY A  78      25.186  -1.857  -0.121  1.00 58.52           C
ATOM    621  O   GLY A  78      25.528  -0.711   0.181  1.00 60.15           O
ATOM    622  N   SER A  79      25.742  -2.554  -1.109  1.00 73.48           N
ATOM    623  CA  SER A  79      26.799  -2.027  -1.967  1.00 73.56           C
ATOM    624  C   SER A  79      26.173  -1.392  -3.209  1.00 74.19           C
ATOM    625  O   SER A  79      25.136  -1.859  -3.671  1.00 78.84           O
ATOM    626  CB  SER A  79      27.741  -3.165  -2.377  1.00 76.10           C
ATOM    627  OG  SER A  79      27.762  -4.201  -1.404  1.00 72.14           O
ATOM    628  N   HIS A  80      26.776  -0.325  -3.737  1.00103.99           N
ATOM    629  CA  HIS A  80      26.234   0.343  -4.929  1.00116.25           C
ATOM    630  C   HIS A  80      25.516  -0.682  -5.801  1.00118.52           C
ATOM    631  O   HIS A  80      24.305  -0.605  -6.015  1.00109.53           O
ATOM    632  CB  HIS A  80      27.357   1.013  -5.725  1.00120.57           C
ATOM    633  CG  HIS A  80      26.912   1.609  -7.030  1.00121.19           C
ATOM    634  ND1 HIS A  80      26.374   2.874  -7.129  1.00116.92           N
ATOM    635  CD2 HIS A  80      26.942   1.114  -8.292  1.00115.86           C
ATOM    636  CE1 HIS A  80      26.079   3.131  -8.391  1.00109.34           C
ATOM    637  NE2 HIS A  80      26.412   2.077  -9.119  1.00110.01           N
ATOM    638  N   THR A  81      26.293  -1.621  -6.332  1.00130.09           N
ATOM    639  CA  THR A  81      25.777  -2.930  -6.707  1.00125.15           C
ATOM    640  C   THR A  81      26.400  -3.792  -5.624  1.00122.99           C
ATOM    641  O   THR A  81      27.577  -3.599  -5.292  1.00122.32           O
ATOM    642  CB  THR A  81      26.273  -3.387  -8.089  1.00121.33           C
ATOM    643  OG1 THR A  81      27.704  -3.489  -8.076  1.00127.79           O
ATOM    644  CG2 THR A  81      25.836  -2.407  -9.182  1.00114.98           C
ATOM    645  N   VAL A  82      25.661  -4.754  -5.080  1.00 57.29           N
ATOM    646  CA  VAL A  82      24.449  -5.306  -5.668  1.00 45.52           C
ATOM    647  C   VAL A  82      23.137  -4.619  -5.268  1.00 48.78           C
ATOM    648  O   VAL A  82      22.043  -5.135  -5.529  1.00 43.92           O
ATOM    649  CB  VAL A  82      24.348  -6.762  -5.237  1.00 45.57           C
ATOM    650  CG1 VAL A  82      25.728  -7.385  -5.223  1.00 43.29           C
ATOM    651  CG2 VAL A  82      23.751  -6.842  -3.844  1.00 54.32           C
ATOM    652  N   GLY A  83      23.230  -3.472  -4.611  1.00 58.23           N
ATOM    653  CA  GLY A  83      22.033  -2.711  -4.298  1.00 53.76           C
ATOM    654  C   GLY A  83      21.752  -2.494  -2.826  1.00 44.94           C
ATOM    655  O   GLY A  83      22.357  -3.128  -1.961  1.00 45.93           O
ATOM    656  N   LEU A  84      20.817  -1.589  -2.551  1.00 48.66           N
ATOM    657  CA  LEU A  84      20.426  -1.243  -1.185  1.00 57.60           C
ATOM    658  C   LEU A  84      19.358  -2.194  -0.642  1.00 54.98           C
ATOM    659  O   LEU A  84      18.549  -2.717  -1.403  1.00 56.71           O
ATOM    660  CB  LEU A  84      19.906   0.197  -1.145  1.00 52.93           C
ATOM    661  CG  LEU A  84      20.446   1.104  -0.040  1.00 46.66           C
ATOM    662  CD1 LEU A  84      21.964   1.019   0.049  1.00 49.27           C
ATOM    663  CD2 LEU A  84      20.003   2.530  -0.286  1.00 48.73           C
ATOM    664  N   SER A  85      19.360  -2.406   0.673  1.00 55.54           N
ATOM    665  CA  SER A  85      18.418  -3.321   1.319  1.00 53.87           C
ATOM    666  C   SER A  85      17.214  -2.581   1.866  1.00 50.23           C
ATOM    667  O   SER A  85      17.156  -1.356   1.835  1.00 53.14           O
ATOM    668  CB  SER A  85      19.078  -4.031   2.490  1.00 47.23           C
ATOM    669  OG  SER A  85      18.851  -3.289   3.673  1.00 42.03           O
ATOM    670  N   GLU A  86      16.259  -3.340   2.387  1.00 58.45           N
ATOM    671  CA  GLU A  86      15.102  -2.757   3.039  1.00 55.14           C
ATOM    672  C   GLU A  86      15.496  -2.309   4.432  1.00 49.03           C
ATOM    673  O   GLU A  86      16.471  -2.808   4.996  1.00 48.79           O
ATOM    674  CB  GLU A  86      13.975  -3.781   3.135  1.00 57.61           C
ATOM    675  CG  GLU A  86      13.558  -4.352   1.797  1.00 73.83           C
ATOM    676  CD  GLU A  86      12.279  -5.155   1.887  1.00 88.89           C
ATOM    677  OE1 GLU A  86      11.883  -5.518   3.017  1.00 77.70           O
ATOM    678  OE2 GLU A  86      11.673  -5.421   0.824  1.00 91.95           O
ATOM    679  N   SER A  87      14.741  -1.360   4.977  1.00 50.94           N
ATOM    680  CA  SER A  87      14.908  -0.946   6.363  1.00 44.97           C
ATOM    681  C   SER A  87      14.688  -2.130   7.292  1.00 47.20           C
ATOM    682  O   SER A  87      13.737  -2.894   7.121  1.00 51.59           O
ATOM    683  CB  SER A  87      13.905   0.154   6.724  1.00 42.81           C
ATOM    684  OG  SER A  87      14.282   1.405   6.182  1.00 47.05           O
ATOM    685  N   SER A  88      15.566  -2.282   8.276  1.00 42.29           N
ATOM    686  CA  SER A  88      15.341  -3.261   9.327  1.00 43.21           C
ATOM    687  C   SER A  88      14.100  -2.845  10.118  1.00 38.04           C
ATOM    688  O   SER A  88      13.591  -1.737   9.940  1.00 34.95           O
ATOM    689  CB  SER A  88      16.559  -3.334  10.247  1.00 38.75           C
ATOM    690  OG  SER A  88      16.791  -2.085  10.877  1.00 36.30           O
ATOM    691  N   ASP A  89      13.602  -3.726  10.980  1.00 39.49           N
ATOM    692  CA  ASP A  89      12.527  -3.336  11.888  1.00 39.13           C
ATOM    693  C   ASP A  89      13.047  -2.265  12.842  1.00 38.82           C
ATOM    694  O   ASP A  89      14.231  -2.256  13.193  1.00 36.94           O
ATOM    695  CB  ASP A  89      11.998  -4.534  12.678  1.00 36.31           C
ATOM    696  CG  ASP A  89      11.301  -5.538  11.803  1.00 37.66           C
ATOM    697  OD1 ASP A  89      10.726  -5.128  10.776  1.00 38.70           O
ATOM    698  OD2 ASP A  89      11.330  -6.738  12.138  1.00 38.00           O
ATOM    699  N   PRO A  90      12.163  -1.355  13.269  1.00 32.29           N
ATOM    700  CA  PRO A  90      12.582  -0.247  14.129  1.00 29.31           C
ATOM    701  C   PRO A  90      13.124  -0.738  15.466  1.00 28.92           C
ATOM    702  O   PRO A  90      12.702  -1.785  15.956  1.00 28.18           O
ATOM    703  CB  PRO A  90      11.283   0.534  14.343  1.00 30.64           C
ATOM    704  CG  PRO A  90      10.208  -0.469  14.127  1.00 35.15           C
ATOM    705  CD  PRO A  90      10.714  -1.335  13.019  1.00 30.40           C
ATOM    706  N   LEU A  91      14.063   0.014  16.031  1.00 31.09           N
ATOM    707  CA  LEU A  91      14.542  -0.221  17.384  1.00 24.92           C
ATOM    708  C   LEU A  91      14.095   0.947  18.250  1.00 29.78           C
ATOM    709  O   LEU A  91      14.373   2.106  17.939  1.00 31.06           O
ATOM    710  CB  LEU A  91      16.070  -0.339  17.416  1.00 26.42           C
ATOM    711  CG  LEU A  91      16.693  -0.619  18.788  1.00 24.00           C
ATOM    712  CD1 LEU A  91      16.822  -2.113  19.033  1.00 23.69           C
ATOM    713  CD2 LEU A  91      18.038   0.051  18.921  1.00 22.19           C
ATOM    714  N   GLU A  92      13.385   0.641  19.326  1.00 37.96           N
ATOM    715  CA  GLU A  92      12.960   1.660  20.264  1.00 38.42           C
ATOM    716  C   GLU A  92      14.070   1.843  21.276  1.00 40.00           C
ATOM    717  O   GLU A  92      14.234   1.020  22.176  1.00 41.00           O
ATOM    718  CB  GLU A  92      11.695   1.208  20.981  1.00 48.95           C
ATOM    719  CG  GLU A  92      10.678   0.536  20.078  1.00 52.29           C
ATOM    720  CD  GLU A  92       9.908   1.527  19.242  1.00 56.64           C
ATOM    721  OE1 GLU A  92       9.368   2.492  19.823  1.00 62.63           O
ATOM    722  OE2 GLU A  92       9.834   1.337  18.009  1.00 54.66           O
ATOM    723  N   LEU A  93      14.846   2.909  21.117  1.00 36.18           N
ATOM    724  CA  LEU A  93      15.938   3.200  22.036  1.00 33.64           C
ATOM    725  C   LEU A  93      15.441   4.095  23.153  1.00 35.15           C
ATOM    726  O   LEU A  93      15.205   5.291  22.952  1.00 32.89           O
ATOM    727  CB  LEU A  93      17.103   3.864  21.307  1.00 36.50           C
ATOM    728  CG  LEU A  93      18.319   4.236  22.159  1.00 36.82           C
ATOM    729  CD1 LEU A  93      18.764   3.054  23.014  1.00 33.05           C
ATOM    730  CD2 LEU A  93      19.466   4.745  21.282  1.00 32.63           C
ATOM    731  N   VAL A  94      15.296   3.498  24.333  1.00 37.24           N
ATOM    732  CA  VAL A  94      14.711   4.165  25.487  1.00 37.33           C
ATOM    733  C   VAL A  94      15.761   4.539  26.520  1.00 34.98           C
ATOM    734  O   VAL A  94      16.679   3.770  26.779  1.00 37.57           O
ATOM    735  CB  VAL A  94      13.690   3.252  26.173  1.00 40.14           C
ATOM    736  CG1 VAL A  94      13.049   3.968  27.355  1.00 41.17           C
ATOM    737  CG2 VAL A  94      12.645   2.777  25.169  1.00 38.15           C
ATOM    738  N   VAL A  95      15.612   5.720  27.113  1.00 34.95           N
ATOM    739  CA  VAL A  95      16.512   6.184  28.164  1.00 35.21           C
ATOM    740  C   VAL A  95      15.723   6.437  29.457  1.00 36.88           C
ATOM    741  O   VAL A  95      14.641   7.029  29.421  1.00 35.18           O
ATOM    742  CB  VAL A  95      17.239   7.475  27.738  1.00 29.19           C
ATOM    743  CG1 VAL A  95      18.426   7.730  28.640  1.00 34.06           C
ATOM    744  CG2 VAL A  95      17.686   7.379  26.287  1.00 25.66           C
ATOM    745  N   THR A  96      16.264   5.988  30.590  1.00 41.08           N
ATOM    746  CA  THR A  96      15.577   6.095  31.882  1.00 40.19           C
ATOM    747  C   THR A  96      16.462   6.663  32.993  1.00 44.24           C
ATOM    748  O   THR A  96      17.498   7.277  32.731  1.00 45.67           O
ATOM    749  CB  THR A  96      15.059   4.723  32.354  1.00 42.10           C
ATOM    750  OG1 THR A  96      16.163   3.907  32.765  1.00 46.55           O
ATOM    751  CG2 THR A  96      14.297   4.022  31.237  1.00 43.81           C
ATOM    752  N   GLY A  97      16.041   6.449  34.237  1.00 52.75           N
ATOM    753  CA  GLY A  97      16.826   6.831  35.400  1.00 49.86           C
ATOM    754  C   GLY A  97      17.140   8.313  35.459  1.00 54.81           C
ATOM    755  O   GLY A  97      18.062   8.737  36.161  1.00 56.05           O
TER
HETATM  756  O   HOH A  98      12.067   8.859  16.800  1.00 28.07           O
HETATM  757  O   HOH A  99      15.469  -4.192  14.509  1.00 28.15           O
HETATM  758  O   HOH A 100      30.272  -3.844  -4.971  1.00 41.99           O
HETATM  759  O   HOH A 101      28.845  10.037  18.238  1.00 28.48           O
HETATM  760  O   HOH A 102      15.336  16.496  12.050  1.00 27.25           O
HETATM  761  O   HOH A 103      28.284  -5.867   2.987  1.00 78.94           O
HETATM  762  O   HOH A 104      15.040  -6.243  11.030  1.00 28.00           O
HETATM  763  O   HOH A 105      12.325  -7.284  14.415  1.00 24.94           O
HETATM  764  O   HOH A 106      39.089   0.917   4.088  1.00 43.47           O
HETATM  765  O   HOH A 107      29.565   8.685  22.520  1.00 30.59           O
HETATM  766  O   HOH A 108      28.472   8.135  20.105  1.00 39.16           O
HETATM  767  O   HOH A 109      19.567  15.452  26.730  1.00 34.93           O
HETATM  768  O   HOH A 110      11.242   4.407  20.797  1.00 47.33           O
HETATM  769  O   HOH A 111      20.490  14.804  28.961  1.00 41.21           O
HETATM  770  O   HOH A 112      19.830 -10.817   9.080  1.00 45.37           O
HETATM  771  O   HOH A 113       9.668  -3.455   8.996  1.00 41.35           O
HETATM  772  O   HOH A 114      12.707   9.026  14.389  1.00 32.70           O
HETATM  773  O   HOH A 115      27.124  -5.161  14.086  1.00 44.80           O
HETATM  774  O   HOH A 116      18.786  -1.043  32.048  1.00 42.66           O
HETATM  775  O   HOH A 117      16.489  -3.839  -1.146  1.00 66.87           O
HETATM  776  O   HOH A 118      28.567  -3.762   3.599  1.00 49.63           O
HETATM  777  O   HOH A 119      14.870  18.972  20.629  1.00 54.87           O
HETATM  778  O   HOH A 120      30.431  -1.309  21.441  1.00 45.49           O
HETATM  779  O   HOH A 121       6.740   3.294  17.043  1.00 42.31           O
HETATM  780  O   HOH A 122      31.540   1.012   1.605  1.00 45.31           O
HETATM  781  O   HOH A 123      25.714   2.391   1.044  1.00 51.27           O
HETATM  782  O   HOH A 124      29.492  -4.632   0.927  1.00 56.02           O
HETATM  783  O   HOH A 125      28.713  -7.346   9.602  1.00 36.45           O
HETATM  784  O   HOH A 126      22.951 -11.873   8.814  1.00 45.23           O
HETATM  785  O   HOH A 127      28.061  -8.436  18.890  1.00 50.79           O
HETATM  786  O   HOH A 128      24.201   2.479   3.211  1.00 33.01           O
HETATM  787  O   HOH A 129      35.203  -2.342   4.420  1.00 47.07           O
END
"""

pdb_str_fraction = """
CRYST1   26.653    4.824   29.048  90.00 101.02  90.00 P 1 21 1
SCALE1      0.037519  0.000000  0.007307        0.00000
SCALE2      0.000000  0.207297  0.000000        0.00000
SCALE3      0.000000  0.000000  0.035072        0.00000
ATOM      1  N   ASN A   1      -1.695   1.735  15.868  1.00  4.33           N
ATOM      2  CA  ASN A   1      -0.410   1.041  15.831  1.00  3.38           C
ATOM      3  C   ASN A   1       0.646   1.801  16.594  1.00  5.38           C
ATOM      4  O   ASN A   1       0.646   3.030  16.628  1.00  4.56           O
ATOM      5  CB  ASN A   1       0.086   0.844  14.397  1.00  1.95           C
ATOM      6  CG  ASN A   1      -0.744  -0.143  13.631  1.00  5.60           C
ATOM      7  OD1 ASN A   1      -1.623  -0.818  14.193  1.00  4.60           O
ATOM      8  ND2 ASN A   1      -0.449  -0.270  12.345  1.00  3.71           N
ATOM      9  H1  ASN A   1      -2.362   1.198  16.458  0.00  4.33           H
ATOM     10  H2  ASN A   1      -1.564   2.685  16.269  0.00  4.33           H
ATOM     11  H3  ASN A   1      -2.073   1.815  14.903  0.00  4.33           H
ATOM     12  HA  ASN A   1      -0.557   0.062  16.287  0.00  3.38           H
ATOM     13  HB2 ASN A   1       0.046   1.798  13.872  0.00  1.95           H
ATOM     14  HB3 ASN A   1       1.111   0.475  14.423  0.00  1.95           H
ATOM     15 HD21 ASN A   1      -0.974  -0.924  11.764  0.00  3.71           H
ATOM     16 HD22 ASN A   1       0.303   0.286  11.937  0.00  3.71           H
ATOM     17  N   VAL A   2       1.575   1.065  17.191  1.00  2.21           N
ATOM     18  CA  VAL A   2       2.779   1.651  17.739  1.00  2.56           C
ATOM     19  C   VAL A   2       3.948   1.033  16.990  1.00  1.90           C
ATOM     20  O   VAL A   2       4.136  -0.192  17.019  1.00  2.64           O
ATOM     21  CB  VAL A   2       2.893   1.411  19.247  1.00  4.05           C
ATOM     22  CG1 VAL A   2       4.189   2.028  19.774  1.00  2.63           C
ATOM     23  CG2 VAL A   2       1.651   2.005  19.922  1.00  2.47           C
ATOM     24  H   VAL A   2       1.515   0.053  17.308  0.00  2.21           H
ATOM     25  HA  VAL A   2       2.784   2.728  17.573  0.00  2.56           H
ATOM     26  HB  VAL A   2       2.935   0.347  19.479  0.00  4.05           H
ATOM     27 HG11 VAL A   2       4.256   1.850  20.847  0.00  2.63           H
ATOM     28 HG12 VAL A   2       5.035   1.564  19.266  0.00  2.63           H
ATOM     29 HG13 VAL A   2       4.178   3.100  19.575  0.00  2.63           H
ATOM     30 HG21 VAL A   2       1.719   1.841  20.997  0.00  2.47           H
ATOM     31 HG22 VAL A   2       1.609   3.074  19.711  0.00  2.47           H
ATOM     32 HG23 VAL A   2       0.763   1.513  19.526  0.00  2.47           H
TER
ATOM    101  N   ASN B   1      12.281   4.857  -1.733  1.00  2.85           N
ATOM    102  CA  ASN B   1      11.027   4.097  -1.673  1.00  3.81           C
ATOM    103  C   ASN B   1       9.965   4.796  -2.471  1.00  2.59           C
ATOM    104  O   ASN B   1       9.976   6.019  -2.588  1.00  2.85           O
ATOM    105  CB  ASN B   1      10.515   3.935  -0.253  1.00  1.67           C
ATOM    106  CG  ASN B   1      11.327   2.968   0.550  1.00  3.35           C
ATOM    107  OD1 ASN B   1      12.142   2.222   0.011  1.00  4.04           O
ATOM    108  ND2 ASN B   1      11.108   2.964   1.860  1.00  3.17           N
ATOM    109  H1  ASN B   1      12.987   4.318  -2.274  0.00  2.85           H
ATOM    110  H2  ASN B   1      12.111   5.771  -2.199  0.00  2.85           H
ATOM    111  H3  ASN B   1      12.634   5.020  -0.768  0.00  2.85           H
ATOM    112  HA  ASN B   1      11.223   3.102  -2.073  0.00  3.81           H
ATOM    113  HB2 ASN B   1      10.549   4.902   0.249  0.00  1.67           H
ATOM    114  HB3 ASN B   1       9.489   3.568  -0.285  0.00  1.67           H
ATOM    115 HD21 ASN B   1      11.630   2.327   2.462  0.00  3.17           H
ATOM    116 HD22 ASN B   1      10.418   3.597   2.264  0.00  3.17           H
ATOM    117  N   VAL B   2       9.020   4.021  -2.990  1.00  1.69           N
ATOM    118  CA  VAL B   2       7.839   4.566  -3.646  1.00  0.82           C
ATOM    119  C   VAL B   2       6.641   4.104  -2.842  1.00  1.98           C
ATOM    120  O   VAL B   2       6.357   2.903  -2.783  1.00  1.64           O
ATOM    121  CB  VAL B   2       7.725   4.115  -5.114  1.00  1.73           C
ATOM    122  CG1 VAL B   2       6.390   4.611  -5.733  1.00  1.72           C
ATOM    123  CG2 VAL B   2       8.903   4.658  -5.900  1.00  2.63           C
ATOM    124  H   VAL B   2       9.046   3.002  -2.971  0.00  1.69           H
ATOM    125  HA  VAL B   2       7.881   5.655  -3.629  0.00  0.82           H
ATOM    126  HB  VAL B   2       7.734   3.026  -5.162  0.00  1.73           H
ATOM    127 HG11 VAL B   2       6.335   4.279  -6.770  0.00  1.72           H
ATOM    128 HG12 VAL B   2       5.559   4.194  -5.164  0.00  1.72           H
ATOM    129 HG13 VAL B   2       6.362   5.700  -5.689  0.00  1.72           H
ATOM    130 HG21 VAL B   2       8.816   4.335  -6.938  0.00  2.63           H
ATOM    131 HG22 VAL B   2       8.893   5.747  -5.847  0.00  2.63           H
ATOM    132 HG23 VAL B   2       9.826   4.273  -5.467  0.00  2.63           H
TER
"""

pdb_str_one_chain = """
CRYST1   21.937    4.866   23.477  90.00 107.08  90.00 P 1 21 1
SCALE1      0.045585  0.000000  0.014006        0.00000
SCALE2      0.000000  0.205508  0.000000        0.00000
SCALE3      0.000000  0.000000  0.044560        0.00000
ATOM      1  N   GLY A   1      12.928   4.612   6.102  1.00 16.77           N
ATOM      2  CA  GLY A   1      12.885   4.207   4.651  1.00 16.57           C
ATOM      3  C   GLY A   1      13.922   3.140   4.419  1.00 16.16           C
ATOM      4  O   GLY A   1      14.414   2.521   5.381  1.00 16.78           O
ATOM      5  H1  GLY A   1      11.977   4.525   6.514  0.00 16.77           H
ATOM      6  H2  GLY A   1      13.586   3.992   6.616  0.00 16.77           H
ATOM      7  H3  GLY A   1      13.250   5.598   6.177  0.00 16.77           H
ATOM      8  HA2 GLY A   1      11.900   3.815   4.398  0.00 16.57           H
ATOM      9  HA3 GLY A   1      13.100   5.065   4.014  0.00 16.57           H
ATOM     10  N   ASN A   2      14.281   2.923   3.155  1.00 15.02           N
ATOM     11  CA  ASN A   2      15.415   2.038   2.831  1.00 14.10           C
ATOM     12  C   ASN A   2      16.696   2.537   3.427  1.00 13.13           C
ATOM     13  O   ASN A   2      16.959   3.742   3.426  1.00 11.91           O
ATOM     14  CB  ASN A   2      15.591   1.881   1.341  1.00 15.38           C
ATOM     15  CG  ASN A   2      14.353   1.342   0.692  1.00 14.08           C
ATOM     16  OD1 ASN A   2      13.912   0.227   1.016  1.00 17.46           O
ATOM     17  ND2 ASN A   2      13.733   2.155  -0.169  1.00 11.72           N
ATOM     18  H   ASN A   2      13.820   3.334   2.343  0.00 15.02           H
ATOM     19  HA  ASN A   2      15.193   1.057   3.252  0.00 14.10           H
ATOM     20  HB2 ASN A   2      15.813   2.853   0.900  0.00 15.38           H
ATOM     21  HB3 ASN A   2      16.409   1.188   1.146  0.00 15.38           H
ATOM     22 HD21 ASN A   2      12.885   1.845  -0.643  0.00 11.72           H
ATOM     23 HD22 ASN A   2      14.108   3.086  -0.352  0.00 11.72           H
ATOM     24  N   ASN A   3      17.499   1.590   3.905  1.00 12.26           N
ATOM     25  CA  ASN A   3      18.744   1.904   4.589  1.00 11.74           C
ATOM     26  C   ASN A   3      19.982   1.332   3.895  1.00 11.10           C
ATOM     27  O   ASN A   3      20.065   0.119   3.648  1.00 10.42           O
ATOM     28  CB  ASN A   3      18.678   1.378   6.042  1.00 12.15           C
ATOM     29  CG  ASN A   3      19.931   1.739   6.861  1.00 12.82           C
ATOM     30  OD1 ASN A   3      20.235   2.925   7.072  1.00 15.05           O
ATOM     31  ND2 ASN A   3      20.666   0.715   7.306  1.00 13.48           N
ATOM     32  OXT ASN A   3      20.908   2.077   3.576  1.00 11.10           O
ATOM     33  H   ASN A   3      17.311   0.590   3.832  0.00 12.26           H
ATOM     34  HA  ASN A   3      18.863   2.987   4.586  0.00 11.74           H
ATOM     35  HB2 ASN A   3      17.812   1.815   6.539  0.00 12.15           H
ATOM     36  HB3 ASN A   3      18.588   0.292   6.023  0.00 12.15           H
ATOM     37 HD21 ASN A   3      21.508   0.892   7.854  0.00 13.48           H
ATOM     38 HD22 ASN A   3      20.385  -0.243   7.097  0.00 13.48           H
TER
"""

pdb_str_huge_box = """
CRYST1  109.608  105.841  108.497  90.00  90.00  90.00 P 1
SCALE1      0.009123  0.000000  0.000000        0.00000
SCALE2      0.000000  0.009448  0.000000        0.00000
SCALE3      0.000000  0.000000  0.009217        0.00000
ATOM      1  N   GLY A   1      51.028  54.855  56.745  1.00 16.77           N
ATOM      2  CA  GLY A   1      50.985  54.450  55.294  1.00 16.57           C
ATOM      3  C   GLY A   1      52.022  53.383  55.062  1.00 16.16           C
ATOM      4  O   GLY A   1      52.514  52.764  56.024  1.00 16.78           O
ATOM      5  H1  GLY A   1      50.077  54.768  57.157  0.00 16.77           H
ATOM      6  H2  GLY A   1      51.686  54.235  57.259  0.00 16.77           H
ATOM      7  H3  GLY A   1      51.350  55.841  56.820  0.00 16.77           H
ATOM      8  HA2 GLY A   1      50.000  54.058  55.041  0.00 16.57           H
ATOM      9  HA3 GLY A   1      51.200  55.308  54.657  0.00 16.57           H
ATOM     10  N   ASN A   2      52.381  53.166  53.798  1.00 15.02           N
ATOM     11  CA  ASN A   2      53.515  52.281  53.474  1.00 14.10           C
ATOM     12  C   ASN A   2      54.796  52.780  54.070  1.00 13.13           C
ATOM     13  O   ASN A   2      55.059  53.985  54.069  1.00 11.91           O
ATOM     14  CB  ASN A   2      53.691  52.124  51.984  1.00 15.38           C
ATOM     15  CG  ASN A   2      52.453  51.585  51.335  1.00 14.08           C
ATOM     16  OD1 ASN A   2      52.012  50.470  51.659  1.00 17.46           O
ATOM     17  ND2 ASN A   2      51.833  52.398  50.474  1.00 11.72           N
ATOM     18  H   ASN A   2      51.920  53.577  52.986  0.00 15.02           H
ATOM     19  HA  ASN A   2      53.293  51.300  53.895  0.00 14.10           H
ATOM     20  HB2 ASN A   2      53.913  53.096  51.543  0.00 15.38           H
ATOM     21  HB3 ASN A   2      54.509  51.431  51.789  0.00 15.38           H
ATOM     22 HD21 ASN A   2      50.985  52.088  50.000  0.00 11.72           H
ATOM     23 HD22 ASN A   2      52.208  53.329  50.291  0.00 11.72           H
ATOM     24  N   ASN A   3      55.599  51.833  54.548  1.00 12.26           N
ATOM     25  CA  ASN A   3      56.844  52.147  55.232  1.00 11.74           C
ATOM     26  C   ASN A   3      58.082  51.575  54.538  1.00 11.10           C
ATOM     27  O   ASN A   3      58.165  50.362  54.291  1.00 10.42           O
ATOM     28  CB  ASN A   3      56.778  51.621  56.685  1.00 12.15           C
ATOM     29  CG  ASN A   3      58.031  51.982  57.504  1.00 12.82           C
ATOM     30  OD1 ASN A   3      58.335  53.168  57.715  1.00 15.05           O
ATOM     31  ND2 ASN A   3      58.766  50.958  57.949  1.00 13.48           N
ATOM     32  OXT ASN A   3      59.008  52.320  54.219  1.00 11.10           O
ATOM     33  H   ASN A   3      55.411  50.833  54.475  0.00 12.26           H
ATOM     34  HA  ASN A   3      56.963  53.230  55.229  0.00 11.74           H
ATOM     35  HB2 ASN A   3      55.912  52.058  57.182  0.00 12.15           H
ATOM     36  HB3 ASN A   3      56.688  50.535  56.666  0.00 12.15           H
ATOM     37 HD21 ASN A   3      59.608  51.135  58.497  0.00 13.48           H
ATOM     38 HD22 ASN A   3      58.485  50.000  57.740  0.00 13.48           H
TER
END
"""

def exercise_00(nonbonded_distance_cutoff=4.5, write_files=False):
  """
  Exercise supercell. General.
  """
  if (libtbx.env.find_in_repositories(relative_path="chem_data") is None):
    print("Skipping exercise(): chem_data directory not available")
    return
  if(write_files):
    with open("input.pdb","w") as fo:
      fo.write(pdb_str_1yjp)
  pdb_inp = iotbx.pdb.input(source_info=None, lines=pdb_str_1yjp)
  m = mmtbx.model.manager(model_input = pdb_inp, log = null_out())
  p = m.get_default_pdb_interpretation_params()
  p.pdb_interpretation.nonbonded_distance_cutoff = nonbonded_distance_cutoff
  m.process(make_restraints=True, pdb_interpretation_params=p)
  # Figure symmetry interactions internally
  sc1 = super_cell.manager(
    pdb_hierarchy        = m.get_hierarchy(),
    crystal_symmetry     = m.crystal_symmetry(),
    select_within_radius = nonbonded_distance_cutoff)
  if(write_files):
    sc1.super_sphere_hierarchy.write_pdb_file(file_name="sc1.pdb",
      crystal_symmetry = sc1.cs_super_sphere)
  # Take symmetry interactions from restraints
  siiu = m.get_restraints_manager().geometry.pair_proxies().nonbonded_proxies.\
     get_symmetry_interacting_indices_unique(
       sites_cart = m.get_hierarchy().atoms().extract_xyz())
  sc2 = super_cell.manager(
    pdb_hierarchy        = m.get_hierarchy(),
    crystal_symmetry     = m.crystal_symmetry(),
    select_within_radius = nonbonded_distance_cutoff,
    siiu                 = siiu)
  if(write_files):
    sc2.super_sphere_hierarchy.write_pdb_file(file_name="sc2.pdb",
      crystal_symmetry = sc2.cs_super_sphere)
  # Check both ways produce the same models (chain/residue order can vary)
  assert sc1.super_sphere_hierarchy.atoms().size()==\
         sc2.super_sphere_hierarchy.atoms().size()

def exercise_01():
  """
  When increasing Rss make sure models with smaller Rss are exact subset of
  models with larger Rss (exercises the bug fix found by Goska).
  """
  def dist(r1,r2):
    return math.sqrt((r1[0]-r2[0])**2+(r1[1]-r2[1])**2+(r1[2]-r2[2])**2)
  coords = []
  for Rss in range(0,11):
    #print(Rss)
    pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str_3q2c)
    h = pdb_inp.construct_hierarchy()
    h.atoms().reset_i_seq()
    ss = super_cell.manager(
      pdb_hierarchy = h,
      crystal_symmetry = pdb_inp.crystal_symmetry(),
      select_within_radius=Rss,
      siiu=None)
    coords.append(ss.super_sphere_hierarchy.atoms().extract_xyz())
  for i, ri in enumerate(coords):
    for j, rj in enumerate(coords):
      if(i<j):
        for site_i in ri:
          found = False
          for site_j in rj:
            d = dist(site_i, site_j)
            if(d<1.e-2):
              found = True
              break
          assert found

def _grad_from_ss(expansion):
  pdb_hierarchy_super = expansion.super_sphere_hierarchy
  ss_crystal_symmetry = expansion.cs_super_sphere
  selection = flex.bool(pdb_hierarchy_super.atoms().size(), False)
  selection = selection.set_selected(
    flex.size_t(range(expansion.pdb_hierarchy.atoms().size())), True)
  model = mmtbx.model.manager(
    model_input       = None,
    pdb_hierarchy     = pdb_hierarchy_super,
    crystal_symmetry  = ss_crystal_symmetry,
    log               = null_out())
  model.process(make_restraints=True, grm_normalization=True)
  rm = model.get_restraints_manager()
  es = rm.geometry.energies_sites(
    sites_cart        = model.get_sites_cart(),
    compute_gradients =True)
  return es.gradients.select(selection)

def exercise_02():
  """
  Check expansion via gradients.
  """
  for pdb_str in [pdb_str_huge_box,
                  pdb_str_one_chain,
                  pdb_str_1yjp,
                  pdb_str_3q2c,
                  pdb_str_fraction]:
    # gradients usual way
    pdb_inp = iotbx.pdb.input(source_info=None, lines = pdb_str)
    h = pdb_inp.construct_hierarchy()
    model = mmtbx.model.manager(
      model_input       = None,
      pdb_hierarchy     = h,
      crystal_symmetry  = pdb_inp.crystal_symmetry(),
      log               = null_out())
    model.process(make_restraints=True, grm_normalization=True)
    rm = model.get_restraints_manager()
    es = rm.geometry.energies_sites(
      sites_cart        = model.get_sites_cart(),
      compute_gradients = True)
    g1 = es.gradients
    # gradients via expansion
    expansion = super_cell.manager(
      pdb_hierarchy        = model.get_hierarchy(),
      crystal_symmetry     = model.crystal_symmetry(),
      select_within_radius = 5,
      box_buffer_layer     = 3)
    g2 = _grad_from_ss(expansion)
    # compare gradinets by means of distance
    dist = flex.sqrt((g1 - g2).dot())
    assert flex.max(dist) < 1.e-6, flex.max(dist)
    #
    # scramble sites_cart
    for it in [1,2]:
      r = model.get_hierarchy().atoms().extract_xyz()
      rs = flex.vec3_double(r.as_double()*3 + flex.random_double(r.as_double().size()))
      expansion.update(sites_cart = rs, debug=True)
      g3 = _grad_from_ss(expansion)
      dist = flex.sqrt((g1 - g3).dot())
      assert flex.max(dist) > 100., flex.max(dist) # some number like this, typically 300-600
      # set original sites
      expansion.update(sites_cart = r, debug=True)
      g4 = _grad_from_ss(expansion)
      dist = flex.sqrt((g1 - g4).dot())
      assert flex.max(dist) < 1.e-6, flex.max(dist)


if(__name__ == "__main__"):
  exercise_00()
  exercise_01()
  if libtbx.env.find_in_repositories(relative_path="chem_data") is None:
    print("Skipping exercise_02(): chem_data directory not available")
  else:
    exercise_02()
