// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file calculator_details.hpp
 * This header file contains support data structures for RPC communication.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__CALCULATOR_DETAILS_HPP
#define FAST_DDS_GENERATED__CALCULATOR_DETAILS_HPP

#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/rpc/RemoteExceptionCode_t.hpp>
#include <fastdds/dds/rpc/interfaces/RpcStatusCode.hpp>

#include "calculator.hpp"

namespace calculator_example {
    namespace detail {

    //{ Calculator interface

    //{ representation_limits
    struct Calculator_representation_limits_In
    {
    };



    struct Calculator_representation_limits_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_representation_limits_Out> result;
    };

    //}  // representation_limits
     
    //{ addition
    struct Calculator_addition_In
    {
        int32_t value1; 
        int32_t value2; 
    };

      

    struct Calculator_addition_Out
    {
        int32_t return_;
    };

    struct Calculator_addition_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_addition_Out> result;
        eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
    };

    //}  // addition
     
    //{ subtraction
    struct Calculator_subtraction_In
    {
        int32_t value1; 
        int32_t value2; 
    };

      

    struct Calculator_subtraction_Out
    {
        int32_t return_;
    };

    struct Calculator_subtraction_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_subtraction_Out> result;
        eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
    };

    //}  // subtraction
     
    //{ fibonacci_seq
    struct Calculator_fibonacci_seq_In
    {
        uint32_t n_results; 
    };

     

    struct Calculator_fibonacci_seq_Out
    {
        eprosima::fastcdr::optional<int32_t> return_;
        eprosima::fastcdr::optional<bool> finished_;
    };

    struct Calculator_fibonacci_seq_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_fibonacci_seq_Out> result;
        eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
    };

    //}  // fibonacci_seq
     
    //{ sum_all
    struct Calculator_sum_all_In
    {
         
    };

    struct Calculator_sum_all_value_Feed
    {
        eprosima::fastcdr::optional<int32_t> value;
        eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
    }; 

    struct Calculator_sum_all_Out
    {
        int32_t return_;
    };

    struct Calculator_sum_all_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_sum_all_Out> result;
        eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
    };

    //}  // sum_all
     
    //{ accumulator
    struct Calculator_accumulator_In
    {
         
    };

    struct Calculator_accumulator_value_Feed
    {
        eprosima::fastcdr::optional<int32_t> value;
        eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
    }; 

    struct Calculator_accumulator_Out
    {
        eprosima::fastcdr::optional<int32_t> return_;
        eprosima::fastcdr::optional<bool> finished_;
    };

    struct Calculator_accumulator_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_accumulator_Out> result;
        eprosima::fastcdr::optional<calculator_example::OverflowException> calculator_example_OverflowException_ex;
    };

    //}  // accumulator
     
    //{ filter
    struct Calculator_filter_In
    {
         
        calculator_example::FilterKind filter_kind; 
    };

    struct Calculator_filter_value_Feed
    {
        eprosima::fastcdr::optional<int32_t> value;
        eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RpcStatusCode> finished_;
    };  

    struct Calculator_filter_Out
    {
        eprosima::fastcdr::optional<int32_t> return_;
        eprosima::fastcdr::optional<bool> finished_;
    };

    struct Calculator_filter_Result
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_filter_Out> result;
    };

    //}  // filter
     

    //{ top level

    struct Calculator_Request
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_representation_limits_In> representation_limits; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_addition_In> addition;   
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_subtraction_In> subtraction;   
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_fibonacci_seq_In> fibonacci_seq;  
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_sum_all_In> sum_all;
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_sum_all_value_Feed> sum_all_value;  
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_accumulator_In> accumulator;
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_accumulator_value_Feed> accumulator_value;  
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_filter_In> filter;
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_filter_value_Feed> filter_value;   
        eprosima::fastcdr::optional<bool> feed_cancel_;
    };

    struct Calculator_Reply
    {
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_representation_limits_Result> representation_limits; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_addition_Result> addition; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_subtraction_Result> subtraction; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_fibonacci_seq_Result> fibonacci_seq; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_sum_all_Result> sum_all; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_accumulator_Result> accumulator; 
        eprosima::fastcdr::optional<calculator_example::detail::Calculator_filter_Result> filter; 
        eprosima::fastcdr::optional<eprosima::fastdds::dds::rpc::RemoteExceptionCode_t> remoteEx;
    };

    //}  // top level

    //}  // Calculator interface

    } // namespace detail
}  // namespace calculator_example

#endif //FAST_DDS_GENERATED__CALCULATOR_DETAILS_HPP