<resource schema="dc" resdir="__system">
	<meta name="description">Helper objects for the support of the VO's
	ad-hoc "parameter query language" as used in various DAL protocols.
	</meta>

	<procDef id="coneParameter" type="phraseMaker">
		<doc>
			A parameter containing a cone search with a single position-like
			key (the first, expecting a coordinate pair fairly leniently) and
			a cone search (a float, in the second input key).

			The generated expression uses pgsphere.
		</doc>

		<setup>
			<par name="posCol" description="Name of the database column
				to be compared against the input value(s).  It must be of
				type spoint."/>
		</setup>

		<code>
			try:
				posKey = inputKeys[0].name
				sizeKey = inputKeys[1].name
			except IndexError:
				raise base.ValidationError("Operator error: the cone condition"
					" is lacking input keys.", "query")
			parsedPos = pql.PQLPositionPar.fromLiteral(
				inPars.get(posKey, None), posKey)
			size = inputKeys[1]._parse(inPars.get(sizeKey, None))
			if parsedPos is not None and size is not None:
				yield parsedPos.getConeSQL(posCol, outPars, size)
		</code>
	</procDef>

	<procDef id="dateParameter">
		<doc>
			A parameter constraining an epoch or similar. 
		</doc>

		<setup>
			<par name="consCol" description="Name of the database column
				constrained by the input value."/>
			<par name="consColKind" description="The kind of date specification
				of consCol; this can be timestamp (also good for dates), jd, mjd,
				or jy (julian year).">"timestamp"</par>
		</setup>

		<code>
			inputKey = inputKeys[0]
			if consColKind=="timestamp":
				convertTo = None
			else:
				convertTo = consColKind

			key = inputKey.name
			parsed = pql.PQLDatePar.fromLiteral(inPars.get(key, None), key)
			if parsed is not None:
				yield parsed.getSQL(consCol, outPars, convertTo)
		</code>
	</procDef>

	<procDef id="floatParameter">
		<setup>
			<par name="consCol" description="Name of the database column
				constrained by the input value."/>
		</setup>

		<code>
			key = inputKeys[0].name
			parsed = pql.PQLFloatPar.fromLiteral(inPars.get(key, None), key)
			if parsed is not None:
				yield parsed.getSQL(consCol, outPars)
		</code>
	</procDef>

	<procDef id="stringParameter">
		<doc>
			A parameter that constrains a string-valued column.  Matches
			are literal and case-sensitive; the collation (for ranges)
			is that given by the database.  Steps are not allowed.
		</doc>

		<setup>
			<par name="consCol" description="Name of the database column
				constrained by the input value."/>
		</setup>

		<code>
			key = inputKeys[0].name
			parsed = pql.PQLStringPar.fromLiteral(inPars.get(key, None), key)
			if parsed is not None:
				yield parsed.getSQL(consCol, outPars)
		</code>
	</procDef>

	<procDef id="irStringParameter">
		<doc>
			A parameter that constrains a string-valued column, where both
			the column values and the search value are interpreted as 
			document vectors and compared according to the information retrieval
			functions of Postgres -- i.e., more or less like google matches
			queries.

			Since it is hard to figure out what they could mean, neither 
			steps nor ranges are supported.
		</doc>

		<setup>
			<par name="consCol" description="Name of the database column
				constrained by the input value."/>
		</setup>

		<code>
			key = inputKeys[0].name
			parsed = pql.PQLTextParIR.fromLiteral(inPars.get(key, None), key)
			if parsed is not None:
				yield parsed.getSQL(consCol, outPars)
		</code>
	</procDef>


<!-- For lack of a better place: Descriptors of the standard DALI parameters
vodal-based services interpret. -->

	<NXSTREAM id="DALIPars">
		<doc>
			This stream includes the standard DALI service parameters
			(RESPONSEFORMAT, MAXREC, VERB).  For services available through
			IVOA-standard protocols (renderers scs.xml, siap.xml, ssap.xml,
			and also api), this is included automatically, so you will
			not usually have to manually FEED this.
		</doc>
		<inputKey name="responseformat" type="text"
			ucd="meta.code.mime"
			tablehead="Output Format"
			description="File format requested for output."
			multiplicity="single" std="True">
			<property key="notForRenderer">form</property>
			<property key="std">1</property>
			<preparse>
				return input and input.lower()
			</preparse>
			<values>
				<LOOP>
					<codeItems>
						from gavo import formats
						for key in formats.iterFormats():
							yield {"item": formats.getMIMEFor(key).lower(), 
								"title": formats.getLabelFor(key)}
							for alias in formats.getAliasesFor(key):
								yield {"item": alias.lower(), 
									"title": "Alias for %s"%formats.getLabelFor(key)}
					</codeItems>
					<events>
						<option title="\\title">\\item</option>
					</events>
				</LOOP>
			</values>
		</inputKey>

		<inputKey name="maxrec" type="integer"
			tablehead="Match limit"
			description="Maximum number of records returned.  Pass 0 to
				 retrieve service parameters."
			multiplicity="single" std="True">
			<property key="notForRenderer">form</property>
			<property key="std">1</property>
		</inputKey>

		<inputKey name="verb" type="integer"
			tablehead="Verbosity"
			description="Exhaustiveness of column selection.  VERB=1 only
				returns the most important columns, VERB=2 selects the columns
				deemed useful to the average user, VERB=3 returns a table
				with all available columns."
			multiplicity="single" std="True">
			<property key="notForRenderer">form</property>
			<values>
				<option title="terse">1</option>
				<option title="normal">2</option>
				<option title="everything">3</option>
			</values>
		</inputKey>

	</NXSTREAM>

	<NXSTREAM id="DALIUpload">
		<doc>
			This stream includes a DALI UPLOAD parameter.  This is purely
			declarative for now, as the interpretation is done anyway
			for VO renderers and not at all otherwise.
		</doc>

		<inputKey name="UPLOAD" type="text"
			multiplicity="multple"
			tablehead="Upload"
			description="DALI-style upload; this is essentially &lt;name>,&lt;spec>,
				where name is a regular SQL identifier and spec a URL or param:Foo.
				In the latter case, give a file upload in a parameter named Foo.">
		</inputKey>
	</NXSTREAM>

</resource>
