// Code generated by smithy-go-codegen DO NOT EDIT.

package mturk

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mturk/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptQualificationRequest struct {
}

func (*validateOpAcceptQualificationRequest) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptQualificationRequest) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptQualificationRequestInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptQualificationRequestInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpApproveAssignment struct {
}

func (*validateOpApproveAssignment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpApproveAssignment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ApproveAssignmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpApproveAssignmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociateQualificationWithWorker struct {
}

func (*validateOpAssociateQualificationWithWorker) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateQualificationWithWorker) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateQualificationWithWorkerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateQualificationWithWorkerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateAdditionalAssignmentsForHIT struct {
}

func (*validateOpCreateAdditionalAssignmentsForHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateAdditionalAssignmentsForHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateAdditionalAssignmentsForHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateAdditionalAssignmentsForHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateHIT struct {
}

func (*validateOpCreateHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateHITType struct {
}

func (*validateOpCreateHITType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHITType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHITTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHITTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateHITWithHITType struct {
}

func (*validateOpCreateHITWithHITType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateHITWithHITType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateHITWithHITTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateHITWithHITTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateQualificationType struct {
}

func (*validateOpCreateQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateWorkerBlock struct {
}

func (*validateOpCreateWorkerBlock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateWorkerBlock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateWorkerBlockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateWorkerBlockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteHIT struct {
}

func (*validateOpDeleteHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteQualificationType struct {
}

func (*validateOpDeleteQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteWorkerBlock struct {
}

func (*validateOpDeleteWorkerBlock) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteWorkerBlock) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteWorkerBlockInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteWorkerBlockInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateQualificationFromWorker struct {
}

func (*validateOpDisassociateQualificationFromWorker) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateQualificationFromWorker) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateQualificationFromWorkerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateQualificationFromWorkerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetAssignment struct {
}

func (*validateOpGetAssignment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetAssignment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetAssignmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetAssignmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetFileUploadURL struct {
}

func (*validateOpGetFileUploadURL) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetFileUploadURL) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetFileUploadURLInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetFileUploadURLInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetHIT struct {
}

func (*validateOpGetHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetQualificationScore struct {
}

func (*validateOpGetQualificationScore) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetQualificationScore) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetQualificationScoreInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetQualificationScoreInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetQualificationType struct {
}

func (*validateOpGetQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListAssignmentsForHIT struct {
}

func (*validateOpListAssignmentsForHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListAssignmentsForHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListAssignmentsForHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListAssignmentsForHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListHITsForQualificationType struct {
}

func (*validateOpListHITsForQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListHITsForQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListHITsForQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListHITsForQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListQualificationTypes struct {
}

func (*validateOpListQualificationTypes) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListQualificationTypes) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListQualificationTypesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListQualificationTypesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListReviewPolicyResultsForHIT struct {
}

func (*validateOpListReviewPolicyResultsForHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListReviewPolicyResultsForHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListReviewPolicyResultsForHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListReviewPolicyResultsForHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListWorkersWithQualificationType struct {
}

func (*validateOpListWorkersWithQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListWorkersWithQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListWorkersWithQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListWorkersWithQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpNotifyWorkers struct {
}

func (*validateOpNotifyWorkers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpNotifyWorkers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*NotifyWorkersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpNotifyWorkersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectAssignment struct {
}

func (*validateOpRejectAssignment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectAssignment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectAssignmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectAssignmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectQualificationRequest struct {
}

func (*validateOpRejectQualificationRequest) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectQualificationRequest) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectQualificationRequestInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectQualificationRequestInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendBonus struct {
}

func (*validateOpSendBonus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendBonus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendBonusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendBonusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSendTestEventNotification struct {
}

func (*validateOpSendTestEventNotification) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSendTestEventNotification) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SendTestEventNotificationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSendTestEventNotificationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateExpirationForHIT struct {
}

func (*validateOpUpdateExpirationForHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateExpirationForHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateExpirationForHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateExpirationForHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateHITReviewStatus struct {
}

func (*validateOpUpdateHITReviewStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateHITReviewStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateHITReviewStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateHITReviewStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateHITTypeOfHIT struct {
}

func (*validateOpUpdateHITTypeOfHIT) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateHITTypeOfHIT) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateHITTypeOfHITInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateHITTypeOfHITInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateNotificationSettings struct {
}

func (*validateOpUpdateNotificationSettings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateNotificationSettings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateNotificationSettingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateNotificationSettingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateQualificationType struct {
}

func (*validateOpUpdateQualificationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateQualificationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateQualificationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateQualificationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptQualificationRequestValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptQualificationRequest{}, middleware.After)
}

func addOpApproveAssignmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpApproveAssignment{}, middleware.After)
}

func addOpAssociateQualificationWithWorkerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateQualificationWithWorker{}, middleware.After)
}

func addOpCreateAdditionalAssignmentsForHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateAdditionalAssignmentsForHIT{}, middleware.After)
}

func addOpCreateHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHIT{}, middleware.After)
}

func addOpCreateHITTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHITType{}, middleware.After)
}

func addOpCreateHITWithHITTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateHITWithHITType{}, middleware.After)
}

func addOpCreateQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateQualificationType{}, middleware.After)
}

func addOpCreateWorkerBlockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateWorkerBlock{}, middleware.After)
}

func addOpDeleteHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteHIT{}, middleware.After)
}

func addOpDeleteQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteQualificationType{}, middleware.After)
}

func addOpDeleteWorkerBlockValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteWorkerBlock{}, middleware.After)
}

func addOpDisassociateQualificationFromWorkerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateQualificationFromWorker{}, middleware.After)
}

func addOpGetAssignmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetAssignment{}, middleware.After)
}

func addOpGetFileUploadURLValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetFileUploadURL{}, middleware.After)
}

func addOpGetHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetHIT{}, middleware.After)
}

func addOpGetQualificationScoreValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetQualificationScore{}, middleware.After)
}

func addOpGetQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetQualificationType{}, middleware.After)
}

func addOpListAssignmentsForHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListAssignmentsForHIT{}, middleware.After)
}

func addOpListHITsForQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListHITsForQualificationType{}, middleware.After)
}

func addOpListQualificationTypesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListQualificationTypes{}, middleware.After)
}

func addOpListReviewPolicyResultsForHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListReviewPolicyResultsForHIT{}, middleware.After)
}

func addOpListWorkersWithQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListWorkersWithQualificationType{}, middleware.After)
}

func addOpNotifyWorkersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpNotifyWorkers{}, middleware.After)
}

func addOpRejectAssignmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectAssignment{}, middleware.After)
}

func addOpRejectQualificationRequestValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectQualificationRequest{}, middleware.After)
}

func addOpSendBonusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendBonus{}, middleware.After)
}

func addOpSendTestEventNotificationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSendTestEventNotification{}, middleware.After)
}

func addOpUpdateExpirationForHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateExpirationForHIT{}, middleware.After)
}

func addOpUpdateHITReviewStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateHITReviewStatus{}, middleware.After)
}

func addOpUpdateHITTypeOfHITValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateHITTypeOfHIT{}, middleware.After)
}

func addOpUpdateNotificationSettingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateNotificationSettings{}, middleware.After)
}

func addOpUpdateQualificationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateQualificationType{}, middleware.After)
}

func validateHITLayoutParameter(v *types.HITLayoutParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HITLayoutParameter"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHITLayoutParameterList(v []types.HITLayoutParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HITLayoutParameterList"}
	for i := range v {
		if err := validateHITLayoutParameter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLocale(v *types.Locale) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Locale"}
	if v.Country == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Country"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLocaleList(v []types.Locale) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LocaleList"}
	for i := range v {
		if err := validateLocale(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateNotificationSpecification(v *types.NotificationSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotificationSpecification"}
	if v.Destination == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destination"))
	}
	if len(v.Transport) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Transport"))
	}
	if v.Version == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if v.EventTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateQualificationRequirement(v *types.QualificationRequirement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QualificationRequirement"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if len(v.Comparator) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Comparator"))
	}
	if v.LocaleValues != nil {
		if err := validateLocaleList(v.LocaleValues); err != nil {
			invalidParams.AddNested("LocaleValues", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateQualificationRequirementList(v []types.QualificationRequirement) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "QualificationRequirementList"}
	for i := range v {
		if err := validateQualificationRequirement(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReviewPolicy(v *types.ReviewPolicy) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReviewPolicy"}
	if v.PolicyName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptQualificationRequestInput(v *AcceptQualificationRequestInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptQualificationRequestInput"}
	if v.QualificationRequestId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationRequestId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpApproveAssignmentInput(v *ApproveAssignmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ApproveAssignmentInput"}
	if v.AssignmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateQualificationWithWorkerInput(v *AssociateQualificationWithWorkerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateQualificationWithWorkerInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateAdditionalAssignmentsForHITInput(v *CreateAdditionalAssignmentsForHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateAdditionalAssignmentsForHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if v.NumberOfAdditionalAssignments == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NumberOfAdditionalAssignments"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHITInput(v *CreateHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHITInput"}
	if v.LifetimeInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LifetimeInSeconds"))
	}
	if v.AssignmentDurationInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentDurationInSeconds"))
	}
	if v.Reward == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reward"))
	}
	if v.Title == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Title"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.QualificationRequirements != nil {
		if err := validateQualificationRequirementList(v.QualificationRequirements); err != nil {
			invalidParams.AddNested("QualificationRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if v.AssignmentReviewPolicy != nil {
		if err := validateReviewPolicy(v.AssignmentReviewPolicy); err != nil {
			invalidParams.AddNested("AssignmentReviewPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.HITReviewPolicy != nil {
		if err := validateReviewPolicy(v.HITReviewPolicy); err != nil {
			invalidParams.AddNested("HITReviewPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.HITLayoutParameters != nil {
		if err := validateHITLayoutParameterList(v.HITLayoutParameters); err != nil {
			invalidParams.AddNested("HITLayoutParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHITTypeInput(v *CreateHITTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHITTypeInput"}
	if v.AssignmentDurationInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentDurationInSeconds"))
	}
	if v.Reward == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reward"))
	}
	if v.Title == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Title"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if v.QualificationRequirements != nil {
		if err := validateQualificationRequirementList(v.QualificationRequirements); err != nil {
			invalidParams.AddNested("QualificationRequirements", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateHITWithHITTypeInput(v *CreateHITWithHITTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateHITWithHITTypeInput"}
	if v.HITTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITTypeId"))
	}
	if v.LifetimeInSeconds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LifetimeInSeconds"))
	}
	if v.AssignmentReviewPolicy != nil {
		if err := validateReviewPolicy(v.AssignmentReviewPolicy); err != nil {
			invalidParams.AddNested("AssignmentReviewPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.HITReviewPolicy != nil {
		if err := validateReviewPolicy(v.HITReviewPolicy); err != nil {
			invalidParams.AddNested("HITReviewPolicy", err.(smithy.InvalidParamsError))
		}
	}
	if v.HITLayoutParameters != nil {
		if err := validateHITLayoutParameterList(v.HITLayoutParameters); err != nil {
			invalidParams.AddNested("HITLayoutParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateQualificationTypeInput(v *CreateQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateQualificationTypeInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Description == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Description"))
	}
	if len(v.QualificationTypeStatus) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeStatus"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateWorkerBlockInput(v *CreateWorkerBlockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateWorkerBlockInput"}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteHITInput(v *DeleteHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteQualificationTypeInput(v *DeleteQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteQualificationTypeInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteWorkerBlockInput(v *DeleteWorkerBlockInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteWorkerBlockInput"}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateQualificationFromWorkerInput(v *DisassociateQualificationFromWorkerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateQualificationFromWorkerInput"}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetAssignmentInput(v *GetAssignmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetAssignmentInput"}
	if v.AssignmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetFileUploadURLInput(v *GetFileUploadURLInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetFileUploadURLInput"}
	if v.AssignmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentId"))
	}
	if v.QuestionIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QuestionIdentifier"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetHITInput(v *GetHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetQualificationScoreInput(v *GetQualificationScoreInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetQualificationScoreInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetQualificationTypeInput(v *GetQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetQualificationTypeInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListAssignmentsForHITInput(v *ListAssignmentsForHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListAssignmentsForHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListHITsForQualificationTypeInput(v *ListHITsForQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListHITsForQualificationTypeInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListQualificationTypesInput(v *ListQualificationTypesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListQualificationTypesInput"}
	if v.MustBeRequestable == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MustBeRequestable"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListReviewPolicyResultsForHITInput(v *ListReviewPolicyResultsForHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListReviewPolicyResultsForHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListWorkersWithQualificationTypeInput(v *ListWorkersWithQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListWorkersWithQualificationTypeInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpNotifyWorkersInput(v *NotifyWorkersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "NotifyWorkersInput"}
	if v.Subject == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Subject"))
	}
	if v.MessageText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MessageText"))
	}
	if v.WorkerIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectAssignmentInput(v *RejectAssignmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectAssignmentInput"}
	if v.AssignmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentId"))
	}
	if v.RequesterFeedback == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RequesterFeedback"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectQualificationRequestInput(v *RejectQualificationRequestInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectQualificationRequestInput"}
	if v.QualificationRequestId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationRequestId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendBonusInput(v *SendBonusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendBonusInput"}
	if v.WorkerId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WorkerId"))
	}
	if v.BonusAmount == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BonusAmount"))
	}
	if v.AssignmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssignmentId"))
	}
	if v.Reason == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Reason"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSendTestEventNotificationInput(v *SendTestEventNotificationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SendTestEventNotificationInput"}
	if v.Notification == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Notification"))
	} else if v.Notification != nil {
		if err := validateNotificationSpecification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.TestEventType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("TestEventType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateExpirationForHITInput(v *UpdateExpirationForHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateExpirationForHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if v.ExpireAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExpireAt"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateHITReviewStatusInput(v *UpdateHITReviewStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateHITReviewStatusInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateHITTypeOfHITInput(v *UpdateHITTypeOfHITInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateHITTypeOfHITInput"}
	if v.HITId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITId"))
	}
	if v.HITTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateNotificationSettingsInput(v *UpdateNotificationSettingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateNotificationSettingsInput"}
	if v.HITTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HITTypeId"))
	}
	if v.Notification != nil {
		if err := validateNotificationSpecification(v.Notification); err != nil {
			invalidParams.AddNested("Notification", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateQualificationTypeInput(v *UpdateQualificationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateQualificationTypeInput"}
	if v.QualificationTypeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("QualificationTypeId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
