/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcGloballyUniqueId.h"
#include "ifcpp/IFC4/include/IfcLabel.h"
#include "ifcpp/IFC4/include/IfcObject.h"
#include "ifcpp/IFC4/include/IfcOwnerHistory.h"
#include "ifcpp/IFC4/include/IfcRelDefinesByType.h"
#include "ifcpp/IFC4/include/IfcText.h"
#include "ifcpp/IFC4/include/IfcTypeObject.h"

// ENTITY IfcRelDefinesByType 
IfcRelDefinesByType::IfcRelDefinesByType( int id ) { m_entity_id = id; }
IfcRelDefinesByType::~IfcRelDefinesByType() {}
shared_ptr<BuildingObject> IfcRelDefinesByType::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcRelDefinesByType> copy_self( new IfcRelDefinesByType() );
	if( m_GlobalId )
	{
		if( options.create_new_IfcGloballyUniqueId ) { copy_self->m_GlobalId = make_shared<IfcGloballyUniqueId>( createBase64Uuid<wchar_t>().data() ); }
		else { copy_self->m_GlobalId = dynamic_pointer_cast<IfcGloballyUniqueId>( m_GlobalId->getDeepCopy(options) ); }
	}
	if( m_OwnerHistory )
	{
		if( options.shallow_copy_IfcOwnerHistory ) { copy_self->m_OwnerHistory = m_OwnerHistory; }
		else { copy_self->m_OwnerHistory = dynamic_pointer_cast<IfcOwnerHistory>( m_OwnerHistory->getDeepCopy(options) ); }
	}
	if( m_Name ) { copy_self->m_Name = dynamic_pointer_cast<IfcLabel>( m_Name->getDeepCopy(options) ); }
	if( m_Description ) { copy_self->m_Description = dynamic_pointer_cast<IfcText>( m_Description->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_RelatedObjects.size(); ++ii )
	{
		auto item_ii = m_RelatedObjects[ii];
		if( item_ii )
		{
			copy_self->m_RelatedObjects.emplace_back( dynamic_pointer_cast<IfcObject>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_RelatingType ) { copy_self->m_RelatingType = dynamic_pointer_cast<IfcTypeObject>( m_RelatingType->getDeepCopy(options) ); }
	return copy_self;
}
void IfcRelDefinesByType::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCRELDEFINESBYTYPE" << "(";
	if( m_GlobalId ) { m_GlobalId->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_OwnerHistory ) { stream << "#" << m_OwnerHistory->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_Name ) { m_Name->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Description ) { m_Description->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	writeEntityList( stream, m_RelatedObjects );
	stream << ",";
	if( m_RelatingType ) { stream << "#" << m_RelatingType->m_entity_id; } else { stream << "$"; }
	stream << ");";
}
void IfcRelDefinesByType::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcRelDefinesByType::toString() const { return L"IfcRelDefinesByType"; }
void IfcRelDefinesByType::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 6 ){ std::stringstream err; err << "Wrong parameter count for entity IfcRelDefinesByType, expecting 6, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_GlobalId = IfcGloballyUniqueId::createObjectFromSTEP( args[0], map );
	readEntityReference( args[1], m_OwnerHistory, map );
	m_Name = IfcLabel::createObjectFromSTEP( args[2], map );
	m_Description = IfcText::createObjectFromSTEP( args[3], map );
	readEntityReferenceList( args[4], m_RelatedObjects, map );
	readEntityReference( args[5], m_RelatingType, map );
}
void IfcRelDefinesByType::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcRelDefines::getAttributes( vec_attributes );
	if( !m_RelatedObjects.empty() )
	{
		shared_ptr<AttributeObjectVector> RelatedObjects_vec_object( new AttributeObjectVector() );
		std::copy( m_RelatedObjects.begin(), m_RelatedObjects.end(), std::back_inserter( RelatedObjects_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "RelatedObjects", RelatedObjects_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "RelatingType", m_RelatingType ) );
}
void IfcRelDefinesByType::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcRelDefines::getAttributesInverse( vec_attributes_inverse );
}
void IfcRelDefinesByType::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcRelDefines::setInverseCounterparts( ptr_self_entity );
	shared_ptr<IfcRelDefinesByType> ptr_self = dynamic_pointer_cast<IfcRelDefinesByType>( ptr_self_entity );
	if( !ptr_self ) { throw BuildingException( "IfcRelDefinesByType::setInverseCounterparts: type mismatch" ); }
	for( size_t i=0; i<m_RelatedObjects.size(); ++i )
	{
		if( m_RelatedObjects[i] )
		{
			m_RelatedObjects[i]->m_IsTypedBy_inverse.emplace_back( ptr_self );
		}
	}
	if( m_RelatingType )
	{
		m_RelatingType->m_Types_inverse.emplace_back( ptr_self );
	}
}
void IfcRelDefinesByType::unlinkFromInverseCounterparts()
{
	IfcRelDefines::unlinkFromInverseCounterparts();
	for( size_t i=0; i<m_RelatedObjects.size(); ++i )
	{
		if( m_RelatedObjects[i] )
		{
			std::vector<weak_ptr<IfcRelDefinesByType> >& IsTypedBy_inverse = m_RelatedObjects[i]->m_IsTypedBy_inverse;
			for( auto it_IsTypedBy_inverse = IsTypedBy_inverse.begin(); it_IsTypedBy_inverse != IsTypedBy_inverse.end(); )
			{
				weak_ptr<IfcRelDefinesByType> self_candidate_weak = *it_IsTypedBy_inverse;
				if( self_candidate_weak.expired() )
				{
					++it_IsTypedBy_inverse;
					continue;
				}
				shared_ptr<IfcRelDefinesByType> self_candidate( *it_IsTypedBy_inverse );
				if( self_candidate.get() == this )
				{
					it_IsTypedBy_inverse= IsTypedBy_inverse.erase( it_IsTypedBy_inverse );
				}
				else
				{
					++it_IsTypedBy_inverse;
				}
			}
		}
	}
	if( m_RelatingType )
	{
		std::vector<weak_ptr<IfcRelDefinesByType> >& Types_inverse = m_RelatingType->m_Types_inverse;
		for( auto it_Types_inverse = Types_inverse.begin(); it_Types_inverse != Types_inverse.end(); )
		{
			weak_ptr<IfcRelDefinesByType> self_candidate_weak = *it_Types_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_Types_inverse;
				continue;
			}
			shared_ptr<IfcRelDefinesByType> self_candidate( *it_Types_inverse );
			if( self_candidate.get() == this )
			{
				it_Types_inverse= Types_inverse.erase( it_Types_inverse );
			}
			else
			{
				++it_Types_inverse;
			}
		}
	}
}
