/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#ifndef UPM_CONTROLDBUS_H
#define UPM_CONTROLDBUS_H

#include <QObject>
#include <QtDBus>
#include <QDBusInterface>

#define UPM_DBUS_SERVICE          "org.ukui.powermanagement"
#define UPM_DBUS_PATH             "/"
#define UPM_DBUS_INTERFACE        "org.ukui.powermanagement.interface"

#define UPM_DBUS_METHOD_USER_LOGIN              "UserLogin"
#define UPM_DBUS_METHOD_USER_LOGOUT             "UserLogout"
#define UPM_DBUS_METHOD_USER_ACTIVE             "UserActive"
#define UPM_DBUS_METHOD_SET_SYS_CONFIG          "SetSystemConfig"
#define UPM_DBUS_METHOD_GET_SYS_CONFIG          "GetSystemConfig"
#define UPM_DBUS_METHOD_SET_PC_POLICY           "SetPcPolicy"
#define UPM_DBUS_METHOD_SET_CPU_POLICY          "SetCpuPolicy"
#define UPM_DBUS_METHOD_SET_GPU_POLICY          "SetGpuPolicy"
#define UPM_DBUS_METHOD_SET_AUDIO_POLICY        "SetAudioPolicy"
#define UPM_DBUS_METHOD_SET_ASPM_POLICY         "SetAspmPolicy"

#define UPM_DBUS_METHOD_SET_POWEROFF            "PowerOff"
#define UPM_DBUS_METHOD_SET_SUSPEND             "Suspend"
#define UPM_DBUS_METHOD_SET_HIBERNATE           "Hibernate"
#define UPM_DBUS_METHOD_SET_SUSPEND_THEN_HIBERNATE    "SuspendThenHibernate"

#define UPM_DBUS_METHOD_SET_BRIGHTNESS_PERCENT  "SetBrightnessPercent"
#define UPM_DBUS_METHOD_GET_BRIGHTNESS_PERCENT  "GetBrightnessPercent"

#define UPM_DBUS_METHOD_SET_BATTERY_SAVE_SWITCH        "SetBatterySaveSwitch"
#define UPM_DBUS_METHOD_SET_AUTO_BATTERY_SAVE_SWITCH   "SetAutoBatterySaveSwitch"
#define UPM_DBUS_METHOD_SET_REDUCE_BACKLIGHT_SWITCH    "SetReduceBacklightSwitch"

class UpmControlDBus : public QObject
{
    Q_OBJECT
public:
    explicit UpmControlDBus(QObject *parent = nullptr);
    ~UpmControlDBus();
    static UpmControlDBus* self();

private:
    QString m_userName;
    bool m_userActive;

public:
    QString getUserName();
    void setUserActive(bool userActive);

    void controlPowerManagement(const QString &method, QVariant parameter = 0, bool effective = true);

    QString getUpmSystemConfig(const QString &key);
    void setUpmSystemConfig(const QString &key, const QString &value);
    void controlDisplay(const QString &action);
    void turnOffDisplaySignal();
    void delayLockScreen(const QString &action);

private slots:
    void dealSystemConfigChanged(const QString, const QString, const QString);
    void dealActiveUserChanged(const QString);

signals:
    void systemConfigChangedSignal(const QString, const QString, const QString);
};

#endif // UPM_CONTROLDBUS_H
