/*
 * Decompiled with CFR 0.152.
 */
package com.ice.tar;

import com.ice.tar.InvalidHeaderException;
import com.ice.tar.TarEntry;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FastTarStream {
    private boolean debug = false;
    private boolean hasHitEOF = false;
    private TarEntry currEntry = null;
    private InputStream inStream = null;
    private int recordSize = 512;

    public FastTarStream(InputStream inputStream) {
        this(inputStream, 512);
    }

    public FastTarStream(InputStream inputStream, int n) {
        this.inStream = inputStream;
        this.hasHitEOF = false;
        this.currEntry = null;
        this.recordSize = n;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public TarEntry getNextEntry() throws IOException {
        int n;
        int n2;
        int n3;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null && this.currEntry.getSize() > 0L && (n3 = ((int)this.currEntry.getSize() + (this.recordSize - 1)) / this.recordSize) > 0) {
            this.inStream.skip(n3 * this.recordSize);
        }
        byte[] byArray = new byte[this.recordSize];
        int n4 = 0;
        for (n = this.recordSize; n > 0; n -= n2) {
            n2 = this.inStream.read(byArray, n4, n);
            if (n2 == -1) {
                this.hasHitEOF = true;
                break;
            }
            n4 += n2;
        }
        if (!this.hasHitEOF) {
            this.hasHitEOF = true;
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n] == 0) continue;
                this.hasHitEOF = false;
                break;
            }
        }
        if (this.hasHitEOF) {
            this.currEntry = null;
        } else {
            try {
                this.currEntry = new TarEntry(byArray);
                if (this.debug) {
                    byte[] byArray2 = new byte[byArray.length];
                    for (n2 = 0; n2 < byArray.length; ++n2) {
                        byArray2[n2] = byArray[n2] == 0 ? 20 : byArray[n2];
                    }
                    String string = new String(byArray2);
                    System.out.println("\n" + string);
                }
                if (byArray[257] != 117 || byArray[258] != 115 || byArray[259] != 116 || byArray[260] != 97 || byArray[261] != 114) {
                    throw new InvalidHeaderException("header magic is not'ustar', but '" + byArray[257] + byArray[258] + byArray[259] + byArray[260] + byArray[261] + "', or (dec) " + byArray[257] + ", " + byArray[258] + ", " + byArray[259] + ", " + byArray[260] + ", " + byArray[261]);
                }
            }
            catch (InvalidHeaderException invalidHeaderException) {
                this.currEntry = null;
                throw invalidHeaderException;
            }
        }
        return this.currEntry;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        InputStream inputStream = null;
        String string = stringArray[0];
        try {
            TarEntry tarEntry;
            int n = 0;
            if (stringArray.length > 0) {
                if (stringArray[n].equals("-d")) {
                    bl = true;
                    ++n;
                }
                inputStream = stringArray[n].endsWith(".gz") || stringArray[n].endsWith(".tgz") ? new GZIPInputStream(new FileInputStream(stringArray[n])) : new FileInputStream(stringArray[n]);
            } else {
                inputStream = System.in;
            }
            FastTarStream fastTarStream = new FastTarStream(inputStream);
            fastTarStream.setDebug(bl);
            int n2 = 56;
            int n3 = 9;
            int n4 = 8;
            StringBuffer stringBuffer = new StringBuffer(128);
            while ((tarEntry = fastTarStream.getNextEntry()) != null) {
                if (tarEntry.isDirectory()) {
                    System.out.print("D ");
                    stringBuffer.setLength(0);
                    stringBuffer.append(tarEntry.getName());
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    if (stringBuffer.length() > n2) {
                        stringBuffer.setLength(n2);
                    }
                    while (stringBuffer.length() < n2) {
                        stringBuffer.append('_');
                    }
                    stringBuffer.append('_');
                    System.out.print(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    while (stringBuffer.length() < n3) {
                        stringBuffer.insert(0, '_');
                    }
                    stringBuffer.append(' ');
                    System.out.print(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    stringBuffer.append(tarEntry.getUserName());
                    if (stringBuffer.length() > n4) {
                        stringBuffer.setLength(n4);
                    }
                    while (stringBuffer.length() < n4) {
                        stringBuffer.append(' ');
                    }
                    System.out.print(stringBuffer.toString());
                } else {
                    System.out.print("F ");
                    stringBuffer.setLength(0);
                    stringBuffer.append(tarEntry.getName());
                    if (stringBuffer.length() > n2) {
                        stringBuffer.setLength(n2);
                    }
                    while (stringBuffer.length() < n2) {
                        stringBuffer.append(' ');
                    }
                    stringBuffer.append(' ');
                    System.out.print(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    stringBuffer.append(tarEntry.getSize());
                    if (stringBuffer.length() > n3) {
                        stringBuffer.setLength(n3);
                    }
                    while (stringBuffer.length() < n3) {
                        stringBuffer.insert(0, ' ');
                    }
                    stringBuffer.append(' ');
                    System.out.print(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    stringBuffer.append(tarEntry.getUserName());
                    if (stringBuffer.length() > n4) {
                        stringBuffer.setLength(n4);
                    }
                    while (stringBuffer.length() < n4) {
                        stringBuffer.append(' ');
                    }
                    System.out.print(stringBuffer.toString());
                }
                System.out.println("");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }
}

