/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.util.LinkedList;
import org.videolan.BDJAction;
import org.videolan.BDJThreadGroup;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public class BDJActionQueue
implements Runnable {
    private boolean terminated = false;
    private Thread thread;
    private LinkedList actions = new LinkedList();

    public BDJActionQueue(String name) {
        this(null, name);
    }

    public BDJActionQueue(BDJThreadGroup threadGroup, String name) {
        if (threadGroup == null && BDJXletContext.getCurrentContext() != null) {
            Logger.getLogger(BDJActionQueue.class.getName()).error("BDJActionQueue created from wrong context: " + Logger.dumpStack());
        }
        this.thread = new Thread(threadGroup, this, name + ".BDJActionQueue");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            this.terminated = true;
            this.actions.addLast(null);
            this.actions.notifyAll();
        }
        try {
            this.thread.join();
        }
        catch (Throwable t) {
            Logger.getLogger(BDJActionQueue.class.getName()).error("Error joining thread: " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object action;
            LinkedList linkedList = this.actions;
            synchronized (linkedList) {
                while (this.actions.isEmpty()) {
                    try {
                        this.actions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                action = this.actions.removeFirst();
            }
            if (action == null) {
                return;
            }
            try {
                ((BDJAction)action).process();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(BDJAction action) {
        if (action != null) {
            LinkedList linkedList = this.actions;
            synchronized (linkedList) {
                if (!this.terminated) {
                    this.actions.addLast(action);
                    this.actions.notifyAll();
                } else {
                    Logger.getLogger(BDJActionQueue.class.getName()).error("Action skipped (queue stopped): " + action);
                    action.abort();
                }
            }
        }
    }
}

